/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.uploader;

import com.intellij.internal.statistic.config.StatisticsStringUtil;
import com.intellij.internal.statistic.eventLog.DataCollectorDebugLogger;
import com.intellij.internal.statistic.eventLog.DataCollectorSystemEventLogger;
import com.intellij.internal.statistic.eventLog.DeviceConfiguration;
import com.intellij.internal.statistic.eventLog.EventLogApplicationInfo;
import com.intellij.internal.statistic.eventLog.EventLogRecorderConfig;
import com.intellij.internal.statistic.eventLog.MachineId;
import com.intellij.internal.statistic.eventLog.config.EventLogExternalApplicationInfo;
import com.intellij.internal.statistic.eventLog.config.EventLogExternalRecorderConfig;
import com.intellij.internal.statistic.eventLog.connection.EventLogConnectionSettings;
import com.intellij.internal.statistic.eventLog.connection.EventLogSendListener;
import com.intellij.internal.statistic.eventLog.connection.EventLogStatisticsService;
import com.intellij.internal.statistic.eventLog.connection.StatisticsResult;
import com.intellij.internal.statistic.uploader.EventLogUploaderCliParser;
import com.intellij.internal.statistic.uploader.ExternalDataCollectorLogger;
import com.intellij.internal.statistic.uploader.events.ExternalEventsLogger;
import com.intellij.internal.statistic.uploader.util.ExtraHTTPHeadersParser;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EventLogUploader {
    private static final int WAIT_FOR_IDE_MS = 2000;

    public static void main(String[] args) {
        ExternalDataCollectorLogger logger2 = new ExternalDataCollectorLogger();
        ExternalEventsLogger eventsLogger = new ExternalEventsLogger();
        try {
            EventLogUploader.execute(args, logger2, eventsLogger);
        }
        catch (Throwable e) {
            logger2.warn("Failed uploading logs", e);
            eventsLogger.logSendingLogsFinished("EXCEPTION_OCCURRED");
        }
    }

    private static void execute(String[] args, DataCollectorDebugLogger logger2, final ExternalEventsLogger eventsLogger) {
        logger2.info("Process started with '" + String.join((CharSequence)" ", args) + "'");
        logger2.info("Classpath:" + System.getProperty("java.class.path"));
        eventsLogger.logSendingLogsStarted();
        if (args.length == 0) {
            logger2.warn("No arguments were found");
            eventsLogger.logSendingLogsFinished("NO_ARGUMENTS");
            return;
        }
        Map<String, String> options = EventLogUploaderCliParser.parseOptions(args);
        DeviceConfiguration device = EventLogUploader.newDeviceConfig(options);
        if (device == null) {
            logger2.warn("Failed creating device config from arguments");
            eventsLogger.logSendingLogsFinished("NO_DEVICE_CONFIG");
            return;
        }
        EventLogRecorderConfig recorder = EventLogUploader.newRecorderConfig(options);
        if (recorder == null) {
            logger2.warn("Failed creating recorder config from arguments");
            eventsLogger.logSendingLogsFinished("NO_RECORDER_CONFIG");
            return;
        }
        EventLogApplicationInfo appInfo = EventLogUploader.newApplicationInfo(options, logger2, eventsLogger);
        if (appInfo == null) {
            logger2.warn("Failed creating application info from arguments");
            eventsLogger.logSendingLogsFinished("NO_APPLICATION_CONFIG");
            return;
        }
        if (!EventLogUploader.waitForIde(logger2, options, 20)) {
            logger2.warn("Cannot send logs because IDE didn't close during 40000ms");
            eventsLogger.logSendingLogsFinished("IDE_NOT_CLOSING");
            return;
        }
        logger2.info("Start uploading...");
        EventLogConnectionSettings connectionSettings = appInfo.getConnectionSettings();
        logger2.info("{url:" + appInfo.getTemplateUrl() + ", product:" + appInfo.getProductCode() + ", userAgent:" + connectionSettings.getUserAgent() + ", internal:" + appInfo.isInternal() + ", isTest:" + appInfo.isTest() + "}");
        String logs = recorder.getFilesToSendProvider().getFilesToSend().stream().map(file -> file.getFile().getAbsolutePath()).collect(Collectors.joining(File.pathSeparator));
        logger2.info("{recorder:" + recorder.getRecorderId() + ", files:" + logs + "}");
        logger2.info("{device:" + device.getDeviceId() + ", bucket:" + device.getBucket() + "}");
        try {
            EventLogStatisticsService service = new EventLogStatisticsService(device, recorder, appInfo, new EventLogSendListener(){

                @Override
                public void onLogsSend(@NotNull List<String> successfullySentFiles, @NotNull List<Integer> errors, int totalLocalFiles) {
                    if (successfullySentFiles == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (errors == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    eventsLogger.logSendingLogsSucceed(successfullySentFiles, errors, totalLocalFiles);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "successfullySentFiles";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "errors";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/internal/statistic/uploader/EventLogUploader$1";
                    objectArray[2] = "onLogsSend";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            StatisticsResult result = service.send();
            eventsLogger.logSendingLogsFinished(result.getCode());
            if (logger2.isTraceEnabled()) {
                logger2.trace("Uploading finished with " + result.getCode().name());
                logger2.trace(result.getDescription());
            }
        }
        catch (Exception e) {
            logger2.warn("Failed sending files: " + e.getMessage());
            eventsLogger.logSendingLogsFinished("ERROR_ON_SEND");
        }
    }

    @Nullable
    private static DeviceConfiguration newDeviceConfig(Map<String, String> options) {
        try {
            int idRevision;
            String bucketOption = options.get("--bucket");
            String deviceOption = options.get("--device");
            String machineIdOption = options.get("--machine-id");
            String idRevisionOption = options.get("--id-revision-option");
            int bucketInt = bucketOption != null ? Integer.parseInt(bucketOption) : -1;
            int n = idRevision = idRevisionOption != null ? Integer.parseInt(idRevisionOption) : -1;
            if (deviceOption != null && bucketInt >= 0 && bucketInt < 256 && machineIdOption != null && idRevision >= 0) {
                return new DeviceConfiguration(deviceOption, bucketInt, new MachineId(machineIdOption, idRevision));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    @Nullable
    private static EventLogRecorderConfig newRecorderConfig(Map<String, String> options) {
        String logs;
        String recorder = options.get("--recorder");
        if (recorder != null && (logs = options.get("--files")) != null) {
            List<String> files = StatisticsStringUtil.split(logs, File.pathSeparatorChar);
            return new EventLogExternalRecorderConfig(recorder, files);
        }
        return null;
    }

    @Nullable
    private static EventLogApplicationInfo newApplicationInfo(Map<String, String> options, DataCollectorDebugLogger logger2, DataCollectorSystemEventLogger eventLogger) {
        String url = options.get("--url");
        String productCode = options.get("--product");
        String productVersion = options.get("--product-version");
        String userAgent = options.get("--user-agent");
        String headersString = options.get("--extra-headers");
        Map<String, String> extraHeaders = ExtraHTTPHeadersParser.parse(headersString);
        if (url != null && productCode != null) {
            boolean isInternal = options.containsKey("--internal");
            boolean isTest = options.containsKey("--test");
            boolean isEAP = options.containsKey("--eap");
            return new EventLogExternalApplicationInfo(url, productCode, productVersion, userAgent, isInternal, isTest, isEAP, extraHeaders, logger2, eventLogger);
        }
        return null;
    }

    private static boolean waitForIde(DataCollectorDebugLogger logger2, Map<String, String> options, int maxAttempts) {
        String ideToken = options.get("--ide-token");
        if (ideToken == null) {
            return true;
        }
        logger2.info("IDE token file: " + ideToken);
        File token = new File(ideToken);
        try {
            for (int attempt = 0; attempt < maxAttempts && token.exists(); ++attempt) {
                logger2.info("Waiting for 2000ms for IDE to close. Attempt #" + attempt);
                Thread.sleep(2000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return !token.exists();
    }
}

