/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ContentType {
    BMP,
    CSV,
    GIF,
    HTML,
    JPEG,
    JPG,
    JSON,
    PNG,
    WEBP,
    XML,
    DEFAULT;

    private static final ImmutableSet<ContentType> IMAGE_TYPES;
    private static final ImmutableSet<ContentType> TEXT_TYPES;
    private static final Map<ContentType, FileType> FILE_TYPE_MAP;
    private String myType = "";

    @NotNull
    public String getType() {
        String string = this.myType;
        if (string == null) {
            ContentType.$$$reportNull$$$0(0);
        }
        return string;
    }

    private ContentType withType(@NotNull String type) {
        if (type == null) {
            ContentType.$$$reportNull$$$0(1);
        }
        this.myType = type;
        return this;
    }

    public boolean isSupportedTextType() {
        return "text".equalsIgnoreCase(this.getType()) || TEXT_TYPES.contains((Object)this);
    }

    public boolean isSupportedImageType() {
        return IMAGE_TYPES.contains((Object)this);
    }

    @Nullable
    public FileType getFileType() {
        return FILE_TYPE_MAP.get((Object)this);
    }

    @NotNull
    private static ContentType get(@NotNull String type, @NotNull String subtype) {
        if (type == null) {
            ContentType.$$$reportNull$$$0(2);
        }
        if (subtype == null) {
            ContentType.$$$reportNull$$$0(3);
        }
        for (ContentType contentType : ContentType.values()) {
            if (!subtype.equalsIgnoreCase(contentType.name())) continue;
            ContentType contentType2 = contentType.withType(type);
            if (contentType2 == null) {
                ContentType.$$$reportNull$$$0(4);
            }
            return contentType2;
        }
        ContentType contentType = DEFAULT.withType(type);
        if (contentType == null) {
            ContentType.$$$reportNull$$$0(5);
        }
        return contentType;
    }

    @NotNull
    public static ContentType fromMimeType(@NotNull String mimeType) {
        String[] typeAndSubType;
        if (mimeType == null) {
            ContentType.$$$reportNull$$$0(6);
        }
        if ((typeAndSubType = mimeType.split("/", 2)).length < 2) {
            ContentType contentType = typeAndSubType.length == 1 ? DEFAULT.withType(typeAndSubType[0]) : DEFAULT;
            if (contentType == null) {
                ContentType.$$$reportNull$$$0(7);
            }
            return contentType;
        }
        String[] subTypeAndSuffix = typeAndSubType[1].split("\\+", 2);
        return ContentType.get(typeAndSubType[0], subTypeAndSuffix[subTypeAndSuffix.length - 1]);
    }

    static {
        IMAGE_TYPES = ImmutableSet.of((Object)((Object)BMP), (Object)((Object)GIF), (Object)((Object)JPEG), (Object)((Object)JPG), (Object)((Object)PNG), (Object)((Object)WEBP), (Object[])new ContentType[0]);
        TEXT_TYPES = ImmutableSet.of((Object)((Object)CSV), (Object)((Object)HTML), (Object)((Object)JSON), (Object)((Object)XML));
        FILE_TYPE_MAP = new ImmutableMap.Builder().put((Object)CSV, (Object)FileTypeManager.getInstance().getStdFileType("CSV")).put((Object)HTML, (Object)HtmlFileType.INSTANCE).put((Object)JSON, (Object)FileTypeManager.getInstance().getStdFileType("JSON")).put((Object)XML, (Object)XmlFileType.INSTANCE).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/stdui/ContentType";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subtype";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mimeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/stdui/ContentType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "fromMimeType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withType";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fromMimeType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

