/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.stdui;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.HoverRowTable;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.Timeline;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.stdui.StandardColors;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public final class TimelineTable {
    private static final int HEADER_HEIGHT = 20;
    private static final int TIMELINE_HEIGHT = 14;

    @NotNull
    public static JBTable create(@NotNull TableModel model2, final @NotNull Timeline timeline, int column) {
        if (model2 == null) {
            TimelineTable.$$$reportNull$$$0(0);
        }
        if (timeline == null) {
            TimelineTable.$$$reportNull$$$0(1);
        }
        final HoverRowTable table = new HoverRowTable(model2);
        table.getTableHeader().setDefaultRenderer(new HeaderRenderer((JTable)((Object)table), timeline, column));
        final AspectObserver timelineObserver = new AspectObserver();
        table.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    if (table.isShowing()) {
                        timeline.getSelectionRange().addDependency(timelineObserver).onChange(Range.Aspect.RANGE, () -> table.repaint());
                    } else {
                        timeline.getSelectionRange().removeDependencies(timelineObserver);
                    }
                }
            }
        });
        final boolean[] lastIsEmpty = new boolean[]{true};
        table.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                boolean isEmpty;
                boolean bl = isEmpty = table.getRowCount() == 0;
                if (lastIsEmpty[0] != isEmpty) {
                    lastIsEmpty[0] = isEmpty;
                    table.getTableHeader().resizeAndRepaint();
                }
            }
        });
        HoverRowTable hoverRowTable = table;
        if (hoverRowTable == null) {
            TimelineTable.$$$reportNull$$$0(2);
        }
        return hoverRowTable;
    }

    @NotNull
    private static AxisComponent createAxis(@NotNull Timeline timeline) {
        if (timeline == null) {
            TimelineTable.$$$reportNull$$$0(3);
        }
        ResizingAxisComponentModel model2 = new ResizingAxisComponentModel.Builder(timeline.getSelectionRange(), new TimeAxisFormatter(1, 5, 1)).setGlobalRange(timeline.getDataRange()).build();
        AxisComponent axis = new AxisComponent(model2, AxisComponent.AxisOrientation.BOTTOM);
        axis.setShowAxisLine(false);
        axis.setMarkerColor(StandardColors.AXIS_MARKER_COLOR);
        AxisComponent axisComponent = axis;
        if (axisComponent == null) {
            TimelineTable.$$$reportNull$$$0(4);
        }
        return axisComponent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeline";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/adtui/stdui/TimelineTable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/adtui/stdui/TimelineTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAxis";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAxis";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class GridBorder
    implements Border {
        private final Color myColor;

        GridBorder(@NotNull JTable table) {
            if (table == null) {
                GridBorder.$$$reportNull$$$0(0);
            }
            this.myColor = table.getGridColor();
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.myColor);
            int xRight = x + width - 1;
            g.drawLine(xRight, y, xRight, y + height);
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return JBInsets.emptyInsets();
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/android/tools/adtui/stdui/TimelineTable$GridBorder", "<init>"));
        }
    }

    public static abstract class CellRenderer
    implements TableCellRenderer {
        private Timeline myTimeline;

        public CellRenderer(@NotNull Timeline timeline) {
            if (timeline == null) {
                CellRenderer.$$$reportNull$$$0(0);
            }
            this.myTimeline = timeline;
        }

        @Override
        public final Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JPanel panel2 = new JPanel(new TabularLayout("*", "*"));
            panel2.add(this.getTableCellRendererComponent(isSelected, row), new TabularLayout.Constraint(0, 0));
            AxisComponent axisTicks = TimelineTable.createAxis(this.myTimeline);
            axisTicks.setShowLabels(false);
            axisTicks.setMarkerLengths(table.getRowHeight(), 0);
            panel2.add((Component)axisTicks, new TabularLayout.Constraint(0, 0));
            return panel2;
        }

        @NotNull
        protected final Timeline getTimeline() {
            Timeline timeline = this.myTimeline;
            if (timeline == null) {
                CellRenderer.$$$reportNull$$$0(1);
            }
            return timeline;
        }

        @NotNull
        protected abstract Component getTableCellRendererComponent(boolean var1, int var2);

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeline";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/adtui/stdui/TimelineTable$CellRenderer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/adtui/stdui/TimelineTable$CellRenderer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeline";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class HeaderRenderer
    implements TableCellRenderer {
        @NotNull
        private final TableCellRenderer myDelegateRenderer;
        @NotNull
        private final Timeline myTimeline;
        private int myTimelineColumn;

        private HeaderRenderer(@NotNull JTable table, @NotNull Timeline timeline, int timelineColumn) {
            if (table == null) {
                HeaderRenderer.$$$reportNull$$$0(0);
            }
            if (timeline == null) {
                HeaderRenderer.$$$reportNull$$$0(1);
            }
            this.myDelegateRenderer = table.getTableHeader().getDefaultRenderer();
            this.myTimeline = timeline;
            this.myTimelineColumn = timelineColumn;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JComponent headerComponent = (JComponent)this.myDelegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (headerComponent instanceof JLabel) {
                headerComponent.setBorder((Border)JBUI.Borders.empty((int)3, (int)10, (int)3, (int)0));
                ((JLabel)headerComponent).setHorizontalAlignment(2);
            }
            if (table.getRowCount() == 0) {
                return headerComponent;
            }
            JPanel rendererPanel = new JPanel(new TabularLayout("*", String.format(Locale.getDefault(), "%dpx,%dpx", 20, 14)));
            rendererPanel.setOpaque(false);
            headerComponent.setOpaque(false);
            JPanel axisPanel = new JPanel(new BorderLayout());
            axisPanel.setBackground(StandardColors.DEFAULT_CONTENT_BACKGROUND_COLOR);
            if (column == this.myTimelineColumn) {
                AxisComponent header = TimelineTable.createAxis(this.myTimeline);
                header.setShowAxisLine(false);
                header.setMarkerLengths(14, 0);
                axisPanel.add(header);
            } else {
                JComponent separator = AdtUiUtils.createHorizontalSeparator();
                separator.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
                axisPanel.add(separator);
            }
            axisPanel.setBorder(new GridBorder(table));
            rendererPanel.add((Component)headerComponent, new TabularLayout.Constraint(0, 0));
            rendererPanel.add((Component)axisPanel, new TabularLayout.Constraint(1, 0));
            return rendererPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "table";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "timeline";
                    break;
                }
            }
            objectArray[1] = "com/android/tools/adtui/stdui/TimelineTable$HeaderRenderer";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

