/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.adtui.ui;

import com.android.tools.adtui.ImageUtils;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u001aB\u0010\u0000\u001a\u00020\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t\u00a8\u0006\u000b"}, d2={"paintPanelImage", "", "T", "Lcom/intellij/ui/components/JBPanel;", "g", "Ljava/awt/Graphics;", "image", "Ljava/awt/Image;", "active", "", "highFidelityScaling", "intellij.android.adt.ui"})
public final class ImagePanelKt {
    public static final <T extends JBPanel<T>> void paintPanelImage(@NotNull JBPanel<T> $this$paintPanelImage, @NotNull Graphics g, @Nullable Image image, boolean active, boolean highFidelityScaling) {
        block5: {
            Composite composite;
            Object $this$apply;
            Object object;
            Intrinsics.checkNotNullParameter($this$paintPanelImage, (String)"$this$paintPanelImage");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Insets insets = $this$paintPanelImage.getInsets();
            Rectangle rect = new Rectangle(insets.left, insets.top, $this$paintPanelImage.getWidth() - insets.left - insets.right, $this$paintPanelImage.getHeight() - insets.bottom - insets.top);
            g.setColor($this$paintPanelImage.getBackground());
            g.fillRect(rect.x, rect.y, rect.width, rect.height);
            Composite prevComposite = null;
            if (!active) {
                $this$apply = object = (Graphics2D)g;
                boolean bl = false;
                prevComposite = ((Graphics2D)$this$apply).getComposite();
                ((Graphics2D)$this$apply).setComposite(AlphaComposite.SrcOver.derive(0.3f));
            }
            Image image2 = image;
            if (image2 != null) {
                Object img = object = image2;
                boolean bl = false;
                int imageWidth = ((Image)img).getWidth((ImageObserver)$this$paintPanelImage);
                int imageHeight = ((Image)img).getHeight((ImageObserver)$this$paintPanelImage);
                if (imageWidth > 0 && imageHeight > 0) {
                    double scale = RangesKt.coerceAtMost((double)(rect.getWidth() / (double)imageWidth), (double)(rect.getHeight() / (double)imageHeight));
                    int w = MathKt.roundToInt((double)((double)imageWidth * scale));
                    int h = MathKt.roundToInt((double)((double)imageHeight * scale));
                    int xOffset = rect.x + (rect.width - w) / 2;
                    int yOffset = rect.y + (rect.height - h) / 2;
                    if (highFidelityScaling) {
                        BufferedImage bufferedImage = ImageUtil.toBufferedImage((Image)img);
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"ImageUtil.toBufferedImage(img)");
                        BufferedImage bufferedImage2 = bufferedImage;
                        double graphicsScale = JBUIScale.sysScale((Graphics2D)((Graphics2D)g));
                        double scaleX = graphicsScale * (double)w / (double)imageWidth;
                        double scaleY = graphicsScale * (double)h / (double)imageHeight;
                        BufferedImage bufferedImage3 = ImageUtils.scale(bufferedImage2, scaleX, scaleY);
                        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage3, (String)"ImageUtils.scale(bufferedImage, scaleX, scaleY)");
                        BufferedImage scaledImage = bufferedImage3;
                        g.drawImage(scaledImage, xOffset, yOffset, w, h, null);
                    } else {
                        StartupUiUtil.drawImage((Graphics)g, (Image)img, (Rectangle)new Rectangle(xOffset, yOffset, w, h), null, null);
                    }
                }
            }
            $this$apply = object = (Graphics2D)g;
            boolean bl = false;
            Composite composite2 = prevComposite;
            if (composite2 == null) break block5;
            Composite it = composite = composite2;
            boolean bl2 = false;
            ((Graphics2D)$this$apply).setComposite(it);
        }
    }
}

