/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ui.resourcechooser.colorpicker2;

import com.android.tools.idea.ui.resourcechooser.colorpicker2.ColorPipette;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.GraphicalColorPipette;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.GraphicalColorPipetteKt;
import com.android.tools.idea.ui.resourcechooser.colorpicker2.PickerDialogBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Update;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\b\"\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u001a\u001a\u00020\u001bH\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00102\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020\fH&J8\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$2\u0006\u0010(\u001a\u00020$H\u0016J\u0006\u0010)\u001a\u00020\u001bJ\b\u0010*\u001a\u00020\u001bH\u0002J\b\u0010+\u001a\u00020\u001bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/PickerDialogBase;", "Ljava/awt/image/ImageObserver;", "parent", "Ljavax/swing/JComponent;", "callback", "Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipette$Callback;", "alwaysOnTop", "", "(Ljavax/swing/JComponent;Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipette$Callback;Z)V", "getCallback", "()Lcom/android/tools/idea/ui/resourcechooser/colorpicker2/ColorPipette$Callback;", "captureRect", "Ljava/awt/Rectangle;", "center", "Ljava/awt/Point;", "image", "Ljava/awt/image/BufferedImage;", "getParent", "()Ljavax/swing/JComponent;", "picker", "Ljava/awt/Dialog;", "previousColor", "Ljava/awt/Color;", "previousLoc", "timer", "Ljavax/swing/Timer;", "cancelPipette", "", "captureScreen", "belowWindow", "Ljava/awt/Window;", "rect", "imageUpdate", "img", "Ljava/awt/Image;", "flags", "", "x", "y", "width", "height", "pick", "pickDone", "updatePipette", "intellij.android.adt.ui"})
abstract class PickerDialogBase
implements ImageObserver {
    private final Timer timer;
    private final Point center;
    private final Rectangle captureRect;
    private final BufferedImage image;
    private Color previousColor;
    private Point previousLoc;
    private final Dialog picker;
    @NotNull
    private final JComponent parent;
    @NotNull
    private final ColorPipette.Callback callback;

    public final void pick() {
        this.picker.setVisible(true);
        this.timer.start();
    }

    @Override
    public boolean imageUpdate(@NotNull Image img, int flags, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return false;
    }

    private final void cancelPipette() {
        this.timer.stop();
        this.picker.setVisible(false);
        UIUtil.dispose((Component)this.picker);
        this.callback.cancel();
    }

    private final void pickDone() {
        Color color;
        PointerInfo pointerInfo;
        this.timer.stop();
        PointerInfo pointerInfo2 = pointerInfo = MouseInfo.getPointerInfo();
        Intrinsics.checkNotNullExpressionValue((Object)pointerInfo2, (String)"pointerInfo");
        Point location = pointerInfo2.getLocation();
        BufferedImage capture = this.captureScreen(this.picker, new Rectangle(location.x, location.y, 1, 1));
        if (capture == null) {
            Logger.getInstance(GraphicalColorPipette.class).warn("Cannot capture screen, use " + Color.WHITE + " instead");
            color = Color.WHITE;
        } else {
            color = new Color(capture.getRGB(0, 0));
        }
        Color pickedColor = color;
        this.picker.setVisible(false);
        UIUtil.dispose((Component)this.picker);
        Color color2 = pickedColor;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"pickedColor");
        this.callback.picked(color2);
    }

    private final void updatePipette() {
        if (this.picker.isShowing()) {
            PointerInfo pointerInfo;
            PointerInfo pointerInfo2 = pointerInfo = MouseInfo.getPointerInfo();
            Intrinsics.checkNotNullExpressionValue((Object)pointerInfo2, (String)"pointerInfo");
            Point mouseLoc = pointerInfo2.getLocation();
            this.picker.setLocation(mouseLoc.x - 24, mouseLoc.y - 24);
            this.captureRect.setBounds(mouseLoc.x - 5, mouseLoc.y - 5, 11, 11);
            BufferedImage bufferedImage = this.captureScreen(this.picker, this.captureRect);
            if (bufferedImage == null) {
                return;
            }
            BufferedImage capture = bufferedImage;
            Color pickedColor = new Color(capture.getRGB(6, 6));
            if (Intrinsics.areEqual((Object)this.previousLoc, (Object)mouseLoc) ^ true || Intrinsics.areEqual((Object)this.previousColor, (Object)pickedColor) ^ true) {
                Rectangle2D rect;
                this.previousLoc = mouseLoc;
                this.previousColor = pickedColor;
                Graphics graphics = this.image.getGraphics();
                if (graphics == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
                }
                Graphics2D graphics2 = (Graphics2D)graphics;
                graphics2.setComposite(AlphaComposite.Src);
                graphics2.setColor(GraphicalColorPipetteKt.access$getTRANSPARENT_COLOR$p());
                graphics2.fillRect(0, 0, this.image.getWidth(), this.image.getHeight());
                graphics2.drawImage(capture, 0, 0, 48, 48, this);
                graphics2.setComposite(AlphaComposite.SrcOver);
                graphics2.setColor(GraphicalColorPipetteKt.access$getPIPETTE_BORDER_COLOR$p());
                graphics2.drawRect(0, 0, 47, 47);
                graphics2.setColor(GraphicalColorPipetteKt.access$getINDICATOR_BOUND_COLOR$p());
                graphics2.drawRect(21, 21, 5, 5);
                Font originalFont = graphics2.getFont();
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "#%06X";
                Object[] objectArray = new Object[]{pickedColor.getRGB() & 0xFFFFFF};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                String colorValueString = string2;
                Font font = StartupUiUtil.getLabelFont().deriveFont(9.2f);
                double tracking = 0.08;
                graphics2.setFont(font.deriveFont(MapsKt.mapOf((Pair)TuplesKt.to((Object)TextAttribute.TRACKING, (Object)tracking))));
                graphics2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2.setColor(GraphicalColorPipetteKt.access$getCOLOR_VALUE_BACKGROUND$p());
                graphics2.fillRect(0, 52, 48, 12);
                graphics2.setColor(GraphicalColorPipetteKt.access$getCOLOR_VALUE_TEXT_COLOR$p());
                FontMetrics fm = graphics2.getFontMetrics();
                Rectangle2D rectangle2D = rect = fm.getStringBounds(colorValueString, graphics2);
                Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"rect");
                double textWidth = rectangle2D.getWidth() * (1.0 + tracking);
                int x = (int)((double)24 - textWidth / (double)2);
                FontMetrics fontMetrics = fm;
                Intrinsics.checkNotNullExpressionValue((Object)fontMetrics, (String)"fm");
                graphics2.drawString(colorValueString, x, 52 + fontMetrics.getAscent());
                graphics2.setFont(originalFont);
                JComponent parentComponent = this.parent;
                GraphicalColorPipetteKt.access$getCursorUpdateQueue$p().queue(new Update(this, parentComponent, "model.render", 999){
                    final /* synthetic */ PickerDialogBase this$0;
                    final /* synthetic */ JComponent $parentComponent;

                    public boolean canEat(@NotNull Update update2) {
                        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
                        return Intrinsics.areEqual((Object)((Object)this), (Object)update2);
                    }

                    public void run() {
                        block2: {
                            try {
                                Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Callable(this){
                                    final /* synthetic */ updatePipette.1 this$0;

                                    public final Cursor call() {
                                        return this.this$0.$parentComponent.getToolkit().createCustomCursor(PickerDialogBase.access$getImage$p(this.this$0.this$0), PickerDialogBase.access$getCenter$p(this.this$0.this$0), "GraphicalColorPicker");
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                                Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"ApplicationManager.getAp\u2026, center, CURSOR_NAME) })");
                                Future future3 = future2;
                                PickerDialogBase.access$getPicker$p(this.this$0).setCursor((Cursor)future3.get(GraphicalColorPipetteKt.access$getDURATION_COLOR_UPDATING$p(), TimeUnit.MILLISECONDS));
                            }
                            catch (Exception e) {
                                if (!(e instanceof NullPointerException)) break block2;
                                Logger.getInstance(GraphicalColorPipette.class).error(e.getMessage());
                            }
                        }
                    }
                    {
                        this.this$0 = this$0;
                        this.$parentComponent = $captured_local_variable$1;
                        super($super_call_param$2, $super_call_param$3);
                    }
                });
            }
        }
    }

    @Nullable
    public abstract BufferedImage captureScreen(@Nullable Window var1, @NotNull Rectangle var2);

    @NotNull
    public final JComponent getParent() {
        return this.parent;
    }

    @NotNull
    public final ColorPipette.Callback getCallback() {
        return this.callback;
    }

    public PickerDialogBase(@NotNull JComponent parent, @NotNull ColorPipette.Callback callback, boolean alwaysOnTop) {
        Window owner;
        BufferedImage image;
        PickerDialogBase pickerDialogBase;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        this.parent = parent;
        this.callback = callback;
        this.timer = new Timer((int)GraphicalColorPipetteKt.access$getDURATION_COLOR_UPDATING$p(), new ActionListener(this){
            final /* synthetic */ PickerDialogBase this$0;

            public final void actionPerformed(ActionEvent it) {
                PickerDialogBase.access$updatePipette(this.this$0);
            }
            {
                this.this$0 = pickerDialogBase;
            }
        });
        this.center = new Point(24, 24);
        this.captureRect = new Rectangle();
        PickerDialogBase pickerDialogBase2 = pickerDialogBase = this;
        PickerDialogBase pickerDialogBase3 = this;
        boolean bl = false;
        int width = 48;
        int height22 = 64;
        BufferedImage bufferedImage = image = this.parent.getGraphicsConfiguration().createCompatibleImage(width, height22, 3);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"image");
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D graphics2d = (Graphics2D)graphics;
        graphics2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        Object object = image;
        pickerDialogBase3.image = object;
        PickerDialogBase it = pickerDialogBase = this;
        pickerDialogBase3 = this;
        boolean bl2 = false;
        Window height22 = owner = SwingUtilities.getWindowAncestor(this.parent);
        JDialog pickerDialog = height22 instanceof Dialog ? new JDialog((Dialog)owner) : (height22 instanceof Frame ? new JDialog((Frame)owner) : new JDialog(new JFrame()));
        pickerDialog.setUndecorated(true);
        pickerDialog.setAlwaysOnTop(alwaysOnTop);
        pickerDialog.setSize(new Dimension(48, 64));
        pickerDialog.setBackground(UIUtil.TRANSPARENT_COLOR);
        pickerDialog.setDefaultCloseOperation(2);
        JRootPane rootPane = pickerDialog.getRootPane();
        rootPane.putClientProperty("Window.shadow", false);
        MouseAdapter mouseAdapter2 = new MouseAdapter(this, alwaysOnTop){
            final /* synthetic */ PickerDialogBase this$0;
            final /* synthetic */ boolean $alwaysOnTop$inlined;
            {
                this.this$0 = pickerDialogBase;
                this.$alwaysOnTop$inlined = bl;
            }

            public void mouseReleased(@NotNull MouseEvent e) {
                block1: {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        e.consume();
                        if (!SwingUtilities.isLeftMouseButton(e)) break block0;
                        PickerDialogBase.access$pickDone(this.this$0);
                        break block1;
                    }
                    if (!SwingUtilities.isRightMouseButton(e)) break block1;
                    PickerDialogBase.access$cancelPipette(this.this$0);
                }
            }

            public void mouseMoved(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PickerDialogBase.access$updatePipette(this.this$0);
            }
        };
        pickerDialog.addMouseListener(mouseAdapter2);
        pickerDialog.addMouseMotionListener(mouseAdapter2);
        pickerDialog.addKeyListener(new KeyAdapter(this, alwaysOnTop){
            final /* synthetic */ PickerDialogBase this$0;
            final /* synthetic */ boolean $alwaysOnTop$inlined;
            {
                this.this$0 = pickerDialogBase;
                this.$alwaysOnTop$inlined = bl;
            }

            public void keyPressed(@NotNull KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                switch (e.getKeyCode()) {
                    case 27: {
                        PickerDialogBase.access$cancelPipette(this.this$0);
                        break;
                    }
                    case 10: {
                        PickerDialogBase.access$pickDone(this.this$0);
                    }
                }
            }
        });
        BufferedImage bufferedImage2 = UIUtil.createImage((Component)pickerDialog, (int)1, (int)1, (int)3);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage2, (String)"UIUtil.createImage(picke\u2026Transparency.TRANSLUCENT)");
        BufferedImage emptyImage = bufferedImage2;
        pickerDialog.setCursor(this.parent.getToolkit().createCustomCursor(emptyImage, new Point(0, 0), "GraphicalColorPicker"));
        object = pickerDialog;
        pickerDialogBase3.picker = (Dialog)object;
    }

    public static final /* synthetic */ BufferedImage access$getImage$p(PickerDialogBase $this) {
        return $this.image;
    }

    public static final /* synthetic */ Point access$getCenter$p(PickerDialogBase $this) {
        return $this.center;
    }

    public static final /* synthetic */ Dialog access$getPicker$p(PickerDialogBase $this) {
        return $this.picker;
    }

    public static final /* synthetic */ void access$updatePipette(PickerDialogBase $this) {
        $this.updatePipette();
    }

    public static final /* synthetic */ void access$pickDone(PickerDialogBase $this) {
        $this.pickDone();
    }

    public static final /* synthetic */ void access$cancelPipette(PickerDialogBase $this) {
        $this.cancelPipette();
    }
}

