/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.File;
import kotlin.collections.CollectionsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CodegenUtil;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.functions.FunctionInvokeDescriptor;
import org.jetbrains.kotlin.codegen.ClassBuilderMode;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.binding.CalculatedClosure;
import org.jetbrains.kotlin.codegen.context.CodegenContext;
import org.jetbrains.kotlin.codegen.context.FacadePartWithSourceFile;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.context.RootContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorPsiUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.SourceFile;
import org.jetbrains.kotlin.descriptors.VariableAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptorWithAccessors;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.load.java.DescriptorsJvmAbiUtil;
import org.jetbrains.kotlin.load.java.descriptors.JavaCallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaPropertyDescriptor;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.ExplicitReceiverKind;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.checkers.PolymorphicSignatureCallChecker;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.resolve.source.PsiSourceElement;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public class JvmCodegenUtil {
    private JvmCodegenUtil() {
    }

    public static boolean isNonDefaultInterfaceMember(@NotNull CallableMemberDescriptor descriptor2, @NotNull JvmDefaultMode jvmDefaultMode) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(0);
        }
        if (jvmDefaultMode == null) {
            JvmCodegenUtil.$$$reportNull$$$0(1);
        }
        if (!JvmCodegenUtil.isJvmInterface(descriptor2.getContainingDeclaration())) {
            return false;
        }
        if (descriptor2 instanceof JavaCallableMemberDescriptor) {
            return descriptor2.getModality() == Modality.ABSTRACT;
        }
        return !JvmAnnotationUtilKt.isCompiledToJvmDefault((CallableMemberDescriptor)descriptor2, (JvmDefaultMode)jvmDefaultMode);
    }

    public static boolean isJvmInterface(@Nullable DeclarationDescriptor descriptor2) {
        if (descriptor2 instanceof ClassDescriptor) {
            ClassKind kind = ((ClassDescriptor)descriptor2).getKind();
            return kind == ClassKind.INTERFACE || kind == ClassKind.ANNOTATION_CLASS;
        }
        return false;
    }

    public static boolean isJvmInterface(KotlinType type2) {
        return JvmCodegenUtil.isJvmInterface(type2.getConstructor().getDeclarationDescriptor());
    }

    public static boolean isConst(@NotNull CalculatedClosure closure) {
        if (closure == null) {
            JvmCodegenUtil.$$$reportNull$$$0(2);
        }
        return closure.getCapturedOuterClassDescriptor() == null && closure.getCapturedReceiverFromOuterContext() == null && closure.getCaptureVariables().isEmpty() && !closure.isSuspend();
    }

    private static boolean isCallInsideSameClassAsFieldRepresentingProperty(@NotNull PropertyDescriptor descriptor2, @NotNull CodegenContext context2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(3);
        }
        if (context2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(4);
        }
        boolean isFakeOverride = descriptor2.getKind() == CallableMemberDescriptor.Kind.FAKE_OVERRIDE;
        boolean isDelegate = descriptor2.getKind() == CallableMemberDescriptor.Kind.DELEGATION;
        DeclarationDescriptor containingDeclaration = descriptor2.getContainingDeclaration().getOriginal();
        if (DescriptorsJvmAbiUtil.isPropertyWithBackingFieldInOuterClass(descriptor2)) {
            containingDeclaration = containingDeclaration.getContainingDeclaration();
        }
        return !isFakeOverride && !isDelegate && (context2.hasThisDescriptor() && containingDeclaration == context2.getThisDescriptor() || context2.getParentContext() instanceof FacadePartWithSourceFile && JvmCodegenUtil.isWithinSameFile(((FacadePartWithSourceFile)((Object)context2.getParentContext())).getSourceFile(), descriptor2)) && context2.getContextKind() != OwnerKind.DEFAULT_IMPLS;
    }

    private static boolean isWithinSameFile(@Nullable KtFile callerFile, @NotNull CallableMemberDescriptor descriptor2) {
        DeclarationDescriptor containingDeclaration;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(5);
        }
        if ((containingDeclaration = descriptor2.getContainingDeclaration().getOriginal()) instanceof PackageFragmentDescriptor) {
            PsiElement calleeElement = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
            PsiFile calleeFile = calleeElement != null ? calleeElement.getContainingFile() : null;
            return callerFile != null && callerFile != SourceFile.NO_SOURCE_FILE && calleeFile == callerFile;
        }
        return false;
    }

    public static boolean isCallInsideSameModuleAsDeclared(@NotNull CallableMemberDescriptor declarationDescriptor, @NotNull CodegenContext context2, @Nullable File outDirectory) {
        if (declarationDescriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(7);
        }
        if (context2 instanceof RootContext) {
            return true;
        }
        Object contextDescriptor = context2.getContextDescriptor();
        CallableMemberDescriptor directMember = JvmCodegenUtil.getDirectMember(declarationDescriptor);
        if (directMember instanceof DeserializedCallableMemberDescriptor) {
            return ModuleVisibilityUtilsKt.isContainedByCompiledPartOfOurModule((DeclarationDescriptor)directMember, (File)outDirectory);
        }
        return DescriptorUtils.areInSameModule(directMember, contextDescriptor);
    }

    public static boolean isConstOrHasJvmFieldAnnotation(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(8);
        }
        return propertyDescriptor.isConst() || JvmAnnotationUtilKt.hasJvmFieldAnnotation((DeclarationDescriptor)propertyDescriptor);
    }

    public static String getCompanionObjectAccessorName(@NotNull ClassDescriptor companionObjectDescriptor2) {
        if (companionObjectDescriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(9);
        }
        return "access$" + companionObjectDescriptor2.getName();
    }

    public static boolean couldUseDirectAccessToProperty(@NotNull PropertyDescriptor property, boolean forGetter, boolean isDelegated, @NotNull MethodContext contextBeforeInline, boolean shouldInlineConstVals) {
        PropertyAccessorDescriptor accessor;
        if (property == null) {
            JvmCodegenUtil.$$$reportNull$$$0(10);
        }
        if (contextBeforeInline == null) {
            JvmCodegenUtil.$$$reportNull$$$0(11);
        }
        if (shouldInlineConstVals && property.isConst()) {
            return true;
        }
        if (KotlinTypeMapper.isAccessor(property)) {
            return false;
        }
        CodegenContext context2 = contextBeforeInline.getFirstCrossInlineOrNonInlineContext();
        if (context2.isInlineMethodContext()) {
            return false;
        }
        if (!JvmCodegenUtil.isCallInsideSameClassAsFieldRepresentingProperty(property, context2)) {
            DeclarationDescriptor propertyOwner = property.getContainingDeclaration();
            boolean isAnnotationValue = propertyOwner instanceof ClassDescriptor ? ((ClassDescriptor)propertyOwner).getKind() == ClassKind.ANNOTATION_CLASS : false;
            if (isAnnotationValue || !JvmCodegenUtil.isDebuggerContext(context2)) {
                return false;
            }
            for (PropertyAccessorDescriptor accessorDescriptor : property.getAccessors()) {
                if (accessorDescriptor.isDefault() || forGetter != accessorDescriptor instanceof PropertyGetterDescriptor) continue;
                return false;
            }
            if (!property.getOverriddenDescriptors().isEmpty()) {
                return false;
            }
        }
        if (isDelegated || property.getExtensionReceiverParameter() != null) {
            return false;
        }
        PropertyAccessorDescriptor propertyAccessorDescriptor = accessor = forGetter ? property.getGetter() : property.getSetter();
        if (accessor == null) {
            return true;
        }
        if (DescriptorPsiUtilsKt.hasBody(accessor)) {
            return false;
        }
        return DescriptorVisibilities.isPrivate(accessor.getVisibility()) || accessor.getModality() == Modality.FINAL;
    }

    public static boolean isDebuggerContext(@NotNull CodegenContext context2) {
        PsiElement psi;
        SourceElement sourceElement;
        if (context2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(12);
        }
        PsiFile file2 = null;
        Object contextDescriptor = context2.getContextDescriptor();
        if (contextDescriptor instanceof DeclarationDescriptorWithSource && (sourceElement = ((DeclarationDescriptorWithSource)contextDescriptor).getSource()) instanceof PsiSourceElement && (psi = ((PsiSourceElement)sourceElement).getPsi()) != null) {
            file2 = psi.getContainingFile();
        }
        return file2 instanceof KtCodeFragment;
    }

    @Nullable
    public static ClassDescriptor getDispatchReceiverParameterForConstructorCall(@NotNull ConstructorDescriptor descriptor2, @Nullable CalculatedClosure closure) {
        ClassDescriptor expectedThisClass;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(13);
        }
        if (closure != null) {
            return closure.getCapturedOuterClassDescriptor();
        }
        ReceiverParameterDescriptor dispatchReceiver = descriptor2.getDispatchReceiverParameter();
        if (dispatchReceiver != null && !(expectedThisClass = (ClassDescriptor)dispatchReceiver.getContainingDeclaration()).getKind().isSingleton()) {
            return expectedThisClass;
        }
        return null;
    }

    @NotNull
    public static CallableMemberDescriptor getDirectMember(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(14);
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember(descriptor2);
        if (callableMemberDescriptor == null) {
            JvmCodegenUtil.$$$reportNull$$$0(15);
        }
        return callableMemberDescriptor;
    }

    public static boolean isArgumentWhichWillBeInlined(@NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor descriptor2) {
        PsiElement declaration2;
        if (bindingContext == null) {
            JvmCodegenUtil.$$$reportNull$$$0(16);
        }
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(17);
        }
        return InlineUtil.canBeInlineArgument(declaration2 = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2)) && InlineUtil.isInlinedArgument((KtFunction)declaration2, bindingContext, false);
    }

    @NotNull
    public static String getModuleName(ModuleDescriptor module) {
        Name name = module.getStableName();
        if (name == null) {
            String string2 = StringsKt.removeSurrounding((String)module.getName().asString(), (CharSequence)"<", (CharSequence)">");
            if (string2 == null) {
                JvmCodegenUtil.$$$reportNull$$$0(18);
            }
            return string2;
        }
        String string3 = StringsKt.removeSurrounding((String)name.asString(), (CharSequence)"<", (CharSequence)">");
        if (string3 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(19);
        }
        return string3;
    }

    @NotNull
    public static String getMappingFileName(@NotNull String moduleName) {
        if (moduleName == null) {
            JvmCodegenUtil.$$$reportNull$$$0(20);
        }
        String string2 = "META-INF/" + moduleName + "." + "kotlin_module";
        if (string2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(21);
        }
        return string2;
    }

    public static boolean isInlinedJavaConstProperty(VariableDescriptor descriptor2) {
        return descriptor2 instanceof JavaPropertyDescriptor && descriptor2.isConst();
    }

    @Nullable
    public static KotlinType getPropertyDelegateType(@NotNull VariableDescriptorWithAccessors descriptor2, @NotNull BindingContext bindingContext) {
        ResolvedCall<FunctionDescriptor> call2;
        VariableAccessorDescriptor getter2;
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(22);
        }
        if (bindingContext == null) {
            JvmCodegenUtil.$$$reportNull$$$0(23);
        }
        if ((getter2 = descriptor2.getGetter()) != null && (call2 = bindingContext.get(BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL, getter2)) != null) {
            assert (call2.getExplicitReceiverKind() != ExplicitReceiverKind.NO_EXPLICIT_RECEIVER) : "No explicit receiver for call:" + call2;
            ReceiverValue extensionReceiver = call2.getExtensionReceiver();
            if (extensionReceiver != null) {
                return extensionReceiver.getType();
            }
            ReceiverValue dispatchReceiver = call2.getDispatchReceiver();
            if (dispatchReceiver != null) {
                return dispatchReceiver.getType();
            }
            return null;
        }
        return null;
    }

    public static boolean isDelegatedLocalVariable(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(24);
        }
        return descriptor2 instanceof LocalVariableDescriptor && ((LocalVariableDescriptor)descriptor2).isDelegated();
    }

    @Nullable
    public static ReceiverValue getBoundCallableReferenceReceiver(@NotNull ResolvedCall<?> resolvedCall2) {
        ReceiverValue receiver;
        Object descriptor2;
        if (resolvedCall2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(25);
        }
        if ((descriptor2 = resolvedCall2.getResultingDescriptor()).getExtensionReceiverParameter() == null && descriptor2.getDispatchReceiverParameter() == null) {
            return null;
        }
        ReceiverValue dispatchReceiver = resolvedCall2.getDispatchReceiver();
        ReceiverValue extensionReceiver = resolvedCall2.getExtensionReceiver();
        assert (dispatchReceiver == null || extensionReceiver == null) : "Cannot generate reference with both receivers: " + descriptor2;
        ReceiverValue receiverValue = receiver = dispatchReceiver != null ? dispatchReceiver : extensionReceiver;
        if (receiver instanceof TransientReceiver) {
            return null;
        }
        return receiver;
    }

    public static boolean isCompanionObjectInInterfaceNotIntrinsic(@NotNull DeclarationDescriptor companionObject) {
        if (companionObject == null) {
            JvmCodegenUtil.$$$reportNull$$$0(26);
        }
        return DescriptorUtils.isCompanionObject(companionObject) && JvmCodegenUtil.isJvmInterface(companionObject.getContainingDeclaration()) && !DescriptorsJvmAbiUtil.isMappedIntrinsicCompanionObject((ClassDescriptor)companionObject);
    }

    public static boolean isNonIntrinsicPrivateCompanionObjectInInterface(@NotNull DeclarationDescriptorWithVisibility companionObject) {
        if (companionObject == null) {
            JvmCodegenUtil.$$$reportNull$$$0(27);
        }
        return JvmCodegenUtil.isCompanionObjectInInterfaceNotIntrinsic(companionObject) && DescriptorVisibilities.isPrivate(companionObject.getVisibility());
    }

    public static boolean isDeclarationOfBigArityFunctionInvoke(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionInvokeDescriptor && ((FunctionInvokeDescriptor)descriptor2).hasBigArity();
    }

    public static boolean isDeclarationOfBigArityCreateCoroutineMethod(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof SimpleFunctionDescriptor && descriptor2.getName().asString().equals("create") && ((SimpleFunctionDescriptor)descriptor2).getValueParameters().size() >= 22 && descriptor2.getContainingDeclaration() instanceof AnonymousFunctionDescriptor && ((AnonymousFunctionDescriptor)descriptor2.getContainingDeclaration()).isSuspend();
    }

    public static boolean isOverrideOfBigArityFunctionInvoke(@Nullable DeclarationDescriptor descriptor2) {
        return descriptor2 instanceof FunctionDescriptor && descriptor2.getName().equals((Object)OperatorNameConventions.INVOKE) && CollectionsKt.any(DescriptorUtils.getAllOverriddenDeclarations((FunctionDescriptor)descriptor2), JvmCodegenUtil::isDeclarationOfBigArityFunctionInvoke);
    }

    @Nullable
    public static ClassDescriptor getSuperClass(@NotNull KtSuperTypeListEntry specifier, @NotNull GenerationState state, @NotNull BindingContext bindingContext) {
        if (specifier == null) {
            JvmCodegenUtil.$$$reportNull$$$0(28);
        }
        if (state == null) {
            JvmCodegenUtil.$$$reportNull$$$0(29);
        }
        if (bindingContext == null) {
            JvmCodegenUtil.$$$reportNull$$$0(30);
        }
        ClassDescriptor superClass = CodegenUtil.getSuperClassBySuperTypeListEntry(specifier, bindingContext);
        assert (superClass != null || state.getClassBuilderMode() == ClassBuilderMode.LIGHT_CLASSES) : "ClassDescriptor should not be null:" + specifier.getText();
        return superClass;
    }

    public static boolean isPolymorphicSignature(@NotNull FunctionDescriptor descriptor2) {
        if (descriptor2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(31);
        }
        return descriptor2.getAnnotations().hasAnnotation(PolymorphicSignatureCallChecker.polymorphicSignatureFqName);
    }

    @NotNull
    public static String sanitizeNameIfNeeded(@NotNull String name, @NotNull LanguageVersionSettings languageVersionSettings) {
        if (name == null) {
            JvmCodegenUtil.$$$reportNull$$$0(32);
        }
        if (languageVersionSettings == null) {
            JvmCodegenUtil.$$$reportNull$$$0(33);
        }
        if (((Boolean)languageVersionSettings.getFlag(JvmAnalysisFlags.getSanitizeParentheses())).booleanValue()) {
            String string2 = name.replace("(", "$_").replace(")", "$_");
            if (string2 == null) {
                JvmCodegenUtil.$$$reportNull$$$0(34);
            }
            return string2;
        }
        String string3 = name;
        if (string3 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(35);
        }
        return string3;
    }

    public static boolean typeHasSpecializedInlineClassEquality(@NotNull KotlinType type2, @NotNull GenerationState state) {
        ClassifierDescriptor descriptor2;
        if (type2 == null) {
            JvmCodegenUtil.$$$reportNull$$$0(36);
        }
        if (state == null) {
            JvmCodegenUtil.$$$reportNull$$$0(37);
        }
        if (!((descriptor2 = type2.getConstructor().getDeclarationDescriptor()) instanceof DeserializedClassDescriptor)) {
            return true;
        }
        DeserializedClassDescriptor classDescriptor = (DeserializedClassDescriptor)descriptor2;
        if (DescriptorUtils.getFqNameSafe(classDescriptor).equals((Object)StandardNames.RESULT_FQ_NAME)) {
            return state.getLanguageVersionSettings().getApiVersion().compareTo(ApiVersion.KOTLIN_1_4) >= 0;
        }
        return ((DeserializedClassDescriptor)descriptor2).getMetadataVersion().isAtLeast(1, 1, 16);
    }

    public static boolean isInSamePackage(DeclarationDescriptor descriptor1, DeclarationDescriptor descriptor2) {
        PackageFragmentDescriptor package1 = DescriptorUtils.getParentOfType(descriptor1, PackageFragmentDescriptor.class, false);
        PackageFragmentDescriptor package2 = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class, false);
        return package1 != null && package2 != null && package1.getFqName().equals((Object)package2.getFqName());
    }

    public static String dumpContextHierarchy(CodegenContext context2) {
        StringBuilder result2 = new StringBuilder();
        int i = 0;
        CodegenContext current = context2;
        while (current != null) {
            result2.append(i).append(": ").append(current).append('\n');
            current = current.getParentContext();
            ++i;
        }
        return result2.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 34: 
            case 35: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 34: 
            case 35: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jvmDefaultMode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closure";
                break;
            }
            case 4: 
            case 7: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationDescriptor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "companionObjectDescriptor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextBeforeInline";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 34: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 16: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bindingContext";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCall";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "companionObject";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 29: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageVersionSettings";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/codegen/JvmCodegenUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirectMember";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingFileName";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "sanitizeNameIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNonDefaultInterfaceMember";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isConst";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCallInsideSameClassAsFieldRepresentingProperty";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isWithinSameFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isCallInsideSameModuleAsDeclared";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isConstOrHasJvmFieldAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getCompanionObjectAccessorName";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "couldUseDirectAccessToProperty";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isDebuggerContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDispatchReceiverParameterForConstructorCall";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDirectMember";
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 34: 
            case 35: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isArgumentWhichWillBeInlined";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getMappingFileName";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyDelegateType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isDelegatedLocalVariable";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getBoundCallableReferenceReceiver";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isCompanionObjectInInterfaceNotIntrinsic";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isNonIntrinsicPrivateCompanionObjectInInterface";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClass";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphicSignature";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "sanitizeNameIfNeeded";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "typeHasSpecializedInlineClassEquality";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 15: 
            case 18: 
            case 19: 
            case 21: 
            case 34: 
            case 35: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

