/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.patterns;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.collections.CollectionsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.name.Name;

public final class NamePredicate
implements Predicate<Name> {
    @NotNull
    public static final NamePredicate PRIMITIVE_NUMBERS = new NamePredicate(CollectionsKt.map((Iterable)PrimitiveType.NUMBER_TYPES, type2 -> type2.getTypeName().asString()));
    @NotNull
    public static final NamePredicate PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS = new NamePredicate(CollectionsKt.mapNotNull((Iterable)PrimitiveType.NUMBER_TYPES, type2 -> type2 != PrimitiveType.LONG ? type2.getTypeName().asString() : null));
    @NotNull
    public static final NamePredicate STRING = new NamePredicate("String");
    @NotNull
    public static final NamePredicate NUMBER = new NamePredicate("Number");
    @NotNull
    public static final NamePredicate BOOLEAN = new NamePredicate("Boolean");
    @NotNull
    public static final NamePredicate CHAR = new NamePredicate(PrimitiveType.CHAR.getTypeName());
    @NotNull
    public static final NamePredicate LONG = new NamePredicate(PrimitiveType.LONG.getTypeName());
    @NotNull
    private final Set<Name> validNames;

    public NamePredicate(String ... validNames) {
        if (validNames == null) {
            NamePredicate.$$$reportNull$$$0(0);
        }
        this(Arrays.asList(validNames));
    }

    private NamePredicate(@NotNull List<String> validNames) {
        if (validNames == null) {
            NamePredicate.$$$reportNull$$$0(1);
        }
        this.validNames = new HashSet<Name>();
        for (String validName : validNames) {
            this.validNames.add(Name.guessByFirstCharacter((String)validName));
        }
    }

    public NamePredicate(@NotNull Collection<Name> validNames) {
        if (validNames == null) {
            NamePredicate.$$$reportNull$$$0(2);
        }
        this.validNames = new HashSet<Name>();
        this.validNames.addAll(validNames);
    }

    public NamePredicate(Name ... validNames) {
        if (validNames == null) {
            NamePredicate.$$$reportNull$$$0(3);
        }
        this.validNames = new HashSet<Name>();
        this.validNames.addAll(Lists.newArrayList((Object[])validNames));
    }

    @Override
    public boolean test(Name name) {
        return this.validNames.contains(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "validNames", "org/jetbrains/kotlin/js/patterns/NamePredicate", "<init>"));
    }
}

