/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.components.PostponeArgumentsChecksKt;
import org.jetbrains.kotlin.resolve.calls.components.candidate.CallableReferenceResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.components.candidate.SimpleResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionContext;
import org.jetbrains.kotlin.resolve.calls.inference.components.ConstraintSystemCompletionMode;
import org.jetbrains.kotlin.resolve.calls.inference.components.FreshVariableNewTypeSubstitutor;
import org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter;
import org.jetbrains.kotlin.resolve.calls.inference.components.PostponedArgumentInputTypesResolver;
import org.jetbrains.kotlin.resolve.calls.inference.components.ResultTypeResolver;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDependencyInformationProvider;
import org.jetbrains.kotlin.resolve.calls.inference.components.TypeVariableDirectionCalculator;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.ArgumentConstraintPositionImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.FixVariableConstraintPosition;
import org.jetbrains.kotlin.resolve.calls.inference.model.FixVariableConstraintPositionImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.NewTypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.model.NotEnoughInformationForTypeParameterImpl;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableForLambdaParameterType;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableForLambdaReturnType;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableFromCallableDescriptor;
import org.jetbrains.kotlin.resolve.calls.inference.model.TypeVariableTypeConstructor;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.CallableReferenceWithRevisedExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.KotlinDiagnosticsHolder;
import org.jetbrains.kotlin.resolve.calls.model.LambdaKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.LambdaWithTypeVariableAsExpectedTypeAtom;
import org.jetbrains.kotlin.resolve.calls.model.NotEnoughInformationForLambdaParameter;
import org.jetbrains.kotlin.resolve.calls.model.PostponedAtomWithRevisableExpectedType;
import org.jetbrains.kotlin.resolve.calls.model.PostponedCallableReferenceAtom;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCallableReferenceArgumentAtom;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedLambdaAtom;
import org.jetbrains.kotlin.resolve.calls.model.StubResolvedAtom;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.UnwrappedType;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSubstitutorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemInferenceExtensionContext;
import org.jetbrains.kotlin.types.model.TypeVariableMarker;
import org.jetbrains.kotlin.types.model.TypeVariableTypeConstructorMarker;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 ;2\u00020\u0001:\u0001;B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ*\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J4\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0018\u0010 \u001a\u0004\u0018\u00010\u00112\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J&\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002J.\u0010!\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u001fJH\u0010+\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013J \u0010,\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J.\u0010/\u001a\u00020\u000e*\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J6\u00100\u001a\u00020\u000e*\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u001c\u00101\u001a\u0004\u0018\u00010\u0011*\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u001c\u00102\u001a\u0004\u0018\u00010\u0011*\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J@\u00103\u001a\u00020\u000e*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J(\u00105\u001a\b\u0012\u0004\u0012\u0002060\u0010*\u00020\u00172\u0006\u00104\u001a\u00020\u000e2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0010H\u0002J\u001a\u00107\u001a\u00020\u000e*\u00020\u00172\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J@\u00108\u001a\u00020\u000e*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002JH\u00109\u001a\u00020\u0014*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001e\u001a\u00020\u001fH\u0002JN\u0010+\u001a\u00020\u0014*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u00104\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0002JT\u0010:\u001a\u00020\u000e*\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0018\u001a\u00020\u00192\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u00104\u001a\u00020\u000e2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00140\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006<"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter;", "", "resultTypeResolver", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver;", "variableFixationFinder", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "postponedArgumentInputTypesResolver", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/PostponedArgumentInputTypesResolver;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "(Lorg/jetbrains/kotlin/resolve/calls/inference/components/ResultTypeResolver;Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;Lorg/jetbrains/kotlin/resolve/calls/inference/components/PostponedArgumentInputTypesResolver;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "getVariableFixationFinder", "()Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder;", "analyzeRemainingNotAnalyzedPostponedArgument", "", "postponedArguments", "", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtom;", "analyze", "Lkotlin/Function1;", "", "completeConstraintSystem", "c", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionContext;", "topLevelType", "Lorg/jetbrains/kotlin/types/UnwrappedType;", "topLevelAtoms", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "completionMode", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/ConstraintSystemCompletionMode;", "diagnosticsHolder", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinDiagnosticsHolder;", "findPostponedArgumentWithRevisableExpectedType", "fixVariable", "variableWithConstraints", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "direction", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDirectionCalculator$ResolveDirection;", "prepareLambdaAtomForFactoryPattern", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedLambdaAtom;", "atom", "candidate", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/SimpleResolutionCandidate;", "runCompletion", "transformToAtomWithNewFunctionalExpectedType", "argument", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedAtomWithRevisableExpectedType;", "analyzeArgumentWithFixedParameterTypes", "analyzeNextReadyPostponedArgument", "findPostponedArgumentWithFixedInputTypes", "findPostponedArgumentWithFixedOrPostponedInputTypes", "fixNextReadyVariable", "collectVariablesFromContext", "getOrderedAllTypeVariables", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "hasLambdaToAnalyze", "isThereAnyReadyForFixationVariable", "reportNotEnoughTypeInformation", "tryToCompleteWithBuilderInference", "Companion", "resolution"})
public final class KotlinConstraintSystemCompleter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResultTypeResolver resultTypeResolver;
    @NotNull
    private final VariableFixationFinder variableFixationFinder;
    @NotNull
    private final PostponedArgumentInputTypesResolver postponedArgumentInputTypesResolver;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public KotlinConstraintSystemCompleter(@NotNull ResultTypeResolver resultTypeResolver, @NotNull VariableFixationFinder variableFixationFinder, @NotNull PostponedArgumentInputTypesResolver postponedArgumentInputTypesResolver, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)resultTypeResolver, (String)"resultTypeResolver");
        Intrinsics.checkNotNullParameter((Object)variableFixationFinder, (String)"variableFixationFinder");
        Intrinsics.checkNotNullParameter((Object)postponedArgumentInputTypesResolver, (String)"postponedArgumentInputTypesResolver");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.resultTypeResolver = resultTypeResolver;
        this.variableFixationFinder = variableFixationFinder;
        this.postponedArgumentInputTypesResolver = postponedArgumentInputTypesResolver;
        this.languageVersionSettings = languageVersionSettings;
    }

    @NotNull
    public final VariableFixationFinder getVariableFixationFinder() {
        return this.variableFixationFinder;
    }

    public final void runCompletion(@NotNull ConstraintSystemCompletionContext c, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull List<? extends ResolvedAtom> topLevelAtoms, @NotNull UnwrappedType topLevelType, @NotNull KotlinDiagnosticsHolder diagnosticsHolder, @NotNull Function1<? super PostponedResolvedAtom, Unit> analyze2) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)completionMode, (String)"completionMode");
        Intrinsics.checkNotNullParameter(topLevelAtoms, (String)"topLevelAtoms");
        Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        Intrinsics.checkNotNullParameter(analyze2, (String)"analyze");
        this.runCompletion(c, completionMode, topLevelAtoms, topLevelType, diagnosticsHolder, false, analyze2);
    }

    public final void completeConstraintSystem(@NotNull ConstraintSystemCompletionContext c, @NotNull UnwrappedType topLevelType, @NotNull List<? extends ResolvedAtom> topLevelAtoms, @NotNull ConstraintSystemCompletionMode completionMode, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)topLevelType, (String)"topLevelType");
        Intrinsics.checkNotNullParameter(topLevelAtoms, (String)"topLevelAtoms");
        Intrinsics.checkNotNullParameter((Object)completionMode, (String)"completionMode");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        this.runCompletion(c, completionMode, topLevelAtoms, topLevelType, diagnosticsHolder, true, (Function1<? super PostponedResolvedAtom, Unit>)((Function1)completeConstraintSystem.1.INSTANCE));
    }

    private final void runCompletion(ConstraintSystemCompletionContext $this$runCompletion, ConstraintSystemCompletionMode completionMode, List<? extends ResolvedAtom> topLevelAtoms, UnwrappedType topLevelType, KotlinDiagnosticsHolder diagnosticsHolder, boolean collectVariablesFromContext, Function1<? super PostponedResolvedAtom, Unit> analyze2) {
        Set topLevelTypeVariables = $this$runCompletion.extractTypeVariables((KotlinTypeMarker)topLevelType);
        block0: while (true) {
            boolean areThereAppearedProperConstraintsForSomeVariable;
            Iterator<PostponedResolvedAtom> $this$filterIsInstanceTo$iv$iv;
            List<PostponedResolvedAtom> postponedArguments = Companion.getOrderedNotAnalyzedPostponedArguments(topLevelAtoms);
            if (completionMode == ConstraintSystemCompletionMode.UNTIL_FIRST_LAMBDA && this.hasLambdaToAnalyze($this$runCompletion, postponedArguments)) {
                return;
            }
            if (this.analyzeArgumentWithFixedParameterTypes($this$runCompletion, postponedArguments, analyze2)) continue;
            boolean isThereAnyReadyForFixationVariable = this.isThereAnyReadyForFixationVariable($this$runCompletion, completionMode, topLevelAtoms, topLevelType, collectVariablesFromContext, postponedArguments);
            if (postponedArguments.isEmpty() && !isThereAnyReadyForFixationVariable) break;
            Iterable $this$filterIsInstance$iv = postponedArguments;
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            Iterator iterator2 = $this$filterIsInstanceTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv$iv = iterator2.next();
                if (!(element$iv$iv instanceof PostponedAtomWithRevisableExpectedType)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List postponedArgumentsWithRevisableType = (List)destination$iv$iv;
            TypeVariableDependencyInformationProvider dependencyProvider = new TypeVariableDependencyInformationProvider($this$runCompletion.getNotFixedTypeVariables(), postponedArguments, (KotlinTypeMarker)topLevelType, (TypeSystemInferenceExtensionContext)$this$runCompletion);
            boolean wasBuiltNewExpectedTypeForSomeArgument = this.postponedArgumentInputTypesResolver.collectParameterTypesAndBuildNewExpectedTypes($this$runCompletion.asConstraintSystemCompletionContext(), postponedArgumentsWithRevisableType, completionMode, dependencyProvider, topLevelTypeVariables);
            if (wasBuiltNewExpectedTypeForSomeArgument) continue;
            if (completionMode == ConstraintSystemCompletionMode.FULL) {
                PostponedResolvedAtom argument2;
                $this$filterIsInstanceTo$iv$iv = postponedArguments.iterator();
                while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                    argument2 = $this$filterIsInstanceTo$iv$iv.next();
                    boolean wasFixedSomeVariable2 = this.postponedArgumentInputTypesResolver.fixNextReadyVariableForParameterTypeIfNeeded($this$runCompletion.asConstraintSystemCompletionContext(), (PostponedResolvedAtomMarker)argument2, postponedArguments, (KotlinTypeMarker)topLevelType, dependencyProvider, (Function1)new Function1<TypeVariableMarker, Object>(topLevelAtoms){
                        final /* synthetic */ List<ResolvedAtom> $topLevelAtoms;
                        {
                            this.$topLevelAtoms = $topLevelAtoms;
                            super(1);
                        }

                        @Nullable
                        public final Object invoke(@NotNull TypeVariableMarker it) {
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Object object = KotlinConstraintSystemCompleter.Companion.findResolvedAtomBy(it, this.$topLevelAtoms);
                            if (object == null) {
                                object = kotlin.collections.CollectionsKt.firstOrNull(this.$topLevelAtoms);
                            }
                            return object;
                        }
                    });
                    if (!wasFixedSomeVariable2) continue;
                    continue block0;
                }
                $this$filterIsInstanceTo$iv$iv = postponedArgumentsWithRevisableType.iterator();
                while ($this$filterIsInstanceTo$iv$iv.hasNext()) {
                    argument2 = (PostponedAtomWithRevisableExpectedType)$this$filterIsInstanceTo$iv$iv.next();
                    boolean wasTransformedSomeArgument = this.transformToAtomWithNewFunctionalExpectedType($this$runCompletion.asConstraintSystemCompletionContext(), (PostponedAtomWithRevisableExpectedType)argument2, diagnosticsHolder);
                    if (!wasTransformedSomeArgument) continue;
                    continue block0;
                }
            }
            if (this.analyzeNextReadyPostponedArgument($this$runCompletion, postponedArguments, completionMode, analyze2) || this.fixNextReadyVariable($this$runCompletion, completionMode, topLevelAtoms, topLevelType, collectVariablesFromContext, postponedArguments) || (areThereAppearedProperConstraintsForSomeVariable = this.tryToCompleteWithBuilderInference($this$runCompletion, completionMode, topLevelAtoms, topLevelType, postponedArguments, collectVariablesFromContext, analyze2))) continue;
            this.reportNotEnoughTypeInformation($this$runCompletion, completionMode, topLevelAtoms, topLevelType, collectVariablesFromContext, postponedArguments, diagnosticsHolder);
            if (completionMode != ConstraintSystemCompletionMode.FULL || !this.analyzeRemainingNotAnalyzedPostponedArgument(postponedArguments, analyze2)) break;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean tryToCompleteWithBuilderInference(ConstraintSystemCompletionContext $this$tryToCompleteWithBuilderInference, ConstraintSystemCompletionMode completionMode, List<? extends ResolvedAtom> topLevelAtoms, UnwrappedType topLevelType, List<? extends PostponedResolvedAtom> postponedArguments, boolean collectVariablesFromContext, Function1<? super PostponedResolvedAtom, Unit> analyze2) {
        VariableFixationFinder.VariableForFixation variableForFixation;
        void $this$filterIsInstanceTo$iv$iv;
        if (completionMode == ConstraintSystemCompletionMode.PARTIAL) {
            return false;
        }
        boolean useBuilderInferenceOnlyIfNeeded = this.languageVersionSettings.supportsFeature(LanguageFeature.UseBuilderInferenceOnlyIfNeeded);
        if (!useBuilderInferenceOnlyIfNeeded) {
            return false;
        }
        Object $this$filterIsInstance$iv = postponedArguments;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ResolvedLambdaAtom)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        Iterable it = $this$filterIsInstance$iv;
        boolean bl = false;
        Object object = !((Collection)it).isEmpty() ? $this$filterIsInstance$iv : null;
        if (object == null) {
            return false;
        }
        Iterable lambdaArguments = object;
        boolean useBuilderInferenceWithoutAnnotation = this.languageVersionSettings.supportsFeature(LanguageFeature.UseBuilderInferenceWithoutAnnotation);
        for (ResolvedLambdaAtom argument2 : lambdaArguments) {
            void $this$filterTo$iv$iv;
            TypeVariableTypeConstructorMarker it2;
            Iterable $this$mapTo$iv$iv;
            void $this$map$iv;
            if (!argument2.getAtom().getHasBuilderInferenceAnnotation() && !useBuilderInferenceWithoutAnnotation) continue;
            destination$iv$iv = argument2.getInputTypes();
            boolean $i$f$map = false;
            Iterator iterator2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                UnwrappedType unwrappedType = (UnwrappedType)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add($this$tryToCompleteWithBuilderInference.extractTypeVariables((KotlinTypeMarker)it2));
            }
            Iterable $this$filter$iv = kotlin.collections.CollectionsKt.flatten((Iterable)((List)destination$iv$iv2));
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (TypeVariableTypeConstructorMarker)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = !$this$tryToCompleteWithBuilderInference.getFixedTypeVariables().containsKey(it2);
                if (!bl4) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List notFixedInputTypeVariables = (List)destination$iv$iv2;
            if (notFixedInputTypeVariables.isEmpty()) continue;
            for (TypeVariableTypeConstructorMarker variable2 : notFixedInputTypeVariables) {
                $this$tryToCompleteWithBuilderInference.getBuilder().markPostponedVariable(((VariableWithConstraints)MapsKt.getValue((Map)$this$tryToCompleteWithBuilderInference.getNotFixedTypeVariables(), (Object)variable2)).getTypeVariable());
            }
            analyze2.invoke((Object)argument2);
        }
        VariableFixationFinder.VariableForFixation variableForFixation2 = variableForFixation = this.variableFixationFinder.findFirstVariableForFixation((VariableFixationFinder.Context)$this$tryToCompleteWithBuilderInference, this.getOrderedAllTypeVariables($this$tryToCompleteWithBuilderInference, collectVariablesFromContext, topLevelAtoms), postponedArguments, completionMode, (KotlinTypeMarker)topLevelType);
        return variableForFixation2 != null ? variableForFixation2.getHasProperConstraint() : false;
    }

    private final boolean transformToAtomWithNewFunctionalExpectedType(ConstraintSystemCompletionContext c, PostponedAtomWithRevisableExpectedType argument2, KotlinDiagnosticsHolder diagnosticsHolder) {
        Object object;
        block9: {
            block8: {
                KotlinTypeMarker kotlinTypeMarker;
                ConstraintSystemCompletionContext $this$transformToAtomWithNewFunctionalExpectedType_u24lambda_u2d5 = c;
                boolean bl = false;
                object = argument2.getRevisedExpectedType();
                if (object == null) break block8;
                KotlinTypeMarker it = kotlinTypeMarker = object;
                boolean bl2 = false;
                object = $this$transformToAtomWithNewFunctionalExpectedType_u24lambda_u2d5.isFunctionOrKFunctionWithAnySuspendability(it) ? kotlinTypeMarker : null;
                if (object == null) break block8;
                KotlinTypeMarker $this$cast$iv = object;
                boolean $i$f$cast = false;
                KotlinTypeMarker kotlinTypeMarker2 = $this$cast$iv;
                if (kotlinTypeMarker2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.types.UnwrappedType");
                }
                object = (UnwrappedType)kotlinTypeMarker2;
                if (object != null) break block9;
            }
            return false;
        }
        KotlinTypeMarker revisedExpectedType = object;
        PostponedAtomWithRevisableExpectedType postponedAtomWithRevisableExpectedType = argument2;
        if (postponedAtomWithRevisableExpectedType instanceof PostponedCallableReferenceAtom) {
            CallableReferenceWithRevisedExpectedTypeAtom callableReferenceWithRevisedExpectedTypeAtom;
            CallableReferenceWithRevisedExpectedTypeAtom it = callableReferenceWithRevisedExpectedTypeAtom = new CallableReferenceWithRevisedExpectedTypeAtom(((PostponedCallableReferenceAtom)argument2).getAtom(), (UnwrappedType)revisedExpectedType);
            boolean bl = false;
            ((PostponedCallableReferenceAtom)argument2).setAnalyzedResults(null, kotlin.collections.CollectionsKt.listOf((Object)it));
        } else if (postponedAtomWithRevisableExpectedType instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
            PostponeArgumentsChecksKt.transformToResolvedLambda$default((LambdaWithTypeVariableAsExpectedTypeAtom)argument2, c.getBuilder(), diagnosticsHolder, (UnwrappedType)revisedExpectedType, null, 8, null);
        } else {
            throw new IllegalStateException("Unsupported postponed argument type of " + argument2);
        }
        return true;
    }

    private final boolean analyzeArgumentWithFixedParameterTypes(ConstraintSystemCompletionContext $this$analyzeArgumentWithFixedParameterTypes, List<? extends PostponedResolvedAtom> postponedArguments, Function1<? super PostponedResolvedAtom, Unit> analyze2) {
        PostponedResolvedAtom argumentToAnalyze;
        boolean useBuilderInferenceOnlyIfNeeded = this.languageVersionSettings.supportsFeature(LanguageFeature.UseBuilderInferenceOnlyIfNeeded);
        PostponedResolvedAtom postponedResolvedAtom = argumentToAnalyze = useBuilderInferenceOnlyIfNeeded ? this.findPostponedArgumentWithFixedInputTypes($this$analyzeArgumentWithFixedParameterTypes, postponedArguments) : this.findPostponedArgumentWithFixedOrPostponedInputTypes($this$analyzeArgumentWithFixedParameterTypes, postponedArguments);
        if (argumentToAnalyze != null) {
            analyze2.invoke((Object)argumentToAnalyze);
            return true;
        }
        return false;
    }

    private final boolean analyzeNextReadyPostponedArgument(ConstraintSystemCompletionContext $this$analyzeNextReadyPostponedArgument, List<? extends PostponedResolvedAtom> postponedArguments, ConstraintSystemCompletionMode completionMode, Function1<? super PostponedResolvedAtom, Unit> analyze2) {
        PostponedResolvedAtom argumentWithTypeVariableAsExpectedType;
        if (completionMode == ConstraintSystemCompletionMode.FULL && (argumentWithTypeVariableAsExpectedType = this.findPostponedArgumentWithRevisableExpectedType(postponedArguments)) != null) {
            analyze2.invoke((Object)argumentWithTypeVariableAsExpectedType);
            return true;
        }
        return this.analyzeArgumentWithFixedParameterTypes($this$analyzeNextReadyPostponedArgument, postponedArguments, analyze2);
    }

    private final boolean analyzeRemainingNotAnalyzedPostponedArgument(List<? extends PostponedResolvedAtom> postponedArguments, Function1<? super PostponedResolvedAtom, Unit> analyze2) {
        Object v0;
        block2: {
            Iterable $this$firstOrNull$iv = postponedArguments;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PostponedResolvedAtom it = (PostponedResolvedAtom)element$iv;
                boolean bl = false;
                if (!(!it.getAnalyzed())) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        PostponedResolvedAtom remainingNotAnalyzedPostponedArgument = v0;
        if (remainingNotAnalyzedPostponedArgument != null) {
            analyze2.invoke((Object)remainingNotAnalyzedPostponedArgument);
            return true;
        }
        return false;
    }

    @NotNull
    public final ResolvedLambdaAtom prepareLambdaAtomForFactoryPattern(@NotNull ResolvedLambdaAtom atom, @NotNull SimpleResolutionCandidate candidate2, @NotNull KotlinDiagnosticsHolder diagnosticsHolder) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Intrinsics.checkNotNullParameter((Object)candidate2, (String)"candidate");
        Intrinsics.checkNotNullParameter((Object)diagnosticsHolder, (String)"diagnosticsHolder");
        TypeVariableForLambdaReturnType returnVariable = new TypeVariableForLambdaReturnType(candidate2.getCallComponents().getBuiltIns(), "_R");
        ConstraintSystemBuilder csBuilder = candidate2.getSystem().getBuilder();
        csBuilder.registerVariable((TypeVariableMarker)returnVariable);
        TypeSubstitutorMarker typeSubstitutorMarker = csBuilder.buildCurrentSubstitutor();
        TypeSystemInferenceExtensionContext typeSystemInferenceExtensionContext = (TypeSystemInferenceExtensionContext)candidate2.getSystem().asConstraintSystemCompleterContext();
        UnwrappedType unwrappedType = atom.getExpectedType();
        Intrinsics.checkNotNull((Object)unwrappedType);
        KotlinType functionalType = (KotlinType)MarkerExtensionsKt.safeSubstitute((TypeSubstitutorMarker)typeSubstitutorMarker, (TypeSystemInferenceExtensionContext)typeSystemInferenceExtensionContext, (KotlinTypeMarker)unwrappedType);
        SimpleType expectedType = KotlinTypeFactory.simpleType$default(functionalType.getAnnotations(), functionalType.getConstructor(), kotlin.collections.CollectionsKt.plus((Collection)kotlin.collections.CollectionsKt.dropLast(functionalType.getArguments(), (int)1), (Object)TypeUtilsKt.asTypeProjection(returnVariable.getDefaultType())), functionalType.isMarkedNullable(), null, 16, null);
        csBuilder.addSubtypeConstraint((KotlinTypeMarker)expectedType, (KotlinTypeMarker)functionalType, (ConstraintPosition)new ArgumentConstraintPositionImpl(atom.getAtom()));
        return PostponeArgumentsChecksKt.transformToResolvedLambda(atom, csBuilder, diagnosticsHolder, (UnwrappedType)expectedType, returnVariable);
    }

    private final boolean hasLambdaToAnalyze(ConstraintSystemCompletionContext $this$hasLambdaToAnalyze, List<? extends PostponedResolvedAtom> postponedArguments) {
        return this.analyzeArgumentWithFixedParameterTypes($this$hasLambdaToAnalyze, postponedArguments, (Function1<? super PostponedResolvedAtom, Unit>)((Function1)hasLambdaToAnalyze.1.INSTANCE));
    }

    private final PostponedResolvedAtom findPostponedArgumentWithRevisableExpectedType(List<? extends PostponedResolvedAtom> postponedArguments) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = postponedArguments;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PostponedResolvedAtom argument2 = (PostponedResolvedAtom)element$iv;
                boolean bl = false;
                if (!(argument2 instanceof PostponedAtomWithRevisableExpectedType)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final PostponedResolvedAtom findPostponedArgumentWithFixedOrPostponedInputTypes(ConstraintSystemCompletionContext $this$findPostponedArgumentWithFixedOrPostponedInputTypes, List<? extends PostponedResolvedAtom> postponedArguments) {
        Object v1;
        block5: {
            Iterable $this$firstOrNull$iv = postponedArguments;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block4: {
                    PostponedResolvedAtom argument2 = (PostponedResolvedAtom)element$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = argument2.getInputTypes();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            UnwrappedType it = (UnwrappedType)element$iv2;
                            boolean bl3 = false;
                            if ($this$findPostponedArgumentWithFixedOrPostponedInputTypes.containsOnlyFixedOrPostponedVariables((KotlinTypeMarker)it)) continue;
                            bl = false;
                            break block4;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    private final PostponedResolvedAtom findPostponedArgumentWithFixedInputTypes(ConstraintSystemCompletionContext $this$findPostponedArgumentWithFixedInputTypes, List<? extends PostponedResolvedAtom> postponedArguments) {
        Object v1;
        block5: {
            Iterable $this$firstOrNull$iv = postponedArguments;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block4: {
                    PostponedResolvedAtom argument2 = (PostponedResolvedAtom)element$iv;
                    boolean bl2 = false;
                    Iterable $this$all$iv = argument2.getInputTypes();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv2 : $this$all$iv) {
                            UnwrappedType it = (UnwrappedType)element$iv2;
                            boolean bl3 = false;
                            if ($this$findPostponedArgumentWithFixedInputTypes.containsOnlyFixedVariables((KotlinTypeMarker)it)) continue;
                            bl = false;
                            break block4;
                        }
                        bl = true;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    private final void fixVariable(ConstraintSystemCompletionContext c, VariableWithConstraints variableWithConstraints, List<? extends ResolvedAtom> topLevelAtoms) {
        this.fixVariable(c, variableWithConstraints, TypeVariableDirectionCalculator.ResolveDirection.UNKNOWN, topLevelAtoms);
    }

    private final void fixVariable(ConstraintSystemCompletionContext c, VariableWithConstraints variableWithConstraints, TypeVariableDirectionCalculator.ResolveDirection direction, List<? extends ResolvedAtom> topLevelAtoms) {
        KotlinTypeMarker resultType = this.resultTypeResolver.findResultType((ResultTypeResolver.Context)c, variableWithConstraints, direction);
        TypeVariableMarker variable2 = variableWithConstraints.getTypeVariable();
        ResolvedAtom resolvedAtom = Companion.findResolvedAtomBy(variable2, topLevelAtoms);
        if (resolvedAtom == null) {
            resolvedAtom = (ResolvedAtom)kotlin.collections.CollectionsKt.firstOrNull(topLevelAtoms);
        }
        ResolvedAtom resolvedAtom2 = resolvedAtom;
        c.fixVariable(variable2, resultType, (FixVariableConstraintPosition)new FixVariableConstraintPositionImpl(variable2, resolvedAtom2));
    }

    private final boolean fixNextReadyVariable(ConstraintSystemCompletionContext $this$fixNextReadyVariable, ConstraintSystemCompletionMode completionMode, List<? extends ResolvedAtom> topLevelAtoms, UnwrappedType topLevelType, boolean collectVariablesFromContext, List<? extends PostponedResolvedAtom> postponedArguments) {
        VariableFixationFinder.VariableForFixation variableForFixation = this.variableFixationFinder.findFirstVariableForFixation((VariableFixationFinder.Context)$this$fixNextReadyVariable, this.getOrderedAllTypeVariables($this$fixNextReadyVariable, collectVariablesFromContext, topLevelAtoms), postponedArguments, completionMode, (KotlinTypeMarker)topLevelType);
        if (variableForFixation == null) {
            return false;
        }
        VariableFixationFinder.VariableForFixation variableForFixation2 = variableForFixation;
        if (!variableForFixation2.getHasProperConstraint()) {
            return false;
        }
        this.fixVariable($this$fixNextReadyVariable, (VariableWithConstraints)MapsKt.getValue((Map)$this$fixNextReadyVariable.getNotFixedTypeVariables(), (Object)variableForFixation2.getVariable()), topLevelAtoms);
        return true;
    }

    private final void reportNotEnoughTypeInformation(ConstraintSystemCompletionContext $this$reportNotEnoughTypeInformation, ConstraintSystemCompletionMode completionMode, List<? extends ResolvedAtom> topLevelAtoms, UnwrappedType topLevelType, boolean collectVariablesFromContext, List<? extends PostponedResolvedAtom> postponedArguments, KotlinDiagnosticsHolder diagnosticsHolder) {
        while (this.variableFixationFinder.findFirstVariableForFixation((VariableFixationFinder.Context)$this$reportNotEnoughTypeInformation, this.getOrderedAllTypeVariables($this$reportNotEnoughTypeInformation, collectVariablesFromContext, topLevelAtoms), postponedArguments, completionMode, (KotlinTypeMarker)topLevelType) != null) {
            KotlinType kotlinType;
            ResolvedAtom resolvedAtom;
            VariableFixationFinder.VariableForFixation variableForFixation;
            boolean bl;
            boolean bl2 = bl = !variableForFixation.getHasProperConstraint();
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-KotlinConstraintSystemCompleter$reportNotEnoughTypeInformation$22 = false;
                String $i$a$-assert-KotlinConstraintSystemCompleter$reportNotEnoughTypeInformation$22 = "At this stage there should be no remaining variables with proper constraints";
                throw new AssertionError((Object)$i$a$-assert-KotlinConstraintSystemCompleter$reportNotEnoughTypeInformation$22);
            }
            if (completionMode == ConstraintSystemCompletionMode.PARTIAL) break;
            VariableWithConstraints variableWithConstraints = (VariableWithConstraints)MapsKt.getValue((Map)$this$reportNotEnoughTypeInformation.getNotFixedTypeVariables(), (Object)variableForFixation.getVariable());
            TypeVariableMarker typeVariable = variableWithConstraints.getTypeVariable();
            ResolvedAtom resolvedAtom2 = Companion.findResolvedAtomBy(typeVariable, topLevelAtoms);
            if (resolvedAtom2 == null) {
                resolvedAtom2 = (ResolvedAtom)kotlin.collections.CollectionsKt.firstOrNull(topLevelAtoms);
            }
            if ((resolvedAtom = resolvedAtom2) != null) {
                $this$reportNotEnoughTypeInformation.addError((ConstraintSystemError)new NotEnoughInformationForTypeParameterImpl(typeVariable, resolvedAtom, $this$reportNotEnoughTypeInformation.couldBeResolvedWithUnrestrictedBuilderInference()));
            }
            if (typeVariable instanceof TypeVariableFromCallableDescriptor) {
                kotlinType = ErrorUtils.createUninferredParameterType(((TypeVariableFromCallableDescriptor)typeVariable).getOriginalTypeParameter());
            } else if (typeVariable instanceof TypeVariableForLambdaParameterType && ((TypeVariableForLambdaParameterType)typeVariable).getAtom() instanceof LambdaKotlinCallArgument) {
                diagnosticsHolder.addDiagnostic(new NotEnoughInformationForLambdaParameter((LambdaKotlinCallArgument)((TypeVariableForLambdaParameterType)typeVariable).getAtom(), ((TypeVariableForLambdaParameterType)typeVariable).getIndex()));
                kotlinType = ErrorUtils.createErrorType("Cannot infer lambda parameter type");
            } else {
                kotlinType = ErrorUtils.createErrorType("Cannot infer type variable " + typeVariable);
            }
            KotlinType kotlinType2 = kotlinType;
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"when {\n                t\u2026eVariable\")\n            }");
            KotlinType resultErrorType = kotlinType2;
            $this$reportNotEnoughTypeInformation.fixVariable(typeVariable, (KotlinTypeMarker)resultErrorType, (FixVariableConstraintPosition)new FixVariableConstraintPositionImpl(typeVariable, resolvedAtom));
        }
    }

    private final List<TypeConstructorMarker> getOrderedAllTypeVariables(ConstraintSystemCompletionContext $this$getOrderedAllTypeVariables, boolean collectVariablesFromContext, List<? extends ResolvedAtom> topLevelAtoms) {
        boolean bl;
        if (collectVariablesFromContext) {
            return kotlin.collections.CollectionsKt.toList((Iterable)$this$getOrderedAllTypeVariables.getNotFixedTypeVariables().keySet());
        }
        LinkedHashSet<TypeConstructor> result2 = new LinkedHashSet<TypeConstructor>();
        for (ResolvedAtom resolvedAtom : topLevelAtoms) {
            KotlinConstraintSystemCompleter.getOrderedAllTypeVariables$process(resolvedAtom, $this$getOrderedAllTypeVariables, result2);
        }
        boolean bl2 = bl = result2.size() == $this$getOrderedAllTypeVariables.getNotFixedTypeVariables().size();
        if (_Assertions.ENABLED && !bl) {
            Set set;
            boolean bl3 = false;
            Set $this$getOrderedAllTypeVariables_u24lambda_u2d21_u24lambda_u2d20 = set = kotlin.collections.CollectionsKt.toMutableSet((Iterable)$this$getOrderedAllTypeVariables.getNotFixedTypeVariables().keySet());
            boolean bl4 = false;
            $this$getOrderedAllTypeVariables_u24lambda_u2d21_u24lambda_u2d20.removeAll((Collection)result2);
            Set notFoundTypeVariables = set;
            String string2 = "Not all type variables found: " + notFoundTypeVariables;
            throw new AssertionError((Object)string2);
        }
        return kotlin.collections.CollectionsKt.toList((Iterable)result2);
    }

    private final boolean isThereAnyReadyForFixationVariable(ConstraintSystemCompletionContext $this$isThereAnyReadyForFixationVariable, ConstraintSystemCompletionMode completionMode, List<? extends ResolvedAtom> topLevelAtoms, UnwrappedType topLevelType, boolean collectVariablesFromContext, List<? extends PostponedResolvedAtom> postponedArguments) {
        return this.variableFixationFinder.findFirstVariableForFixation((VariableFixationFinder.Context)$this$isThereAnyReadyForFixationVariable, this.getOrderedAllTypeVariables($this$isThereAnyReadyForFixationVariable, collectVariablesFromContext, topLevelAtoms), postponedArguments, completionMode, (KotlinTypeMarker)topLevelType) != null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<TypeVariableTypeConstructor> getOrderedAllTypeVariables$getVariablesFromRevisedExpectedType(KotlinType revisedExpectedType) {
        List list2;
        Object object = revisedExpectedType;
        if (object != null && (object = ((KotlinType)object).getArguments()) != null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TypeProjection typeProjection = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getType().getConstructor());
            }
            Iterable $this$filterIsInstance$iv = (List)destination$iv$iv;
            boolean $i$f$filterIsInstance = false;
            $this$mapTo$iv$iv = $this$filterIsInstance$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof TypeVariableTypeConstructor)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final void getOrderedAllTypeVariables$process(ResolvedAtom $this$getOrderedAllTypeVariables_u24process, ConstraintSystemCompletionContext $this_getOrderedAllTypeVariables, LinkedHashSet<TypeConstructor> to) {
        block25: {
            Object it;
            Object item$iv$iv;
            Object $this$mapTo$iv$iv;
            Collection destination$iv$iv;
            Object $this$map$iv;
            boolean $i$f$map;
            Collection collection;
            Iterable destination$iv$iv2;
            List list2;
            ResolvedAtom resolvedAtom = $this$getOrderedAllTypeVariables_u24process;
            if (resolvedAtom instanceof LambdaWithTypeVariableAsExpectedTypeAtom) {
                list2 = KotlinConstraintSystemCompleter.getOrderedAllTypeVariables$getVariablesFromRevisedExpectedType(((LambdaWithTypeVariableAsExpectedTypeAtom)$this$getOrderedAllTypeVariables_u24process).getRevisedExpectedType());
                if (list2 == null) {
                    list2 = kotlin.collections.CollectionsKt.emptyList();
                }
            } else if (resolvedAtom instanceof ResolvedCallAtom) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = ((ResolvedCallAtom)$this$getOrderedAllTypeVariables_u24process).getFreshVariablesSubstitutor().getFreshVariables();
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv2;
                destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    void it2;
                    TypeVariableFromCallableDescriptor typeVariableFromCallableDescriptor = (TypeVariableFromCallableDescriptor)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it2.getFreshTypeConstructor());
                }
                list2 = (List)destination$iv$iv2;
            } else if (resolvedAtom instanceof PostponedCallableReferenceAtom) {
                List list3;
                List list4;
                List list5 = KotlinConstraintSystemCompleter.getOrderedAllTypeVariables$getVariablesFromRevisedExpectedType(((PostponedCallableReferenceAtom)$this$getOrderedAllTypeVariables_u24process).getRevisedExpectedType());
                if (list5 == null) {
                    list5 = kotlin.collections.CollectionsKt.emptyList();
                }
                Collection collection2 = list5;
                Object object = ((PostponedCallableReferenceAtom)$this$getOrderedAllTypeVariables_u24process).getCandidate();
                if (object != null && (object = ((CallableReferenceResolutionCandidate)object).getFreshVariablesSubstitutor()) != null && (object = ((FreshVariableNewTypeSubstitutor)object).getFreshVariables()) != null) {
                    destination$iv$iv2 = (Iterable)object;
                    collection = collection2;
                    $i$f$map = false;
                    Object object2 = $this$map$iv;
                    destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator bl = $this$mapTo$iv$iv.iterator();
                    while (bl.hasNext()) {
                        item$iv$iv = bl.next();
                        TypeVariableFromCallableDescriptor typeVariableFromCallableDescriptor = (TypeVariableFromCallableDescriptor)item$iv$iv;
                        Collection collection3 = destination$iv$iv;
                        boolean bl2 = false;
                        collection3.add(((NewTypeVariable)it).getFreshTypeConstructor());
                    }
                    list4 = (List)destination$iv$iv;
                    collection2 = collection;
                } else {
                    list4 = list3 = null;
                }
                if (list4 == null) {
                    list3 = kotlin.collections.CollectionsKt.emptyList();
                }
                list2 = kotlin.collections.CollectionsKt.plus((Collection)collection2, (Iterable)list3);
            } else if (resolvedAtom instanceof ResolvedCallableReferenceArgumentAtom) {
                List list6;
                Object object = ((ResolvedCallableReferenceArgumentAtom)$this$getOrderedAllTypeVariables_u24process).getCandidate();
                if (object != null && (object = ((CallableReferenceResolutionCandidate)object).getFreshVariablesSubstitutor()) != null && (object = ((FreshVariableNewTypeSubstitutor)object).getFreshVariables()) != null) {
                    $this$map$iv = (Iterable)object;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator bl = $this$mapTo$iv$iv.iterator();
                    while (bl.hasNext()) {
                        item$iv$iv = bl.next();
                        it = (TypeVariableFromCallableDescriptor)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(((NewTypeVariable)it).getFreshTypeConstructor());
                    }
                    list6 = (List)destination$iv$iv;
                } else {
                    list6 = list2 = null;
                }
                if (list6 == null) {
                    list2 = kotlin.collections.CollectionsKt.emptyList();
                }
            } else if (resolvedAtom instanceof ResolvedLambdaAtom) {
                TypeVariableForLambdaReturnType typeVariableForLambdaReturnType = ((ResolvedLambdaAtom)$this$getOrderedAllTypeVariables_u24process).getTypeVariableForLambdaReturnType();
                list2 = kotlin.collections.CollectionsKt.listOfNotNull((Object)(typeVariableForLambdaReturnType != null ? typeVariableForLambdaReturnType.getFreshTypeConstructor() : null));
            } else {
                list2 = kotlin.collections.CollectionsKt.emptyList();
            }
            List typeVariables = list2;
            Iterable $this$mapNotNullTo$iv = typeVariables;
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            $this$map$iv = $this$forEach$iv$iv.iterator();
            while ($this$map$iv.hasNext()) {
                TypeVariableTypeConstructor it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = $this$map$iv.next();
                boolean bl = false;
                TypeVariableTypeConstructor it3 = (TypeVariableTypeConstructor)element$iv;
                boolean bl4 = false;
                TypeVariableTypeConstructor typeVariableTypeConstructor = it3;
                it = typeVariableTypeConstructor;
                boolean bl5 = false;
                if (($this_getOrderedAllTypeVariables.getNotFixedTypeVariables().containsKey(it) ? typeVariableTypeConstructor : null) == null) continue;
                it$iv = it$iv;
                boolean bl6 = false;
                ((Collection)to).add(it$iv);
            }
            if ($this$getOrderedAllTypeVariables_u24process instanceof StubResolvedAtom && $this_getOrderedAllTypeVariables.getNotFixedTypeVariables().containsKey(((StubResolvedAtom)$this$getOrderedAllTypeVariables_u24process).getTypeVariable())) {
                ((Collection)to).add(((StubResolvedAtom)$this$getOrderedAllTypeVariables_u24process).getTypeVariable());
            }
            if (!$this$getOrderedAllTypeVariables_u24process.getAnalyzed()) break block25;
            List<ResolvedAtom> list7 = $this$getOrderedAllTypeVariables_u24process.getSubResolvedAtoms();
            if (list7 != null) {
                Iterable $this$forEach$iv = list7;
                boolean $i$f$forEach2 = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolvedAtom it4 = (ResolvedAtom)element$iv;
                    boolean bl = false;
                    KotlinConstraintSystemCompleter.getOrderedAllTypeVariables$process(it4, $this_getOrderedAllTypeVariables, to);
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bJ\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/KotlinConstraintSystemCompleter$Companion;", "", "()V", "findResolvedAtomBy", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedAtom;", "typeVariable", "Lorg/jetbrains/kotlin/types/model/TypeVariableMarker;", "topLevelAtoms", "", "getOrderedNotAnalyzedPostponedArguments", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtom;", "resolution"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<PostponedResolvedAtom> getOrderedNotAnalyzedPostponedArguments(@NotNull List<? extends ResolvedAtom> topLevelAtoms) {
            Intrinsics.checkNotNullParameter(topLevelAtoms, (String)"topLevelAtoms");
            ArrayList notAnalyzedArguments = new ArrayList();
            for (ResolvedAtom resolvedAtom : topLevelAtoms) {
                org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter$Companion.getOrderedNotAnalyzedPostponedArguments$process(resolvedAtom, notAnalyzedArguments);
            }
            return notAnalyzedArguments;
        }

        @Nullable
        public final ResolvedAtom findResolvedAtomBy(@NotNull TypeVariableMarker typeVariable, @NotNull List<? extends ResolvedAtom> topLevelAtoms) {
            Intrinsics.checkNotNullParameter((Object)typeVariable, (String)"typeVariable");
            Intrinsics.checkNotNullParameter(topLevelAtoms, (String)"topLevelAtoms");
            for (ResolvedAtom resolvedAtom : topLevelAtoms) {
                ResolvedAtom resolvedAtom2 = org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter$Companion.findResolvedAtomBy$check(resolvedAtom, typeVariable);
                if (resolvedAtom2 == null) continue;
                ResolvedAtom it = resolvedAtom2;
                boolean bl = false;
                return it;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private static final void getOrderedNotAnalyzedPostponedArguments$process(ResolvedAtom $this$getOrderedNotAnalyzedPostponedArguments_u24process, List<PostponedResolvedAtom> to) {
            block5: {
                ResolvedAtom resolvedAtom;
                Collection collection = to;
                ResolvedAtom $this$safeAs$iv = $this$getOrderedNotAnalyzedPostponedArguments_u24process;
                boolean $i$f$safeAs2 = false;
                ResolvedAtom resolvedAtom2 = $this$safeAs$iv;
                if (!(resolvedAtom2 instanceof PostponedResolvedAtom)) {
                    resolvedAtom2 = null;
                }
                PostponedResolvedAtom postponedResolvedAtom = (PostponedResolvedAtom)resolvedAtom2;
                if (postponedResolvedAtom != null) {
                    void it;
                    ResolvedAtom $i$f$safeAs2 = $this$safeAs$iv = postponedResolvedAtom;
                    Collection collection2 = collection;
                    boolean bl = false;
                    boolean bl2 = it.getAnalyzed();
                    collection = collection2;
                    resolvedAtom = !bl2 ? $this$safeAs$iv : null;
                } else {
                    resolvedAtom = null;
                }
                CollectionsKt.addIfNotNull((Collection)collection, resolvedAtom);
                if (!$this$getOrderedNotAnalyzedPostponedArguments_u24process.getAnalyzed()) break block5;
                List<ResolvedAtom> list2 = $this$getOrderedNotAnalyzedPostponedArguments_u24process.getSubResolvedAtoms();
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ResolvedAtom it = (ResolvedAtom)element$iv;
                        boolean bl = false;
                        org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter$Companion.getOrderedNotAnalyzedPostponedArguments$process(it, to);
                    }
                }
            }
        }

        private static final ResolvedAtom findResolvedAtomBy$check(ResolvedAtom $this$findResolvedAtomBy_u24check, TypeVariableMarker $typeVariable) {
            block8: {
                boolean suitableCall;
                boolean bl;
                ResolvedAtom resolvedAtom = $this$findResolvedAtomBy_u24check;
                if (resolvedAtom instanceof ResolvedCallAtom) {
                    bl = kotlin.collections.CollectionsKt.contains((Iterable)((ResolvedCallAtom)$this$findResolvedAtomBy_u24check).getFreshVariablesSubstitutor().getFreshVariables(), (Object)$typeVariable);
                } else if (resolvedAtom instanceof ResolvedCallableReferenceArgumentAtom) {
                    Object object = ((ResolvedCallableReferenceArgumentAtom)$this$findResolvedAtomBy_u24check).getCandidate();
                    if (object != null && (object = ((CallableReferenceResolutionCandidate)object).getFreshVariablesSubstitutor()) != null && (object = ((FreshVariableNewTypeSubstitutor)object).getFreshVariables()) != null) {
                        List<TypeVariableFromCallableDescriptor> it = object;
                        boolean bl2 = false;
                        bl = kotlin.collections.CollectionsKt.contains((Iterable)it, (Object)$typeVariable);
                    } else {
                        bl = false;
                    }
                } else {
                    bl = suitableCall = resolvedAtom instanceof ResolvedLambdaAtom ? Intrinsics.areEqual((Object)$typeVariable, (Object)((ResolvedLambdaAtom)$this$findResolvedAtomBy_u24check).getTypeVariableForLambdaReturnType()) : false;
                }
                if (suitableCall) {
                    return $this$findResolvedAtomBy_u24check;
                }
                List<ResolvedAtom> list2 = $this$findResolvedAtomBy_u24check.getSubResolvedAtoms();
                if (list2 == null) break block8;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ResolvedAtom subResolvedAtom = (ResolvedAtom)element$iv;
                    boolean bl3 = false;
                    ResolvedAtom resolvedAtom2 = org.jetbrains.kotlin.resolve.calls.inference.components.KotlinConstraintSystemCompleter$Companion.findResolvedAtomBy$check(subResolvedAtom, $typeVariable);
                    if (resolvedAtom2 == null) continue;
                    ResolvedAtom result2 = resolvedAtom2;
                    boolean bl4 = false;
                    return result2;
                }
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

