/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.ide.common.blame.parser.util.ParserUtil;
import com.android.utils.ILogger;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class XmlValidationErrorParser
implements PatternAwareOutputParser {
    private static final Pattern FATAL_ERROR = Pattern.compile("\\[Fatal Error\\] :(\\d+):(\\d+): (.+)");
    private static final Pattern FILE_REFERENCE = Pattern.compile("Failed to parse (.+)");

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        Matcher m1;
        if (line == null) {
            XmlValidationErrorParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            XmlValidationErrorParser.$$$reportNull$$$0(1);
        }
        if (messages == null) {
            XmlValidationErrorParser.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            XmlValidationErrorParser.$$$reportNull$$$0(3);
        }
        if (!(m1 = FATAL_ERROR.matcher(line)).matches()) {
            File sourceFile;
            Matcher m2 = FILE_REFERENCE.matcher(line);
            if (m2.matches() && (sourceFile = new File(m2.group(1))).exists()) {
                String message = line;
                String exceptionMessage = ParserUtil.digestStackTrace((OutputLineReader)reader);
                if (exceptionMessage != null) {
                    message = exceptionMessage + ": " + message;
                }
                messages.add(new Message(Message.Kind.ERROR, message, new SourceFilePosition(sourceFile, SourcePosition.UNKNOWN), new SourceFilePosition[0]));
                return true;
            }
            return false;
        }
        String message = m1.group(3);
        int lineNumber = Integer.parseInt(m1.group(1));
        int column = Integer.parseInt(m1.group(2));
        SourceFile sourceFile = SourceFile.UNKNOWN;
        String nextLine = reader.peek(0);
        if (nextLine == null) {
            return false;
        }
        Matcher m2 = FILE_REFERENCE.matcher(nextLine);
        if (m2.matches()) {
            reader.readLine();
            File possibleSourceFile = new File(m2.group(1));
            if (possibleSourceFile.exists()) {
                sourceFile = new SourceFile(possibleSourceFile);
            }
        }
        messages.add(new Message(Message.Kind.ERROR, message, new SourceFilePosition(sourceFile, new SourcePosition(lineNumber - 1, column - 1, -1)), new SourceFilePosition[0]));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "line";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "messages";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "logger";
                break;
            }
        }
        objectArray[1] = "com/android/tools/idea/gradle/output/parser/androidPlugin/XmlValidationErrorParser";
        objectArray[2] = "parse";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

