/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.common.replacement;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;

public class ConsistentReplacementDetector {
    private static <T extends Replacement> Set<T> inconsistentRenames(Set<T> currentRenames, T newRename) {
        LinkedHashSet<Replacement> inconsistentRenames = new LinkedHashSet<Replacement>();
        for (Replacement rename : currentRenames) {
            if (rename.getBefore().equals(newRename.getBefore()) && !rename.getAfter().equals(newRename.getAfter())) {
                inconsistentRenames.add(rename);
                continue;
            }
            if (rename.getBefore().equals(newRename.getBefore()) || !rename.getAfter().equals(newRename.getAfter())) continue;
            inconsistentRenames.add(rename);
        }
        return inconsistentRenames;
    }

    public static <T extends Replacement> void updateRenames(Set<T> allConsistentRenames, Set<T> allInconsistentRenames, Set<T> renames) {
        for (Replacement newRename : renames) {
            Set<Replacement> inconsistentRenames = ConsistentReplacementDetector.inconsistentRenames(allConsistentRenames, newRename);
            if (inconsistentRenames.isEmpty()) {
                allConsistentRenames.add(newRename);
                continue;
            }
            allInconsistentRenames.addAll(inconsistentRenames);
            allInconsistentRenames.add(newRename);
        }
    }

    public static <T extends Replacement> void updateRenames(Set<T> allConsistentRenames, Set<T> allInconsistentRenames, Set<T> renames, Map<String, Set<String>> aliasedAttributesInOriginalClass, Map<String, Set<String>> aliasedAttributesInNextClass) {
        for (Replacement newRename : renames) {
            Set<Replacement> inconsistentRenames = ConsistentReplacementDetector.inconsistentRenames(allConsistentRenames, newRename);
            ConsistentReplacementDetector.filter(inconsistentRenames, aliasedAttributesInOriginalClass, aliasedAttributesInNextClass);
            if (inconsistentRenames.isEmpty()) {
                allConsistentRenames.add(newRename);
                continue;
            }
            allInconsistentRenames.addAll(inconsistentRenames);
            allInconsistentRenames.add(newRename);
        }
    }

    private static <T extends Replacement> Set<T> filter(Set<T> inconsistentRenames, Map<String, Set<String>> aliasedAttributesInOriginalClass, Map<String, Set<String>> aliasedAttributesInNextClass) {
        Set<String> aliasedAttributes;
        LinkedHashSet<Replacement> renamesToBeRemoved = new LinkedHashSet<Replacement>();
        for (String key : aliasedAttributesInOriginalClass.keySet()) {
            aliasedAttributes = aliasedAttributesInOriginalClass.get(key);
            for (Replacement r : inconsistentRenames) {
                if (!aliasedAttributes.contains(r.getBefore())) continue;
                renamesToBeRemoved.add(r);
            }
        }
        for (String key : aliasedAttributesInNextClass.keySet()) {
            aliasedAttributes = aliasedAttributesInNextClass.get(key);
            for (Replacement r : inconsistentRenames) {
                if (!aliasedAttributes.contains(r.getAfter())) continue;
                renamesToBeRemoved.add(r);
            }
        }
        inconsistentRenames.removeAll(renamesToBeRemoved);
        return inconsistentRenames;
    }
}

