/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.kdoc.psi.api.KDoc;
import org.jetbrains.kotlin.kdoc.psi.impl.KDocSection;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtImportList;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationBody;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLCompanionObject;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLFile;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLGeneralization;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLJavadoc;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLModel;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLTagElement;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLTypeParameter;

public class UMLModelPsiReader {
    private final UMLModel umlModel;

    public UMLModelPsiReader(Set<String> repositoryDirectories) {
        this.umlModel = new UMLModel(repositoryDirectories);
    }

    public void parseFiles(@Nullable Project project, Map<String, String> kotlinFileContents) {
        for (String filePath : kotlinFileContents.keySet()) {
            KtFile ktFile = null;
            if (project != null) {
                ktFile = (KtFile)PsiFileFactory.getInstance((Project)project).createFileFromText(filePath, (Language)KotlinLanguage.INSTANCE, (CharSequence)kotlinFileContents.get(filePath));
            }
            List<String> importedTypes = this.processImports(ktFile);
            PsiElement[] elementsInFile = ktFile.getChildren();
            ArrayList<KtNamedFunction> packageLevelFunctions = new ArrayList<KtNamedFunction>();
            for (PsiElement psiElement : elementsInFile) {
                if (psiElement instanceof KtObjectDeclaration) {
                    KtObjectDeclaration objectDeclaration = (KtObjectDeclaration)psiElement;
                    this.processObject(objectDeclaration, filePath);
                    continue;
                }
                if (psiElement instanceof KtClass) {
                    KtClass ktClass = (KtClass)psiElement;
                    if (ktClass.isEnum()) {
                        this.processKtEnum(ktClass, ktFile.getPackageFqName().asString(), filePath, importedTypes);
                        continue;
                    }
                    this.processKtClass(ktClass, ktFile.getPackageFqName().asString(), filePath, importedTypes);
                    continue;
                }
                if (!(psiElement instanceof KtNamedFunction)) continue;
                packageLevelFunctions.add((KtNamedFunction)psiElement);
            }
            if (packageLevelFunctions.size() <= 0) continue;
            this.processPackageLevelFunctions(ktFile, packageLevelFunctions, filePath);
        }
    }

    private void processPackageLevelFunctions(KtFile ktFile, List<KtNamedFunction> packageLevelFunctions, String filePath) {
        UMLFile umlFile = new UMLFile(filePath);
        LocationInfo locationInfo = this.generateLocationInfo(ktFile, ktFile.getVirtualFilePath(), (KtElement)ktFile, CodeElementType.TYPE_DECLARATION);
        umlFile.setLocationInfo(locationInfo);
        for (KtNamedFunction function : packageLevelFunctions) {
            UMLOperation umlOperation = this.processMethodDeclaration(ktFile, function, false, filePath);
            umlOperation.setClassName(ktFile.getName());
            umlFile.addMethod(umlOperation);
        }
        this.getUmlModel().addFile(umlFile);
    }

    public List<String> processImports(KtFile ktFile) {
        ArrayList<String> importedTypes = new ArrayList<String>();
        KtImportList importList = ktFile.getImportList();
        if (importList != null) {
            for (KtImportDirective importDeclaration : importList.getImports()) {
                FqName fqName = importDeclaration.getImportedFqName();
                String importName = fqName == null ? null : fqName.asString();
                if (importName == null) continue;
                importedTypes.add(importName);
            }
        }
        return importedTypes;
    }

    public void processKtEnum(KtClass ktEnum, String packageName, String sourceFile, List<String> importedTypes) {
        UMLJavadoc javadoc = this.generateDocComment((KtNamedDeclaration)ktEnum);
        String className = ktEnum.getName();
        LocationInfo locationInfo = this.generateLocationInfo(ktEnum.getContainingKtFile(), sourceFile, (KtElement)ktEnum, CodeElementType.TYPE_DECLARATION);
        UMLClass umlClass = new UMLClass(packageName, className, locationInfo, ktEnum.isTopLevel(), importedTypes);
        umlClass.setJavadoc(javadoc);
        umlClass.setEnum(true);
        umlClass.setVisibility(this.extractVisibilityModifier((KtNamedDeclaration)ktEnum));
        this.getUmlModel().addClass(umlClass);
    }

    public void processKtClass(KtClass ktClass, String packageName, String sourceFile, List<String> importedTypes) {
        String className = ktClass.getName();
        LocationInfo locationInfo = this.generateLocationInfo(ktClass.getContainingKtFile(), sourceFile, (KtElement)ktClass, CodeElementType.TYPE_DECLARATION);
        UMLClass umlClass = new UMLClass(packageName, className, locationInfo, ktClass.isTopLevel(), importedTypes);
        if (ktClass.isInterface()) {
            umlClass.setInterface(true);
        }
        umlClass.setVisibility(this.extractVisibilityModifier((KtNamedDeclaration)ktClass));
        if (ktClass.isData()) {
            umlClass.setData(true);
        } else if (ktClass.isSealed()) {
            umlClass.setSealed(true);
        } else if (ktClass.isInner()) {
            umlClass.setInner(true);
        }
        KtModifierList ktClassExtendedModifiers = ktClass.getModifierList();
        if (ktClassExtendedModifiers != null) {
            for (KtAnnotation annotation : ktClassExtendedModifiers.getAnnotations()) {
                umlClass.addAnnotation(new UMLAnnotation(ktClass.getContainingKtFile(), sourceFile, annotation));
            }
        }
        List parameters = ktClass.getTypeParameters();
        for (Object parameter : parameters) {
            UMLTypeParameter umlTypeParameter = new UMLTypeParameter(parameter.getName());
            KtModifierList parameterModifierList = parameter.getModifierList();
            if (parameterModifierList != null) {
                for (KtAnnotation annotation : parameterModifierList.getAnnotations()) {
                    umlTypeParameter.addAnnotation(new UMLAnnotation(ktClass.getContainingKtFile(), sourceFile, annotation));
                }
            }
            umlClass.addTypeParameter(umlTypeParameter);
        }
        List superTypeListEntries = ktClass.getSuperTypeListEntries();
        for (Object superTypeListEntry : superTypeListEntries) {
            UMLType umlType = UMLType.extractTypeObject(ktClass.getContainingKtFile(), sourceFile, (KtElement)superTypeListEntry.getTypeReference(), 0);
            UMLGeneralization umlGeneralization = new UMLGeneralization(umlClass, umlType.getClassType());
            umlClass.setSuperclass(umlType);
            this.getUmlModel().addGeneralization(umlGeneralization);
        }
        List ktClassProperties = ktClass.getProperties();
        for (Object ktProperty : ktClassProperties) {
            UMLAttribute attribute = this.processFieldDeclaration(ktClass.getContainingKtFile(), (KtProperty)ktProperty, sourceFile);
            attribute.setClassName(umlClass.getQualifiedName());
            umlClass.addAttribute(attribute);
        }
        List declarations = ktClass.getDeclarations();
        for (KtDeclaration declaration : declarations) {
            if (!(declaration instanceof KtNamedFunction)) continue;
            KtNamedFunction function = (KtNamedFunction)declaration;
            UMLOperation operation = this.processMethodDeclaration(ktClass.getContainingKtFile(), function, umlClass.isInterface(), sourceFile);
            operation.setClassName(umlClass.getQualifiedName());
            umlClass.addOperation(operation);
        }
        List companionObjects = ktClass.getCompanionObjects();
        for (KtObjectDeclaration companionObject : companionObjects) {
            UMLCompanionObject umlCompanionObject = this.processCompanionObject(companionObject, sourceFile);
            umlCompanionObject.setClassName(umlClass.getQualifiedName());
            umlClass.addCompanionObject(umlCompanionObject);
        }
        this.getUmlModel().addClass(umlClass);
    }

    private UMLAttribute processFieldDeclaration(KtFile ktFile, KtProperty fieldDeclaration, String sourceFile) {
        UMLJavadoc javadoc = this.generateDocComment((KtNamedDeclaration)fieldDeclaration);
        UMLType type = UMLType.extractTypeObject(ktFile, sourceFile, (KtElement)fieldDeclaration.getTypeReference(), 0);
        String fieldName = fieldDeclaration.getName();
        LocationInfo locationInfo = this.generateLocationInfo(ktFile, sourceFile, (KtElement)fieldDeclaration, CodeElementType.FIELD_DECLARATION);
        UMLAttribute umlAttribute = new UMLAttribute(fieldName, type, locationInfo);
        VariableDeclaration variableDeclaration = new VariableDeclaration(ktFile, sourceFile, (KtElement)fieldDeclaration);
        variableDeclaration.setAttribute(true);
        umlAttribute.setVariableDeclaration(variableDeclaration);
        umlAttribute.setJavadoc(javadoc);
        umlAttribute.setVisibility(this.extractVisibilityModifier((KtNamedDeclaration)fieldDeclaration));
        return umlAttribute;
    }

    private UMLJavadoc generateDocComment(KtNamedDeclaration bodyDeclaration) {
        UMLJavadoc doc = null;
        KDoc javaDoc = bodyDeclaration.getDocComment();
        if (javaDoc != null) {
            doc = new UMLJavadoc();
            KDocSection tag = javaDoc.getDefaultSection();
            UMLTagElement tagElement = new UMLTagElement(tag.getName());
            String fragments = tag.getContent();
            tagElement.addFragment(fragments);
            doc.addTag(tagElement);
        }
        return doc;
    }

    private UMLOperation processMethodDeclaration(KtFile ktFile, KtNamedFunction methodDeclaration, boolean isInterfaceMethod, String filePath) {
        KtTypeReference returnTypeReference;
        UMLJavadoc javadoc = this.generateDocComment((KtNamedDeclaration)methodDeclaration);
        String methodName = methodDeclaration.getName();
        LocationInfo locationInfo = this.generateLocationInfo(ktFile.getContainingKtFile(), filePath, (KtElement)methodDeclaration, CodeElementType.METHOD_DECLARATION);
        UMLOperation umlOperation = new UMLOperation(methodName, locationInfo);
        umlOperation.setJavadoc(javadoc);
        umlOperation.setConstructor(false);
        if (methodDeclaration.hasDeclaredReturnType() && (returnTypeReference = methodDeclaration.getTypeReference()) != null) {
            UMLType type = UMLType.extractTypeObject(ktFile.getContainingKtFile(), filePath, (KtElement)returnTypeReference, 0);
            UMLParameter returnParameter = new UMLParameter("return", type, "return", false);
            umlOperation.addParameter(returnParameter);
        }
        KtModifierList methodModifiers = methodDeclaration.getModifierList();
        if (isInterfaceMethod) {
            umlOperation.setVisibility("public");
        } else {
            umlOperation.setVisibility(this.extractVisibilityModifier((KtNamedDeclaration)methodDeclaration));
        }
        if (methodModifiers != null) {
            List ktAnnotations = methodModifiers.getAnnotations();
            for (KtAnnotation annotation : ktAnnotations) {
                umlOperation.addAnnotation(new UMLAnnotation(ktFile.getContainingKtFile(), filePath, annotation));
            }
        }
        List typeParameters = methodDeclaration.getTypeParameters();
        for (KtTypeParameter typeParameter : typeParameters) {
            KtModifierList typeParameterExtendedModifiers;
            UMLTypeParameter umlTypeParameter = new UMLTypeParameter(typeParameter.getName());
            KtTypeReference typeBounds = typeParameter.getExtendsBound();
            if (typeBounds != null) {
                umlTypeParameter.addTypeBound(UMLType.extractTypeObject(ktFile.getContainingKtFile(), filePath, (KtElement)typeBounds, 0));
            }
            if ((typeParameterExtendedModifiers = typeParameter.getModifierList()) != null) {
                for (KtAnnotation annotation : typeParameterExtendedModifiers.getAnnotations()) {
                    umlTypeParameter.addAnnotation(new UMLAnnotation(ktFile.getContainingKtFile(), filePath, annotation));
                }
            }
            umlOperation.addTypeParameter(umlTypeParameter);
        }
        KtBlockExpression methodBody = methodDeclaration.getBodyBlockExpression();
        if (methodBody != null) {
            OperationBody body = new OperationBody(ktFile.getContainingKtFile(), filePath, methodBody);
            umlOperation.setBody(body);
            if (methodBody.getStatements().size() == 0) {
                umlOperation.setEmptyBody(true);
            }
        } else {
            umlOperation.setBody(null);
        }
        List parameters = methodDeclaration.getValueParameters();
        for (KtParameter parameter : parameters) {
            KtTypeReference typeReference = parameter.getTypeReference();
            String paramName = parameter.getName();
            UMLType type = UMLType.extractTypeObject(parameter.getContainingKtFile(), filePath, (KtElement)typeReference, 0);
            UMLParameter umlParameter = new UMLParameter(paramName, type, "in", parameter.isVarArg());
            VariableDeclaration variableDeclaration = new VariableDeclaration(parameter.getContainingKtFile(), filePath, parameter, parameter.isVarArg());
            variableDeclaration.setParameter(true);
            umlParameter.setVariableDeclaration(variableDeclaration);
            umlOperation.addParameter(umlParameter);
        }
        return umlOperation;
    }

    public UMLCompanionObject processCompanionObject(KtObjectDeclaration object, String sourceFile) {
        UMLCompanionObject umlCompanionObject = new UMLCompanionObject();
        umlCompanionObject.setName(object.getName());
        LocationInfo objectLocationInfo = this.generateLocationInfo(object.getContainingKtFile(), sourceFile, (KtElement)object, CodeElementType.COMPANION_OBJECT);
        umlCompanionObject.setLocationInfo(objectLocationInfo);
        List declarations = object.getDeclarations();
        for (KtDeclaration declaration : declarations) {
            LocationInfo locationInfo = this.generateLocationInfo(declaration.getContainingKtFile(), sourceFile, (KtElement)declaration, CodeElementType.METHOD_DECLARATION);
            UMLOperation method = new UMLOperation(declaration.getName(), locationInfo);
            umlCompanionObject.addMethod(method);
        }
        return umlCompanionObject;
    }

    public void processObject(KtObjectDeclaration objectDeclaration, String filePath) {
        String objectName = objectDeclaration.getName();
        LocationInfo locationInfo = this.generateLocationInfo(objectDeclaration.getContainingKtFile(), filePath, (KtElement)objectDeclaration, CodeElementType.TYPE_DECLARATION);
        UMLClass object = new UMLClass(objectDeclaration.getContainingKtFile().getPackageFqName().asString(), objectName, locationInfo, objectDeclaration.isTopLevel(), this.processImports(objectDeclaration.getContainingKtFile()));
        object.setObject(true);
        object.setVisibility(this.extractVisibilityModifier((KtNamedDeclaration)objectDeclaration));
        KtClassBody body = objectDeclaration.getBody();
        if (body != null) {
            List functions = body.getFunctions();
            for (KtNamedFunction function : functions) {
                UMLOperation operation = this.processMethodDeclaration(objectDeclaration.getContainingKtFile(), function, object.isInterface(), filePath);
                operation.setClassName(object.getQualifiedName());
                object.addOperation(operation);
            }
            List properties = body.getProperties();
            for (KtProperty property : properties) {
                UMLAttribute umlAttribute = this.processFieldDeclaration(property.getContainingKtFile(), property, filePath);
                umlAttribute.setClassName(object.getQualifiedName());
                object.addAttribute(umlAttribute);
            }
        }
        this.getUmlModel().addClass(object);
    }

    private String extractVisibilityModifier(KtNamedDeclaration ktNamedDeclaration) {
        KtModifierList modifiers = ktNamedDeclaration.getModifierList();
        String visibility = modifiers != null ? (modifiers.hasModifier(KtTokens.PUBLIC_KEYWORD) ? "public" : (modifiers.hasModifier(KtTokens.PROTECTED_KEYWORD) ? "protected" : (modifiers.hasModifier(KtTokens.PRIVATE_KEYWORD) ? "private" : (modifiers.hasModifier(KtTokens.INTERNAL_KEYWORD) ? "internal" : "public")))) : "public";
        return visibility;
    }

    public UMLModel getUmlModel() {
        return this.umlModel;
    }

    private LocationInfo generateLocationInfo(KtFile ktFile, String sourceFile, KtElement node, CodeElementType codeElementType) {
        return new LocationInfo(ktFile, sourceFile, node, codeElementType);
    }
}

