/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeFragment;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AnonymousClassDeclarationObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.ObjectCreation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.Visitor;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;

public class AbstractExpression
extends AbstractCodeFragment {
    private final String expression;
    private final LocationInfo locationInfo;
    private CompositeStatementObject owner;
    private final List<String> variables;
    private final List<String> types;
    private final List<String> stringLiterals;
    private final List<String> numberLiterals;
    private final List<String> nullLiterals;
    private final List<String> booleanLiterals;
    private final List<String> typeLiterals;
    private final List<VariableDeclaration> variableDeclarations;
    private final List<String> arrayAccesses;
    private final List<String> arguments;
    private final List<String> prefixExpressions;
    private final List<String> postfixExpressions;
    private final List<String> infixOperators;
    private final List<LambdaExpressionObject> lambdas;
    private final Map<String, List<ObjectCreation>> creationMap;
    private final Map<String, List<OperationInvocation>> methodInvocationMap;

    public AbstractExpression(@NotNull KtFile cu, @NotNull String filePath, @NotNull KtExpression expression, @NotNull CodeElementType codeElementType) {
        if (cu == null) {
            AbstractExpression.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            AbstractExpression.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            AbstractExpression.$$$reportNull$$$0(2);
        }
        if (codeElementType == null) {
            AbstractExpression.$$$reportNull$$$0(3);
        }
        this.locationInfo = new LocationInfo(cu, filePath, (KtElement)expression, codeElementType);
        Visitor visitor = new Visitor(cu, filePath);
        expression.accept((PsiElementVisitor)visitor);
        this.variables = visitor.getVariables();
        this.types = visitor.getTypes();
        this.variableDeclarations = visitor.getVariableDeclarations();
        this.stringLiterals = visitor.getStringLiterals();
        this.numberLiterals = visitor.getNumberLiterals();
        this.nullLiterals = visitor.getNullLiterals();
        this.booleanLiterals = visitor.getBooleanLiterals();
        this.typeLiterals = visitor.getTypeLiterals();
        this.arrayAccesses = visitor.getArrayAccesses();
        this.arguments = visitor.getArguments();
        this.prefixExpressions = visitor.getPrefixExpressions();
        this.postfixExpressions = visitor.getPostfixExpressions();
        this.infixOperators = visitor.getInfixOperators();
        this.lambdas = visitor.getLambdas();
        this.expression = expression.getText();
        this.owner = null;
        this.creationMap = visitor.getCreationMap();
        this.methodInvocationMap = visitor.getMethodInvocationMap();
    }

    public void setOwner(CompositeStatementObject owner) {
        this.owner = owner;
    }

    public CompositeStatementObject getOwner() {
        return this.owner;
    }

    @Override
    public CompositeStatementObject getParent() {
        return this.getOwner();
    }

    public String getExpression() {
        return this.expression;
    }

    @Override
    public String getString() {
        return this.toString();
    }

    public String toString() {
        return this.getExpression();
    }

    @Override
    public List<String> getVariables() {
        return this.variables;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    @Override
    public Map<String, List<OperationInvocation>> getMethodInvocationMap() {
        return this.methodInvocationMap;
    }

    @Override
    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return new ArrayList<AnonymousClassDeclarationObject>();
    }

    @Override
    public List<String> getStringLiterals() {
        return this.stringLiterals;
    }

    @Override
    public List<String> getNumberLiterals() {
        return this.numberLiterals;
    }

    @Override
    public List<String> getNullLiterals() {
        return this.nullLiterals;
    }

    @Override
    public List<String> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    @Override
    public List<String> getTypeLiterals() {
        return this.typeLiterals;
    }

    @Override
    public Map<String, List<ObjectCreation>> getCreationMap() {
        return this.creationMap;
    }

    @Override
    public List<String> getArrayAccesses() {
        return this.arrayAccesses;
    }

    @Override
    public List<String> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    @Override
    public List<String> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    @Override
    public List<String> getInfixOperators() {
        return this.infixOperators;
    }

    @Override
    public List<String> getInfixExpressions() {
        return new ArrayList<String>();
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public VariableDeclaration searchVariableDeclaration(String variableName) {
        VariableDeclaration variableDeclaration = this.getVariableDeclaration(variableName);
        if (variableDeclaration != null) {
            return variableDeclaration;
        }
        if (this.owner != null) {
            return this.owner.searchVariableDeclaration(variableName);
        }
        return null;
    }

    @Override
    public VariableDeclaration getVariableDeclaration(String variableName) {
        List<VariableDeclaration> variableDeclarations = this.getVariableDeclarations();
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(variableName)) continue;
            return declaration;
        }
        return null;
    }

    @Override
    public List<LambdaExpressionObject> getLambdas() {
        return this.lambdas;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "cu";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "expression";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "codeElementType";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/research/kotlinrminer/ide/decomposition/AbstractExpression";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

