/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class CallTreeNode {
    private final UMLOperation originalOperation;
    private final UMLOperation invokedOperation;
    private final OperationInvocation invocation;
    private final List<CallTreeNode> children = new ArrayList<CallTreeNode>();

    public CallTreeNode(UMLOperation originalOperation, UMLOperation invokedOperation, OperationInvocation invocation) {
        this.originalOperation = originalOperation;
        this.invokedOperation = invokedOperation;
        this.invocation = invocation;
    }

    public UMLOperation getOriginalOperation() {
        return this.originalOperation;
    }

    public UMLOperation getInvokedOperation() {
        return this.invokedOperation;
    }

    public OperationInvocation getInvocation() {
        return this.invocation;
    }

    public void addChild(CallTreeNode node) {
        this.children.add(node);
    }

    public List<CallTreeNode> getChildren() {
        return this.children;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.invocation == null ? 0 : this.invocation.hashCode());
        result = 31 * result + (this.invokedOperation == null ? 0 : this.invokedOperation.hashCode());
        result = 31 * result + (this.originalOperation == null ? 0 : this.originalOperation.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CallTreeNode other = (CallTreeNode)obj;
        if (this.invocation == null ? other.invocation != null : !this.invocation.equals(other.invocation)) {
            return false;
        }
        if (this.invokedOperation == null ? other.invokedOperation != null : !this.invokedOperation.equals(other.invokedOperation)) {
            return false;
        }
        if (this.originalOperation == null) {
            return other.originalOperation == null;
        }
        return this.originalOperation.equals(other.originalOperation);
    }

    public String toString() {
        return this.invokedOperation + " called from " + this.originalOperation;
    }
}

