/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.research.kotlinrminer.common.replacement.ConsistentReplacementDetector;
import org.jetbrains.research.kotlinrminer.common.replacement.MergeVariableReplacement;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.common.replacement.SplitVariableReplacement;
import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.replacement.MethodInvocationReplacement;
import org.jetbrains.research.kotlinrminer.ide.diff.ExtractOperationDetection;
import org.jetbrains.research.kotlinrminer.ide.diff.InlineOperationDetection;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLAnnotationListDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLAttributeDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLOperationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateMergeVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateSplitVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ChangeVariableTypeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.InlineOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MergeVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.SplitVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public abstract class UMLClassBaseDiff
implements Comparable<UMLClassBaseDiff> {
    public static final double MAX_OPERATION_NAME_DISTANCE = 0.4;
    protected UMLClass originalClass;
    protected UMLClass nextClass;
    protected List<UMLOperation> addedOperations;
    protected List<UMLOperation> removedOperations;
    protected List<UMLAttribute> addedAttributes;
    protected List<UMLAttribute> removedAttributes;
    protected List<UMLAttributeDiff> attributeDiffList;
    private final List<UMLOperationBodyMapper> operationBodyMapperList;
    private boolean visibilityChanged;
    private String oldVisibility;
    private String newVisibility;
    private boolean abstractionChanged;
    private boolean oldAbstraction;
    private boolean newAbstraction;
    private boolean superclassChanged;
    private UMLType oldSuperclass;
    private UMLType newSuperclass;
    private final List<UMLType> addedImplementedInterfaces;
    private final List<UMLType> removedImplementedInterfaces;
    private final List<UMLOperationDiff> operationDiffList;
    private UMLAnnotationListDiff annotationListDiff;
    protected List<Refactoring> refactorings;
    private Set<MethodInvocationReplacement> consistentMethodInvocationRenames;
    private final Set<CandidateAttributeRefactoring> candidateAttributeRenames = new LinkedHashSet<CandidateAttributeRefactoring>();
    private final Set<CandidateMergeVariableRefactoring> candidateAttributeMerges = new LinkedHashSet<CandidateMergeVariableRefactoring>();
    private final Set<CandidateSplitVariableRefactoring> candidateAttributeSplits = new LinkedHashSet<CandidateSplitVariableRefactoring>();
    private final Map<Replacement, Set<CandidateAttributeRefactoring>> renameMap = new LinkedHashMap<Replacement, Set<CandidateAttributeRefactoring>>();
    private final Map<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>> mergeMap = new LinkedHashMap<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>>();
    private final Map<SplitVariableReplacement, Set<CandidateSplitVariableRefactoring>> splitMap = new LinkedHashMap<SplitVariableReplacement, Set<CandidateSplitVariableRefactoring>>();
    private final UMLModelDiff modelDiff;

    public UMLClassBaseDiff(UMLClass originalClass, UMLClass nextClass, UMLModelDiff modelDiff) {
        this.originalClass = originalClass;
        this.nextClass = nextClass;
        this.visibilityChanged = false;
        this.abstractionChanged = false;
        this.superclassChanged = false;
        this.addedOperations = new ArrayList<UMLOperation>();
        this.removedOperations = new ArrayList<UMLOperation>();
        this.addedAttributes = new ArrayList<UMLAttribute>();
        this.removedAttributes = new ArrayList<UMLAttribute>();
        this.operationBodyMapperList = new ArrayList<UMLOperationBodyMapper>();
        this.addedImplementedInterfaces = new ArrayList<UMLType>();
        this.removedImplementedInterfaces = new ArrayList<UMLType>();
        this.operationDiffList = new ArrayList<UMLOperationDiff>();
        this.attributeDiffList = new ArrayList<UMLAttributeDiff>();
        this.refactorings = new ArrayList<Refactoring>();
        this.modelDiff = modelDiff;
    }

    public void process() throws RefactoringMinerTimedOutException {
        this.processAnnotations();
        this.processInheritance();
        this.processOperations();
        this.createBodyMappers();
        this.processAttributes();
        this.checkForAttributeChanges();
        this.processAnonymousClasses();
        this.checkForOperationSignatureChanges();
        this.checkForInlinedOperations();
        this.checkForExtractedOperations();
    }

    private void processAnnotations() {
        this.annotationListDiff = new UMLAnnotationListDiff(this.originalClass.getAnnotations(), this.nextClass.getAnnotations());
        for (UMLAnnotation uMLAnnotation : this.annotationListDiff.getAddedAnnotations()) {
        }
    }

    public UMLOperationDiff getOperationDiff(UMLOperation operation1, UMLOperation operation2) {
        for (UMLOperationDiff diff : this.operationDiffList) {
            if (!diff.getRemovedOperation().equals(operation1) || !diff.getAddedOperation().equals(operation2)) continue;
            return diff;
        }
        return null;
    }

    public UMLOperationBodyMapper findMapperWithMatchingSignatures(UMLOperation operation1, UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (!mapper.getOperation1().equalSignature(operation1) || !mapper.getOperation2().equalSignature(operation2)) continue;
            return mapper;
        }
        return null;
    }

    public UMLOperationBodyMapper findMapperWithMatchingSignature2(UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (!mapper.getOperation2().equalSignature(operation2)) continue;
            return mapper;
        }
        return null;
    }

    public Set<UMLType> nextClassCommonInterfaces(UMLClassBaseDiff other) {
        LinkedHashSet<UMLType> common = new LinkedHashSet<UMLType>(this.nextClass.getImplementedInterfaces());
        common.retainAll(other.nextClass.getImplementedInterfaces());
        return common;
    }

    protected void checkForAttributeChanges() {
    }

    protected void createBodyMappers() throws RefactoringMinerTimedOutException {
    }

    protected void processAnonymousClasses() {
    }

    protected void processAttributes() {
        UMLAttributeDiff attributeDiff;
        UMLAttribute attributeWithTheSameName;
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            attributeWithTheSameName = this.nextClass.attributeWithTheSameNameIgnoringChangedType(attribute);
            if (attributeWithTheSameName == null) {
                this.removedAttributes.add(attribute);
                continue;
            }
            if (this.attributeDiffListContainsAttribute(attribute, attributeWithTheSameName) || (attributeDiff = new UMLAttributeDiff(attribute, attributeWithTheSameName, this.operationBodyMapperList)).isEmpty()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
            this.attributeDiffList.add(attributeDiff);
        }
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            attributeWithTheSameName = this.originalClass.attributeWithTheSameNameIgnoringChangedType(attribute);
            if (attributeWithTheSameName == null) {
                this.addedAttributes.add(attribute);
                continue;
            }
            if (this.attributeDiffListContainsAttribute(attributeWithTheSameName, attribute) || (attributeDiff = new UMLAttributeDiff(attributeWithTheSameName, attribute, this.operationBodyMapperList)).isEmpty()) continue;
            this.refactorings.addAll(attributeDiff.getRefactorings());
            this.attributeDiffList.add(attributeDiff);
        }
    }

    protected void processOperations() throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper mapper;
        UMLOperation operationWithTheSameSignature;
        for (UMLOperation operation : this.originalClass.getOperations()) {
            operationWithTheSameSignature = this.nextClass.operationWithTheSameSignatureIgnoringChangedTypes(operation);
            if (operationWithTheSameSignature == null) {
                this.removedOperations.add(operation);
                continue;
            }
            if (this.mapperListContainsOperation(operation, operationWithTheSameSignature)) continue;
            mapper = new UMLOperationBodyMapper(operation, operationWithTheSameSignature, this);
            this.operationBodyMapperList.add(mapper);
        }
        for (UMLOperation operation : this.nextClass.getOperations()) {
            operationWithTheSameSignature = this.originalClass.operationWithTheSameSignatureIgnoringChangedTypes(operation);
            if (operationWithTheSameSignature == null) {
                this.addedOperations.add(operation);
                continue;
            }
            if (this.mapperListContainsOperation(operationWithTheSameSignature, operation)) continue;
            mapper = new UMLOperationBodyMapper(operationWithTheSameSignature, operation, this);
            this.operationBodyMapperList.add(mapper);
        }
    }

    private boolean attributeDiffListContainsAttribute(UMLAttribute attribute1, UMLAttribute attribute2) {
        for (UMLAttributeDiff diff : this.attributeDiffList) {
            if (!diff.getRemovedAttribute().equals(attribute1) && !diff.getAddedAttribute().equals(attribute2)) continue;
            return true;
        }
        return false;
    }

    private boolean mapperListContainsOperation(UMLOperation operation1, UMLOperation operation2) {
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            if (!mapper.getOperation1().equals(operation1) && !mapper.getOperation2().equals(operation2)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(String className) {
        return this.originalClass.getQualifiedName().equals(className) || this.nextClass.getQualifiedName().equals(className);
    }

    public boolean matches(UMLType type) {
        return this.originalClass.getQualifiedName().endsWith("." + type.getClassType()) || this.nextClass.getQualifiedName().endsWith("." + type.getClassType());
    }

    public String getOriginalClassName() {
        return this.originalClass.getQualifiedName();
    }

    public String getNextClassName() {
        return this.nextClass.getQualifiedName();
    }

    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getNextClass() {
        return this.nextClass;
    }

    public List<UMLOperationBodyMapper> getOperationBodyMapperList() {
        return this.operationBodyMapperList;
    }

    public List<UMLOperation> getAddedOperations() {
        return this.addedOperations;
    }

    public List<UMLOperation> getRemovedOperations() {
        return this.removedOperations;
    }

    public List<UMLAttribute> getAddedAttributes() {
        return this.addedAttributes;
    }

    public List<UMLAttribute> getRemovedAttributes() {
        return this.removedAttributes;
    }

    public boolean isInnerClassMove(UMLClassBaseDiff classDiff) {
        return this.originalClass.isInnerClass(classDiff.originalClass) && this.nextClass.isInnerClass(classDiff.nextClass);
    }

    public boolean nextClassImportsType(String targetClass) {
        return this.nextClass.importsType(targetClass);
    }

    public boolean originalClassImportsType(String targetClass) {
        return this.originalClass.importsType(targetClass);
    }

    public List<UMLAttribute> nextClassAttributesOfType(String targetClass) {
        return this.nextClass.attributesOfType(targetClass);
    }

    public List<UMLAttribute> originalClassAttributesOfType(String targetClass) {
        return this.originalClass.attributesOfType(targetClass);
    }

    private void reportAddedImplementedInterface(UMLType implementedInterface) {
        this.addedImplementedInterfaces.add(implementedInterface);
    }

    private void reportRemovedImplementedInterface(UMLType implementedInterface) {
        this.removedImplementedInterfaces.add(implementedInterface);
    }

    private void setVisibilityChanged(boolean visibilityChanged) {
        this.visibilityChanged = visibilityChanged;
    }

    private void setOldVisibility(String oldVisibility) {
        this.oldVisibility = oldVisibility;
    }

    private void setNewVisibility(String newVisibility) {
        this.newVisibility = newVisibility;
    }

    private void setAbstractionChanged(boolean abstractionChanged) {
        this.abstractionChanged = abstractionChanged;
    }

    private void setOldAbstraction(boolean oldAbstraction) {
        this.oldAbstraction = oldAbstraction;
    }

    private void setNewAbstraction(boolean newAbstraction) {
        this.newAbstraction = newAbstraction;
    }

    private void setSuperclassChanged(boolean superclassChanged) {
        this.superclassChanged = superclassChanged;
    }

    private void setOldSuperclass(UMLType oldSuperclass) {
        this.oldSuperclass = oldSuperclass;
    }

    private void setNewSuperclass(UMLType newSuperclass) {
        this.newSuperclass = newSuperclass;
    }

    public UMLType getSuperclass() {
        if (!this.superclassChanged && this.oldSuperclass != null && this.newSuperclass != null) {
            return this.oldSuperclass;
        }
        return null;
    }

    public UMLType getOldSuperclass() {
        return this.oldSuperclass;
    }

    public UMLType getNewSuperclass() {
        return this.newSuperclass;
    }

    public List<UMLType> getAddedImplementedInterfaces() {
        return this.addedImplementedInterfaces;
    }

    public List<UMLType> getRemovedImplementedInterfaces() {
        return this.removedImplementedInterfaces;
    }

    public Set<CandidateAttributeRefactoring> getCandidateAttributeRenames() {
        return this.candidateAttributeRenames;
    }

    public Set<CandidateMergeVariableRefactoring> getCandidateAttributeMerges() {
        return this.candidateAttributeMerges;
    }

    public Set<CandidateSplitVariableRefactoring> getCandidateAttributeSplits() {
        return this.candidateAttributeSplits;
    }

    public boolean containsOperationWithTheSameSignatureInOriginalClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.originalClass.getOperations()) {
            if (!originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public boolean containsOperationWithTheSameSignatureInNextClass(UMLOperation operation) {
        for (UMLOperation originalOperation : this.nextClass.getOperations()) {
            if (!originalOperation.equalSignatureWithIdenticalNameIgnoringChangedTypes(operation)) continue;
            return true;
        }
        return false;
    }

    public UMLOperation containsRemovedOperationWithTheSameSignature(UMLOperation operation) {
        for (UMLOperation removedOperation : this.removedOperations) {
            if (!removedOperation.equalSignature(operation)) continue;
            return removedOperation;
        }
        return null;
    }

    public UMLAttribute containsRemovedAttributeWithTheSameSignature(UMLAttribute attribute) {
        for (UMLAttribute removedAttribute : this.removedAttributes) {
            if (!removedAttribute.equalsIgnoringChangedVisibility(attribute)) continue;
            return removedAttribute;
        }
        return null;
    }

    private void processInheritance() {
        if (!this.originalClass.getVisibility().equals(this.nextClass.getVisibility())) {
            this.setVisibilityChanged(true);
            this.setOldVisibility(this.originalClass.getVisibility());
            this.setNewVisibility(this.nextClass.getVisibility());
        }
        if (!this.originalClass.isInterface() && !this.nextClass.isInterface() && this.originalClass.isAbstract() != this.nextClass.isAbstract()) {
            this.setAbstractionChanged(true);
            this.setOldAbstraction(this.originalClass.isAbstract());
            this.setNewAbstraction(this.nextClass.isAbstract());
        }
        if (this.originalClass.getSuperclass() != null && this.nextClass.getSuperclass() != null) {
            if (!this.originalClass.getSuperclass().equals(this.nextClass.getSuperclass())) {
                this.setSuperclassChanged(true);
            }
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        } else if (this.originalClass.getSuperclass() != null && this.nextClass.getSuperclass() == null) {
            this.setSuperclassChanged(true);
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        } else if (this.originalClass.getSuperclass() == null && this.nextClass.getSuperclass() != null) {
            this.setSuperclassChanged(true);
            this.setOldSuperclass(this.originalClass.getSuperclass());
            this.setNewSuperclass(this.nextClass.getSuperclass());
        }
        for (UMLType implementedInterface : this.originalClass.getImplementedInterfaces()) {
            if (this.nextClass.getImplementedInterfaces().contains(implementedInterface)) continue;
            this.reportRemovedImplementedInterface(implementedInterface);
        }
        for (UMLType implementedInterface : this.nextClass.getImplementedInterfaces()) {
            if (this.originalClass.getImplementedInterfaces().contains(implementedInterface)) continue;
            this.reportAddedImplementedInterface(implementedInterface);
        }
    }

    public void addOperationBodyMapper(UMLOperationBodyMapper operationBodyMapper) {
        this.operationBodyMapperList.add(operationBodyMapper);
    }

    public List<Refactoring> getRefactoringsBeforePostProcessing() {
        return this.refactorings;
    }

    public List<Refactoring> getRefactorings() {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>(this.refactorings);
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(mapper.getOperation1(), mapper.getOperation2(), mapper.getMappings());
            refactorings.addAll(operationSignatureDiff.getRefactorings());
            this.processMapperRefactorings(mapper, refactorings);
        }
        refactorings.addAll(this.inferAttributeMergesAndSplits(this.renameMap, refactorings));
        for (MergeVariableReplacement merge : this.mergeMap.keySet()) {
            LinkedHashSet<UMLAttribute> mergedAttributes = new LinkedHashSet<UMLAttribute>();
            LinkedHashSet<VariableDeclaration> mergedVariables = new LinkedHashSet<VariableDeclaration>();
            for (String mergedVariable : merge.getMergedVariables()) {
                UMLAttribute a1 = this.findAttributeInOriginalClass(mergedVariable);
                if (a1 == null) continue;
                mergedAttributes.add(a1);
                mergedVariables.add(a1.getVariableDeclaration());
            }
        }
        for (SplitVariableReplacement split : this.splitMap.keySet()) {
            LinkedHashSet<UMLAttribute> splitAttributes = new LinkedHashSet<UMLAttribute>();
            LinkedHashSet<VariableDeclaration> splitVariables = new LinkedHashSet<VariableDeclaration>();
            for (String splitVariable : split.getSplitVariables()) {
                UMLAttribute a2 = this.findAttributeInNextClass(splitVariable);
                if (a2 == null) continue;
                splitAttributes.add(a2);
                splitVariables.add(a2.getVariableDeclaration());
            }
        }
        Set<Replacement> renames = this.renameMap.keySet();
        LinkedHashSet allConsistentRenames = new LinkedHashSet();
        LinkedHashSet allInconsistentRenames = new LinkedHashSet();
        Map<String, Set<String>> aliasedAttributesInOriginalClass = this.originalClass.aliasedAttributes();
        Map<String, Set<String>> aliasedAttributesInNextClass = this.nextClass.aliasedAttributes();
        ConsistentReplacementDetector.updateRenames(allConsistentRenames, allInconsistentRenames, renames, aliasedAttributesInOriginalClass, aliasedAttributesInNextClass);
        allConsistentRenames.removeAll(allInconsistentRenames);
        for (Replacement pattern : allConsistentRenames) {
            UMLAttribute a1 = this.findAttributeInOriginalClass(pattern.getBefore());
            UMLAttribute a2 = this.findAttributeInNextClass(pattern.getAfter());
            Set<CandidateAttributeRefactoring> set = this.renameMap.get(pattern);
            for (CandidateAttributeRefactoring candidate : set) {
                if (candidate.getOriginalVariableDeclaration() == null && candidate.getRenamedVariableDeclaration() == null) {
                    if (a1 != null && a2 != null) {
                        if (this.originalClass.containsAttributeWithName(pattern.getAfter()) && !UMLClassBaseDiff.cyclicRename(this.renameMap, pattern) || this.nextClass.containsAttributeWithName(pattern.getBefore()) && !UMLClassBaseDiff.cyclicRename(this.renameMap, pattern) || this.inconsistentAttributeRename(pattern, aliasedAttributesInOriginalClass, aliasedAttributesInNextClass) || this.attributeMerged(a1, a2, refactorings) || this.attributeSplit(a1, a2, refactorings)) continue;
                        continue;
                    }
                    candidate.setOriginalAttribute(a1);
                    candidate.setRenamedAttribute(a2);
                    if (a1 != null) {
                        candidate.setOriginalVariableDeclaration(a1.getVariableDeclaration());
                    }
                    if (a2 != null) {
                        candidate.setRenamedVariableDeclaration(a2.getVariableDeclaration());
                    }
                    this.candidateAttributeRenames.add(candidate);
                    continue;
                }
                if (candidate.getOriginalVariableDeclaration() == null) continue;
                if (a2 != null) {
                    RenameVariableRefactoring ref = new RenameVariableRefactoring(candidate.getOriginalVariableDeclaration(), a2.getVariableDeclaration(), candidate.getOperationBefore(), candidate.getOperationAfter(), candidate.getAttributeReferences());
                    if (refactorings.contains(ref)) continue;
                    refactorings.add(ref);
                    if (candidate.getOriginalVariableDeclaration().getType().equals(a2.getVariableDeclaration().getType()) && candidate.getOriginalVariableDeclaration().getType().equalsQualified(a2.getVariableDeclaration().getType())) continue;
                    ChangeVariableTypeRefactoring refactoring = new ChangeVariableTypeRefactoring(candidate.getOriginalVariableDeclaration(), a2.getVariableDeclaration(), candidate.getOperationBefore(), candidate.getOperationAfter(), candidate.getAttributeReferences());
                    refactoring.addRelatedRefactoring(ref);
                    refactorings.add(refactoring);
                    continue;
                }
                this.candidateAttributeRenames.add(candidate);
            }
        }
        return refactorings;
    }

    private void processMapperRefactorings(UMLOperationBodyMapper mapper, List<Refactoring> refactorings) {
        Object after;
        for (Refactoring refactoring : mapper.getRefactorings()) {
            if (refactorings.contains(refactoring)) {
                int index = refactorings.indexOf(refactoring);
                refactorings.remove(index);
                refactorings.add(index, refactoring);
                continue;
            }
            refactorings.add(refactoring);
        }
        for (CandidateAttributeRefactoring candidateAttributeRefactoring : mapper.getCandidateAttributeRenames()) {
            Replacement renamePattern;
            String prefix2;
            String prefix1;
            if (this.multipleExtractedMethodInvocationsWithDifferentAttributesAsArguments(candidateAttributeRefactoring, refactorings)) continue;
            String before = PrefixSuffixUtils.normalize(candidateAttributeRefactoring.getOriginalVariableName());
            after = PrefixSuffixUtils.normalize(candidateAttributeRefactoring.getRenamedVariableName());
            if (before.contains(".") && ((String)after).contains(".") && (prefix1 = before.substring(0, before.lastIndexOf(".") + 1)).equals(prefix2 = ((String)after).substring(0, ((String)after).lastIndexOf(".") + 1))) {
                before = before.substring(prefix1.length());
                after = ((String)after).substring(prefix2.length());
            }
            if (this.renameMap.containsKey(renamePattern = new Replacement(before, (String)after, Replacement.ReplacementType.VARIABLE_NAME))) {
                this.renameMap.get(renamePattern).add(candidateAttributeRefactoring);
                continue;
            }
            LinkedHashSet<CandidateAttributeRefactoring> set = new LinkedHashSet<CandidateAttributeRefactoring>();
            set.add(candidateAttributeRefactoring);
            this.renameMap.put(renamePattern, set);
        }
        for (CandidateMergeVariableRefactoring candidateMergeVariableRefactoring : mapper.getCandidateAttributeMerges()) {
            LinkedHashSet<String> before = new LinkedHashSet<String>();
            for (String mergedVariable : candidateMergeVariableRefactoring.getMergedVariables()) {
                before.add(PrefixSuffixUtils.normalize(mergedVariable));
            }
            after = PrefixSuffixUtils.normalize(candidateMergeVariableRefactoring.getNewVariable());
            MergeVariableReplacement merge = new MergeVariableReplacement((Set<String>)before, (String)after);
            this.processMerge(this.mergeMap, merge, candidateMergeVariableRefactoring);
        }
        for (CandidateSplitVariableRefactoring candidateSplitVariableRefactoring : mapper.getCandidateAttributeSplits()) {
            LinkedHashSet<String> after2 = new LinkedHashSet<String>();
            for (String splitVariable : candidateSplitVariableRefactoring.getSplitVariables()) {
                after2.add(PrefixSuffixUtils.normalize(splitVariable));
            }
            String before = PrefixSuffixUtils.normalize(candidateSplitVariableRefactoring.getOldVariable());
            SplitVariableReplacement split = new SplitVariableReplacement(before, after2);
            this.processSplit(this.splitMap, split, candidateSplitVariableRefactoring);
        }
    }

    private Set<Refactoring> inferAttributeMergesAndSplits(Map<Replacement, Set<CandidateAttributeRefactoring>> map, List<Refactoring> refactorings) {
        LinkedHashSet<Refactoring> newRefactorings = new LinkedHashSet<Refactoring>();
        for (Replacement replacement : map.keySet()) {
            Set<CandidateAttributeRefactoring> candidates = map.get(replacement);
            for (CandidateAttributeRefactoring candidate : candidates) {
                String originalAttributeName = PrefixSuffixUtils.normalize(candidate.getOriginalVariableName());
                String renamedAttributeName = PrefixSuffixUtils.normalize(candidate.getRenamedVariableName());
                UMLOperationBodyMapper candidateMapper = null;
                block2: for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
                    if (mapper.getMappings().containsAll(candidate.getAttributeReferences())) {
                        candidateMapper = mapper;
                        break;
                    }
                    for (UMLOperationBodyMapper nestedMapper : mapper.getChildMappers()) {
                        if (!nestedMapper.getMappings().containsAll(candidate.getAttributeReferences())) continue;
                        candidateMapper = nestedMapper;
                        continue block2;
                    }
                }
                for (Refactoring refactoring : refactorings) {
                    LinkedHashSet<String> allMatchingVariables;
                    String matchingVariableName;
                    LinkedHashSet<String> nonMatchingVariableNames;
                    if (refactoring instanceof MergeVariableRefactoring) {
                        MergeVariableRefactoring merge = (MergeVariableRefactoring)refactoring;
                        nonMatchingVariableNames = new LinkedHashSet<String>();
                        matchingVariableName = null;
                        block5: for (VariableDeclaration variableDeclaration : merge.getMergedVariables()) {
                            if (originalAttributeName.equals(variableDeclaration.getVariableName())) {
                                matchingVariableName = variableDeclaration.getVariableName();
                                continue;
                            }
                            for (StatementObject statementObject : candidateMapper.getNonMappedLeavesT1()) {
                                if (!statementObject.getString().startsWith(variableDeclaration.getVariableName() + "=") && !statementObject.getString().startsWith("this." + variableDeclaration.getVariableName() + "=")) continue;
                                nonMatchingVariableNames.add(variableDeclaration.getVariableName());
                                continue block5;
                            }
                        }
                        if (matchingVariableName == null || !renamedAttributeName.equals(merge.getNewVariable().getVariableName()) || nonMatchingVariableNames.size() <= 0) continue;
                        LinkedHashSet mergedAttributes = new LinkedHashSet();
                        LinkedHashSet<VariableDeclaration> mergedVariables = new LinkedHashSet<VariableDeclaration>();
                        allMatchingVariables = new LinkedHashSet();
                        if (merge.getMergedVariables().iterator().next().getVariableName().equals(matchingVariableName)) {
                            allMatchingVariables.add(matchingVariableName);
                            allMatchingVariables.addAll(nonMatchingVariableNames);
                        } else {
                            allMatchingVariables.addAll(nonMatchingVariableNames);
                            allMatchingVariables.add(matchingVariableName);
                        }
                        for (String mergedVariable : allMatchingVariables) {
                            UMLAttribute a1 = this.findAttributeInOriginalClass(mergedVariable);
                            if (a1 == null) continue;
                            mergedAttributes.add(a1);
                            mergedVariables.add(a1.getVariableDeclaration());
                        }
                        continue;
                    }
                    if (!(refactoring instanceof SplitVariableRefactoring)) continue;
                    SplitVariableRefactoring split = (SplitVariableRefactoring)refactoring;
                    nonMatchingVariableNames = new LinkedHashSet();
                    matchingVariableName = null;
                    block8: for (VariableDeclaration variableDeclaration : split.getSplitVariables()) {
                        if (renamedAttributeName.equals(variableDeclaration.getVariableName())) {
                            matchingVariableName = variableDeclaration.getVariableName();
                            continue;
                        }
                        for (StatementObject statementObject : candidateMapper.getNonMappedLeavesT2()) {
                            if (!statementObject.getString().startsWith(variableDeclaration.getVariableName() + "=") && !statementObject.getString().startsWith("this." + variableDeclaration.getVariableName() + "=")) continue;
                            nonMatchingVariableNames.add(variableDeclaration.getVariableName());
                            continue block8;
                        }
                    }
                    if (matchingVariableName == null || !originalAttributeName.equals(split.getOldVariable().getVariableName()) || nonMatchingVariableNames.size() <= 0) continue;
                    LinkedHashSet<UMLAttribute> splitAttributes = new LinkedHashSet<UMLAttribute>();
                    LinkedHashSet<VariableDeclaration> splitVariables = new LinkedHashSet<VariableDeclaration>();
                    allMatchingVariables = new LinkedHashSet<String>();
                    if (split.getSplitVariables().iterator().next().getVariableName().equals(matchingVariableName)) {
                        allMatchingVariables.add(matchingVariableName);
                        allMatchingVariables.addAll(nonMatchingVariableNames);
                    } else {
                        allMatchingVariables.addAll(nonMatchingVariableNames);
                        allMatchingVariables.add(matchingVariableName);
                    }
                    for (String splitVariable : allMatchingVariables) {
                        UMLAttribute a2 = this.findAttributeInNextClass(splitVariable);
                        if (a2 == null) continue;
                        splitAttributes.add(a2);
                        splitVariables.add(a2.getVariableDeclaration());
                    }
                }
            }
        }
        return newRefactorings;
    }

    private boolean attributeMerged(UMLAttribute a1, UMLAttribute a2, List<Refactoring> refactorings) {
        return false;
    }

    private boolean attributeSplit(UMLAttribute a1, UMLAttribute a2, List<Refactoring> refactorings) {
        return false;
    }

    private void processMerge(Map<MergeVariableReplacement, Set<CandidateMergeVariableRefactoring>> mergeMap, MergeVariableReplacement newMerge, CandidateMergeVariableRefactoring candidate) {
        MergeVariableReplacement mergeToBeRemoved = null;
        for (MergeVariableReplacement merge : mergeMap.keySet()) {
            if (merge.subsumes(newMerge)) {
                mergeMap.get(merge).add(candidate);
                return;
            }
            if (merge.equal(newMerge)) {
                mergeMap.get(merge).add(candidate);
                return;
            }
            if (merge.commonAfter(newMerge)) {
                mergeToBeRemoved = merge;
                LinkedHashSet<String> mergedVariables = new LinkedHashSet<String>();
                mergedVariables.addAll(merge.getMergedVariables());
                mergedVariables.addAll(newMerge.getMergedVariables());
                MergeVariableReplacement replacement = new MergeVariableReplacement(mergedVariables, merge.getAfter());
                Set<CandidateMergeVariableRefactoring> candidates = mergeMap.get(mergeToBeRemoved);
                candidates.add(candidate);
                mergeMap.put(replacement, candidates);
                break;
            }
            if (!newMerge.subsumes(merge)) continue;
            mergeToBeRemoved = merge;
            Set<CandidateMergeVariableRefactoring> candidates = mergeMap.get(mergeToBeRemoved);
            candidates.add(candidate);
            mergeMap.put(newMerge, candidates);
            break;
        }
        if (mergeToBeRemoved != null) {
            mergeMap.remove(mergeToBeRemoved);
            return;
        }
        LinkedHashSet<CandidateMergeVariableRefactoring> set = new LinkedHashSet<CandidateMergeVariableRefactoring>();
        set.add(candidate);
        mergeMap.put(newMerge, set);
    }

    private void processSplit(Map<SplitVariableReplacement, Set<CandidateSplitVariableRefactoring>> splitMap, SplitVariableReplacement newSplit, CandidateSplitVariableRefactoring candidate) {
        SplitVariableReplacement splitToBeRemoved = null;
        for (SplitVariableReplacement split : splitMap.keySet()) {
            if (split.subsumes(newSplit)) {
                splitMap.get(split).add(candidate);
                return;
            }
            if (split.equal(newSplit)) {
                splitMap.get(split).add(candidate);
                return;
            }
            if (split.commonBefore(newSplit)) {
                splitToBeRemoved = split;
                LinkedHashSet<String> splitVariables = new LinkedHashSet<String>();
                splitVariables.addAll(split.getSplitVariables());
                splitVariables.addAll(newSplit.getSplitVariables());
                SplitVariableReplacement replacement = new SplitVariableReplacement(split.getBefore(), splitVariables);
                Set<CandidateSplitVariableRefactoring> candidates = splitMap.get(splitToBeRemoved);
                candidates.add(candidate);
                splitMap.put(replacement, candidates);
                break;
            }
            if (!newSplit.subsumes(split)) continue;
            splitToBeRemoved = split;
            Set<CandidateSplitVariableRefactoring> candidates = splitMap.get(splitToBeRemoved);
            candidates.add(candidate);
            splitMap.put(newSplit, candidates);
            break;
        }
        if (splitToBeRemoved != null) {
            splitMap.remove(splitToBeRemoved);
            return;
        }
        LinkedHashSet<CandidateSplitVariableRefactoring> set = new LinkedHashSet<CandidateSplitVariableRefactoring>();
        set.add(candidate);
        splitMap.put(newSplit, set);
    }

    public UMLAttribute findAttributeInOriginalClass(String attributeName) {
        for (UMLAttribute attribute : this.originalClass.getAttributes()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    public UMLAttribute findAttributeInNextClass(String attributeName) {
        for (UMLAttribute attribute : this.nextClass.getAttributes()) {
            if (!attribute.getName().equals(attributeName)) continue;
            return attribute;
        }
        return null;
    }

    private boolean inconsistentAttributeRename(Replacement pattern, Map<String, Set<String>> aliasedAttributesInOriginalClass, Map<String, Set<String>> aliasedAttributesInNextClass) {
        for (String key : aliasedAttributesInOriginalClass.keySet()) {
            if (!aliasedAttributesInOriginalClass.get(key).contains(pattern.getBefore())) continue;
            return false;
        }
        for (String key : aliasedAttributesInNextClass.keySet()) {
            if (!aliasedAttributesInNextClass.get(key).contains(pattern.getAfter())) continue;
            return false;
        }
        int counter = 0;
        int allCases = 0;
        for (UMLOperationBodyMapper mapper : this.operationBodyMapperList) {
            boolean variables2Contains;
            List<String> allVariables1 = mapper.getOperation1().getAllVariables();
            List<String> allVariables2 = mapper.getOperation2().getAllVariables();
            for (UMLOperationBodyMapper nestedMapper : mapper.getChildMappers()) {
                allVariables1.addAll(nestedMapper.getOperation1().getAllVariables());
                allVariables2.addAll(nestedMapper.getOperation2().getAllVariables());
            }
            boolean variables1contains = allVariables1.contains(pattern.getBefore()) && !mapper.getOperation1().getParameterNameList().contains(pattern.getBefore()) || allVariables1.contains("this." + pattern.getBefore());
            boolean bl = variables2Contains = allVariables2.contains(pattern.getAfter()) && !mapper.getOperation2().getParameterNameList().contains(pattern.getAfter()) || allVariables2.contains("this." + pattern.getAfter());
            if (variables1contains && !variables2Contains) {
                ++counter;
            }
            if (variables2Contains && !variables1contains) {
                ++counter;
            }
            if (!variables1contains && !variables2Contains) continue;
            ++allCases;
        }
        double percentage = (double)counter / (double)allCases;
        return percentage > 0.5;
    }

    private static boolean cyclicRename(Map<Replacement, Set<CandidateAttributeRefactoring>> renames, Replacement rename) {
        for (Replacement r : renames.keySet()) {
            if (!rename.getAfter().equals(r.getBefore()) && !rename.getBefore().equals(r.getAfter()) || UMLClassBaseDiff.totalOccurrences(renames.get(rename)) <= 1 && UMLClassBaseDiff.totalOccurrences(renames.get(r)) <= 1) continue;
            return true;
        }
        return false;
    }

    private static int totalOccurrences(Set<CandidateAttributeRefactoring> candidates) {
        int totalCount = 0;
        for (CandidateAttributeRefactoring candidate : candidates) {
            totalCount += candidate.getOccurrences();
        }
        return totalCount;
    }

    private int computeAbsoluteDifferenceInPositionWithinClass(UMLOperation removedOperation, UMLOperation addedOperation) {
        int index1 = this.originalClass.getOperations().indexOf(removedOperation);
        int index2 = this.nextClass.getOperations().indexOf(addedOperation);
        return Math.abs(index1 - index2);
    }

    private void checkForOperationSignatureChanges() throws RefactoringMinerTimedOutException {
        this.consistentMethodInvocationRenames = this.findConsistentMethodInvocationRenames();
        if (this.removedOperations.size() <= this.addedOperations.size()) {
            for (UMLOperation removedOperation : this.removedOperations) {
                UMLOperationBodyMapper bestMapper;
                UMLOperation addedOperation2;
                TreeSet<UMLOperationBodyMapper> mapperSet = new TreeSet<UMLOperationBodyMapper>();
                for (UMLOperation addedOperation2 : this.addedOperations) {
                    int maxDifferenceInPosition = removedOperation.hasTestAnnotation() && addedOperation2.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : Math.max(this.removedOperations.size(), this.addedOperations.size());
                    this.updateMapperSet(mapperSet, removedOperation, addedOperation2, maxDifferenceInPosition);
                }
                if (mapperSet.isEmpty() || (bestMapper = this.findBestMapper(mapperSet)) == null) continue;
                removedOperation = bestMapper.getOperation1();
                addedOperation2 = bestMapper.getOperation2();
                this.addedOperations.remove(addedOperation2);
                UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation2, bestMapper.getMappings());
                this.operationDiffList.add(operationSignatureDiff);
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                if (!(removedOperation.getName().equals(addedOperation2.getName()) || removedOperation.isConstructor() && addedOperation2.isConstructor())) {
                    RenameOperationRefactoring rename = new RenameOperationRefactoring(bestMapper);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper(bestMapper);
            }
        } else {
            Iterator<UMLOperation> addedOperationIterator = this.addedOperations.iterator();
            while (addedOperationIterator.hasNext()) {
                UMLOperation removedOperation;
                UMLOperation addedOperation = addedOperationIterator.next();
                TreeSet<UMLOperationBodyMapper> mapperSet = new TreeSet<UMLOperationBodyMapper>();
                Object bestMapper = this.removedOperations.iterator();
                while (bestMapper.hasNext()) {
                    removedOperation = bestMapper.next();
                    int maxDifferenceInPosition = removedOperation.hasTestAnnotation() && addedOperation.hasTestAnnotation() ? Math.abs(this.removedOperations.size() - this.addedOperations.size()) : Math.max(this.removedOperations.size(), this.addedOperations.size());
                    this.updateMapperSet(mapperSet, removedOperation, addedOperation, maxDifferenceInPosition);
                }
                if (mapperSet.isEmpty() || (bestMapper = this.findBestMapper(mapperSet)) == null) continue;
                removedOperation = ((UMLOperationBodyMapper)bestMapper).getOperation1();
                addedOperation = ((UMLOperationBodyMapper)bestMapper).getOperation2();
                this.removedOperations.remove(removedOperation);
                addedOperationIterator.remove();
                UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, ((UMLOperationBodyMapper)bestMapper).getMappings());
                this.operationDiffList.add(operationSignatureDiff);
                this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                if (!(removedOperation.getName().equals(addedOperation.getName()) || removedOperation.isConstructor() && addedOperation.isConstructor())) {
                    RenameOperationRefactoring rename = new RenameOperationRefactoring((UMLOperationBodyMapper)bestMapper);
                    this.refactorings.add(rename);
                }
                this.addOperationBodyMapper((UMLOperationBodyMapper)bestMapper);
            }
        }
    }

    private Set<MethodInvocationReplacement> findConsistentMethodInvocationRenames() {
        LinkedHashSet<MethodInvocationReplacement> allConsistentMethodInvocationRenames = new LinkedHashSet<MethodInvocationReplacement>();
        LinkedHashSet allInconsistentMethodInvocationRenames = new LinkedHashSet();
        for (UMLOperationBodyMapper bodyMapper : this.operationBodyMapperList) {
            Set<MethodInvocationReplacement> methodInvocationRenames = bodyMapper.getMethodInvocationRenameReplacements();
            ConsistentReplacementDetector.updateRenames(allConsistentMethodInvocationRenames, allInconsistentMethodInvocationRenames, methodInvocationRenames);
        }
        allConsistentMethodInvocationRenames.removeAll(allInconsistentMethodInvocationRenames);
        return allConsistentMethodInvocationRenames;
    }

    private void updateMapperSet(TreeSet<UMLOperationBodyMapper> mapperSet, UMLOperation removedOperation, UMLOperation addedOperation, int differenceInPosition) throws RefactoringMinerTimedOutException {
        int absoluteDifferenceInPosition;
        ArrayList<AbstractCodeMapping> totalMappings;
        UMLOperationBodyMapper operationBodyMapper;
        block5: {
            block3: {
                int mappings;
                block7: {
                    block6: {
                        block4: {
                            operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, this);
                            totalMappings = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
                            mappings = operationBodyMapper.mappingsWithoutBlocks();
                            if (mappings <= 0) break block3;
                            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
                            if (!this.exactMappings(operationBodyMapper)) break block4;
                            mapperSet.add(operationBodyMapper);
                            break block5;
                        }
                        if (!this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper) || absoluteDifferenceInPosition > differenceInPosition || !this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition) || !removedOperation.testAnnotationCheck(addedOperation)) break block6;
                        mapperSet.add(operationBodyMapper);
                        break block5;
                    }
                    if (!this.mappedElementsMoreThanNonMappedT2(mappings, operationBodyMapper) || absoluteDifferenceInPosition > differenceInPosition || !this.isPartOfMethodExtracted(removedOperation, addedOperation) || !removedOperation.testAnnotationCheck(addedOperation)) break block7;
                    mapperSet.add(operationBodyMapper);
                    break block5;
                }
                if (!this.mappedElementsMoreThanNonMappedT1(mappings, operationBodyMapper) || absoluteDifferenceInPosition > differenceInPosition || !this.isPartOfMethodInlined(removedOperation, addedOperation) || !removedOperation.testAnnotationCheck(addedOperation)) break block5;
                mapperSet.add(operationBodyMapper);
                break block5;
            }
            for (MethodInvocationReplacement replacement : this.consistentMethodInvocationRenames) {
                if (!replacement.getInvokedOperationBefore().matchesOperation(removedOperation) || !replacement.getInvokedOperationAfter().matchesOperation(addedOperation)) continue;
                mapperSet.add(operationBodyMapper);
                break;
            }
        }
        if (totalMappings.size() > 0) {
            absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.singleUnmatchedStatementCallsAddedOperation(operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) {
                mapperSet.add(operationBodyMapper);
            }
        }
    }

    private void updateMapperSet(TreeSet<UMLOperationBodyMapper> mapperSet, UMLOperation removedOperation, UMLOperation operationInsideAnonymousClass, UMLOperation addedOperation, int differenceInPosition) throws RefactoringMinerTimedOutException {
        UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, operationInsideAnonymousClass, this);
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        if (mappings > 0) {
            int absoluteDifferenceInPosition = this.computeAbsoluteDifferenceInPositionWithinClass(removedOperation, addedOperation);
            if (this.exactMappings(operationBodyMapper)) {
                mapperSet.add(operationBodyMapper);
            } else if (this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.compatibleSignatures(removedOperation, addedOperation, absoluteDifferenceInPosition)) {
                mapperSet.add(operationBodyMapper);
            } else if (this.mappedElementsMoreThanNonMappedT2(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.isPartOfMethodExtracted(removedOperation, addedOperation)) {
                mapperSet.add(operationBodyMapper);
            } else if (this.mappedElementsMoreThanNonMappedT1(mappings, operationBodyMapper) && absoluteDifferenceInPosition <= differenceInPosition && this.isPartOfMethodInlined(removedOperation, addedOperation)) {
                mapperSet.add(operationBodyMapper);
            }
        }
    }

    private boolean exactMappings(UMLOperationBodyMapper operationBodyMapper) {
        if (UMLClassBaseDiff.allMappingsAreExactMatches(operationBodyMapper)) {
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                return true;
            }
            if (operationBodyMapper.nonMappedElementsT1() > 0 && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.nonMappedElementsT2() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                UMLOperation addedOperation = operationBodyMapper.getOperation2();
                ArrayList<String> nonMappedLeavesT1 = new ArrayList<String>();
                for (StatementObject statementObject : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!statementObject.countableStatement()) continue;
                    nonMappedLeavesT1.add(statementObject.getString());
                    for (String string : addedOperation.getParameterNameList()) {
                        if (statementObject.getVariableDeclaration(string) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                int nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation = 0;
                for (UMLOperation operation : this.addedOperations) {
                    if (operation.equals(addedOperation) || operation.getBody() == null) continue;
                    for (StatementObject statement : operation.getBody().getCompositeStatement().getLeaves()) {
                        if (!nonMappedLeavesT1.contains(statement.getString())) continue;
                        ++nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation;
                    }
                }
                return (countableStatements == parameterizedVariableDeclarationStatements || countableStatements == nonMappedLeavesExactlyMatchedInTheBodyOfAddedOperation + parameterizedVariableDeclarationStatements) && countableStatements > 0;
            }
            if (operationBodyMapper.nonMappedElementsT1() == 0 && operationBodyMapper.nonMappedElementsT2() > 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                int countableStatements = 0;
                int parameterizedVariableDeclarationStatements = 0;
                UMLOperation removedOperation = operationBodyMapper.getOperation1();
                for (StatementObject statement : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!statement.countableStatement()) continue;
                    for (String parameterName : removedOperation.getParameterNameList()) {
                        if (statement.getVariableDeclaration(parameterName) == null) continue;
                        ++parameterizedVariableDeclarationStatements;
                        break;
                    }
                    ++countableStatements;
                }
                return countableStatements == parameterizedVariableDeclarationStatements && countableStatements > 0;
            }
            if ((operationBodyMapper.nonMappedElementsT1() == 1 || operationBodyMapper.nonMappedElementsT2() == 1) && operationBodyMapper.getNonMappedInnerNodesT1().size() == 0 && operationBodyMapper.getNonMappedInnerNodesT2().size() == 0) {
                StatementObject statementUsingParameterAsInvoker1 = null;
                UMLOperation removedOperation = operationBodyMapper.getOperation1();
                block6: for (StatementObject statement : operationBodyMapper.getNonMappedLeavesT1()) {
                    if (!statement.countableStatement()) continue;
                    for (String string : removedOperation.getParameterNameList()) {
                        OperationInvocation invocation = statement.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker1 = statement;
                        continue block6;
                    }
                }
                StatementObject statementUsingParameterAsInvoker2 = null;
                UMLOperation addedOperation = operationBodyMapper.getOperation2();
                block8: for (StatementObject statementObject : operationBodyMapper.getNonMappedLeavesT2()) {
                    if (!statementObject.countableStatement()) continue;
                    for (String string : addedOperation.getParameterNameList()) {
                        OperationInvocation invocation = statementObject.invocationCoveringEntireFragment();
                        if (invocation == null || invocation.getExpression() == null || !invocation.getExpression().equals(string)) continue;
                        statementUsingParameterAsInvoker2 = statementObject;
                        continue block8;
                    }
                }
                if (statementUsingParameterAsInvoker1 != null && statementUsingParameterAsInvoker2 != null) {
                    for (AbstractCodeMapping abstractCodeMapping : operationBodyMapper.getMappings()) {
                        if (!(abstractCodeMapping.getFragment1() instanceof CompositeStatementObject) || !(abstractCodeMapping.getFragment2() instanceof CompositeStatementObject)) continue;
                        CompositeStatementObject parent1 = (CompositeStatementObject)abstractCodeMapping.getFragment1();
                        CompositeStatementObject compositeStatementObject = (CompositeStatementObject)abstractCodeMapping.getFragment2();
                        if (!parent1.getLeaves().contains(statementUsingParameterAsInvoker1) || !compositeStatementObject.getLeaves().contains(statementUsingParameterAsInvoker2)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean mappedElementsMoreThanNonMappedT1AndT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        return mappings > nonMappedElementsT1 && mappings > nonMappedElementsT2 || nonMappedElementsT1 == 0 && (double)mappings > Math.floor((double)nonMappedElementsT2 / 2.0) || mappings == 1 && nonMappedElementsT1 + nonMappedElementsT2 == 1 && operationBodyMapper.getOperation1().getName().equals(operationBodyMapper.getOperation2().getName());
    }

    private boolean mappedElementsMoreThanNonMappedT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        int nonMappedElementsT2CallingAddedOperation = operationBodyMapper.nonMappedElementsT2CallingAddedOperation(this.addedOperations);
        int nonMappedElementsT2WithoutThoseCallingAddedOperation = nonMappedElementsT2 - nonMappedElementsT2CallingAddedOperation;
        return mappings > nonMappedElementsT2 || mappings >= nonMappedElementsT2WithoutThoseCallingAddedOperation && nonMappedElementsT2CallingAddedOperation >= nonMappedElementsT2WithoutThoseCallingAddedOperation;
    }

    private boolean mappedElementsMoreThanNonMappedT1(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT1CallingRemovedOperation = operationBodyMapper.nonMappedElementsT1CallingRemovedOperation(this.removedOperations);
        int nonMappedElementsT1WithoutThoseCallingRemovedOperation = nonMappedElementsT1 - nonMappedElementsT1CallingRemovedOperation;
        return mappings > nonMappedElementsT1 || mappings >= nonMappedElementsT1WithoutThoseCallingRemovedOperation && nonMappedElementsT1CallingRemovedOperation >= nonMappedElementsT1WithoutThoseCallingRemovedOperation;
    }

    private UMLOperationBodyMapper findBestMapper(TreeSet<UMLOperationBodyMapper> mapperSet) {
        UMLOperation bestMapperOperation2;
        ArrayList<UMLOperationBodyMapper> mapperList = new ArrayList<UMLOperationBodyMapper>(mapperSet);
        UMLOperationBodyMapper bestMapper = mapperSet.first();
        UMLOperation bestMapperOperation1 = bestMapper.getOperation1();
        if (bestMapperOperation1.equalReturnParameter(bestMapperOperation2 = bestMapper.getOperation2()) && bestMapperOperation1.getName().equals(bestMapperOperation2.getName()) && bestMapperOperation1.commonParameterTypes(bestMapperOperation2).size() > 0) {
            return bestMapper;
        }
        boolean identicalBodyWithOperation1OfTheBestMapper = this.identicalBodyWithAnotherAddedMethod(bestMapper);
        boolean identicalBodyWithOperation2OfTheBestMapper = this.identicalBodyWithAnotherRemovedMethod(bestMapper);
        for (int i = 1; i < mapperList.size(); ++i) {
            UMLOperationBodyMapper mapper = (UMLOperationBodyMapper)mapperList.get(i);
            UMLOperation operation2 = mapper.getOperation2();
            List<OperationInvocation> operationInvocations2 = operation2.getAllOperationInvocations();
            boolean anotherMapperCallsOperation2OfTheBestMapper = false;
            for (OperationInvocation invocation : operationInvocations2) {
                if (!invocation.matchesOperation(bestMapper.getOperation2(), operation2.variableTypeMap(), this.modelDiff) || invocation.matchesOperation(bestMapper.getOperation1(), operation2.variableTypeMap(), this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.removedOperations)) continue;
                anotherMapperCallsOperation2OfTheBestMapper = true;
                break;
            }
            UMLOperation operation1 = mapper.getOperation1();
            List<OperationInvocation> operationInvocations1 = operation1.getAllOperationInvocations();
            boolean anotherMapperCallsOperation1OfTheBestMapper = false;
            for (OperationInvocation invocation : operationInvocations1) {
                if (!invocation.matchesOperation(bestMapper.getOperation1(), operation1.variableTypeMap(), this.modelDiff) || invocation.matchesOperation(bestMapper.getOperation2(), operation1.variableTypeMap(), this.modelDiff) || this.operationContainsMethodInvocationWithTheSameNameAndCommonArguments(invocation, this.addedOperations)) continue;
                anotherMapperCallsOperation1OfTheBestMapper = true;
                break;
            }
            boolean nextMapperMatchesConsistentRename = this.matchesConsistentMethodInvocationRename(mapper, this.consistentMethodInvocationRenames);
            boolean bestMapperMismatchesConsistentRename = this.mismatchesConsistentMethodInvocationRename(bestMapper, this.consistentMethodInvocationRenames);
            if (bestMapperMismatchesConsistentRename && nextMapperMatchesConsistentRename) {
                bestMapper = mapper;
                break;
            }
            if (anotherMapperCallsOperation2OfTheBestMapper || anotherMapperCallsOperation1OfTheBestMapper) {
                bestMapper = mapper;
                break;
            }
            if (!identicalBodyWithOperation2OfTheBestMapper && !identicalBodyWithOperation1OfTheBestMapper) continue;
            bestMapper = mapper;
            break;
        }
        if (this.mismatchesConsistentMethodInvocationRename(bestMapper, this.consistentMethodInvocationRenames)) {
            return null;
        }
        return bestMapper;
    }

    private boolean identicalBodyWithAnotherAddedMethod(UMLOperationBodyMapper mapper) {
        UMLOperation operation1 = mapper.getOperation1();
        List<String> stringRepresentation = operation1.stringRepresentation();
        if (stringRepresentation.size() > 2) {
            for (UMLOperation addedOperation : this.addedOperations) {
                if (mapper.getOperation2().equals(addedOperation) || !addedOperation.stringRepresentation().equals(stringRepresentation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean identicalBodyWithAnotherRemovedMethod(UMLOperationBodyMapper mapper) {
        UMLOperation operation2 = mapper.getOperation2();
        List<String> stringRepresentation = operation2.stringRepresentation();
        if (stringRepresentation.size() > 2) {
            for (UMLOperation removedOperation : this.removedOperations) {
                if (mapper.getOperation1().equals(removedOperation) || !removedOperation.stringRepresentation().equals(stringRepresentation)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean matchesConsistentMethodInvocationRename(UMLOperationBodyMapper mapper, Set<MethodInvocationReplacement> consistentMethodInvocationRenames) {
        for (MethodInvocationReplacement rename : consistentMethodInvocationRenames) {
            if (!mapper.getOperation1().getName().equals(rename.getBefore()) || !mapper.getOperation2().getName().equals(rename.getAfter())) continue;
            return true;
        }
        return false;
    }

    private boolean mismatchesConsistentMethodInvocationRename(UMLOperationBodyMapper mapper, Set<MethodInvocationReplacement> consistentMethodInvocationRenames) {
        for (MethodInvocationReplacement rename : consistentMethodInvocationRenames) {
            if (mapper.getOperation1().getName().equals(rename.getBefore()) && !mapper.getOperation2().getName().equals(rename.getAfter())) {
                return true;
            }
            if (mapper.getOperation1().getName().equals(rename.getBefore()) || !mapper.getOperation2().getName().equals(rename.getAfter())) continue;
            return true;
        }
        return false;
    }

    private boolean operationContainsMethodInvocationWithTheSameNameAndCommonArguments(OperationInvocation invocation, List<UMLOperation> operations) {
        for (UMLOperation operation : operations) {
            List<OperationInvocation> operationInvocations = operation.getAllOperationInvocations();
            for (OperationInvocation operationInvocation : operationInvocations) {
                LinkedHashSet<String> argumentIntersection = new LinkedHashSet<String>(operationInvocation.getArguments());
                argumentIntersection.retainAll(invocation.getArguments());
                if (operationInvocation.getMethodName().equals(invocation.getMethodName()) && !argumentIntersection.isEmpty()) {
                    return true;
                }
                if (argumentIntersection.size() <= 0 || argumentIntersection.size() != invocation.getArguments().size()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean singleUnmatchedStatementCallsAddedOperation(UMLOperationBodyMapper operationBodyMapper) {
        StatementObject statementT2;
        OperationInvocation invocationT2;
        List<StatementObject> nonMappedLeavesT1 = operationBodyMapper.getNonMappedLeavesT1();
        List<StatementObject> nonMappedLeavesT2 = operationBodyMapper.getNonMappedLeavesT2();
        if (nonMappedLeavesT1.size() == 1 && nonMappedLeavesT2.size() == 1 && (invocationT2 = (statementT2 = nonMappedLeavesT2.get(0)).invocationCoveringEntireFragment()) != null) {
            for (UMLOperation addedOperation : this.addedOperations) {
                StatementObject statementT1;
                OperationInvocation invocationT1;
                if (!invocationT2.matchesOperation(addedOperation, operationBodyMapper.getOperation2().variableTypeMap(), this.modelDiff) || (invocationT1 = (statementT1 = nonMappedLeavesT1.get(0)).invocationCoveringEntireFragment()) == null || !addedOperation.getAllOperationInvocations().contains(invocationT1)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPartOfMethodExtracted(UMLOperation removedOperation, UMLOperation addedOperation) {
        List<OperationInvocation> removedOperationInvocations = removedOperation.getAllOperationInvocations();
        List<OperationInvocation> addedOperationInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<OperationInvocation> intersection = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        intersection.retainAll(addedOperationInvocations);
        int numberOfInvocationsMissingFromRemovedOperation = new LinkedHashSet<OperationInvocation>(removedOperationInvocations).size() - intersection.size();
        LinkedHashSet<OperationInvocation> operationInvocationsInMethodsCalledByAddedOperation = new LinkedHashSet<OperationInvocation>();
        for (OperationInvocation addedOperationInvocation : addedOperationInvocations) {
            if (intersection.contains(addedOperationInvocation)) continue;
            for (UMLOperation operation : this.addedOperations) {
                if (operation.equals(addedOperation) || operation.getBody() == null || !addedOperationInvocation.matchesOperation(operation, addedOperation.variableTypeMap(), this.modelDiff)) continue;
                operationInvocationsInMethodsCalledByAddedOperation.addAll(operation.getAllOperationInvocations());
            }
        }
        LinkedHashSet<OperationInvocation> newIntersection = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        newIntersection.retainAll(operationInvocationsInMethodsCalledByAddedOperation);
        LinkedHashSet<OperationInvocation> removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(intersection);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeAll(newIntersection);
        removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.removeIf(invocation -> invocation.getMethodName().startsWith("get"));
        int numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations = newIntersection.size();
        int numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations = numberOfInvocationsMissingFromRemovedOperation - numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations;
        return numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > numberOfInvocationsMissingFromRemovedOperationWithoutThoseFoundInOtherAddedOperations || numberOfInvocationsOriginallyCalledByRemovedOperationFoundInOtherAddedOperations > removedOperationInvocationsWithIntersectionsAndGetterInvocationsSubtracted.size();
    }

    private boolean isPartOfMethodInlined(UMLOperation removedOperation, UMLOperation addedOperation) {
        List<OperationInvocation> removedOperationInvocations = removedOperation.getAllOperationInvocations();
        List<OperationInvocation> addedOperationInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<OperationInvocation> intersection = new LinkedHashSet<OperationInvocation>(removedOperationInvocations);
        intersection.retainAll(addedOperationInvocations);
        int numberOfInvocationsMissingFromAddedOperation = new LinkedHashSet<OperationInvocation>(addedOperationInvocations).size() - intersection.size();
        LinkedHashSet<OperationInvocation> operationInvocationsInMethodsCalledByRemovedOperation = new LinkedHashSet<OperationInvocation>();
        for (OperationInvocation removedOperationInvocation : removedOperationInvocations) {
            if (intersection.contains(removedOperationInvocation)) continue;
            for (UMLOperation operation : this.removedOperations) {
                if (operation.equals(removedOperation) || operation.getBody() == null || !removedOperationInvocation.matchesOperation(operation, removedOperation.variableTypeMap(), this.modelDiff)) continue;
                operationInvocationsInMethodsCalledByRemovedOperation.addAll(operation.getAllOperationInvocations());
            }
        }
        LinkedHashSet<OperationInvocation> newIntersection = new LinkedHashSet<OperationInvocation>(addedOperationInvocations);
        newIntersection.retainAll(operationInvocationsInMethodsCalledByRemovedOperation);
        int numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations = newIntersection.size();
        int numberOfInvocationsMissingFromAddedOperationWithoutThoseFoundInOtherRemovedOperations = numberOfInvocationsMissingFromAddedOperation - numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations;
        return numberOfInvocationsCalledByAddedOperationFoundInOtherRemovedOperations > numberOfInvocationsMissingFromAddedOperationWithoutThoseFoundInOtherRemovedOperations;
    }

    public static boolean allMappingsAreExactMatches(UMLOperationBodyMapper operationBodyMapper) {
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int tryMappings = 0;
        int mappingsWithTypeReplacement = 0;
        for (AbstractCodeMapping mapping : operationBodyMapper.getMappings()) {
            if (mapping.getFragment1().getString().equals("try") && mapping.getFragment2().getString().equals("try")) {
                ++tryMappings;
            }
            if (!mapping.containsReplacement(Replacement.ReplacementType.TYPE)) continue;
            ++mappingsWithTypeReplacement;
        }
        if (mappings == operationBodyMapper.exactMatches() + tryMappings) {
            return true;
        }
        return mappings == operationBodyMapper.exactMatches() + tryMappings + mappingsWithTypeReplacement && mappings > mappingsWithTypeReplacement;
    }

    private boolean compatibleSignatures(UMLOperation removedOperation, UMLOperation addedOperation, int absoluteDifferenceInPosition) {
        return addedOperation.compatibleSignature(removedOperation) || (absoluteDifferenceInPosition == 0 || this.operationsBeforeAndAfterMatch(removedOperation, addedOperation)) && !this.gettersWithDifferentReturnType(removedOperation, addedOperation) && (addedOperation.getParameterTypeList().equals(removedOperation.getParameterTypeList()) || addedOperation.normalizedNameDistance(removedOperation) <= 0.4);
    }

    private boolean gettersWithDifferentReturnType(UMLOperation removedOperation, UMLOperation addedOperation) {
        return false;
    }

    private boolean operationsBeforeAndAfterMatch(UMLOperation removedOperation, UMLOperation addedOperation) {
        UMLOperation operationBefore1 = null;
        UMLOperation operationAfter1 = null;
        List<UMLOperation> originalClassOperations = this.originalClass.getOperations();
        for (int i = 0; i < originalClassOperations.size(); ++i) {
            UMLOperation current = originalClassOperations.get(i);
            if (!current.equals(removedOperation)) continue;
            if (i > 0) {
                operationBefore1 = originalClassOperations.get(i - 1);
            }
            if (i >= originalClassOperations.size() - 1) continue;
            operationAfter1 = originalClassOperations.get(i + 1);
        }
        UMLOperation operationBefore2 = null;
        UMLOperation operationAfter2 = null;
        List<UMLOperation> nextClassOperations = this.nextClass.getOperations();
        for (int i = 0; i < nextClassOperations.size(); ++i) {
            UMLOperation current = nextClassOperations.get(i);
            if (!current.equals(addedOperation)) continue;
            if (i > 0) {
                operationBefore2 = nextClassOperations.get(i - 1);
            }
            if (i >= nextClassOperations.size() - 1) continue;
            operationAfter2 = nextClassOperations.get(i + 1);
        }
        boolean operationsBeforeMatch = false;
        if (operationBefore1 != null && operationBefore2 != null) {
            operationsBeforeMatch = operationBefore1.equalParameterTypes(operationBefore2) && operationBefore1.getName().equals(operationBefore2.getName());
        }
        boolean operationsAfterMatch = false;
        if (operationAfter1 != null && operationAfter2 != null) {
            operationsAfterMatch = operationAfter1.equalParameterTypes(operationAfter2) && operationAfter1.getName().equals(operationAfter2.getName());
        }
        return operationsBeforeMatch || operationsAfterMatch;
    }

    private void checkForInlinedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
                InlineOperationDetection detection = new InlineOperationDetection(mapper, this.removedOperations, this, this.modelDiff);
                List<InlineOperationRefactoring> refs = detection.check(removedOperation);
                for (InlineOperationRefactoring refactoring : refs) {
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    this.processMapperRefactorings(operationBodyMapper, this.refactorings);
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(removedOperation);
                }
            }
        }
        this.removedOperations.removeAll(operationsToBeRemoved);
    }

    private void checkForExtractedOperations() throws RefactoringMinerTimedOutException {
        ArrayList<UMLOperation> operationsToBeRemoved = new ArrayList<UMLOperation>();
        for (UMLOperation addedOperation : this.addedOperations) {
            for (UMLOperationBodyMapper mapper : this.getOperationBodyMapperList()) {
                ExtractOperationDetection detection = new ExtractOperationDetection(mapper, this.addedOperations, this, this.modelDiff);
                List<ExtractOperationRefactoring> refs = detection.check(addedOperation);
                for (ExtractOperationRefactoring refactoring : refs) {
                    this.refactorings.add(refactoring);
                    UMLOperationBodyMapper operationBodyMapper = refactoring.getBodyMapper();
                    this.processMapperRefactorings(operationBodyMapper, this.refactorings);
                    mapper.addChildMapper(operationBodyMapper);
                    operationsToBeRemoved.add(addedOperation);
                }
                this.checkForInconsistentVariableRenames(mapper);
            }
        }
        this.addedOperations.removeAll(operationsToBeRemoved);
    }

    private void checkForInconsistentVariableRenames(UMLOperationBodyMapper mapper) {
        if (mapper.getChildMappers().size() > 1) {
            LinkedHashSet<RenameVariableRefactoring> refactoringsToBeRemoved = new LinkedHashSet<RenameVariableRefactoring>();
            for (Refactoring r : this.refactorings) {
                if (!(r instanceof RenameVariableRefactoring)) continue;
                RenameVariableRefactoring rename = (RenameVariableRefactoring)r;
                Set<AbstractCodeMapping> references = rename.getVariableReferences();
                block1: for (AbstractCodeMapping reference : references) {
                    if (reference.getFragment1().getVariableDeclarations().size() <= 0 || reference.isExact()) continue;
                    LinkedHashSet<AbstractCodeMapping> allMappingsForReference = new LinkedHashSet<AbstractCodeMapping>();
                    block2: for (UMLOperationBodyMapper childMapper : mapper.getChildMappers()) {
                        for (AbstractCodeMapping mapping : childMapper.getMappings()) {
                            if (!mapping.getFragment1().equals(reference.getFragment1())) continue;
                            allMappingsForReference.add(mapping);
                            continue block2;
                        }
                    }
                    if (allMappingsForReference.size() <= 1) continue;
                    for (AbstractCodeMapping mapping : allMappingsForReference) {
                        if (mapping.equals(reference) || !mapping.isExact()) continue;
                        refactoringsToBeRemoved.add(rename);
                        continue block1;
                    }
                }
            }
            this.refactorings.removeAll(refactoringsToBeRemoved);
        }
    }

    public boolean isEmpty() {
        return this.addedOperations.isEmpty() && this.removedOperations.isEmpty() && this.addedAttributes.isEmpty() && this.removedAttributes.isEmpty() && this.operationDiffList.isEmpty() && this.attributeDiffList.isEmpty() && this.operationBodyMapperList.isEmpty() && !this.visibilityChanged && !this.abstractionChanged;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.isEmpty()) {
            sb.append(this.originalClass.getQualifiedName()).append(":").append("\n");
        }
        if (this.visibilityChanged) {
            sb.append("\t").append("visibility changed from ").append(this.oldVisibility).append(" to ").append(this.newVisibility).append("\n");
        }
        if (this.abstractionChanged) {
            sb.append("\t").append("abstraction changed from ").append(this.oldAbstraction ? "abstract" : "concrete").append(" to ").append(this.newAbstraction ? "abstract" : "concrete").append("\n");
        }
        Collections.sort(this.removedOperations);
        for (UMLOperation umlOperation : this.removedOperations) {
            sb.append("operation ").append(umlOperation).append(" removed").append("\n");
        }
        Collections.sort(this.addedOperations);
        for (UMLOperation umlOperation : this.addedOperations) {
            sb.append("operation ").append(umlOperation).append(" added").append("\n");
        }
        Collections.sort(this.removedAttributes);
        for (UMLAttribute umlAttribute : this.removedAttributes) {
            sb.append("attribute ").append(umlAttribute).append(" removed").append("\n");
        }
        Collections.sort(this.addedAttributes);
        for (UMLAttribute umlAttribute : this.addedAttributes) {
            sb.append("attribute ").append(umlAttribute).append(" added").append("\n");
        }
        for (UMLOperationDiff operationDiff : this.operationDiffList) {
            sb.append(operationDiff);
        }
        return sb.toString();
    }

    @Override
    public int compareTo(UMLClassBaseDiff other) {
        return this.originalClass.getQualifiedName().compareTo(other.originalClass.getQualifiedName());
    }

    private boolean multipleExtractedMethodInvocationsWithDifferentAttributesAsArguments(CandidateAttributeRefactoring candidate, List<Refactoring> refactorings) {
        for (Refactoring refactoring : refactorings) {
            List<OperationInvocation> extractedInvocations;
            ExtractOperationRefactoring extractRefactoring;
            if (!(refactoring instanceof ExtractOperationRefactoring) || !(extractRefactoring = (ExtractOperationRefactoring)refactoring).getExtractedOperation().equals(candidate.getOperationAfter()) || (extractedInvocations = extractRefactoring.getExtractedOperationInvocations()).size() <= 1) continue;
            LinkedHashSet<VariableDeclaration> attributesMatchedWithArguments = new LinkedHashSet<VariableDeclaration>();
            LinkedHashSet<String> attributeNamesMatchedWithArguments = new LinkedHashSet<String>();
            for (OperationInvocation extractedInvocation : extractedInvocations) {
                block2: for (String argument : extractedInvocation.getArguments()) {
                    for (UMLAttribute attribute : this.originalClass.getAttributes()) {
                        if (!attribute.getName().equals(argument)) continue;
                        attributesMatchedWithArguments.add(attribute.getVariableDeclaration());
                        attributeNamesMatchedWithArguments.add(attribute.getName());
                        continue block2;
                    }
                }
            }
            if (!attributeNamesMatchedWithArguments.contains(candidate.getOriginalVariableName()) && !attributeNamesMatchedWithArguments.contains(candidate.getRenamedVariableName()) || attributesMatchedWithArguments.size() <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean containsExtractOperationRefactoring(UMLOperation sourceOperationBeforeExtraction, UMLOperation extractedOperation) {
        for (Refactoring ref : this.refactorings) {
            ExtractOperationRefactoring extractRef;
            if (!(ref instanceof ExtractOperationRefactoring) || !(extractRef = (ExtractOperationRefactoring)ref).getSourceOperationBeforeExtraction().equals(sourceOperationBeforeExtraction) || !extractRef.getExtractedOperation().equalSignature(extractedOperation)) continue;
            return true;
        }
        return false;
    }

    public UMLModelDiff getModelDiff() {
        return this.modelDiff;
    }
}

