/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.common.replacement.Replacement;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObjectMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LeafMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapperComparator;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.ClassMoveComparator;
import org.jetbrains.research.kotlinrminer.ide.diff.ClassRenameComparator;
import org.jetbrains.research.kotlinrminer.ide.diff.ExtractOperationDetection;
import org.jetbrains.research.kotlinrminer.ide.diff.MovedClassToAnotherSourceFolder;
import org.jetbrains.research.kotlinrminer.ide.diff.RenamePattern;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassMoveDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassRenameDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLFileDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLGeneralizationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLOperationDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.CandidateExtractClassRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ChangeVariableTypeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractClassRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractSuperClassRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.InlineOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveAndRenameClassRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveClassRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveSourceFolderRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.PullUpAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.PullUpOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.PushDownAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.PushDownOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameClassRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenamePackageRefactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.RenameVariableRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClassMatcher;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLGeneralization;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLRealization;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class UMLModelDiff {
    private static final int MAXIMUM_NUMBER_OF_COMPARED_METHODS = 100;
    private final List<UMLClassMoveDiff> classMoveDiffList;
    private final List<UMLClass> addedClasses = new ArrayList<UMLClass>();
    private final List<UMLClass> removedClasses = new ArrayList<UMLClass>();
    private final Set<String> deletedFolderPaths;
    private final List<UMLGeneralization> addedGeneralizations;
    private final List<UMLGeneralization> removedGeneralizations;
    private final List<UMLGeneralizationDiff> generalizationDiffList;
    private final List<UMLRealization> addedRealizations;
    private List<UMLRealization> removedRealizations;
    private final List<UMLClassMoveDiff> innerClassMoveDiffList;
    private final List<UMLClassRenameDiff> classRenameDiffList;
    private final List<UMLClassDiff> commonClassDiffList;
    private final List<UMLFileDiff> umlFileDiff;
    private final List<Refactoring> refactorings;

    public UMLModelDiff() {
        this.classMoveDiffList = new ArrayList<UMLClassMoveDiff>();
        this.deletedFolderPaths = new LinkedHashSet<String>();
        this.innerClassMoveDiffList = new ArrayList<UMLClassMoveDiff>();
        this.classRenameDiffList = new ArrayList<UMLClassRenameDiff>();
        this.commonClassDiffList = new ArrayList<UMLClassDiff>();
        this.umlFileDiff = new ArrayList<UMLFileDiff>();
        this.refactorings = new ArrayList<Refactoring>();
        this.addedGeneralizations = new ArrayList<UMLGeneralization>();
        this.removedGeneralizations = new ArrayList<UMLGeneralization>();
        this.generalizationDiffList = new ArrayList<UMLGeneralizationDiff>();
        this.addedRealizations = new ArrayList<UMLRealization>();
        this.removedRealizations = new ArrayList<UMLRealization>();
        this.removedRealizations = new ArrayList<UMLRealization>();
    }

    public static boolean looksLikeSameType(String parent, String addedClassName) {
        if (addedClassName.contains(".") && !parent.contains(".")) {
            return parent.equals(addedClassName.substring(addedClassName.lastIndexOf(".") + 1));
        }
        if (parent.contains(".") && !addedClassName.contains(".")) {
            return addedClassName.equals(parent.substring(parent.lastIndexOf(".") + 1));
        }
        if (parent.contains(".") && addedClassName.contains(".")) {
            return UMLType.extractTypeObject(parent).equalClassType(UMLType.extractTypeObject(addedClassName));
        }
        return parent.equals(addedClassName);
    }

    public void reportAddedClass(UMLClass umlClass) {
        if (!this.addedClasses.contains(umlClass)) {
            this.addedClasses.add(umlClass);
        }
    }

    public void reportRemovedClass(UMLClass umlClass) {
        if (!this.removedClasses.contains(umlClass)) {
            this.removedClasses.add(umlClass);
        }
    }

    private Map<RenamePattern, Integer> typeRenamePatternMap(Set<Refactoring> refactorings) {
        LinkedHashMap<RenamePattern, Integer> typeRenamePatternMap = new LinkedHashMap<RenamePattern, Integer>();
        for (Refactoring ref : refactorings) {
            if (!(ref instanceof ChangeVariableTypeRefactoring)) continue;
            ChangeVariableTypeRefactoring refactoring = (ChangeVariableTypeRefactoring)ref;
            RenamePattern pattern = new RenamePattern(refactoring.getOriginalVariable().getType().toString(), refactoring.getChangedTypeVariable().getType().toString());
            if (typeRenamePatternMap.containsKey(pattern)) {
                typeRenamePatternMap.put(pattern, (Integer)typeRenamePatternMap.get(pattern) + 1);
                continue;
            }
            typeRenamePatternMap.put(pattern, 1);
        }
        return typeRenamePatternMap;
    }

    private UMLClass looksLikeAddedClass(UMLType type) {
        for (UMLClass umlClass : this.addedClasses) {
            if (!umlClass.getQualifiedName().endsWith("." + type.getClassType())) continue;
            return umlClass;
        }
        return null;
    }

    private UMLClass looksLikeRemovedClass(UMLType type) {
        for (UMLClass umlClass : this.removedClasses) {
            if (!umlClass.getQualifiedName().endsWith("." + type.getClassType())) continue;
            return umlClass;
        }
        return null;
    }

    private int computeCompatibility(MoveAttributeRefactoring candidate) {
        int count = 0;
        for (Refactoring ref : this.refactorings) {
            MoveOperationRefactoring moveRef;
            if (!(ref instanceof MoveOperationRefactoring) || !(moveRef = (MoveOperationRefactoring)ref).compatibleWith(candidate)) continue;
            ++count;
        }
        UMLClassBaseDiff sourceClassDiff = this.getUMLClassDiff(candidate.getSourceClassName());
        UMLClassBaseDiff targetClassDiff = this.getUMLClassDiff(candidate.getTargetClassName());
        if (sourceClassDiff != null) {
            UMLType targetSuperclass = null;
            if (targetClassDiff != null) {
                targetSuperclass = targetClassDiff.getSuperclass();
            }
            List<UMLAttribute> addedAttributes = sourceClassDiff.getAddedAttributes();
            for (UMLAttribute addedAttribute : addedAttributes) {
                if (UMLModelDiff.looksLikeSameType(addedAttribute.getType().getClassType(), candidate.getTargetClassName())) {
                    ++count;
                }
                if (targetSuperclass == null || !UMLModelDiff.looksLikeSameType(addedAttribute.getType().getClassType(), targetSuperclass.getClassType())) continue;
                ++count;
            }
            List<UMLAttribute> originalAttributes = sourceClassDiff.originalClassAttributesOfType(candidate.getTargetClassName());
            List<UMLAttribute> nextAttributes = sourceClassDiff.nextClassAttributesOfType(candidate.getTargetClassName());
            if (targetSuperclass != null) {
                originalAttributes.addAll(sourceClassDiff.originalClassAttributesOfType(targetSuperclass.getClassType()));
                nextAttributes.addAll(sourceClassDiff.nextClassAttributesOfType(targetSuperclass.getClassType()));
            }
            LinkedHashSet<UMLAttribute> intersection = new LinkedHashSet<UMLAttribute>(originalAttributes);
            intersection.retainAll(nextAttributes);
            if (!intersection.isEmpty()) {
                ++count;
            }
        }
        return count;
    }

    private void processCandidates(List<MoveAttributeRefactoring> candidates, List<MoveAttributeRefactoring> refactorings) {
        if (candidates.size() > 1) {
            TreeMap map = new TreeMap();
            for (MoveAttributeRefactoring candidate : candidates) {
                int compatibility = this.computeCompatibility(candidate);
                if (map.containsKey(compatibility)) {
                    ((List)map.get(compatibility)).add(candidate);
                    continue;
                }
                ArrayList<MoveAttributeRefactoring> refs = new ArrayList<MoveAttributeRefactoring>();
                refs.add(candidate);
                map.put(compatibility, refs);
            }
            int maxCompatibility = (Integer)map.lastKey();
            refactorings.addAll((Collection)map.get(maxCompatibility));
        } else if (candidates.size() == 1) {
            refactorings.addAll(candidates);
        }
    }

    private List<MoveAttributeRefactoring> checkForAttributeMoves(List<UMLAttribute> addedAttributes, List<UMLAttribute> removedAttributes) {
        ArrayList<MoveAttributeRefactoring> refactorings = new ArrayList<MoveAttributeRefactoring>();
        if (addedAttributes.size() <= removedAttributes.size()) {
            for (UMLAttribute addedAttribute : addedAttributes) {
                ArrayList<MoveAttributeRefactoring> candidates = new ArrayList<MoveAttributeRefactoring>();
                for (UMLAttribute removedAttribute : removedAttributes) {
                    MoveAttributeRefactoring candidate = this.processPairOfAttributes(addedAttribute, removedAttribute);
                    if (candidate == null) continue;
                    candidates.add(candidate);
                }
                this.processCandidates(candidates, refactorings);
            }
        } else {
            for (UMLAttribute removedAttribute : removedAttributes) {
                ArrayList<MoveAttributeRefactoring> candidates = new ArrayList<MoveAttributeRefactoring>();
                for (UMLAttribute addedAttribute : addedAttributes) {
                    MoveAttributeRefactoring candidate = this.processPairOfAttributes(addedAttribute, removedAttribute);
                    if (candidate == null) continue;
                    candidates.add(candidate);
                }
                this.processCandidates(candidates, refactorings);
            }
        }
        return refactorings;
    }

    private MoveAttributeRefactoring processPairOfAttributes(UMLAttribute addedAttribute, UMLAttribute removedAttribute) {
        if (addedAttribute.getName().equals(removedAttribute.getName()) && addedAttribute.getType().equals(removedAttribute.getType())) {
            if (this.isSubclassOf(removedAttribute.getClassName(), addedAttribute.getClassName())) {
                return new PullUpAttributeRefactoring(removedAttribute, addedAttribute);
            }
            if (this.isSubclassOf(addedAttribute.getClassName(), removedAttribute.getClassName())) {
                return new PushDownAttributeRefactoring(removedAttribute, addedAttribute);
            }
            if ((this.sourceClassImportsTargetClass(removedAttribute.getClassName(), addedAttribute.getClassName()) || this.targetClassImportsSourceClass(removedAttribute.getClassName(), addedAttribute.getClassName())) && !this.initializerContainsTypeLiteral(addedAttribute, removedAttribute)) {
                return new MoveAttributeRefactoring(removedAttribute, addedAttribute);
            }
        }
        return null;
    }

    private boolean initializerContainsTypeLiteral(UMLAttribute addedAttribute, UMLAttribute removedAttribute) {
        VariableDeclaration v1 = addedAttribute.getVariableDeclaration();
        VariableDeclaration v2 = removedAttribute.getVariableDeclaration();
        if (v1.getInitializer() != null && v2.getInitializer() != null) {
            List<String> typeLiterals1 = v1.getInitializer().getTypeLiterals();
            List<String> typeLiterals2 = v2.getInitializer().getTypeLiterals();
            String className1 = addedAttribute.getNonQualifiedClassName();
            String className2 = removedAttribute.getNonQualifiedClassName();
            return typeLiterals1.contains(className1 + ".class") && typeLiterals2.contains(className2 + ".class") && addedAttribute.getType().getClassType().endsWith("Logger") && removedAttribute.getType().getClassType().endsWith("Logger");
        }
        return false;
    }

    private UMLClassBaseDiff getUMLClassDiffWithAttribute(Replacement pattern) {
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (uMLClassDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (uMLClassRenameDiff.findAttributeInOriginalClass(pattern.getBefore()) == null || uMLClassRenameDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            return uMLClassRenameDiff;
        }
        return null;
    }

    private List<UMLClassBaseDiff> getUMLClassDiffWithExistingAttributeAfter(Replacement pattern) {
        ArrayList<UMLClassBaseDiff> classDiffs = new ArrayList<UMLClassBaseDiff>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (uMLClassDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (uMLClassRenameDiff.findAttributeInOriginalClass(pattern.getAfter()) == null || uMLClassRenameDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassRenameDiff);
        }
        return classDiffs;
    }

    private List<UMLClassBaseDiff> getUMLClassDiffWithNewAttributeAfter(Replacement pattern) {
        ArrayList<UMLClassBaseDiff> classDiffs = new ArrayList<UMLClassBaseDiff>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (uMLClassDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (uMLClassMoveDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassMoveDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassMoveDiff);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (uMLClassRenameDiff.findAttributeInOriginalClass(pattern.getAfter()) != null || uMLClassRenameDiff.findAttributeInNextClass(pattern.getAfter()) == null) continue;
            classDiffs.add(uMLClassRenameDiff);
        }
        return classDiffs;
    }

    public boolean isSubclassOf(String subclass, String finalSuperclass) {
        return this.isSubclassOf(subclass, finalSuperclass, new LinkedHashSet<String>());
    }

    private boolean checkInheritanceRelationship(UMLType superclass, String finalSuperclass, Set<String> visitedClasses) {
        if (UMLModelDiff.looksLikeSameType(superclass.getClassType(), finalSuperclass)) {
            return true;
        }
        return this.isSubclassOf(superclass.getClassType(), finalSuperclass, visitedClasses);
    }

    private boolean isSubclassOf(String subclass, String finalSuperclass, Set<String> visitedClasses) {
        UMLClass removedClass;
        UMLClass addedClass;
        if (visitedClasses.contains(subclass)) {
            return false;
        }
        visitedClasses.add(subclass);
        UMLClassBaseDiff subclassDiff = this.getUMLClassDiff(subclass);
        if (subclassDiff == null) {
            subclassDiff = this.getUMLClassDiff(UMLType.extractTypeObject(subclass));
        }
        if (subclassDiff != null) {
            UMLType superclass = subclassDiff.getSuperclass();
            if (superclass != null) {
                if (this.checkInheritanceRelationship(superclass, finalSuperclass, visitedClasses)) {
                    return true;
                }
            } else if (subclassDiff.getOldSuperclass() != null && subclassDiff.getNewSuperclass() != null && !subclassDiff.getOldSuperclass().equals(subclassDiff.getNewSuperclass()) && this.looksLikeAddedClass(subclassDiff.getNewSuperclass()) != null) {
                UMLClass addedClass2 = this.looksLikeAddedClass(subclassDiff.getNewSuperclass());
                if (addedClass2 != null && addedClass2.getSuperclass() != null) {
                    return this.checkInheritanceRelationship(addedClass2.getSuperclass(), finalSuperclass, visitedClasses);
                }
            } else if (subclassDiff.getOldSuperclass() == null && subclassDiff.getNewSuperclass() != null && this.looksLikeAddedClass(subclassDiff.getNewSuperclass()) != null) {
                UMLClass addedClass2 = this.looksLikeAddedClass(subclassDiff.getNewSuperclass());
                return this.checkInheritanceRelationship(UMLType.extractTypeObject(addedClass2.getQualifiedName()), finalSuperclass, visitedClasses);
            }
            for (UMLType uMLType : subclassDiff.getAddedImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(uMLType, finalSuperclass, visitedClasses)) continue;
                return true;
            }
            for (UMLType uMLType : subclassDiff.getNextClass().getImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(uMLType, finalSuperclass, visitedClasses)) continue;
                return true;
            }
        }
        if ((addedClass = this.getAddedClass(subclass)) == null) {
            addedClass = this.looksLikeAddedClass(UMLType.extractTypeObject(subclass));
        }
        if (addedClass != null) {
            UMLType superclass = addedClass.getSuperclass();
            if (superclass != null) {
                return this.checkInheritanceRelationship(superclass, finalSuperclass, visitedClasses);
            }
            for (UMLType implementedInterface : addedClass.getImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(implementedInterface, finalSuperclass, visitedClasses)) continue;
                return true;
            }
        }
        if ((removedClass = this.getRemovedClass(subclass)) == null) {
            removedClass = this.looksLikeRemovedClass(UMLType.extractTypeObject(subclass));
        }
        if (removedClass != null) {
            UMLType uMLType = removedClass.getSuperclass();
            if (uMLType != null) {
                return this.checkInheritanceRelationship(uMLType, finalSuperclass, visitedClasses);
            }
            for (UMLType implementedInterface : removedClass.getImplementedInterfaces()) {
                if (!this.checkInheritanceRelationship(implementedInterface, finalSuperclass, visitedClasses)) continue;
                return true;
            }
        }
        return false;
    }

    public UMLClass getAddedClass(String className) {
        for (UMLClass umlClass : this.addedClasses) {
            if (!umlClass.getQualifiedName().equals(className)) continue;
            return umlClass;
        }
        return null;
    }

    public UMLClass getRemovedClass(String className) {
        for (UMLClass umlClass : this.removedClasses) {
            if (!umlClass.getQualifiedName().equals(className)) continue;
            return umlClass;
        }
        return null;
    }

    public List<Refactoring> getRefactorings() throws RefactoringMinerTimedOutException {
        LinkedHashSet<Refactoring> refactorings = new LinkedHashSet<Refactoring>();
        refactorings.addAll(this.getMoveClassRefactorings());
        refactorings.addAll(this.getRenameClassRefactorings());
        LinkedHashMap renameMap = new LinkedHashMap();
        LinkedHashMap mergeMap = new LinkedHashMap();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            refactorings.addAll(uMLClassDiff.getRefactorings());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            refactorings.addAll(uMLClassMoveDiff.getRefactorings());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            refactorings.addAll(uMLClassMoveDiff.getRefactorings());
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            refactorings.addAll(uMLClassRenameDiff.getRefactorings());
        }
        for (UMLFileDiff uMLFileDiff : this.umlFileDiff) {
            refactorings.addAll(uMLFileDiff.getRefactorings());
        }
        Map<RenamePattern, Integer> typeRenamePatternMap = this.typeRenamePatternMap(refactorings);
        for (RenamePattern renamePattern : typeRenamePatternMap.keySet()) {
            if (typeRenamePatternMap.get(renamePattern) <= 1) continue;
            UMLClass removedClass = this.looksLikeRemovedClass(UMLType.extractTypeObject(renamePattern.getBefore()));
            UMLClass addedClass = this.looksLikeAddedClass(UMLType.extractTypeObject(renamePattern.getAfter()));
            if (removedClass == null || addedClass == null) continue;
            UMLClassRenameDiff renameDiff = new UMLClassRenameDiff(removedClass, addedClass, this);
            renameDiff.process();
            refactorings.addAll(renameDiff.getRefactorings());
            this.classRenameDiffList.add(renameDiff);
            Refactoring refactoring = renameDiff.samePackage() ? new RenameClassRefactoring(renameDiff.getOriginalClass(), renameDiff.getRenamedClass()) : new MoveAndRenameClassRefactoring(renameDiff.getOriginalClass(), renameDiff.getRenamedClass());
            refactorings.add(refactoring);
        }
        block6: for (Replacement replacement : renameMap.keySet()) {
            Set set = (Set)renameMap.get(replacement);
            for (CandidateAttributeRefactoring candidate : set) {
                RenameVariableRefactoring ref;
                Object a2;
                UMLClassBaseDiff originalClassDiff;
                if (candidate.getOriginalVariableDeclaration() == null) continue;
                List<UMLClassBaseDiff> diffs1 = this.getUMLClassDiffWithExistingAttributeAfter(replacement);
                List<UMLClassBaseDiff> diffs2 = this.getUMLClassDiffWithNewAttributeAfter(replacement);
                if (!diffs1.isEmpty()) {
                    UMLClassBaseDiff diff1 = diffs1.get(0);
                    originalClassDiff = candidate.getOriginalAttribute() != null ? this.getUMLClassDiff(candidate.getOriginalAttribute().getClassName()) : this.getUMLClassDiff(candidate.getOperationBefore().getClassName());
                    if (diffs1.size() > 1) {
                        for (UMLClassBaseDiff classDiff : diffs1) {
                            if (!this.isSubclassOf(originalClassDiff.nextClass.getQualifiedName(), classDiff.nextClass.getQualifiedName())) continue;
                            diff1 = classDiff;
                            break;
                        }
                    }
                    if ((a2 = diff1.findAttributeInNextClass(replacement.getAfter())) == null || candidate.getOriginalVariableDeclaration().isAttribute() || refactorings.contains(ref = new RenameVariableRefactoring(candidate.getOriginalVariableDeclaration(), ((UMLAttribute)a2).getVariableDeclaration(), candidate.getOperationBefore(), candidate.getOperationAfter(), candidate.getAttributeReferences()))) continue;
                    refactorings.add(ref);
                    continue block6;
                }
                if (diffs2.isEmpty()) continue;
                UMLClassBaseDiff diff2 = diffs2.get(0);
                originalClassDiff = candidate.getOriginalAttribute() != null ? this.getUMLClassDiff(candidate.getOriginalAttribute().getClassName()) : this.getUMLClassDiff(candidate.getOperationBefore().getClassName());
                if (diffs2.size() > 1) {
                    a2 = diffs2.iterator();
                    while (a2.hasNext()) {
                        UMLClassBaseDiff classDiff;
                        classDiff = (UMLClassBaseDiff)a2.next();
                        if (!this.isSubclassOf(originalClassDiff.nextClass.getQualifiedName(), classDiff.nextClass.getQualifiedName())) continue;
                        diff2 = classDiff;
                        break;
                    }
                }
                if ((a2 = diff2.findAttributeInNextClass(replacement.getAfter())) == null || candidate.getOriginalVariableDeclaration().isAttribute() || refactorings.contains(ref = new RenameVariableRefactoring(candidate.getOriginalVariableDeclaration(), ((UMLAttribute)a2).getVariableDeclaration(), candidate.getOperationBefore(), candidate.getOperationAfter(), candidate.getAttributeReferences()))) continue;
                refactorings.add(ref);
                continue block6;
            }
        }
        this.checkForOperationMovesBetweenCommonClasses();
        this.checkForOperationMovesIncludingAddedClasses();
        this.checkForOperationMovesIncludingRemovedClasses();
        refactorings.addAll(this.identifyExtractSuperclassRefactorings());
        refactorings.addAll(this.identifyExtractClassRefactorings(this.commonClassDiffList));
        refactorings.addAll(this.identifyExtractClassRefactorings(this.classMoveDiffList));
        refactorings.addAll(this.identifyExtractClassRefactorings(this.innerClassMoveDiffList));
        refactorings.addAll(this.identifyExtractClassRefactorings(this.classRenameDiffList));
        this.checkForExtractedAndMovedOperations(this.getOperationBodyMappersInCommonClasses(), this.getAddedAndExtractedOperationsInCommonClasses());
        this.checkForExtractedAndMovedOperations(this.getOperationBodyMappersInMovedAndRenamedClasses(), this.getAddedOperationsInMovedAndRenamedClasses());
        this.checkForMovedAndInlinedOperations(this.getOperationBodyMappersInCommonClasses(), this.getRemovedAndInlinedOperationsInCommonClasses());
        refactorings.addAll(this.refactorings);
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassDiff, refactorings);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassMoveDiff, refactorings);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassMoveDiff, refactorings);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            this.inferMethodSignatureRelatedRefactorings(uMLClassRenameDiff, refactorings);
        }
        return new ArrayList<Refactoring>(refactorings);
    }

    private List<UMLOperation> getAddedOperationsInCommonClasses() {
        ArrayList<UMLOperation> addedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            addedOperations.addAll(classDiff.getAddedOperations());
        }
        return addedOperations;
    }

    private List<UMLOperation> getAddedAndExtractedOperationsInCommonClasses() {
        ArrayList<UMLOperation> addedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            addedOperations.addAll(classDiff.getAddedOperations());
            for (Refactoring ref : classDiff.getRefactorings()) {
                if (!(ref instanceof ExtractOperationRefactoring)) continue;
                ExtractOperationRefactoring extractRef = (ExtractOperationRefactoring)ref;
                addedOperations.add(extractRef.getExtractedOperation());
            }
        }
        return addedOperations;
    }

    private List<UMLOperation> getAddedOperationsInMovedAndRenamedClasses() {
        ArrayList<UMLOperation> addedOperations = new ArrayList<UMLOperation>();
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            addedOperations.addAll(uMLClassMoveDiff.getAddedOperations());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            addedOperations.addAll(uMLClassMoveDiff.getAddedOperations());
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            addedOperations.addAll(uMLClassRenameDiff.getAddedOperations());
        }
        return addedOperations;
    }

    private List<UMLOperation> getRemovedOperationsInCommonClasses() {
        ArrayList<UMLOperation> removedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            removedOperations.addAll(classDiff.getRemovedOperations());
        }
        return removedOperations;
    }

    private void checkForOperationMovesIncludingRemovedClasses() throws RefactoringMinerTimedOutException {
        List<UMLOperation> addedOperations = this.getAddedAndExtractedOperationsInCommonClasses();
        List<UMLOperation> removedOperations = this.getRemovedOperationsInCommonClasses();
        for (UMLClass removedClass : this.removedClasses) {
            removedOperations.addAll(removedClass.getOperations());
        }
        if (removedOperations.size() <= 100 || addedOperations.size() <= 100) {
            this.checkForOperationMoves(addedOperations, removedOperations);
        }
    }

    private void checkForOperationMovesIncludingAddedClasses() throws RefactoringMinerTimedOutException {
        List<UMLOperation> addedOperations = this.getAddedOperationsInCommonClasses();
        for (UMLClass addedClass : this.addedClasses) {
            addedOperations.addAll(addedClass.getOperations());
        }
        List<UMLOperation> removedOperations = this.getRemovedOperationsInCommonClasses();
        if (removedOperations.size() <= 100 || addedOperations.size() <= 100) {
            this.checkForOperationMoves(addedOperations, removedOperations);
        }
    }

    private void checkForMovedAndInlinedOperations(List<UMLOperationBodyMapper> mappers, List<UMLOperation> removedOperations) throws RefactoringMinerTimedOutException {
        for (UMLOperation removedOperation : removedOperations) {
            for (UMLOperationBodyMapper mapper : mappers) {
                if (mapper.getNonMappedLeavesT2().isEmpty() && mapper.getNonMappedInnerNodesT2().isEmpty() && mapper.getReplacementsInvolvingMethodInvocation().isEmpty()) continue;
                List<OperationInvocation> operationInvocations = mapper.getOperation1().getAllOperationInvocations();
                ArrayList<OperationInvocation> removedOperationInvocations = new ArrayList<OperationInvocation>();
                for (OperationInvocation invocation : operationInvocations) {
                    if (!invocation.matchesOperation(removedOperation, mapper.getOperation1().variableTypeMap(), this)) continue;
                    removedOperationInvocations.add(invocation);
                }
                if (removedOperationInvocations.size() <= 0 || this.invocationMatchesWithAddedOperation((OperationInvocation)removedOperationInvocations.get(0), mapper.getOperation1().variableTypeMap(), mapper.getOperation2().getAllOperationInvocations())) continue;
                OperationInvocation removedOperationInvocation = (OperationInvocation)removedOperationInvocations.get(0);
                List<String> arguments = removedOperationInvocation.getArguments();
                List<String> parameters = removedOperation.getParameterNameList();
                LinkedHashMap<String, String> parameterToArgumentMap = new LinkedHashMap<String, String>();
                int size = Math.min(arguments.size(), parameters.size());
                for (int i = 0; i < size; ++i) {
                    parameterToArgumentMap.put(parameters.get(i), arguments.get(i));
                }
                UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, mapper, parameterToArgumentMap, this.getUMLClassDiff(removedOperation.getClassName()));
                if (!this.moveAndInlineMatchCondition(operationBodyMapper, mapper)) continue;
                InlineOperationRefactoring inlineOperationRefactoring = new InlineOperationRefactoring(operationBodyMapper, mapper.getOperation1(), removedOperationInvocations);
                this.refactorings.add(inlineOperationRefactoring);
                this.deleteRemovedOperation(removedOperation);
            }
        }
    }

    private boolean invocationMatchesWithAddedOperation(OperationInvocation removedOperationInvocation, Map<String, UMLType> variableTypeMap, List<OperationInvocation> operationInvocationsInNewMethod) {
        if (operationInvocationsInNewMethod.contains(removedOperationInvocation)) {
            for (UMLOperation addedOperation : this.getAddedOperationsInCommonClasses()) {
                if (!removedOperationInvocation.matchesOperation(addedOperation, variableTypeMap, this)) continue;
                return true;
            }
        }
        return false;
    }

    private List<UMLOperationBodyMapper> getOperationBodyMappersInCommonClasses() {
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            mappers.addAll(classDiff.getOperationBodyMapperList());
        }
        return mappers;
    }

    private void checkForExtractedAndMovedOperations(List<UMLOperationBodyMapper> mappers, List<UMLOperation> addedOperations) throws RefactoringMinerTimedOutException {
        for (UMLOperation addedOperation : addedOperations) {
            for (UMLOperationBodyMapper mapper : mappers) {
                ExtractOperationRefactoring extractOperationRefactoring;
                UMLClassBaseDiff umlClassDiff;
                if (mapper.nonMappedElementsT1() <= 0 && mapper.getReplacementsInvolvingMethodInvocation().isEmpty() || mapper.containsExtractOperationRefactoring(addedOperation)) continue;
                List<OperationInvocation> operationInvocations = ExtractOperationDetection.getInvocationsInSourceOperationAfterExtraction(mapper);
                ArrayList<OperationInvocation> addedOperationInvocations = new ArrayList<OperationInvocation>();
                for (OperationInvocation invocation : operationInvocations) {
                    if (!invocation.matchesOperation(addedOperation, mapper.getOperation2().variableTypeMap(), this)) continue;
                    addedOperationInvocations.add(invocation);
                }
                if (addedOperationInvocations.size() <= 0) continue;
                OperationInvocation addedOperationInvocation = (OperationInvocation)addedOperationInvocations.get(0);
                List<String> arguments = addedOperationInvocation.getArguments();
                List<String> parameters = addedOperation.getParameterNameList();
                LinkedHashMap<String, String> parameterToArgumentMap2 = new LinkedHashMap<String, String>();
                int size = Math.min(arguments.size(), parameters.size());
                for (int i = 0; i < size; ++i) {
                    parameterToArgumentMap2.put(parameters.get(i), arguments.get(i));
                }
                String className = mapper.getOperation2().getClassName();
                ArrayList<UMLAttribute> attributes = new ArrayList<UMLAttribute>();
                if (className.contains(".") && UMLModelDiff.isNumeric(className.substring(className.lastIndexOf(".") + 1))) {
                    umlClassDiff = this.getUMLClassDiff(className.substring(0, className.lastIndexOf(".")));
                    attributes.addAll(umlClassDiff.originalClassAttributesOfType(addedOperation.getClassName()));
                } else {
                    umlClassDiff = this.getUMLClassDiff(className);
                    if (umlClassDiff == null) {
                        for (UMLClassDiff classDiff : this.commonClassDiffList) {
                            if (umlClassDiff == null) continue;
                            break;
                        }
                    }
                    attributes.addAll(umlClassDiff.originalClassAttributesOfType(addedOperation.getClassName()));
                }
                LinkedHashMap<String, String> parameterToArgumentMap1 = new LinkedHashMap<String, String>();
                for (UMLAttribute attribute : attributes) {
                    parameterToArgumentMap1.put(attribute.getName() + ".", "");
                    parameterToArgumentMap2.put("this.", "");
                }
                if (addedOperationInvocation.getExpression() != null) {
                    parameterToArgumentMap1.put(addedOperationInvocation.getExpression() + ".", "");
                    parameterToArgumentMap2.put("this.", "");
                }
                UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(mapper, addedOperation, parameterToArgumentMap1, parameterToArgumentMap2, this.getUMLClassDiff(addedOperation.getClassName()));
                if (this.anotherAddedMethodExistsWithBetterMatchingInvocationExpression(addedOperationInvocation, addedOperation, addedOperations) || this.conflictingExpression(addedOperationInvocation, addedOperation, mapper.getOperation2().variableTypeMap()) || !this.extractAndMoveMatchCondition(operationBodyMapper, mapper)) continue;
                if (className.equals(addedOperation.getClassName())) {
                    extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getOperation2(), addedOperationInvocations);
                    this.refactorings.add(extractOperationRefactoring);
                    this.deleteAddedOperation(addedOperation);
                    continue;
                }
                if (this.isSubclassOf(className, addedOperation.getClassName())) {
                    extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getOperation2(), addedOperationInvocations);
                    this.refactorings.add(extractOperationRefactoring);
                    this.deleteAddedOperation(addedOperation);
                    continue;
                }
                if (this.isSubclassOf(addedOperation.getClassName(), className)) {
                    extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getOperation2(), addedOperationInvocations);
                    this.refactorings.add(extractOperationRefactoring);
                    this.deleteAddedOperation(addedOperation);
                    continue;
                }
                if (addedOperation.getClassName().startsWith(className + ".")) {
                    extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getOperation2(), addedOperationInvocations);
                    this.refactorings.add(extractOperationRefactoring);
                    this.deleteAddedOperation(addedOperation);
                    continue;
                }
                if (className.startsWith(addedOperation.getClassName() + ".")) {
                    extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getOperation2(), addedOperationInvocations);
                    this.refactorings.add(extractOperationRefactoring);
                    this.deleteAddedOperation(addedOperation);
                    continue;
                }
                if (!this.sourceClassImportsTargetClass(className, addedOperation.getClassName()) && !this.sourceClassImportsSuperclassOfTargetClass(className, addedOperation.getClassName()) && !this.targetClassImportsSourceClass(className, addedOperation.getClassName())) continue;
                extractOperationRefactoring = new ExtractOperationRefactoring(operationBodyMapper, mapper.getOperation2(), addedOperationInvocations);
                this.refactorings.add(extractOperationRefactoring);
                this.deleteAddedOperation(addedOperation);
            }
        }
    }

    private List<UMLOperationBodyMapper> getOperationBodyMappersInMovedAndRenamedClasses() {
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            mappers.addAll(uMLClassMoveDiff.getOperationBodyMapperList());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            mappers.addAll(uMLClassMoveDiff.getOperationBodyMapperList());
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            mappers.addAll(uMLClassRenameDiff.getOperationBodyMapperList());
        }
        return mappers;
    }

    private boolean moveAndInlineMatchCondition(UMLOperationBodyMapper operationBodyMapper, UMLOperationBodyMapper parentMapper) {
        ArrayList<AbstractCodeMapping> mappingList = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        if ((operationBodyMapper.getOperation1().isGetter() || operationBodyMapper.getOperation1().isDelegate() != null) && mappingList.size() == 1) {
            ArrayList<AbstractCodeMapping> parentMappingList = new ArrayList<AbstractCodeMapping>(parentMapper.getMappings());
            for (AbstractCodeMapping mapping : parentMappingList) {
                if (mapping.getFragment2().equals(((AbstractCodeMapping)mappingList.get(0)).getFragment2())) {
                    return false;
                }
                if (!(mapping instanceof CompositeStatementObjectMapping)) continue;
                CompositeStatementObjectMapping compositeMapping = (CompositeStatementObjectMapping)mapping;
                CompositeStatementObject fragment2 = (CompositeStatementObject)compositeMapping.getFragment2();
                for (AbstractExpression expression : fragment2.getExpressions()) {
                    if (!expression.equals(((AbstractCodeMapping)mappingList.get(0)).getFragment2())) continue;
                    return false;
                }
            }
        }
        int delegateStatements = 0;
        for (StatementObject statement : operationBodyMapper.getNonMappedLeavesT1()) {
            OperationInvocation invocation = statement.invocationCoveringEntireFragment();
            if (invocation == null || !invocation.matchesOperation(operationBodyMapper.getOperation1())) continue;
            ++delegateStatements;
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1() - delegateStatements;
        List<AbstractCodeMapping> exactMatchList = operationBodyMapper.getExactMatches();
        int exactMatches = exactMatchList.size();
        return mappings > 0 && (mappings > nonMappedElementsT1 || exactMatches == 1 && !exactMatchList.get(0).getFragment1().throwsNewException() && nonMappedElementsT1 - exactMatches < 10 || exactMatches > 1 && nonMappedElementsT1 - exactMatches < 20);
    }

    private List<UMLOperation> getRemovedAndInlinedOperationsInCommonClasses() {
        ArrayList<UMLOperation> removedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff classDiff : this.commonClassDiffList) {
            removedOperations.addAll(classDiff.getRemovedOperations());
            for (Refactoring ref : classDiff.getRefactorings()) {
                if (!(ref instanceof InlineOperationRefactoring)) continue;
                InlineOperationRefactoring extractRef = (InlineOperationRefactoring)ref;
                removedOperations.add(extractRef.getInlinedOperation());
            }
        }
        return removedOperations;
    }

    private void checkForOperationMovesBetweenCommonClasses() throws RefactoringMinerTimedOutException {
        List<UMLOperation> addedOperations = this.getAddedAndExtractedOperationsInCommonClasses();
        List<UMLOperation> removedOperations = this.getRemovedOperationsInCommonMovedRenamedClasses();
        if (removedOperations.size() <= 100 || addedOperations.size() <= 100) {
            this.checkForOperationMoves(addedOperations, removedOperations);
        }
    }

    private List<UMLOperation> getRemovedOperationsInCommonMovedRenamedClasses() {
        ArrayList<UMLOperation> removedOperations = new ArrayList<UMLOperation>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            removedOperations.addAll(uMLClassDiff.getRemovedOperations());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            removedOperations.addAll(uMLClassMoveDiff.getRemovedOperations());
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            removedOperations.addAll(uMLClassMoveDiff.getRemovedOperations());
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            removedOperations.addAll(uMLClassRenameDiff.getRemovedOperations());
        }
        return removedOperations;
    }

    private List<Refactoring> getRenameClassRefactorings() {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        for (UMLClassRenameDiff classRenameDiff : this.classRenameDiffList) {
            if (classRenameDiff.getOriginalClass().getName().equals(classRenameDiff.getRenamedClass().getName())) continue;
            Refactoring refactoring = classRenameDiff.samePackage() ? new RenameClassRefactoring(classRenameDiff.getOriginalClass(), classRenameDiff.getRenamedClass()) : new MoveAndRenameClassRefactoring(classRenameDiff.getOriginalClass(), classRenameDiff.getRenamedClass());
            refactorings.add(refactoring);
        }
        return refactorings;
    }

    private UMLClassBaseDiff getUMLClassDiff(String className) {
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (!uMLClassDiff.matches(className)) continue;
            return uMLClassDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (!uMLClassMoveDiff.matches(className)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (!uMLClassMoveDiff.matches(className)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (!uMLClassRenameDiff.matches(className)) continue;
            return uMLClassRenameDiff;
        }
        return null;
    }

    private UMLClassBaseDiff getUMLClassDiff(UMLType type) {
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            if (!uMLClassDiff.matches(type)) continue;
            return uMLClassDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            if (!uMLClassMoveDiff.matches(type)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            if (!uMLClassMoveDiff.matches(type)) continue;
            return uMLClassMoveDiff;
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            if (!uMLClassRenameDiff.matches(type)) continue;
            return uMLClassRenameDiff;
        }
        return null;
    }

    public boolean commonlyImplementedOperations(UMLOperation operation1, UMLOperation operation2, UMLClassBaseDiff classDiff2) {
        UMLClassBaseDiff classDiff1 = this.getUMLClassDiff(operation1.getClassName());
        if (classDiff1 != null) {
            Set<UMLType> commonInterfaces = classDiff1.nextClassCommonInterfaces(classDiff2);
            for (UMLType commonInterface : commonInterfaces) {
                UMLClassBaseDiff interfaceDiff = this.getUMLClassDiff(commonInterface);
                if (interfaceDiff == null || !interfaceDiff.containsOperationWithTheSameSignatureInOriginalClass(operation1) || !interfaceDiff.containsOperationWithTheSameSignatureInNextClass(operation2)) continue;
                return true;
            }
        }
        return false;
    }

    private List<UMLOperationBodyMapper> findMappersWithMatchingSignatures(UMLOperation operation1, UMLOperation operation2) {
        UMLOperationBodyMapper mapper;
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            mapper = uMLClassDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            mapper = uMLClassRenameDiff.findMapperWithMatchingSignatures(operation1, operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        return mappers;
    }

    private void inferMethodSignatureRelatedRefactorings(UMLClassBaseDiff classDiff, Set<Refactoring> refactorings) {
        block7: {
            block6: {
                if (!classDiff.getOriginalClass().isInterface() || !classDiff.getNextClass().isInterface()) break block6;
                for (UMLOperation removedOperation : classDiff.getRemovedOperations()) {
                    for (UMLOperation addedOperation : classDiff.getAddedOperations()) {
                        List<UMLOperationBodyMapper> mappers = this.findMappersWithMatchingSignatures(removedOperation, addedOperation);
                        if (mappers.isEmpty()) continue;
                        UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation);
                        if (operationSignatureDiff.isOperationRenamed()) {
                            RenameOperationRefactoring refactoring = new RenameOperationRefactoring(removedOperation, addedOperation);
                            refactorings.add(refactoring);
                        }
                        Set<Refactoring> signatureRefactorings = operationSignatureDiff.getRefactorings();
                        refactorings.addAll(signatureRefactorings);
                        if (!signatureRefactorings.isEmpty()) continue;
                        this.inferRefactoringsFromMatchingMappers(mappers, operationSignatureDiff, refactorings);
                    }
                }
                break block7;
            }
            if (!classDiff.getOriginalClass().isAbstract() || !classDiff.getNextClass().isAbstract()) break block7;
            for (UMLOperation removedOperation : classDiff.getRemovedOperations()) {
                for (UMLOperation addedOperation : classDiff.getAddedOperations()) {
                    List<UMLOperationBodyMapper> mappers;
                    if (!removedOperation.isAbstract() || !addedOperation.isAbstract() || (mappers = this.findMappersWithMatchingSignatures(removedOperation, addedOperation)).isEmpty()) continue;
                    UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation);
                    if (operationSignatureDiff.isOperationRenamed()) {
                        RenameOperationRefactoring refactoring = new RenameOperationRefactoring(removedOperation, addedOperation);
                        refactorings.add(refactoring);
                    }
                    Set<Refactoring> signatureRefactorings = operationSignatureDiff.getRefactorings();
                    refactorings.addAll(signatureRefactorings);
                    if (!signatureRefactorings.isEmpty()) continue;
                    this.inferRefactoringsFromMatchingMappers(mappers, operationSignatureDiff, refactorings);
                }
            }
        }
    }

    public List<UMLOperationBodyMapper> findMappersWithMatchingSignature2(UMLOperation operation2) {
        UMLOperationBodyMapper mapper;
        ArrayList<UMLOperationBodyMapper> mappers = new ArrayList<UMLOperationBodyMapper>();
        for (UMLClassDiff uMLClassDiff : this.commonClassDiffList) {
            mapper = uMLClassDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.classMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassMoveDiff uMLClassMoveDiff : this.innerClassMoveDiffList) {
            mapper = uMLClassMoveDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        for (UMLClassRenameDiff uMLClassRenameDiff : this.classRenameDiffList) {
            mapper = uMLClassRenameDiff.findMapperWithMatchingSignature2(operation2);
            if (mapper == null) continue;
            mappers.add(mapper);
        }
        return mappers;
    }

    private void inferRefactoringsFromMatchingMappers(List<UMLOperationBodyMapper> mappers, UMLOperationDiff operationSignatureDiff, Set<Refactoring> refactorings) {
        for (UMLOperationBodyMapper mapper : mappers) {
            for (Refactoring refactoring : mapper.getRefactoringsAfterPostProcessing()) {
                Object matchingAddedParameter;
                UMLParameter matchingRemovedParameter;
                if (refactoring instanceof RenameVariableRefactoring) {
                    RenameVariableRefactoring rename = (RenameVariableRefactoring)refactoring;
                    matchingRemovedParameter = null;
                    for (UMLParameter uMLParameter : operationSignatureDiff.getRemovedParameters()) {
                        if (!uMLParameter.getName().equals(rename.getOriginalVariable().getVariableName()) || !uMLParameter.getType().equals(rename.getOriginalVariable().getType())) continue;
                        matchingRemovedParameter = uMLParameter;
                        break;
                    }
                    matchingAddedParameter = null;
                    for (UMLParameter parameter : operationSignatureDiff.getAddedParameters()) {
                        if (!parameter.getName().equals(rename.getRenamedVariable().getVariableName()) || !parameter.getType().equals(rename.getRenamedVariable().getType())) continue;
                        matchingAddedParameter = parameter;
                        break;
                    }
                    if (matchingRemovedParameter == null || matchingAddedParameter == null) continue;
                    RenameVariableRefactoring renameVariableRefactoring = new RenameVariableRefactoring(matchingRemovedParameter.getVariableDeclaration(), ((UMLParameter)matchingAddedParameter).getVariableDeclaration(), operationSignatureDiff.getRemovedOperation(), operationSignatureDiff.getAddedOperation(), new LinkedHashSet<AbstractCodeMapping>());
                    refactorings.add(renameVariableRefactoring);
                    continue;
                }
                if (!(refactoring instanceof ChangeVariableTypeRefactoring)) continue;
                ChangeVariableTypeRefactoring changeType = (ChangeVariableTypeRefactoring)refactoring;
                matchingRemovedParameter = null;
                for (UMLParameter uMLParameter : operationSignatureDiff.getRemovedParameters()) {
                    if (!uMLParameter.getName().equals(changeType.getOriginalVariable().getVariableName()) || !uMLParameter.getType().equals(changeType.getOriginalVariable().getType())) continue;
                    matchingRemovedParameter = uMLParameter;
                    break;
                }
                matchingAddedParameter = null;
                for (UMLParameter parameter : operationSignatureDiff.getAddedParameters()) {
                    if (!parameter.getName().equals(changeType.getChangedTypeVariable().getVariableName()) || !parameter.getType().equals(changeType.getChangedTypeVariable().getType())) continue;
                    matchingAddedParameter = parameter;
                    break;
                }
                if (matchingRemovedParameter == null || matchingAddedParameter == null) continue;
                ChangeVariableTypeRefactoring changeVariableTypeRefactoring = new ChangeVariableTypeRefactoring(matchingRemovedParameter.getVariableDeclaration(), ((UMLParameter)matchingAddedParameter).getVariableDeclaration(), operationSignatureDiff.getRemovedOperation(), operationSignatureDiff.getAddedOperation(), new LinkedHashSet<AbstractCodeMapping>());
                refactorings.add(changeVariableTypeRefactoring);
            }
        }
    }

    private List<Refactoring> getMoveClassRefactorings() {
        ArrayList<Refactoring> refactorings = new ArrayList<Refactoring>();
        ArrayList<RenamePackageRefactoring> renamePackageRefactorings = new ArrayList<RenamePackageRefactoring>();
        ArrayList<MoveSourceFolderRefactoring> moveSourceFolderRefactorings = new ArrayList<MoveSourceFolderRefactoring>();
        for (UMLClassMoveDiff classMoveDiff : this.classMoveDiffList) {
            RenamePattern renamePattern;
            Object refactoring;
            UMLClass originalClass = classMoveDiff.getOriginalClass();
            String originalName = originalClass.getQualifiedName();
            UMLClass movedClass = classMoveDiff.getMovedClass();
            String movedName = movedClass.getQualifiedName();
            String originalPath = originalClass.getSourceFile();
            String movedPath = movedClass.getSourceFile();
            String originalPathPrefix = "";
            if (originalPath.contains("/")) {
                originalPathPrefix = originalPath.substring(0, originalPath.lastIndexOf(47));
            }
            String movedPathPrefix = "";
            if (movedPath.contains("/")) {
                movedPathPrefix = movedPath.substring(0, movedPath.lastIndexOf(47));
            }
            if (!originalName.equals(movedName)) {
                refactoring = new MoveClassRefactoring(originalClass, movedClass);
                renamePattern = ((MoveClassRefactoring)refactoring).getRenamePattern();
                if (renamePattern.getBefore().contains(renamePattern.getAfter()) || renamePattern.getAfter().contains(renamePattern.getBefore()) || !originalClass.isTopLevel() || !movedClass.isTopLevel()) {
                    refactorings.add((Refactoring)refactoring);
                    continue;
                }
                boolean foundInMatchingRenamePackageRefactoring = false;
                for (RenamePackageRefactoring renamePackageRefactoring : renamePackageRefactorings) {
                    if (!renamePackageRefactoring.getPattern().equals(renamePattern)) continue;
                    renamePackageRefactoring.addMoveClassRefactoring((MoveClassRefactoring)refactoring);
                    foundInMatchingRenamePackageRefactoring = true;
                    break;
                }
                if (foundInMatchingRenamePackageRefactoring) continue;
                renamePackageRefactorings.add(new RenamePackageRefactoring((MoveClassRefactoring)refactoring));
                continue;
            }
            if (originalPathPrefix.equals(movedPathPrefix)) continue;
            refactoring = new MovedClassToAnotherSourceFolder(originalClass, movedClass, originalPathPrefix, movedPathPrefix);
            renamePattern = ((MovedClassToAnotherSourceFolder)refactoring).getRenamePattern();
            boolean foundInMatchingMoveSourceFolderRefactoring = false;
            for (MoveSourceFolderRefactoring moveSourceFolderRefactoring : moveSourceFolderRefactorings) {
                if (!moveSourceFolderRefactoring.getPattern().equals(renamePattern)) continue;
                moveSourceFolderRefactoring.addMovedClassToAnotherSourceFolder((MovedClassToAnotherSourceFolder)refactoring);
                foundInMatchingMoveSourceFolderRefactoring = true;
                break;
            }
            if (foundInMatchingMoveSourceFolderRefactoring) continue;
            moveSourceFolderRefactorings.add(new MoveSourceFolderRefactoring((MovedClassToAnotherSourceFolder)refactoring));
        }
        for (RenamePackageRefactoring renamePackageRefactoring : renamePackageRefactorings) {
            List<MoveClassRefactoring> moveClassRefactorings = renamePackageRefactoring.getMoveClassRefactorings();
            if (moveClassRefactorings.size() > 1 && this.isSourcePackageDeleted(renamePackageRefactoring)) {
                refactorings.add(renamePackageRefactoring);
            }
            refactorings.addAll(moveClassRefactorings);
        }
        refactorings.addAll(moveSourceFolderRefactorings);
        return refactorings;
    }

    public void checkForMovedClasses(Map<String, String> renamedFileHints, Set<String> repositoryDirectories, UMLClassMatcher matcher) throws RefactoringMinerTimedOutException {
        Iterator<UMLClass> removedClassIterator = this.removedClasses.iterator();
        while (removedClassIterator.hasNext()) {
            UMLClass removedClass = removedClassIterator.next();
            TreeSet<UMLClassMoveDiff> diffSet = new TreeSet<UMLClassMoveDiff>(new ClassMoveComparator());
            for (UMLClass addedClass : this.addedClasses) {
                String removedClassSourceFile = removedClass.getSourceFile();
                String renamedFile = renamedFileHints.get(removedClassSourceFile);
                String removedClassSourceFolder = "";
                if (removedClassSourceFile.contains("/")) {
                    removedClassSourceFolder = removedClassSourceFile.substring(0, removedClassSourceFile.lastIndexOf("/"));
                }
                if (!repositoryDirectories.contains(removedClassSourceFolder)) {
                    this.deletedFolderPaths.add(removedClassSourceFolder);
                    String subDirectory = removedClassSourceFolder;
                    while (subDirectory.contains("/")) {
                        if (repositoryDirectories.contains(subDirectory = subDirectory.substring(0, subDirectory.lastIndexOf("/")))) continue;
                        this.deletedFolderPaths.add(subDirectory);
                    }
                }
                if (!matcher.match(removedClass, addedClass, renamedFile) || this.conflictingMoveOfTopLevelClass(removedClass, addedClass)) continue;
                UMLClassMoveDiff classMoveDiff = new UMLClassMoveDiff(removedClass, addedClass, this);
                diffSet.add(classMoveDiff);
            }
            if (diffSet.isEmpty()) continue;
            UMLClassMoveDiff minClassMoveDiff = diffSet.first();
            minClassMoveDiff.process();
            this.classMoveDiffList.add(minClassMoveDiff);
            this.addedClasses.remove(minClassMoveDiff.getMovedClass());
            removedClassIterator.remove();
        }
        ArrayList<UMLClassMoveDiff> allClassMoves = new ArrayList<UMLClassMoveDiff>(this.classMoveDiffList);
        Collections.sort(allClassMoves);
        for (int i = 0; i < allClassMoves.size(); ++i) {
            UMLClassMoveDiff classMoveI = (UMLClassMoveDiff)allClassMoves.get(i);
            for (int j = i + 1; j < allClassMoves.size(); ++j) {
                UMLClassMoveDiff classMoveJ = (UMLClassMoveDiff)allClassMoves.get(j);
                if (!classMoveI.isInnerClassMove(classMoveJ)) continue;
                this.innerClassMoveDiffList.add(classMoveJ);
            }
        }
        this.classMoveDiffList.removeAll(this.innerClassMoveDiffList);
    }

    public void checkForRenamedClasses(Map<String, String> renamedFileHints, UMLClassMatcher matcher) throws RefactoringMinerTimedOutException {
        Iterator<UMLClass> removedClassIterator = this.removedClasses.iterator();
        while (removedClassIterator.hasNext()) {
            UMLClass removedClass = removedClassIterator.next();
            TreeSet<UMLClassRenameDiff> diffSet = new TreeSet<UMLClassRenameDiff>(new ClassRenameComparator());
            for (UMLClass addedClass : this.addedClasses) {
                String renamedFile = renamedFileHints.get(removedClass.getSourceFile());
                if (removedClass.getQualifiedName().equals(addedClass.getQualifiedName()) || !matcher.match(removedClass, addedClass, renamedFile) || this.conflictingMoveOfTopLevelClass(removedClass, addedClass) || this.innerClassWithTheSameName(removedClass, addedClass)) continue;
                UMLClassRenameDiff classRenameDiff = new UMLClassRenameDiff(removedClass, addedClass, this);
                diffSet.add(classRenameDiff);
            }
            if (diffSet.isEmpty()) continue;
            UMLClassRenameDiff minClassRenameDiff = diffSet.first();
            minClassRenameDiff.process();
            this.classRenameDiffList.add(minClassRenameDiff);
            this.addedClasses.remove(minClassRenameDiff.getRenamedClass());
            removedClassIterator.remove();
        }
        ArrayList<UMLClassMoveDiff> allClassMoves = new ArrayList<UMLClassMoveDiff>(this.classMoveDiffList);
        Collections.sort(allClassMoves);
        for (UMLClassRenameDiff classRename : this.classRenameDiffList) {
            for (UMLClassMoveDiff classMove : allClassMoves) {
                if (!classRename.isInnerClassMove(classMove)) continue;
                this.innerClassMoveDiffList.add(classMove);
            }
        }
        this.classMoveDiffList.removeAll(this.innerClassMoveDiffList);
    }

    private void checkForOperationMoves(List<UMLOperation> addedOperations, List<UMLOperation> removedOperations) throws RefactoringMinerTimedOutException {
        if (addedOperations.size() <= removedOperations.size()) {
            Iterator<UMLOperation> addedOperationIterator = addedOperations.iterator();
            while (addedOperationIterator.hasNext()) {
                UMLOperation addedOperation = addedOperationIterator.next();
                TreeMap<Integer, List<UMLOperationBodyMapper>> operationBodyMapperMap = new TreeMap<Integer, List<UMLOperationBodyMapper>>();
                for (UMLOperation removedOperation : removedOperations) {
                    List<Object> mapperList;
                    UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, this.getUMLClassDiff(removedOperation.getClassName()));
                    int mappings = operationBodyMapper.mappingsWithoutBlocks();
                    if (mappings <= 0 || !this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper)) continue;
                    int exactMatches = operationBodyMapper.exactMatches();
                    if (operationBodyMapperMap.containsKey(exactMatches)) {
                        mapperList = operationBodyMapperMap.get(exactMatches);
                        mapperList.add(operationBodyMapper);
                        continue;
                    }
                    mapperList = new ArrayList<UMLOperationBodyMapper>();
                    mapperList.add(operationBodyMapper);
                    operationBodyMapperMap.put(exactMatches, mapperList);
                }
                if (operationBodyMapperMap.isEmpty()) continue;
                List<UMLOperationBodyMapper> firstMappers = this.firstMappers(operationBodyMapperMap);
                firstMappers.sort(new UMLOperationBodyMapperComparator());
                addedOperationIterator.remove();
                boolean sameSourceAndTargetClass = this.sameSourceAndTargetClass(firstMappers);
                if (sameSourceAndTargetClass) {
                    TreeSet<UMLOperationBodyMapper> set = this.allRenamedOperations(firstMappers) ? new TreeSet() : new TreeSet<UMLOperationBodyMapper>(new UMLOperationBodyMapperComparator());
                    set.addAll(firstMappers);
                    UMLOperationBodyMapper bestMapper = set.first();
                    firstMappers.clear();
                    firstMappers.add(bestMapper);
                }
                for (UMLOperationBodyMapper firstMapper : firstMappers) {
                    UMLOperation removedOperation = firstMapper.getOperation1();
                    if (sameSourceAndTargetClass) {
                        removedOperations.remove(removedOperation);
                    }
                    MoveOperationRefactoring refactoring = null;
                    if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(removedOperation.getClassName(), addedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation)) {
                        refactoring = new PullUpOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(addedOperation.getClassName(), removedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation)) {
                        refactoring = new PushDownOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && !addedOperation.getClassName().equals(removedOperation.getClassName()) && this.movedMethodSignature(removedOperation, addedOperation) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && !addedOperation.getClassName().equals(removedOperation.getClassName()) && this.movedAndRenamedMethodSignature(removedOperation, addedOperation, firstMapper) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    }
                    if (refactoring == null) continue;
                    this.deleteRemovedOperation(removedOperation);
                    this.deleteAddedOperation(addedOperation);
                    UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, firstMapper.getMappings());
                    this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                    this.refactorings.add(refactoring);
                    UMLClass addedClass = this.getAddedClass(addedOperation.getClassName());
                    if (addedClass == null) continue;
                    this.checkForExtractedOperationsWithinMovedMethod(firstMapper, addedClass);
                }
            }
        } else {
            Iterator<UMLOperation> removedOperationIterator = removedOperations.iterator();
            while (removedOperationIterator.hasNext()) {
                UMLOperation removedOperation = removedOperationIterator.next();
                TreeMap<Integer, List<UMLOperationBodyMapper>> operationBodyMapperMap = new TreeMap<Integer, List<UMLOperationBodyMapper>>();
                for (UMLOperation addedOperation : addedOperations) {
                    List<Object> mapperList;
                    UMLOperationBodyMapper operationBodyMapper = new UMLOperationBodyMapper(removedOperation, addedOperation, this.getUMLClassDiff(removedOperation.getClassName()));
                    int mappings = operationBodyMapper.mappingsWithoutBlocks();
                    if (mappings <= 0 || !this.mappedElementsMoreThanNonMappedT1AndT2(mappings, operationBodyMapper)) continue;
                    int exactMatches = operationBodyMapper.exactMatches();
                    if (operationBodyMapperMap.containsKey(exactMatches)) {
                        mapperList = operationBodyMapperMap.get(exactMatches);
                        mapperList.add(operationBodyMapper);
                        continue;
                    }
                    mapperList = new ArrayList<UMLOperationBodyMapper>();
                    mapperList.add(operationBodyMapper);
                    operationBodyMapperMap.put(exactMatches, mapperList);
                }
                if (operationBodyMapperMap.isEmpty()) continue;
                List<UMLOperationBodyMapper> firstMappers = this.firstMappers(operationBodyMapperMap);
                firstMappers.sort(new UMLOperationBodyMapperComparator());
                removedOperationIterator.remove();
                boolean sameSourceAndTargetClass = this.sameSourceAndTargetClass(firstMappers);
                if (sameSourceAndTargetClass) {
                    TreeSet<Object> set = this.allRenamedOperations(firstMappers) ? new TreeSet() : new TreeSet<UMLOperationBodyMapper>(new UMLOperationBodyMapperComparator());
                    set.addAll(firstMappers);
                    UMLOperationBodyMapper bestMapper = (UMLOperationBodyMapper)set.first();
                    firstMappers.clear();
                    firstMappers.add(bestMapper);
                }
                Iterator iterator = firstMappers.iterator();
                while (iterator.hasNext()) {
                    UMLOperationBodyMapper firstMapper = (UMLOperationBodyMapper)iterator.next();
                    UMLOperation addedOperation = firstMapper.getOperation2();
                    if (sameSourceAndTargetClass) {
                        addedOperations.remove(addedOperation);
                    }
                    MoveOperationRefactoring refactoring = null;
                    if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(removedOperation.getClassName(), addedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation)) {
                        refactoring = new PullUpOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && this.isSubclassOf(addedOperation.getClassName(), removedOperation.getClassName()) && addedOperation.compatibleSignature(removedOperation)) {
                        refactoring = new PushDownOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && !addedOperation.getClassName().equals(removedOperation.getClassName()) && this.movedMethodSignature(removedOperation, addedOperation) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    } else if (removedOperation.isConstructor() == addedOperation.isConstructor() && !addedOperation.getClassName().equals(removedOperation.getClassName()) && this.movedAndRenamedMethodSignature(removedOperation, addedOperation, firstMapper) && !this.refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(removedOperation)) {
                        refactoring = new MoveOperationRefactoring(firstMapper);
                    }
                    if (refactoring == null) continue;
                    this.deleteRemovedOperation(removedOperation);
                    this.deleteAddedOperation(addedOperation);
                    UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, firstMapper.getMappings());
                    this.refactorings.addAll(operationSignatureDiff.getRefactorings());
                    this.refactorings.add(refactoring);
                }
            }
        }
    }

    private void checkForExtractedOperationsWithinMovedMethod(UMLOperationBodyMapper movedMethodMapper, UMLClass addedClass) throws RefactoringMinerTimedOutException {
        UMLOperation removedOperation = movedMethodMapper.getOperation1();
        UMLOperation addedOperation = movedMethodMapper.getOperation2();
        List<OperationInvocation> removedInvocations = removedOperation.getAllOperationInvocations();
        List<OperationInvocation> addedInvocations = addedOperation.getAllOperationInvocations();
        LinkedHashSet<OperationInvocation> intersection = new LinkedHashSet<OperationInvocation>(removedInvocations);
        intersection.retainAll(addedInvocations);
        LinkedHashSet<OperationInvocation> newInvocations = new LinkedHashSet<OperationInvocation>(addedInvocations);
        newInvocations.removeAll(intersection);
        for (OperationInvocation newInvocation : newInvocations) {
            for (UMLOperation operation : addedClass.getOperations()) {
                if (operation.isAbstract() || operation.hasEmptyBody() || !newInvocation.matchesOperation(operation, addedOperation.variableTypeMap(), this)) continue;
                ExtractOperationDetection detection = new ExtractOperationDetection(movedMethodMapper, addedClass.getOperations(), this.getUMLClassDiff(operation.getClassName()), this);
                List<ExtractOperationRefactoring> refs = detection.check(operation);
                this.refactorings.addAll(refs);
            }
        }
    }

    private boolean movedAndRenamedMethodSignature(UMLOperation removedOperation, UMLOperation addedOperation, UMLOperationBodyMapper mapper) {
        UMLClassBaseDiff removedOperationClassDiff = this.getUMLClassDiff(removedOperation.getClassName());
        if (removedOperationClassDiff != null && removedOperationClassDiff.containsOperationWithTheSameSignatureInNextClass(removedOperation)) {
            return false;
        }
        if (!(!removedOperation.isConstructor() && !addedOperation.isConstructor() || mapper.mappingsWithoutBlocks() <= 0 || UMLClassBaseDiff.allMappingsAreExactMatches(mapper) && mapper.nonMappedElementsT1() == 0 && mapper.nonMappedElementsT2() == 0)) {
            return false;
        }
        int exactLeafMappings = 0;
        for (AbstractCodeMapping mapping : mapper.getMappings()) {
            if (!(mapping instanceof LeafMapping) || !mapping.isExact() || mapping.getFragment1().getString().startsWith("return ")) continue;
            ++exactLeafMappings;
        }
        double normalizedEditDistance = mapper.normalizedEditDistance();
        if (exactLeafMappings == 0 && normalizedEditDistance > 0.24) {
            return false;
        }
        if (exactLeafMappings == 1 && normalizedEditDistance > 0.5 && (mapper.nonMappedElementsT1() > 0 || mapper.nonMappedElementsT2() > 0)) {
            return false;
        }
        if (mapper.mappingsWithoutBlocks() == 1) {
            for (AbstractCodeMapping mapping : mapper.getMappings()) {
                String fragment1 = mapping.getFragment1().getString();
                String fragment2 = mapping.getFragment2().getString();
                if (!fragment1.startsWith("return True") && !fragment1.startsWith("return False") && !fragment1.startsWith("return this") && !fragment1.startsWith("return null") && !fragment1.startsWith("return") && !fragment2.startsWith("return True") && !fragment2.startsWith("return False") && !fragment2.startsWith("return this") && !fragment2.startsWith("return null") && !fragment2.startsWith("return")) continue;
                return false;
            }
        }
        if (addedOperation.isAbstract() == removedOperation.isAbstract() && addedOperation.getTypeParameters().equals(removedOperation.getTypeParameters())) {
            List<UMLType> removedOperationParameterTypeList;
            List<UMLType> addedOperationParameterTypeList = addedOperation.getParameterTypeList();
            if (addedOperationParameterTypeList.equals(removedOperationParameterTypeList = removedOperation.getParameterTypeList()) && addedOperationParameterTypeList.size() > 0) {
                return true;
            }
            ArrayList<UMLParameter> oldParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> oldParameterNames = new LinkedHashSet<String>();
            for (UMLParameter oldParameter : removedOperation.getParameters()) {
                if (oldParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                oldParameters.add(oldParameter);
                oldParameterNames.add(oldParameter.getName());
            }
            ArrayList<UMLParameter> newParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> newParameterNames = new LinkedHashSet<String>();
            for (UMLParameter newParameter : addedOperation.getParameters()) {
                if (newParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                newParameters.add(newParameter);
                newParameterNames.add(newParameter.getName());
            }
            LinkedHashSet intersection = new LinkedHashSet(oldParameterNames);
            intersection.retainAll(newParameterNames);
            boolean parameterMatch = oldParameters.equals(newParameters) || oldParameters.containsAll(newParameters) || newParameters.containsAll(oldParameters) || intersection.size() > 0 || removedOperation.isStatic() || addedOperation.isStatic();
            return parameterMatch && oldParameters.size() > 0 && newParameters.size() > 0 || parameterMatch && addedOperation.equalReturnParameter(removedOperation) && (oldParameters.size() == 0 || newParameters.size() == 0);
        }
        return false;
    }

    private String isRenamedClass(UMLClass umlClass) {
        for (UMLClassRenameDiff renameDiff : this.classRenameDiffList) {
            if (!renameDiff.getOriginalClass().equals(umlClass)) continue;
            return renameDiff.getRenamedClass().getQualifiedName();
        }
        return null;
    }

    private String isMovedClass(UMLClass umlClass) {
        for (UMLClassMoveDiff moveDiff : this.classMoveDiffList) {
            if (!moveDiff.getOriginalClass().equals(umlClass)) continue;
            return moveDiff.getMovedClass().getQualifiedName();
        }
        return null;
    }

    public void checkForGeneralizationChanges() {
        Iterator<UMLGeneralization> removedGeneralizationIterator = this.removedGeneralizations.iterator();
        block0: while (removedGeneralizationIterator.hasNext()) {
            UMLGeneralization removedGeneralization = removedGeneralizationIterator.next();
            Iterator<UMLGeneralization> addedGeneralizationIterator = this.addedGeneralizations.iterator();
            while (addedGeneralizationIterator.hasNext()) {
                UMLGeneralizationDiff generalizationDiff;
                UMLGeneralization addedGeneralization = addedGeneralizationIterator.next();
                String renamedChild = this.isRenamedClass(removedGeneralization.getChild());
                String movedChild = this.isMovedClass(removedGeneralization.getChild());
                if (removedGeneralization.getChild().equals(addedGeneralization.getChild())) {
                    generalizationDiff = new UMLGeneralizationDiff(removedGeneralization, addedGeneralization);
                    addedGeneralizationIterator.remove();
                    removedGeneralizationIterator.remove();
                    this.generalizationDiffList.add(generalizationDiff);
                    continue block0;
                }
                if ((renamedChild == null || !renamedChild.equals(addedGeneralization.getChild().getQualifiedName())) && (movedChild == null || !movedChild.equals(addedGeneralization.getChild().getQualifiedName()))) continue;
                generalizationDiff = new UMLGeneralizationDiff(removedGeneralization, addedGeneralization);
                addedGeneralizationIterator.remove();
                removedGeneralizationIterator.remove();
                this.generalizationDiffList.add(generalizationDiff);
                continue block0;
            }
        }
    }

    private ExtractClassRefactoring atLeastOneCommonAttributeOrOperation(UMLClass umlClass, UMLClassBaseDiff classDiff, UMLAttribute attributeOfExtractedClassType) {
        int n;
        LinkedHashSet<UMLOperation> commonOperations = new LinkedHashSet<UMLOperation>();
        for (UMLOperation uMLOperation : classDiff.getRemovedOperations()) {
            if (uMLOperation.isConstructor() || uMLOperation.overridesObject() || !umlClass.containsOperationWithTheSameSignatureIgnoringChangedTypes(uMLOperation)) continue;
            commonOperations.add(uMLOperation);
        }
        LinkedHashSet<UMLAttribute> commonAttributes = new LinkedHashSet<UMLAttribute>();
        for (UMLAttribute attribute : classDiff.getRemovedAttributes()) {
            if (!umlClass.containsAttributeWithTheSameNameIgnoringChangedType(attribute)) continue;
            commonAttributes.add(attribute);
        }
        boolean bl = true;
        if (attributeOfExtractedClassType != null) {
            n = 0;
        }
        if (commonOperations.size() > n || commonAttributes.size() > n) {
            return new ExtractClassRefactoring(umlClass, classDiff, commonOperations, commonAttributes, attributeOfExtractedClassType);
        }
        return null;
    }

    private List<ExtractClassRefactoring> identifyExtractClassRefactorings(List<? extends UMLClassBaseDiff> classDiffs) throws RefactoringMinerTimedOutException {
        ArrayList<ExtractClassRefactoring> refactorings = new ArrayList<ExtractClassRefactoring>();
        for (UMLClass addedClass : this.addedClasses) {
            TreeSet<CandidateExtractClassRefactoring> candidates = new TreeSet<CandidateExtractClassRefactoring>();
            UMLType addedClassSuperType = addedClass.getSuperclass();
            if (!addedClass.isInterface()) {
                for (UMLClassBaseDiff uMLClassBaseDiff : classDiffs) {
                    ExtractClassRefactoring refactoring;
                    boolean isTestClass;
                    UMLType classDiffSuperType = uMLClassBaseDiff.getNewSuperclass();
                    boolean commonSuperType = addedClassSuperType != null && classDiffSuperType != null && addedClassSuperType.getClassType().equals(classDiffSuperType.getClassType());
                    boolean commonInterface = false;
                    for (UMLType addedClassInterface : addedClass.getImplementedInterfaces()) {
                        for (UMLType classDiffInterface : uMLClassBaseDiff.getNextClass().getImplementedInterfaces()) {
                            if (!addedClassInterface.getClassType().equals(classDiffInterface.getClassType())) continue;
                            commonInterface = true;
                            break;
                        }
                        if (!commonInterface) continue;
                        break;
                    }
                    boolean extendsAddedClass = uMLClassBaseDiff.getNewSuperclass() != null && addedClass.getQualifiedName().endsWith("." + uMLClassBaseDiff.getNewSuperclass().getClassType());
                    UMLAttribute attributeOfExtractedClassType = this.attributeOfExtractedClassType(addedClass, uMLClassBaseDiff);
                    boolean bl = isTestClass = addedClass.isTestClass() && uMLClassBaseDiff.getOriginalClass().isTestClass();
                    if ((commonSuperType || commonInterface || extendsAddedClass) && attributeOfExtractedClassType == null && !isTestClass || (refactoring = this.atLeastOneCommonAttributeOrOperation(addedClass, uMLClassBaseDiff, attributeOfExtractedClassType)) == null) continue;
                    CandidateExtractClassRefactoring candidate = new CandidateExtractClassRefactoring(uMLClassBaseDiff, refactoring);
                    candidates.add(candidate);
                }
            }
            if (candidates.isEmpty()) continue;
            CandidateExtractClassRefactoring firstCandidate = (CandidateExtractClassRefactoring)candidates.first();
            if (firstCandidate.innerClassExtract() || firstCandidate.subclassExtract()) {
                this.detectSubRefactorings(firstCandidate.getClassDiff(), firstCandidate.getRefactoring().getExtractedClass(), firstCandidate.getRefactoring().getRefactoringType());
                refactorings.add(firstCandidate.getRefactoring());
                continue;
            }
            for (CandidateExtractClassRefactoring candidate : candidates) {
                this.detectSubRefactorings(candidate.getClassDiff(), candidate.getRefactoring().getExtractedClass(), candidate.getRefactoring().getRefactoringType());
                refactorings.add(candidate.getRefactoring());
            }
        }
        return refactorings;
    }

    private UMLAttribute attributeOfExtractedClassType(UMLClass umlClass, UMLClassBaseDiff classDiff) {
        List<UMLAttribute> addedAttributes = classDiff.getAddedAttributes();
        for (UMLAttribute addedAttribute : addedAttributes) {
            if (!umlClass.getQualifiedName().endsWith("." + addedAttribute.getType().getClassType())) continue;
            return addedAttribute;
        }
        return null;
    }

    private void detectSubRefactorings(UMLClassBaseDiff classDiff, UMLClass addedClass, RefactoringType parentType) throws RefactoringMinerTimedOutException {
        Refactoring ref;
        for (UMLOperation addedOperation : addedClass.getOperations()) {
            UMLOperation removedOperation = classDiff.containsRemovedOperationWithTheSameSignature(addedOperation);
            if (removedOperation == null) continue;
            classDiff.getRemovedOperations().remove(removedOperation);
            ref = null;
            if (parentType.equals((Object)RefactoringType.EXTRACT_SUPERCLASS)) {
                ref = new PullUpOperationRefactoring(removedOperation, addedOperation);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_CLASS)) {
                ref = new MoveOperationRefactoring(removedOperation, addedOperation);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_SUBCLASS)) {
                ref = new PushDownOperationRefactoring(removedOperation, addedOperation);
            }
            this.refactorings.add(ref);
            UMLOperationBodyMapper mapper = new UMLOperationBodyMapper(removedOperation, addedOperation, classDiff);
            UMLOperationDiff operationSignatureDiff = new UMLOperationDiff(removedOperation, addedOperation, mapper.getMappings());
            this.refactorings.addAll(operationSignatureDiff.getRefactorings());
            this.checkForExtractedOperationsWithinMovedMethod(mapper, addedClass);
        }
        for (UMLAttribute addedAttribute : addedClass.getAttributes()) {
            UMLAttribute removedAttribute = classDiff.containsRemovedAttributeWithTheSameSignature(addedAttribute);
            if (removedAttribute == null) continue;
            classDiff.getRemovedAttributes().remove(removedAttribute);
            ref = null;
            if (parentType.equals((Object)RefactoringType.EXTRACT_SUPERCLASS)) {
                ref = new PullUpAttributeRefactoring(removedAttribute, addedAttribute);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_CLASS)) {
                ref = new MoveAttributeRefactoring(removedAttribute, addedAttribute);
            } else if (parentType.equals((Object)RefactoringType.EXTRACT_SUBCLASS)) {
                ref = new PushDownAttributeRefactoring(removedAttribute, addedAttribute);
            }
            this.refactorings.add(ref);
        }
    }

    public void reportAddedGeneralization(UMLGeneralization umlGeneralization) {
        this.addedGeneralizations.add(umlGeneralization);
    }

    public void reportRemovedGeneralization(UMLGeneralization umlGeneralization) {
        this.removedGeneralizations.add(umlGeneralization);
    }

    public void reportAddedRealization(UMLRealization umlRealization) {
        this.addedRealizations.add(umlRealization);
    }

    public void reportRemovedRealization(UMLRealization umlRealization) {
        this.removedRealizations.add(umlRealization);
    }

    private List<ExtractSuperClassRefactoring> identifyExtractSuperclassRefactorings() throws RefactoringMinerTimedOutException {
        ArrayList<ExtractSuperClassRefactoring> refactorings = new ArrayList<ExtractSuperClassRefactoring>();
        for (UMLClass addedClass : this.addedClasses) {
            LinkedHashSet<UMLClass> subclassSet = new LinkedHashSet<UMLClass>();
            String addedClassName = addedClass.getQualifiedName();
            for (UMLGeneralization addedGeneralization : this.addedGeneralizations) {
                this.processAddedGeneralization(addedClass, subclassSet, addedGeneralization);
            }
            for (UMLGeneralizationDiff generalizationDiff : this.generalizationDiffList) {
                UMLGeneralization addedGeneralization = generalizationDiff.getAddedGeneralization();
                UMLGeneralization removedGeneralization = generalizationDiff.getRemovedGeneralization();
                if (addedGeneralization.getParent().equals(removedGeneralization.getParent())) continue;
                this.processAddedGeneralization(addedClass, subclassSet, addedGeneralization);
            }
            for (UMLRealization addedRealization : this.addedRealizations) {
                String supplier = addedRealization.getSupplier();
                if (!UMLModelDiff.looksLikeSameType(supplier, addedClassName) || !this.topLevelOrSameOuterClass(addedClass, addedRealization.getClient()) || this.getAddedClass(addedRealization.getClient().getQualifiedName()) != null) continue;
                UMLClassBaseDiff clientClassDiff = this.getUMLClassDiff(addedRealization.getClient().getQualifiedName());
                int implementedInterfaceOperations = 0;
                boolean clientImplementsSupplier = false;
                if (clientClassDiff != null) {
                    for (UMLOperation interfaceOperation : addedClass.getOperations()) {
                        if (!clientClassDiff.containsOperationWithTheSameSignatureInOriginalClass(interfaceOperation)) continue;
                        ++implementedInterfaceOperations;
                    }
                    clientImplementsSupplier = clientClassDiff.getOriginalClass().getImplementedInterfaces().contains(UMLType.extractTypeObject(supplier));
                }
                if (implementedInterfaceOperations <= 0 && addedClass.getOperations().size() != 0 || clientImplementsSupplier) continue;
                subclassSet.add(addedRealization.getClient());
            }
            if (subclassSet.size() <= 0) continue;
            ExtractSuperClassRefactoring extractSuperclassRefactoring = new ExtractSuperClassRefactoring(addedClass, subclassSet);
            refactorings.add(extractSuperclassRefactoring);
        }
        return refactorings;
    }

    private void processAddedGeneralization(UMLClass addedClass, Set<UMLClass> subclassSet, UMLGeneralization addedGeneralization) throws RefactoringMinerTimedOutException {
        String parent = addedGeneralization.getParent();
        UMLClass subclass = addedGeneralization.getChild();
        if (UMLModelDiff.looksLikeSameType(parent, addedClass.getQualifiedName()) && this.topLevelOrSameOuterClass(addedClass, subclass) && this.getAddedClass(subclass.getQualifiedName()) == null) {
            UMLClassBaseDiff subclassDiff = this.getUMLClassDiff(subclass.getQualifiedName());
            if (subclassDiff != null) {
                this.detectSubRefactorings(subclassDiff, addedClass, RefactoringType.EXTRACT_SUPERCLASS);
            }
            subclassSet.add(subclass);
        }
    }

    private boolean topLevelOrSameOuterClass(UMLClass class1, UMLClass class2) {
        if (!class1.isTopLevel() && !class2.isTopLevel()) {
            return class1.getPackageName().equals(class2.getPackageName());
        }
        return true;
    }

    private boolean anotherAddedMethodExistsWithBetterMatchingInvocationExpression(OperationInvocation invocation, UMLOperation addedOperation, List<UMLOperation> addedOperations) {
        String expression = invocation.getExpression();
        if (expression != null) {
            int originalDistance = StringDistance.editDistance(expression, addedOperation.getNonQualifiedClassName());
            for (UMLOperation operation : addedOperations) {
                int newDistance;
                boolean isInterface;
                UMLClassBaseDiff classDiff = this.getUMLClassDiff(operation.getClassName());
                boolean bl = isInterface = classDiff != null && classDiff.nextClass.isInterface();
                if (operation.equals(addedOperation) || !addedOperation.equalSignature(operation) || operation.isAbstract() || isInterface || (newDistance = StringDistance.editDistance(expression, operation.getNonQualifiedClassName())) >= originalDistance) continue;
                return true;
            }
        }
        return false;
    }

    private boolean sourceClassImportsSuperclassOfTargetClass(String sourceClassName, String targetClassName) {
        UMLClassBaseDiff superclassOfTargetClassDiff;
        UMLClassBaseDiff targetClassDiff = this.getUMLClassDiff(targetClassName);
        if (targetClassDiff != null && targetClassDiff.getSuperclass() != null && (superclassOfTargetClassDiff = this.getUMLClassDiff(targetClassDiff.getSuperclass())) != null) {
            return this.sourceClassImportsTargetClass(sourceClassName, superclassOfTargetClassDiff.getNextClassName());
        }
        return false;
    }

    private boolean sourceClassImportsTargetClass(String sourceClassName, String targetClassName) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(sourceClassName);
        if (classDiff == null) {
            classDiff = this.getUMLClassDiff(UMLType.extractTypeObject(sourceClassName));
        }
        if (classDiff != null) {
            return classDiff.nextClassImportsType(targetClassName) || classDiff.originalClassImportsType(targetClassName);
        }
        UMLClass removedClass = this.getRemovedClass(sourceClassName);
        if (removedClass == null) {
            removedClass = this.looksLikeRemovedClass(UMLType.extractTypeObject(sourceClassName));
        }
        if (removedClass != null) {
            return removedClass.importsType(targetClassName);
        }
        return false;
    }

    private boolean targetClassImportsSourceClass(String sourceClassName, String targetClassName) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(targetClassName);
        if (classDiff == null) {
            classDiff = this.getUMLClassDiff(UMLType.extractTypeObject(targetClassName));
        }
        if (classDiff != null) {
            return classDiff.originalClassImportsType(sourceClassName) || classDiff.nextClassImportsType(sourceClassName);
        }
        UMLClass addedClass = this.getAddedClass(targetClassName);
        if (addedClass == null) {
            addedClass = this.looksLikeAddedClass(UMLType.extractTypeObject(targetClassName));
        }
        if (addedClass != null) {
            return addedClass.importsType(sourceClassName);
        }
        return false;
    }

    private boolean conflictingExpression(OperationInvocation invocation, UMLOperation addedOperation, Map<String, UMLType> variableTypeMap) {
        String expression = invocation.getExpression();
        if (expression != null && variableTypeMap.containsKey(expression)) {
            UMLType type = variableTypeMap.get(expression);
            UMLClassBaseDiff classDiff = this.getUMLClassDiff(addedOperation.getClassName());
            boolean superclassRelationship = classDiff != null && classDiff.getNewSuperclass() != null && classDiff.getNewSuperclass().equals(type);
            return !addedOperation.getNonQualifiedClassName().equals(type.getClassType()) && !superclassRelationship;
        }
        return false;
    }

    private boolean extractAndMoveMatchCondition(UMLOperationBodyMapper operationBodyMapper, UMLOperationBodyMapper parentMapper) {
        ArrayList<AbstractCodeMapping> mappingList = new ArrayList<AbstractCodeMapping>(operationBodyMapper.getMappings());
        if (operationBodyMapper.getOperation2().isGetter() && mappingList.size() == 1) {
            ArrayList<AbstractCodeMapping> parentMappingList = new ArrayList<AbstractCodeMapping>(parentMapper.getMappings());
            for (AbstractCodeMapping mapping : parentMappingList) {
                if (mapping.getFragment1().equals(((AbstractCodeMapping)mappingList.get(0)).getFragment1())) {
                    return false;
                }
                if (!(mapping instanceof CompositeStatementObjectMapping)) continue;
                CompositeStatementObjectMapping compositeMapping = (CompositeStatementObjectMapping)mapping;
                CompositeStatementObject fragment1 = (CompositeStatementObject)compositeMapping.getFragment1();
                for (AbstractExpression expression : fragment1.getExpressions()) {
                    if (!expression.equals(((AbstractCodeMapping)mappingList.get(0)).getFragment1())) continue;
                    return false;
                }
            }
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        List<AbstractCodeMapping> exactMatchList = operationBodyMapper.getExactMatches();
        int exactMatches = exactMatchList.size();
        return mappings > 0 && (mappings > nonMappedElementsT2 || mappings > 1 && mappings >= nonMappedElementsT2 || exactMatches == mappings && nonMappedElementsT1 == 0 || exactMatches == 1 && !exactMatchList.get(0).getFragment1().throwsNewException() && nonMappedElementsT2 - exactMatches <= 10 || exactMatches > 1 && nonMappedElementsT2 - exactMatches < 20 || mappings == 1 && mappings > operationBodyMapper.nonMappedLeafElementsT2());
    }

    private boolean movedMethodSignature(UMLOperation removedOperation, UMLOperation addedOperation) {
        if (addedOperation.getName().equals(removedOperation.getName()) && addedOperation.equalReturnParameter(removedOperation) && addedOperation.isAbstract() == removedOperation.isAbstract() && addedOperation.getTypeParameters().equals(removedOperation.getTypeParameters())) {
            if (addedOperation.getParameters().equals(removedOperation.getParameters())) {
                return true;
            }
            ArrayList<UMLParameter> oldParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> oldParameterNames = new LinkedHashSet<String>();
            for (UMLParameter oldParameter : removedOperation.getParameters()) {
                if (oldParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(oldParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                oldParameters.add(oldParameter);
                oldParameterNames.add(oldParameter.getName());
            }
            ArrayList<UMLParameter> newParameters = new ArrayList<UMLParameter>();
            LinkedHashSet<String> newParameterNames = new LinkedHashSet<String>();
            for (UMLParameter newParameter : addedOperation.getParameters()) {
                if (newParameter.getKind().equals("return") || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), addedOperation.getClassName()) || UMLModelDiff.looksLikeSameType(newParameter.getType().getClassType(), removedOperation.getClassName())) continue;
                newParameters.add(newParameter);
                newParameterNames.add(newParameter.getName());
            }
            LinkedHashSet intersection = new LinkedHashSet(oldParameterNames);
            intersection.retainAll(newParameterNames);
            return oldParameters.equals(newParameters) || oldParameters.containsAll(newParameters) || newParameters.containsAll(oldParameters) || intersection.size() > 0 || removedOperation.isStatic() || addedOperation.isStatic();
        }
        return false;
    }

    private boolean allRenamedOperations(List<UMLOperationBodyMapper> mappers) {
        for (UMLOperationBodyMapper mapper : mappers) {
            if (!mapper.getOperation1().getName().equals(mapper.getOperation2().getName())) continue;
            return false;
        }
        return true;
    }

    private boolean refactoringListContainsAnotherMoveRefactoringWithTheSameOperations(UMLOperation removedOperation) {
        for (Refactoring refactoring : this.refactorings) {
            MoveOperationRefactoring moveRefactoring;
            if (!(refactoring instanceof MoveOperationRefactoring) || !(moveRefactoring = (MoveOperationRefactoring)refactoring).getOriginalOperation().equals(removedOperation)) continue;
            return true;
        }
        return false;
    }

    private boolean sameSourceAndTargetClass(List<UMLOperationBodyMapper> mappers) {
        if (mappers.size() == 1) {
            return false;
        }
        String sourceClassName = null;
        String targetClassName = null;
        for (UMLOperationBodyMapper mapper : mappers) {
            String mapperSourceClassName = mapper.getOperation1().getClassName();
            if (sourceClassName == null) {
                sourceClassName = mapperSourceClassName;
            } else if (!mapperSourceClassName.equals(sourceClassName)) {
                return false;
            }
            String mapperTargetClassName = mapper.getOperation2().getClassName();
            if (targetClassName == null) {
                targetClassName = mapperTargetClassName;
                continue;
            }
            if (mapperTargetClassName.equals(targetClassName)) continue;
            return false;
        }
        return true;
    }

    private List<UMLOperationBodyMapper> firstMappers(TreeMap<Integer, List<UMLOperationBodyMapper>> operationBodyMapperMap) {
        ArrayList<UMLOperationBodyMapper> firstMappers = new ArrayList<UMLOperationBodyMapper>((Collection)operationBodyMapperMap.get(operationBodyMapperMap.lastKey()));
        List<UMLOperationBodyMapper> extraMappers = operationBodyMapperMap.get(0);
        if (extraMappers != null && operationBodyMapperMap.lastKey() != 0) {
            block0: for (UMLOperationBodyMapper extraMapper : extraMappers) {
                Set<Replacement> replacements;
                ArrayList<AbstractCodeMapping> mappings;
                UMLOperation operation2;
                UMLOperation operation1 = extraMapper.getOperation1();
                if (!operation1.equalSignature(operation2 = extraMapper.getOperation2()) || (mappings = new ArrayList<AbstractCodeMapping>(extraMapper.getMappings())).size() != 1 || (replacements = ((AbstractCodeMapping)mappings.get(0)).getReplacements()).size() != 1) continue;
                Replacement replacement = replacements.iterator().next();
                List<String> parameterNames1 = operation1.getParameterNameList();
                List<String> parameterNames2 = operation2.getParameterNameList();
                for (int i = 0; i < parameterNames1.size(); ++i) {
                    String parameterName1 = parameterNames1.get(i);
                    String parameterName2 = parameterNames2.get(i);
                    if (!replacement.getBefore().equals(parameterName1) || !replacement.getAfter().equals(parameterName2)) continue;
                    firstMappers.add(extraMapper);
                    continue block0;
                }
            }
        }
        return firstMappers;
    }

    private boolean mappedElementsMoreThanNonMappedT1AndT2(int mappings, UMLOperationBodyMapper operationBodyMapper) {
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1();
        int nonMappedElementsT2 = operationBodyMapper.nonMappedElementsT2();
        UMLClass addedClass = this.getAddedClass(operationBodyMapper.getOperation2().getClassName());
        int nonMappedStatementsDeclaringSameVariable = 0;
        ListIterator<StatementObject> leafIterator1 = operationBodyMapper.getNonMappedLeavesT1().listIterator();
        block0: while (leafIterator1.hasNext()) {
            StatementObject s1 = leafIterator1.next();
            for (StatementObject s2 : operationBodyMapper.getNonMappedLeavesT2()) {
                if (s1.getVariableDeclarations().size() != 1 || s2.getVariableDeclarations().size() != 1) continue;
                VariableDeclaration v1 = s1.getVariableDeclarations().get(0);
                VariableDeclaration v2 = s2.getVariableDeclarations().get(0);
                if (!v1.getVariableName().equals(v2.getVariableName()) || !v1.getType().equals(v2.getType())) continue;
                ++nonMappedStatementsDeclaringSameVariable;
            }
            if (addedClass == null || s1.getVariableDeclarations().size() != 1) continue;
            VariableDeclaration v1 = s1.getVariableDeclarations().get(0);
            for (UMLAttribute attribute : addedClass.getAttributes()) {
                String variableInitializer;
                String attributeInitializer;
                VariableDeclaration attributeDeclaration = attribute.getVariableDeclaration();
                if (attributeDeclaration.getInitializer() == null || v1.getInitializer() == null || !(attributeInitializer = attributeDeclaration.getInitializer().getString()).equals(variableInitializer = v1.getInitializer().getString()) || !attribute.getType().equals(v1.getType()) || !attribute.getName().equals(v1.getVariableName()) && !attribute.getName().toLowerCase().contains(v1.getVariableName().toLowerCase()) && !v1.getVariableName().toLowerCase().contains(attribute.getName().toLowerCase())) continue;
                ++nonMappedStatementsDeclaringSameVariable;
                leafIterator1.remove();
                LeafMapping mapping = new LeafMapping(v1.getInitializer(), attributeDeclaration.getInitializer(), operationBodyMapper.getOperation1(), operationBodyMapper.getOperation2());
                operationBodyMapper.getMappings().add(mapping);
                continue block0;
            }
        }
        int nonMappedLoopsIteratingOverSameVariable = 0;
        for (CompositeStatementObject c1 : operationBodyMapper.getNonMappedInnerNodesT1()) {
            if (!c1.isLoop()) continue;
            for (CompositeStatementObject c2 : operationBodyMapper.getNonMappedInnerNodesT2()) {
                if (!c2.isLoop()) continue;
                LinkedHashSet<String> intersection = new LinkedHashSet<String>(c1.getVariables());
                intersection.retainAll(c2.getVariables());
                if (intersection.isEmpty()) continue;
                ++nonMappedLoopsIteratingOverSameVariable;
            }
        }
        return mappings > nonMappedElementsT1 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable && mappings > nonMappedElementsT2 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable || nonMappedElementsT1 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable == 0 && (double)mappings > Math.floor((double)nonMappedElementsT2 / 2.0) || nonMappedElementsT2 - nonMappedStatementsDeclaringSameVariable - nonMappedLoopsIteratingOverSameVariable == 0 && (double)mappings > Math.floor((double)nonMappedElementsT1 / 2.0);
    }

    private boolean conflictingMoveOfTopLevelClass(UMLClass removedClass, UMLClass addedClass) {
        if (!removedClass.isTopLevel() && !addedClass.isTopLevel()) {
            for (UMLClassMoveDiff diff : this.classMoveDiffList) {
                if ((!diff.getOriginalClass().getQualifiedName().startsWith(removedClass.getPackageName()) || diff.getMovedClass().getQualifiedName().startsWith(addedClass.getPackageName())) && (diff.getOriginalClass().getQualifiedName().startsWith(removedClass.getPackageName()) || !diff.getMovedClass().getQualifiedName().startsWith(addedClass.getPackageName()))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isSourcePackageDeleted(RenamePackageRefactoring renamePackageRefactoring) {
        for (String deletedFolderPath : this.deletedFolderPaths) {
            String originalPath;
            String trimmedOriginalPath;
            String convertedPackageToFilePath;
            if (!deletedFolderPath.endsWith(convertedPackageToFilePath = (trimmedOriginalPath = (originalPath = renamePackageRefactoring.getPattern().getBefore()).endsWith(".") ? originalPath.substring(0, originalPath.length() - 1) : originalPath).replaceAll("\\.", "/"))) continue;
            return true;
        }
        return false;
    }

    private void deleteRemovedOperation(UMLOperation operation) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(operation.getClassName());
        if (classDiff != null) {
            classDiff.getRemovedOperations().remove(operation);
        }
    }

    private void deleteAddedOperation(UMLOperation operation) {
        UMLClassBaseDiff classDiff = this.getUMLClassDiff(operation.getClassName());
        if (classDiff != null) {
            classDiff.getAddedOperations().remove(operation);
        }
    }

    private boolean innerClassWithTheSameName(UMLClass removedClass, UMLClass addedClass) {
        if (!removedClass.isTopLevel() && !addedClass.isTopLevel()) {
            String removedClassName = removedClass.getQualifiedName();
            String removedName = removedClassName.substring(removedClassName.lastIndexOf(".") + 1);
            String addedClassName = addedClass.getQualifiedName();
            String addedName = addedClassName.substring(addedClassName.lastIndexOf(".") + 1);
            return removedName.equals(addedName);
        }
        return false;
    }

    public void addUMLClassDiff(UMLClassDiff classDiff) {
        this.commonClassDiffList.add(classDiff);
    }

    public void addUmlFileDiff(UMLFileDiff fileDiff) {
        this.umlFileDiff.add(fileDiff);
    }

    private static boolean isNumeric(String str) {
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }
}

