/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.Set;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class CandidateAttributeRefactoring {
    private final String originalVariableName;
    private final String renamedVariableName;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;
    private final Set<AbstractCodeMapping> attributeReferences;
    private VariableDeclaration originalVariableDeclaration;
    private VariableDeclaration renamedVariableDeclaration;
    private UMLAttribute originalAttribute;
    private UMLAttribute renamedAttribute;

    public CandidateAttributeRefactoring(String originalVariableName, String renamedVariableName, UMLOperation operationBefore, UMLOperation operationAfter, Set<AbstractCodeMapping> attributeReferences) {
        this.originalVariableName = originalVariableName;
        this.renamedVariableName = renamedVariableName;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.attributeReferences = attributeReferences;
    }

    public String getOriginalVariableName() {
        return this.originalVariableName;
    }

    public String getRenamedVariableName() {
        return this.renamedVariableName;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    public Set<AbstractCodeMapping> getAttributeReferences() {
        return this.attributeReferences;
    }

    public int getOccurrences() {
        return this.attributeReferences.size();
    }

    public VariableDeclaration getOriginalVariableDeclaration() {
        return this.originalVariableDeclaration;
    }

    public void setOriginalVariableDeclaration(VariableDeclaration originalVariableDeclaration) {
        this.originalVariableDeclaration = originalVariableDeclaration;
    }

    public VariableDeclaration getRenamedVariableDeclaration() {
        return this.renamedVariableDeclaration;
    }

    public void setRenamedVariableDeclaration(VariableDeclaration renamedVariableDeclaration) {
        this.renamedVariableDeclaration = renamedVariableDeclaration;
    }

    public UMLAttribute getOriginalAttribute() {
        return this.originalAttribute;
    }

    public void setOriginalAttribute(UMLAttribute originalAttribute) {
        this.originalAttribute = originalAttribute;
    }

    public UMLAttribute getRenamedAttribute() {
        return this.renamedAttribute;
    }

    public void setRenamedAttribute(UMLAttribute renamedAttribute) {
        this.renamedAttribute = renamedAttribute;
    }

    public String toString() {
        return "Rename Attribute\t" + this.originalVariableName + " to " + this.renamedVariableName + " in method " + this.operationAfter + " in class " + this.operationAfter.getClassName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalVariableName == null ? 0 : this.originalVariableName.hashCode());
        result = 31 * result + (this.renamedVariableName == null ? 0 : this.renamedVariableName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CandidateAttributeRefactoring other = (CandidateAttributeRefactoring)obj;
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.originalVariableName == null ? other.originalVariableName != null : !this.originalVariableName.equals(other.originalVariableName)) {
            return false;
        }
        if (this.renamedVariableName == null) {
            return other.renamedVariableName == null;
        }
        return this.renamedVariableName.equals(other.renamedVariableName);
    }
}

