/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class ChangeVariableTypeRefactoring
implements Refactoring {
    private final VariableDeclaration originalVariable;
    private final VariableDeclaration changedTypeVariable;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;
    private final Set<AbstractCodeMapping> variableReferences;
    private final Set<Refactoring> relatedRefactorings;

    public ChangeVariableTypeRefactoring(VariableDeclaration originalVariable, VariableDeclaration changedTypeVariable, UMLOperation operationBefore, UMLOperation operationAfter, Set<AbstractCodeMapping> variableReferences) {
        this.originalVariable = originalVariable;
        this.changedTypeVariable = changedTypeVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
        this.relatedRefactorings = new LinkedHashSet<Refactoring>();
    }

    public void addRelatedRefactoring(Refactoring refactoring) {
        this.relatedRefactorings.add(refactoring);
    }

    public Set<Refactoring> getRelatedRefactorings() {
        return this.relatedRefactorings;
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.originalVariable.isParameter() && this.changedTypeVariable.isParameter()) {
            return RefactoringType.CHANGE_PARAMETER_TYPE;
        }
        return RefactoringType.CHANGE_VARIABLE_TYPE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public VariableDeclaration getOriginalVariable() {
        return this.originalVariable;
    }

    public VariableDeclaration getChangedTypeVariable() {
        return this.changedTypeVariable;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    public Set<AbstractCodeMapping> getVariableReferences() {
        return this.variableReferences;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean qualified = this.originalVariable.getType().equals(this.changedTypeVariable.getType()) && !this.originalVariable.getType().equalsQualified(this.changedTypeVariable.getType());
        sb.append(this.getName()).append(" ");
        sb.append(qualified ? this.originalVariable.toQualifiedString() : this.originalVariable.toString());
        sb.append(" to ");
        sb.append(qualified ? this.changedTypeVariable.toQualifiedString() : this.changedTypeVariable.toString());
        sb.append(" in method ");
        sb.append(qualified ? this.operationAfter.toQualifiedString() : this.operationAfter.toString());
        sb.append(" in class ").append(this.operationAfter.getClassName());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.changedTypeVariable == null ? 0 : this.changedTypeVariable.hashCode());
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalVariable == null ? 0 : this.originalVariable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeVariableTypeRefactoring other = (ChangeVariableTypeRefactoring)obj;
        if (this.changedTypeVariable == null ? other.changedTypeVariable != null : !this.changedTypeVariable.equals(other.changedTypeVariable)) {
            return false;
        }
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.originalVariable == null) {
            return other.originalVariable == null;
        }
        return this.originalVariable.equals(other.originalVariable);
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalVariable.codeRange().setDescription("original variable declaration").setCodeElement(this.originalVariable.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.changedTypeVariable.codeRange().setDescription("changed-type variable declaration").setCodeElement(this.changedTypeVariable.toString()));
        return ranges;
    }
}

