/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class InlineVariableRefactoring
implements Refactoring {
    private final VariableDeclaration variableDeclaration;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;
    private final Set<AbstractCodeMapping> references;

    public InlineVariableRefactoring(VariableDeclaration variableDeclaration, UMLOperation operationBefore, UMLOperation operationAfter) {
        this.variableDeclaration = variableDeclaration;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.references = new LinkedHashSet<AbstractCodeMapping>();
    }

    public void addReference(AbstractCodeMapping mapping) {
        this.references.add(mapping);
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.INLINE_VARIABLE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public VariableDeclaration getVariableDeclaration() {
        return this.variableDeclaration;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    public Set<AbstractCodeMapping> getReferences() {
        return this.references;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.variableDeclaration + " in method " + this.operationBefore + " from class " + this.operationBefore.getClassName();
    }

    public CodeRange getInlinedVariableDeclarationCodeRange() {
        return this.variableDeclaration.codeRange();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.variableDeclaration == null ? 0 : this.variableDeclaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InlineVariableRefactoring other = (InlineVariableRefactoring)obj;
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.variableDeclaration == null) {
            return other.variableDeclaration == null;
        }
        return this.variableDeclaration.equals(other.variableDeclaration);
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.variableDeclaration.codeRange().setDescription("inlined variable declaration").setCodeElement(this.variableDeclaration.toString()));
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment1().codeRange().setDescription("statement with the name of the inlined variable"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment2().codeRange().setDescription("statement with the initializer of the inlined variable"));
        }
        return ranges;
    }
}

