/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class RenameVariableRefactoring
implements Refactoring {
    private final VariableDeclaration originalVariable;
    private final VariableDeclaration renamedVariable;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;
    private final Set<AbstractCodeMapping> variableReferences;

    public RenameVariableRefactoring(VariableDeclaration originalVariable, VariableDeclaration renamedVariable, UMLOperation operationBefore, UMLOperation operationAfter, Set<AbstractCodeMapping> variableReferences) {
        this.originalVariable = originalVariable;
        this.renamedVariable = renamedVariable;
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.variableReferences = variableReferences;
    }

    @Override
    public RefactoringType getRefactoringType() {
        if (this.originalVariable.isParameter() && this.renamedVariable.isParameter()) {
            return RefactoringType.RENAME_PARAMETER;
        }
        if (!this.originalVariable.isParameter() && this.renamedVariable.isParameter()) {
            return RefactoringType.PARAMETERIZE_VARIABLE;
        }
        if (!this.originalVariable.isAttribute() && this.renamedVariable.isAttribute()) {
            return RefactoringType.REPLACE_VARIABLE_WITH_ATTRIBUTE;
        }
        return RefactoringType.RENAME_VARIABLE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public VariableDeclaration getOriginalVariable() {
        return this.originalVariable;
    }

    public VariableDeclaration getRenamedVariable() {
        return this.renamedVariable;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    public Set<AbstractCodeMapping> getVariableReferences() {
        return this.variableReferences;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.originalVariable + " to " + this.renamedVariable + " in method " + this.operationAfter + " in class " + this.operationAfter.getClassName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.originalVariable == null ? 0 : this.originalVariable.hashCode());
        result = 31 * result + (this.renamedVariable == null ? 0 : this.renamedVariable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RenameVariableRefactoring other = (RenameVariableRefactoring)obj;
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.originalVariable == null ? other.originalVariable != null : !this.originalVariable.equals(other.originalVariable)) {
            return false;
        }
        if (this.renamedVariable == null) {
            return other.renamedVariable == null;
        }
        return this.renamedVariable.equals(other.renamedVariable);
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.originalVariable.codeRange().setDescription("original variable declaration").setCodeElement(this.originalVariable.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.renamedVariable.codeRange().setDescription("renamed variable declaration").setCodeElement(this.renamedVariable.toString()));
        return ranges;
    }
}

