/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.io.Serializable;
import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclarationProvider;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLJavadoc;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class UMLAttribute
implements Comparable<UMLAttribute>,
Serializable,
LocationInfoProvider,
VariableDeclarationProvider {
    private final LocationInfo locationInfo;
    private final String name;
    private UMLType type;
    private String visibility;
    private String className;
    private boolean isFinal;
    private boolean isStatic;
    private VariableDeclaration variableDeclaration;
    private UMLJavadoc javadoc;

    public UMLAttribute(String name, UMLType type, LocationInfo locationInfo) {
        this.locationInfo = locationInfo;
        this.name = name;
        this.type = type;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public UMLType getType() {
        return this.type;
    }

    public void setType(UMLType type) {
        this.type = type;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public void setStatic(boolean isStatic) {
        this.isStatic = isStatic;
    }

    public String getNonQualifiedClassName() {
        return this.className.contains(".") ? this.className.substring(this.className.lastIndexOf(".") + 1) : this.className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public VariableDeclaration getVariableDeclaration() {
        return this.variableDeclaration;
    }

    public void setVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.variableDeclaration = variableDeclaration;
    }

    public UMLJavadoc getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(UMLJavadoc javadoc) {
        this.javadoc = javadoc;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.variableDeclaration.getAnnotations();
    }

    public boolean equalsIgnoringChangedType(UMLAttribute attribute) {
        if (this.isStatic != attribute.isStatic) {
            return false;
        }
        if (this.isFinal != attribute.isFinal) {
            return false;
        }
        if (this.name.equals(attribute.name) && this.type.equals(attribute.type) && this.type.equalsQualified(attribute.type)) {
            return true;
        }
        if (!this.type.equals(attribute.type)) {
            return this.name.equals(attribute.name);
        }
        return false;
    }

    public boolean equalsIgnoringChangedVisibility(UMLAttribute attribute) {
        return this.name.equals(attribute.name) && this.type.equals(attribute.type);
    }

    @Override
    public CodeRange codeRange() {
        LocationInfo info = this.getLocationInfo();
        return info.codeRange();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UMLAttribute) {
            UMLAttribute umlAttribute = (UMLAttribute)o;
            return this.name.equals(umlAttribute.name) && this.visibility.equals(umlAttribute.visibility) && this.type.equals(umlAttribute.type);
        }
        return false;
    }

    public boolean equalsQualified(UMLAttribute umlAttribute) {
        return this.name.equals(umlAttribute.name) && this.visibility.equals(umlAttribute.visibility) && this.type.equalsQualified(umlAttribute.type);
    }

    public String toString() {
        return this.visibility + " " + this.name + " : " + this.type;
    }

    public String toQualifiedString() {
        return this.visibility + " " + this.name + " : " + this.type.toQualifiedString();
    }

    @Override
    public int compareTo(UMLAttribute attribute) {
        return this.toString().compareTo(attribute.toString());
    }
}

