/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAbstractClass;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLJavadoc;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLTypeParameter;

public class UMLClass
extends UMLAbstractClass
implements Comparable<UMLClass>,
Serializable,
LocationInfoProvider {
    private final String qualifiedName;
    private final String sourceFile;
    private final List<UMLType> implementedInterfaces;
    private final List<String> importedTypes;
    private final List<UMLTypeParameter> typeParameters;
    private final List<UMLAnnotation> annotations;
    private String sourceFolder;
    private String visibility;
    private boolean isSealed;
    private boolean isData;
    private boolean isInner;
    private boolean isObject;
    private boolean isAbstract;
    private boolean isInterface;
    private boolean isEnum;
    private boolean topLevel;
    private UMLType superclass;
    private UMLJavadoc javadoc;

    public UMLClass(String packageName, String name, LocationInfo locationInfo, boolean topLevel, List<String> importedTypes) {
        this.locationInfo = locationInfo;
        this.packageName = packageName;
        this.name = name;
        this.qualifiedName = packageName.equals("") ? name : packageName + "." + name;
        this.sourceFile = this.getSourceFile();
        this.sourceFolder = "";
        if (packageName.equals("")) {
            int index = this.sourceFile.indexOf(name);
            if (index != -1) {
                this.sourceFolder = this.sourceFile.substring(0, index);
            }
        } else if (topLevel) {
            int index = this.sourceFile.indexOf(packageName.replace('.', '/'));
            if (index != -1) {
                this.sourceFolder = this.sourceFile.substring(0, index);
            }
        } else {
            int index = -1;
            if (packageName.contains(".")) {
                String realPackageName = packageName.substring(0, packageName.lastIndexOf(46));
                index = this.sourceFile.indexOf(realPackageName.replace('.', '/'));
            } else {
                index = this.sourceFile.indexOf(packageName);
            }
            if (index != -1) {
                this.sourceFolder = this.sourceFile.substring(0, index);
            }
        }
        this.isData = false;
        this.isSealed = false;
        this.isInner = false;
        this.isAbstract = false;
        this.isInterface = false;
        this.topLevel = topLevel;
        this.superclass = null;
        this.implementedInterfaces = new ArrayList<UMLType>();
        this.importedTypes = importedTypes;
        this.typeParameters = new ArrayList<UMLTypeParameter>();
        this.annotations = new ArrayList<UMLAnnotation>();
    }

    public List<UMLTypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public List<String> getTypeParameterNames() {
        ArrayList<String> typeParameterNames = new ArrayList<String>();
        for (UMLTypeParameter typeParameter : this.typeParameters) {
            typeParameterNames.add(typeParameter.getName());
        }
        return typeParameterNames;
    }

    public void addTypeParameter(UMLTypeParameter typeParameter) {
        this.typeParameters.add(typeParameter);
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(UMLAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInnerClass(UMLClass innerClass) {
        return this.getQualifiedName().equals(innerClass.packageName);
    }

    public boolean isTopLevel() {
        return this.topLevel;
    }

    public void setTopLevel(boolean topLevel) {
        this.topLevel = topLevel;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    public void setEnum(boolean isEnum) {
        this.isEnum = isEnum;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    public void setInterface(boolean isInterface) {
        this.isInterface = isInterface;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public UMLType getSuperclass() {
        return this.superclass;
    }

    public void setSuperclass(UMLType superclass) {
        this.superclass = superclass;
    }

    public void addImplementedInterface(UMLType implementedInterface) {
        this.implementedInterfaces.add(implementedInterface);
    }

    public List<UMLType> getImplementedInterfaces() {
        return this.implementedInterfaces;
    }

    public List<String> getImportedTypes() {
        return this.importedTypes;
    }

    public UMLJavadoc getJavadoc() {
        return this.javadoc;
    }

    public void setJavadoc(UMLJavadoc javadoc) {
        this.javadoc = javadoc;
    }

    public UMLAttribute containsAttribute(UMLAttribute otherAttribute) {
        for (UMLAttribute attribute : this.attributes) {
            if (!attribute.equals(otherAttribute)) continue;
            return attribute;
        }
        return null;
    }

    public UMLAttribute matchAttribute(UMLAttribute otherAttribute) {
        for (UMLAttribute attribute : this.attributes) {
            String otherAttributeTypeComparedString;
            if (!attribute.getName().equals(otherAttribute.getName())) continue;
            String thisAttributeType = attribute.getType().getClassType();
            String otherAttributeType = otherAttribute.getType().getClassType();
            int thisArrayDimension = attribute.getType().getArrayDimension();
            int otherArrayDimension = otherAttribute.getType().getArrayDimension();
            String thisAttributeTypeComparedString = thisAttributeType.contains(".") ? thisAttributeType.substring(thisAttributeType.lastIndexOf(".") + 1) : thisAttributeType;
            if (!thisAttributeTypeComparedString.equals(otherAttributeTypeComparedString = otherAttributeType.contains(".") ? otherAttributeType.substring(otherAttributeType.lastIndexOf(".") + 1) : otherAttributeType) || thisArrayDimension != otherArrayDimension) continue;
            return attribute;
        }
        return null;
    }

    public UMLOperation matchOperation(UMLOperation otherOperation) {
        for (UMLOperation operation : this.operations) {
            if (!operation.getName().equals(otherOperation.getName()) || operation.getParameters().size() != otherOperation.getParameters().size()) continue;
            boolean match = true;
            int i = 0;
            for (UMLParameter parameter : operation.getParameters()) {
                String otherParameterTypeComparedString;
                UMLParameter otherParameter = otherOperation.getParameters().get(i);
                String thisParameterType = parameter.getType().getClassType();
                String otherParameterType = otherParameter.getType().getClassType();
                int thisArrayDimension = parameter.getType().getArrayDimension();
                int otherArrayDimension = otherParameter.getType().getArrayDimension();
                String thisParameterTypeComparedString = thisParameterType.contains(".") ? thisParameterType.substring(thisParameterType.lastIndexOf(".") + 1) : thisParameterType;
                if (!thisParameterTypeComparedString.equals(otherParameterTypeComparedString = otherParameterType.contains(".") ? otherParameterType.substring(otherParameterType.lastIndexOf(".") + 1) : otherParameterType) || thisArrayDimension != otherArrayDimension) {
                    match = false;
                    break;
                }
                ++i;
            }
            if (!match) continue;
            return operation;
        }
        return null;
    }

    public boolean hasSameNameAndKind(UMLClass umlClass) {
        if (!this.name.equals(umlClass.name)) {
            return false;
        }
        return this.hasSameKind(umlClass);
    }

    public boolean hasSameKind(UMLClass umlClass) {
        if (this.isAbstract != umlClass.isAbstract) {
            return false;
        }
        if (this.isInterface != umlClass.isInterface) {
            return false;
        }
        return this.equalTypeParameters(umlClass);
    }

    private boolean equalTypeParameters(UMLClass umlClass) {
        return this.typeParameters.equals(umlClass.typeParameters) || this.getTypeParameterNames().equals(umlClass.getTypeParameterNames());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UMLClass) {
            UMLClass umlClass = (UMLClass)o;
            return this.packageName.equals(umlClass.packageName) && this.name.equals(umlClass.name) && this.sourceFile.equals(umlClass.sourceFile);
        }
        return false;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    @Override
    public int compareTo(UMLClass umlClass) {
        return this.toString().compareTo(umlClass.toString());
    }

    public boolean isSubTypeOf(UMLClass umlClass) {
        if (this.superclass != null && umlClass.getQualifiedName().endsWith("." + this.superclass.getClassType())) {
            return true;
        }
        for (UMLType implementedInterface : this.implementedInterfaces) {
            if (!umlClass.getQualifiedName().endsWith("." + implementedInterface.getClassType())) continue;
            return true;
        }
        return false;
    }

    public boolean importsType(String targetClass) {
        if (targetClass.startsWith(this.getPackageName())) {
            return true;
        }
        for (String importedType : this.getImportedTypes()) {
            String targetClassPackage;
            if (importedType.equals(targetClass) || importedType.startsWith(targetClass)) {
                return true;
            }
            if (!targetClass.contains(".") || !importedType.equals(targetClassPackage = targetClass.substring(0, targetClass.lastIndexOf(".")))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSingleAbstractMethodInterface() {
        return this.isInterface && this.operations.size() == 1;
    }

    public Map<String, Set<String>> aliasedAttributes() {
        for (UMLOperation operation : this.getOperations()) {
            Map<String, Set<String>> aliased;
            if (!operation.isConstructor() || (aliased = operation.aliasedAttributes()).isEmpty()) continue;
            return aliased;
        }
        return new LinkedHashMap<String, Set<String>>();
    }

    public double normalizedSourceFolderDistance(UMLClass c) {
        String s1 = this.sourceFolder.toLowerCase();
        String s2 = c.sourceFolder.toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public double normalizedNameDistance(UMLClass c) {
        String s1 = this.name.toLowerCase();
        String s2 = c.name.toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public double normalizedPackageNameDistance(UMLClass c) {
        String s1 = this.packageName.toLowerCase();
        String s2 = c.packageName.toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public void setSealed(boolean sealed) {
        this.isSealed = sealed;
    }

    public void setData(boolean data) {
        this.isData = data;
    }

    public void setInner(boolean inner) {
        this.isInner = inner;
    }

    public void setObject(boolean isObject) {
        this.isInner = isObject;
    }
}

