/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;

public interface UMLClassMatcher {
    public boolean match(UMLClass var1, UMLClass var2, String var3);

    public static class ExtremelyRelaxedRename
    implements UMLClassMatcher {
        @Override
        public boolean match(UMLClass removedClass, UMLClass addedClass, String renamedFile) {
            return removedClass.hasSameKind(addedClass) && (removedClass.hasAttributesAndOperationsWithCommonNames(addedClass) || addedClass.getSourceFile().equals(renamedFile));
        }
    }

    public static class RelaxedRename
    implements UMLClassMatcher {
        @Override
        public boolean match(UMLClass removedClass, UMLClass addedClass, String renamedFile) {
            return removedClass.hasSameKind(addedClass) && (removedClass.hasCommonAttributesAndOperations(addedClass) || addedClass.getSourceFile().equals(renamedFile));
        }
    }

    public static class Rename
    implements UMLClassMatcher {
        @Override
        public boolean match(UMLClass removedClass, UMLClass addedClass, String renamedFile) {
            return removedClass.hasSameKind(addedClass) && (removedClass.hasSameAttributesAndOperations(addedClass) || addedClass.getSourceFile().equals(renamedFile));
        }
    }

    public static class ExtremelyRelaxedMove
    implements UMLClassMatcher {
        @Override
        public boolean match(UMLClass removedClass, UMLClass addedClass, String renamedFile) {
            return removedClass.hasSameNameAndKind(addedClass) && (removedClass.hasAttributesAndOperationsWithCommonNames(addedClass) || addedClass.getSourceFile().equals(renamedFile));
        }
    }

    public static class RelaxedMove
    implements UMLClassMatcher {
        @Override
        public boolean match(UMLClass removedClass, UMLClass addedClass, String renamedFile) {
            return removedClass.hasSameNameAndKind(addedClass) && (removedClass.hasCommonAttributesAndOperations(addedClass) || addedClass.getSourceFile().equals(renamedFile));
        }
    }

    public static class Move
    implements UMLClassMatcher {
        @Override
        public boolean match(UMLClass removedClass, UMLClass addedClass, String renamedFile) {
            return removedClass.hasSameNameAndKind(addedClass) && (removedClass.hasSameAttributesAndOperations(addedClass) || addedClass.getSourceFile().equals(renamedFile));
        }
    }
}

