/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.io.Serializable;
import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclarationProvider;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class UMLParameter
implements Serializable,
VariableDeclarationProvider {
    private final String name;
    private final UMLType type;
    private final String kind;
    private final boolean varargs;
    private VariableDeclaration variableDeclaration;

    public UMLParameter(String name, UMLType type, String kind, boolean varargs) {
        this.name = name;
        this.type = type;
        this.kind = kind;
        this.varargs = varargs;
        if (varargs) {
            type.setVarargs();
        }
    }

    public UMLType getType() {
        return this.type;
    }

    @Override
    public VariableDeclaration getVariableDeclaration() {
        return this.variableDeclaration;
    }

    public void setVariableDeclaration(VariableDeclaration variableDeclaration) {
        this.variableDeclaration = variableDeclaration;
    }

    public String getName() {
        return this.name;
    }

    public String getKind() {
        return this.kind;
    }

    public boolean isVarargs() {
        return this.varargs;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.variableDeclaration.getAnnotations();
    }

    public boolean equalsExcludingType(UMLParameter parameter) {
        return this.name.equals(parameter.name) && this.kind.equals(parameter.kind);
    }

    public boolean equalsIncludingName(UMLParameter parameter) {
        return this.name.equals(parameter.name) && this.type.equals(parameter.type) && this.kind.equals(parameter.kind) && this.varargs == parameter.varargs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof UMLParameter) {
            UMLParameter parameter = (UMLParameter)o;
            return this.type.equals(parameter.type) && this.kind.equals(parameter.kind) && this.name.equals(parameter.name) && this.varargs == parameter.varargs;
        }
        return false;
    }

    public boolean equalsQualified(UMLParameter parameter) {
        return this.type.equalsQualified(parameter.type) && this.kind.equals(parameter.kind) && this.varargs == parameter.varargs;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.kind == null ? 0 : this.kind.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.varargs ? 1231 : 1237);
        return result;
    }

    public String toString() {
        if (this.kind.equals("return")) {
            return this.type.toString();
        }
        if (this.varargs) {
            return this.name + " " + this.type.toString().substring(0, this.type.toString().lastIndexOf("[]")) + "...";
        }
        return this.name + " " + this.type;
    }

    public String toQualifiedString() {
        if (this.kind.equals("return")) {
            return this.type.toQualifiedString();
        }
        if (this.varargs) {
            return this.name + " " + this.type.toQualifiedString().substring(0, this.type.toQualifiedString().lastIndexOf("[]")) + "...";
        }
        return this.name + " " + this.type.toQualifiedString();
    }
}

