/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class UMLTypeParameter {
    private final String name;
    private final List<UMLType> typeBounds;
    private final List<UMLAnnotation> annotations;

    public UMLTypeParameter(String name) {
        this.name = name;
        this.typeBounds = new ArrayList<UMLType>();
        this.annotations = new ArrayList<UMLAnnotation>();
    }

    public String getName() {
        return this.name;
    }

    public List<UMLType> getTypeBounds() {
        return this.typeBounds;
    }

    public void addTypeBound(UMLType type) {
        this.typeBounds.add(type);
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(UMLAnnotation annotation) {
        this.annotations.add(annotation);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.typeBounds.isEmpty() ? 0 : this.typeBounds.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UMLTypeParameter other = (UMLTypeParameter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.typeBounds.isEmpty()) {
            return other.typeBounds.isEmpty();
        }
        return this.typeBounds.equals(other.typeBounds);
    }
}

