/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.data;

import com.intellij.openapi.util.Pair;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.common.data.RefactoringLine;
import org.jetbrains.research.refactorinsight.common.data.RefactoringType;
import org.jetbrains.research.refactorinsight.common.utils.StringUtils;
import org.jetbrains.research.refactorinsight.common.utils.Utils;

public class RefactoringEntry
implements Serializable {
    private List<RefactoringInfo> refactorings;

    public static RefactoringEntry createEmptyEntry() {
        RefactoringEntry refactoringEntry = new RefactoringEntry();
        refactoringEntry.setRefactorings(new ArrayList<RefactoringInfo>());
        return refactoringEntry;
    }

    public String toString() {
        String del = StringUtils.delimiter(2);
        return this.refactorings.stream().map(Object::toString).collect(Collectors.joining(del));
    }

    public void combineRelated() {
        this.combineRelatedExtractSuperClass();
        this.combineRelatedExtractClass();
        HashMap<String, List> groups = new HashMap<String, List>();
        this.refactorings.forEach(r -> {
            if (r.getGroupId() != null) {
                List list = groups.getOrDefault(r.getGroupId(), new ArrayList());
                list.add(r);
                groups.put(r.getGroupId(), list);
            }
            r.setEntry(this);
        });
        groups.forEach((k, v) -> {
            if (v.size() > 1) {
                RefactoringInfo info = Utils.getMainRefactoringInfo(v);
                if (info == null) {
                    return;
                }
                v.remove(info);
                v.forEach(r -> {
                    info.addIncludedRefactoring(r.getName());
                    info.addAllMarkings((RefactoringInfo)r);
                    r.setHidden(true);
                });
            }
        });
    }

    private void combineRelatedExtractSuperClass() {
        List<RefactoringInfo> superClassRefs = this.refactorings.stream().filter(info -> info != null && info.getType().getName().equals(RefactoringType.EXTRACT_SUPERCLASS.name())).collect(Collectors.toList());
        List pullUpRefs = this.refactorings.stream().filter(info -> info != null && info.getType().getName().equals(RefactoringType.PULL_UP_ATTRIBUTE.name()) || info != null && info.getType().getName().equals(RefactoringType.PULL_UP_OPERATION.name())).collect(Collectors.toList());
        superClassRefs.forEach(info -> {
            String superPath = info.getRightPath();
            List<RefactoringInfo> related = pullUpRefs.stream().filter(pullUp -> pullUp != null && pullUp.getRightPath().equals(superPath)).collect(Collectors.toList());
            related.forEach(relInfo -> {
                relInfo.setHidden(true);
                relInfo.getLineMarkings().forEach(line -> {
                    line.setMoreSided(true);
                    info.getLineMarkings().add(0, (RefactoringLine)line);
                    info.getMoreSidedLeftPaths().add(0, (Pair<String, Boolean>)new Pair((Object)relInfo.getLeftPath(), (Object)false));
                });
            });
        });
    }

    private void combineRelatedExtractClass() {
        List<RefactoringInfo> extractClassRefactorings = this.refactorings.stream().filter(x -> x != null && x.getType().getName().equals(RefactoringType.EXTRACT_CLASS.name())).collect(Collectors.toList());
        List moves = this.refactorings.stream().filter(info -> info.getType().getName().equals(RefactoringType.MOVE_OPERATION.name()) || info.getType().getName().equals(RefactoringType.MOVE_ATTRIBUTE.name())).collect(Collectors.toList());
        extractClassRefactorings.forEach(extractClass -> {
            String extracted = extractClass.getMidPath() == null ? extractClass.getRightPath() : extractClass.getMidPath();
            String leftPath = extractClass.getLeftPath();
            List<RefactoringInfo> related = moves.stream().filter(move -> move.getRightPath().equals(extracted) && move.getLeftPath().equals(leftPath)).collect(Collectors.toList());
            related.forEach(r -> {
                extractClass.addIncludedRefactoring(r.getName());
                r.setHidden(true);
            });
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefactoringEntry entry = (RefactoringEntry)o;
        return Objects.equals(this.refactorings, entry.refactorings);
    }

    public List<RefactoringInfo> getRefactorings() {
        return this.refactorings;
    }

    public void addRefactorings(List<RefactoringInfo> refactorings) {
        this.refactorings.addAll(refactorings);
    }

    public RefactoringEntry setRefactorings(@NotNull List<RefactoringInfo> refactorings) {
        if (refactorings == null) {
            RefactoringEntry.$$$reportNull$$$0(0);
        }
        this.refactorings = refactorings;
        return this;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refactorings", "org/jetbrains/research/refactorinsight/common/data/RefactoringEntry", "setRefactorings"));
    }
}

