/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.kotlin.impl.data.methods;

import java.util.ArrayList;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ExtractOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;
import org.jetbrains.research.refactorinsight.common.data.Group;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.common.data.RefactoringLine;
import org.jetbrains.research.refactorinsight.common.diff.VisualizationType;
import org.jetbrains.research.refactorinsight.common.utils.StringUtils;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.KotlinRefactoringHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.util.KotlinUtils;

public class ExtractOperationKotlinHandler
extends KotlinRefactoringHandler {
    @Override
    public RefactoringInfo specify(Refactoring refactoring, RefactoringInfo info) {
        ExtractOperationRefactoring ref = (ExtractOperationRefactoring)refactoring;
        String classNameBefore = ref.getSourceOperationBeforeExtraction().getClassName();
        String classNameAfter = ref.getExtractedOperation().getClassName();
        ArrayList<String> parameterTypeList = new ArrayList<String>();
        for (UMLType type : ref.getExtractedOperation().getParameterTypeList()) {
            parameterTypeList.add(type.toString());
        }
        String extractedMethod = StringUtils.calculateSignatureWithoutClassName(ref.getExtractedOperation().getName(), parameterTypeList);
        if (ref.getRefactoringType() == RefactoringType.EXTRACT_AND_MOVE_OPERATION) {
            info.setGroup(Group.METHOD).setThreeSided(true).setDetailsBefore(classNameBefore).setDetailsAfter(classNameAfter).setElementBefore(extractedMethod).setElementAfter(null).setNameBefore(KotlinUtils.calculateSignatureForKotlinMethod(ref.getSourceOperationBeforeExtraction())).setNameAfter(KotlinUtils.calculateSignatureForKotlinMethod(ref.getSourceOperationAfterExtraction())).addMarking(KotlinUtils.createCodeRangeFromKotlin(ref.getExtractedCodeRangeFromSourceOperation()), KotlinUtils.createCodeRangeFromKotlin(ref.getExtractedCodeRangeToExtractedOperation()), KotlinUtils.createCodeRangeFromKotlin(ref.getExtractedCodeRangeFromSourceOperation()), VisualizationType.LEFT, null, RefactoringLine.MarkingOption.NONE, true);
            ref.getExtractedOperationInvocationCodeRanges().forEach(invocation -> info.addMarking(KotlinUtils.createCodeRangeFromKotlin(ref.getSourceOperationCodeRangeBeforeExtraction()), KotlinUtils.createCodeRangeFromKotlin(ref.getExtractedOperation().getBody().getCompositeStatement().codeRange()), KotlinUtils.createCodeRangeFromKotlin(invocation), VisualizationType.RIGHT, refactoringLine -> refactoringLine.setWord(new String[]{null, ref.getExtractedOperation().getName(), null}), RefactoringLine.MarkingOption.EXTRACT, true));
        } else {
            info.setGroup(Group.METHOD).setDetailsBefore(classNameBefore).setDetailsAfter(classNameAfter).setElementBefore(extractedMethod).setElementAfter(null).setNameBefore(KotlinUtils.calculateSignatureForKotlinMethod(ref.getSourceOperationBeforeExtraction())).setNameAfter(KotlinUtils.calculateSignatureForKotlinMethod(ref.getSourceOperationAfterExtraction())).addMarking(KotlinUtils.createCodeRangeFromKotlin(ref.getSourceOperationCodeRangeBeforeExtraction()), KotlinUtils.createCodeRangeFromKotlin(ref.getSourceOperationCodeRangeAfterExtraction()), false).addMarking(KotlinUtils.createCodeRangeFromKotlin(ref.getExtractedCodeRangeFromSourceOperation()), KotlinUtils.createCodeRangeFromKotlin(ref.getExtractedCodeRangeToExtractedOperation()), true);
            ref.getExtractedOperationInvocationCodeRanges().forEach(invocation -> info.addMarking(KotlinUtils.createCodeRangeFromKotlin(ref.getExtractedCodeRangeFromSourceOperation()), KotlinUtils.createCodeRangeFromKotlin(invocation), null, RefactoringLine.MarkingOption.ADD, true));
        }
        return info;
    }
}

