/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.kotlin.impl.data.util;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractStatement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;
import org.jetbrains.research.refactorinsight.common.adapters.CodeRange;
import org.jetbrains.research.refactorinsight.common.utils.StringUtils;

public class KotlinUtils {
    public static String calculateSignatureForKotlinMethod(UMLOperation operation) {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> parameterTypeList = new ArrayList<String>();
        for (UMLType type : operation.getParameterTypeList()) {
            parameterTypeList.add(type.toString());
        }
        builder.append(operation.getClassName()).append(".").append(StringUtils.calculateSignatureWithoutClassName(operation.getName(), parameterTypeList));
        return builder.toString();
    }

    public static CodeRange createCodeRangeFromKotlin(org.jetbrains.research.kotlinrminer.ide.diff.CodeRange codeRange) {
        return new CodeRange(codeRange.getStartLine(), codeRange.getEndLine(), codeRange.getStartColumn(), codeRange.getEndColumn(), codeRange.getFilePath());
    }

    public static org.jetbrains.research.refactorinsight.common.adapters.LocationInfo createLocationInfoFromKotlin(LocationInfo locationInfo) {
        return new org.jetbrains.research.refactorinsight.common.adapters.LocationInfo(locationInfo.getFilePath(), locationInfo.getStartOffset(), locationInfo.getEndOffset(), locationInfo.getStartLine(), locationInfo.getEndLine(), locationInfo.getStartColumn(), locationInfo.getEndColumn(), locationInfo.getLength());
    }

    public static boolean isStatementsEqualKotlin(@NotNull List<AbstractStatement> statementsBefore, @NotNull List<AbstractStatement> statementsAfter) {
        if (statementsBefore.size() == statementsAfter.size()) {
            boolean equal = true;
            for (int i = 0; i < statementsBefore.size() && equal; ++i) {
                equal = statementsBefore.get(i).equalFragment(statementsAfter.get(i));
            }
            return equal;
        }
        return false;
    }
}

