/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.PackagePartProvider;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.jvm.deserialization.BinaryModuleData;
import org.jetbrains.kotlin.metadata.jvm.deserialization.ModuleMapping;
import org.jetbrains.kotlin.metadata.jvm.deserialization.PackageParts;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.deserialization.MetadataPartProvider;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u001b*\u0004\b\u0000\u0010\u00012\u00020\u00022\u00020\u0003:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fH\u0016J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\u0006\u0010\u0017\u001a\u00020\u0010H\u0016J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase;", "MappingsKey", "Lorg/jetbrains/kotlin/load/kotlin/PackagePartProvider;", "Lorg/jetbrains/kotlin/serialization/deserialization/MetadataPartProvider;", "()V", "deserializationConfiguration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "getDeserializationConfiguration", "()Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "loadedModules", "", "Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "getLoadedModules", "()Ljava/util/List;", "findMetadataPackageParts", "", "", "packageFqName", "findPackageParts", "getAllOptionalAnnotationClasses", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "getAnnotationsOnBinaryModule", "Lorg/jetbrains/kotlin/name/ClassId;", "moduleName", "getPackageParts", "", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/PackageParts;", "Companion", "ModuleMappingInfo", "descriptors.jvm"})
public abstract class JvmPackagePartProviderBase<MappingsKey>
implements PackagePartProvider,
MetadataPartProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected abstract List<ModuleMappingInfo<MappingsKey>> getLoadedModules();

    @NotNull
    public abstract DeserializationConfiguration getDeserializationConfiguration();

    @Override
    @NotNull
    public List<String> findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Collection<PackageParts> rootToPackageParts = this.getPackageParts(packageFqName);
        if (rootToPackageParts.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        LinkedHashSet visitedMultifileFacades = new LinkedHashSet();
        for (PackageParts packageParts : rootToPackageParts) {
            for (String name : packageParts.getParts()) {
                String facadeName = packageParts.getMultifileFacadeName(name);
                if (facadeName != null && visitedMultifileFacades.contains(facadeName)) continue;
                result2.add(name);
            }
            Iterable $this$mapNotNullTo$iv = packageParts.getParts();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl = false;
                String p0 = (String)element$iv;
                boolean bl2 = false;
                if (packageParts.getMultifileFacadeName(p0) == null) continue;
                boolean bl3 = false;
                ((Collection)visitedMultifileFacades).add(it$iv);
            }
        }
        return CollectionsKt.toList((Iterable)result2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> findMetadataPackageParts(@NotNull String packageFqName) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Iterable $this$flatMap$iv = this.getPackageParts(packageFqName);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PackageParts p0 = (PackageParts)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = p0.getMetadataParts();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
    }

    private final Collection<PackageParts> getPackageParts(String packageFqName) {
        Map result2 = new LinkedHashMap();
        for (ModuleMappingInfo<MappingsKey> moduleMappingInfo : this.getLoadedModules()) {
            PackageParts newParts;
            MappingsKey root = moduleMappingInfo.component1();
            ModuleMapping mapping = moduleMappingInfo.component2();
            if (mapping.findPackageParts(packageFqName) == null) continue;
            if ((PackageParts)result2.get(root) != null) {
                PackageParts parts;
                boolean bl = false;
                parts.plusAssign(newParts);
                continue;
            }
            result2.put(root, newParts);
        }
        return result2.values();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ClassId> getAnnotationsOnBinaryModule(@NotNull String moduleName) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Iterable $this$mapNotNull$iv = this.getLoadedModules();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            List list;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            ModuleMappingInfo moduleMappingInfo = (ModuleMappingInfo)element$iv$iv;
            boolean bl2 = false;
            ModuleMapping mapping = moduleMappingInfo.component2();
            String name = moduleMappingInfo.component3();
            if (Intrinsics.areEqual((Object)name, (Object)moduleName)) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = mapping.getModuleData().getAnnotations();
                boolean $i$f$map = false;
                Iterable iterable2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void p0;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    collection.add(ClassId.fromString((String)p0));
                }
                list = (List)destination$iv$iv2;
            } else {
                list = null;
            }
            if (list == null) continue;
            List it$iv$iv = list;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<ClassData> getAllOptionalAnnotationClasses() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.getLoadedModules();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            ModuleMappingInfo module = (ModuleMappingInfo)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = Companion.getAllOptionalAnnotationClasses(module.getMapping());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u0000*\u0004\b\u0001\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\u0010\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00012\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0007H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "MappingsKey", "", "key", "mapping", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "name", "", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;Ljava/lang/String;)V", "getKey", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getMapping", "()Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "getName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;Ljava/lang/String;)Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$ModuleMappingInfo;", "equals", "", "other", "hashCode", "", "toString", "descriptors.jvm"})
    protected static final class ModuleMappingInfo<MappingsKey> {
        private final MappingsKey key;
        @NotNull
        private final ModuleMapping mapping;
        @NotNull
        private final String name;

        public ModuleMappingInfo(MappingsKey key, @NotNull ModuleMapping mapping, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.key = key;
            this.mapping = mapping;
            this.name = name;
        }

        public final MappingsKey getKey() {
            return this.key;
        }

        @NotNull
        public final ModuleMapping getMapping() {
            return this.mapping;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final MappingsKey component1() {
            return this.key;
        }

        @NotNull
        public final ModuleMapping component2() {
            return this.mapping;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final ModuleMappingInfo<MappingsKey> copy(MappingsKey key, @NotNull ModuleMapping mapping, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ModuleMappingInfo<MappingsKey>(key, mapping, name);
        }

        public static /* synthetic */ ModuleMappingInfo copy$default(ModuleMappingInfo moduleMappingInfo, Object object, ModuleMapping moduleMapping, String string2, int n, Object object2) {
            if ((n & 1) != 0) {
                object = moduleMappingInfo.key;
            }
            if ((n & 2) != 0) {
                moduleMapping = moduleMappingInfo.mapping;
            }
            if ((n & 4) != 0) {
                string2 = moduleMappingInfo.name;
            }
            return moduleMappingInfo.copy(object, moduleMapping, string2);
        }

        @NotNull
        public String toString() {
            return "ModuleMappingInfo(key=" + this.key + ", mapping=" + this.mapping + ", name=" + this.name + ')';
        }

        public int hashCode() {
            int result2 = this.key == null ? 0 : this.key.hashCode();
            result2 = result2 * 31 + this.mapping.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModuleMappingInfo)) {
                return false;
            }
            ModuleMappingInfo moduleMappingInfo = (ModuleMappingInfo)other;
            if (!Intrinsics.areEqual(this.key, moduleMappingInfo.key)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.mapping, (Object)moduleMappingInfo.mapping)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)moduleMappingInfo.name);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/JvmPackagePartProviderBase$Companion;", "", "()V", "getAllOptionalAnnotationClasses", "", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "module", "Lorg/jetbrains/kotlin/metadata/jvm/deserialization/ModuleMapping;", "descriptors.jvm"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ClassData> getAllOptionalAnnotationClasses(@NotNull ModuleMapping module) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            BinaryModuleData data2 = module.getModuleData();
            Iterable $this$map$iv = data2.getOptionalAnnotations();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void proto;
                ProtoBuf.Class clazz = (ProtoBuf.Class)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                NameResolver nameResolver2 = data2.getNameResolver();
                BinaryVersion binaryVersion = module.getVersion();
                SourceElement sourceElement = SourceElement.NO_SOURCE;
                Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
                collection.add(new ClassData(nameResolver2, (ProtoBuf.Class)proto, binaryVersion, sourceElement));
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

