/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.diagnostic.KaptError;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fH\u0002\u001a\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0001H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u001a$\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u001a\u0014\u0010\u0018\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u0001H\u0002\u001a\f\u0010\u001b\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a\f\u0010\u001e\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u0014\u0010\u001f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010 \u001a\u00020\u001aH\u0002\u001a\u0014\u0010!\u001a\u00020\u0001*\u00020\u00012\u0006\u0010 \u001a\u00020\u001aH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0002\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0006\u001a\n \u0004*\u0004\u0018\u00010\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"COLON", "", "JAVAC_POSITION_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT", "KOTLIN_POSITION_PATTERN", "addMessage", "", "message", "Lcom/android/ide/common/blame/Message;", "messages", "", "createMessage", "messageKind", "Lcom/android/ide/common/blame/Message$Kind;", "text", "getMessageKind", "kind", "isKaptErrorWhileAnnotationProcessing", "parse", "lineText", "reader", "Lcom/android/ide/common/blame/parser/util/OutputLineReader;", "amendNextLinesIfNeeded", "colon", "", "isNextMessage", "skipDriveOnWin", "line", "startsWithSeverityPrefix", "substringAfterAndTrim", "index", "substringBeforeAndTrim", "intellij.android.kotlin.output.parser"})
public final class KotlinOutputParserHelperKt {
    private static final String COLON = ":";
    private static final Pattern KOTLIN_POSITION_PATTERN = Pattern.compile("\\(([0-9]*), ([0-9]*)\\)");
    private static final Pattern JAVAC_POSITION_PATTERN = Pattern.compile("([0-9]+)");
    private static final String KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT = KaptError.class.getCanonicalName() + ": " + KaptError.Kind.ERROR_RAISED.getMessage();

    public static final boolean parse(@NotNull String lineText, @NotNull OutputLineReader reader, @NotNull List<Message> messages) {
        Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        int colonIndex1 = KotlinOutputParserHelperKt.colon(lineText);
        if (colonIndex1 < 0) {
            return false;
        }
        String severity = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineText, colonIndex1);
        if (!KotlinOutputParserHelperKt.startsWithSeverityPrefix(severity)) {
            return false;
        }
        String lineWoSeverity = KotlinOutputParserHelperKt.substringAfterAndTrim(lineText, colonIndex1);
        int colonIndex2 = KotlinOutputParserHelperKt.skipDriveOnWin(KotlinOutputParserHelperKt.colon(lineWoSeverity), lineWoSeverity);
        if (colonIndex2 >= 0) {
            String path = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoSeverity, colonIndex2);
            File file = new File(path);
            String string = FilesKt.getExtension((File)file);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
            Locale locale2 = locale;
            String string2 = string;
            String string3 = string2.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            String fileExtension = string3;
            if (!file.isFile() || Intrinsics.areEqual((Object)fileExtension, (Object)"kt") ^ true && Intrinsics.areEqual((Object)fileExtension, (Object)"java") ^ true) {
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
            }
            String lineWoPath = KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoSeverity, colonIndex2);
            int colonIndex3 = KotlinOutputParserHelperKt.colon(lineWoPath);
            if (colonIndex3 >= 0) {
                Matcher matcher;
                String position = KotlinOutputParserHelperKt.substringBeforeAndTrim(lineWoPath, colonIndex3);
                Matcher it = matcher = KOTLIN_POSITION_PATTERN.matcher(position);
                boolean bl2 = false;
                Matcher matcher2 = it.matches() ? matcher : null;
                if (matcher2 == null) {
                    matcher2 = JAVAC_POSITION_PATTERN.matcher(position);
                }
                Matcher matcher3 = matcher2;
                String message = KotlinOutputParserHelperKt.amendNextLinesIfNeeded(KotlinOutputParserHelperKt.substringAfterAndTrim(lineWoPath, colonIndex3), reader);
                if (matcher3.matches()) {
                    int column;
                    int n;
                    Integer line;
                    Integer n2;
                    String string4 = matcher3.group(1);
                    if (string4 != null) {
                        String bl2 = string4;
                        n2 = Integer.parseInt(bl2);
                    } else {
                        n2 = line = null;
                    }
                    if (matcher3.groupCount() >= 2) {
                        String string5 = matcher3.group(2);
                        if (string5 != null) {
                            String string6 = string5;
                            n = Integer.parseInt(string6);
                        } else {
                            n = 1;
                        }
                    } else {
                        n = column = 1;
                    }
                    if (line != null) {
                        SourceFilePosition position2 = new SourceFilePosition(file, new SourcePosition(line.intValue(), column, column));
                        String string7 = message;
                        return KotlinOutputParserHelperKt.addMessage(new Message(KotlinOutputParserHelperKt.getMessageKind(severity), ((Object)StringsKt.trim((CharSequence)string7)).toString(), position2, new SourceFilePosition[0]), messages);
                    }
                }
                return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), message), messages);
            }
            return KotlinOutputParserHelperKt.addMessage(KotlinOutputParserHelperKt.createMessage(KotlinOutputParserHelperKt.getMessageKind(severity), KotlinOutputParserHelperKt.amendNextLinesIfNeeded(lineWoSeverity, reader)), messages);
        }
        return false;
    }

    private static final String amendNextLinesIfNeeded(String $this$amendNextLinesIfNeeded, OutputLineReader reader) {
        String nextLine = reader.readLine();
        StringBuilder builder = new StringBuilder($this$amendNextLinesIfNeeded);
        while (nextLine != null && !KotlinOutputParserHelperKt.isNextMessage(nextLine)) {
            builder.append("\n").append(nextLine);
            if (!reader.hasNextLine()) break;
            nextLine = reader.readLine();
        }
        if (nextLine != null) {
            Field field;
            try {
                field = reader.getClass().getDeclaredField("myPosition");
            }
            catch (Throwable e) {
                field = null;
            }
            Field positionField = field;
            if (positionField != null) {
                positionField.setAccessible(true);
                positionField.setInt(reader, positionField.getInt(reader) - 1);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNextMessage(String $this$isNextMessage) {
        int colonIndex1 = StringsKt.indexOf$default((CharSequence)$this$isNextMessage, (String)COLON, (int)0, (boolean)false, (int)6, null);
        if (colonIndex1 == 0) return true;
        if (colonIndex1 >= 0) {
            String string = $this$isNextMessage;
            int n = 0;
            String string2 = string.substring(n, colonIndex1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            if (KotlinOutputParserHelperKt.startsWithSeverityPrefix(string2)) return true;
        }
        if (StringUtil.containsIgnoreCase((String)$this$isNextMessage, (String)"FAILURE")) return true;
        if (!StringUtil.containsIgnoreCase((String)$this$isNextMessage, (String)"FAILED")) return false;
        return true;
    }

    private static final boolean startsWithSeverityPrefix(String $this$startsWithSeverityPrefix) {
        return KotlinOutputParserHelperKt.getMessageKind($this$startsWithSeverityPrefix) != Message.Kind.UNKNOWN;
    }

    private static final Message.Kind getMessageKind(String kind) {
        Message.Kind kind2;
        switch (kind) {
            case "e": {
                kind2 = Message.Kind.ERROR;
                break;
            }
            case "w": {
                kind2 = Message.Kind.WARNING;
                break;
            }
            case "i": {
                kind2 = Message.Kind.INFO;
                break;
            }
            case "v": {
                kind2 = Message.Kind.SIMPLE;
                break;
            }
            default: {
                kind2 = Message.Kind.UNKNOWN;
            }
        }
        return kind2;
    }

    private static final String substringAfterAndTrim(String $this$substringAfterAndTrim, int index) {
        String string = $this$substringAfterAndTrim;
        int n = index + 1;
        String string2 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
        string = string2;
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final String substringBeforeAndTrim(String $this$substringBeforeAndTrim, int index) {
        String string = $this$substringBeforeAndTrim;
        int n = 0;
        String string2 = string.substring(n, index);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        string = string2;
        return ((Object)StringsKt.trim((CharSequence)string)).toString();
    }

    private static final int colon(String $this$colon) {
        return StringsKt.indexOf$default((CharSequence)$this$colon, (String)COLON, (int)0, (boolean)false, (int)6, null);
    }

    private static final int skipDriveOnWin(int $this$skipDriveOnWin, String line) {
        return $this$skipDriveOnWin == 1 ? StringsKt.indexOf$default((CharSequence)line, (String)COLON, (int)($this$skipDriveOnWin + 1), (boolean)false, (int)4, null) : $this$skipDriveOnWin;
    }

    private static final boolean isKaptErrorWhileAnnotationProcessing(Message message) {
        if (message.getKind() != Message.Kind.ERROR) {
            return false;
        }
        if (Intrinsics.areEqual((Object)((SourceFilePosition)CollectionsKt.singleOrNull((List)message.getSourceFilePositions())), (Object)SourceFilePosition.UNKNOWN) ^ true) {
            return false;
        }
        String messageText = message.getText();
        String string = IllegalStateException.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"IllegalStateException::class.java.name");
        return StringsKt.startsWith$default((String)messageText, (String)string, (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)messageText, (CharSequence)KAPT_ERROR_WHILE_ANNOTATION_PROCESSING_MARKER_TEXT, (boolean)false, (int)2, null);
    }

    private static final boolean addMessage(Message message, List<Message> messages) {
        if (KotlinOutputParserHelperKt.isKaptErrorWhileAnnotationProcessing(message)) {
            return true;
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Message lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = Intrinsics.areEqual((Object)lastMessage, (Object)message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
        return true;
    }

    private static final Message createMessage(Message.Kind messageKind, String text) {
        String string = text;
        String string2 = ((Object)StringsKt.trim((CharSequence)string)).toString();
        Optional optional = Optional.absent();
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"Optional.absent<String>()");
        ImmutableList immutableList = ImmutableList.of();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"ImmutableList.of()");
        return new Message(messageKind, string2, text, optional, immutableList);
    }
}

