/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.android.configure;

import com.android.tools.idea.gradle.model.IdeModuleLibrary;
import com.android.tools.idea.gradle.model.java.JarLibraryDependency;
import com.android.tools.idea.gradle.model.java.JavaModuleDependency;
import com.android.tools.idea.gradle.project.model.AndroidModuleModel;
import com.android.tools.idea.gradle.project.model.JavaModuleModel;
import com.android.tools.idea.gradle.project.sync.idea.data.service.AndroidProjectKeys;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.gradle.tooling.model.idea.IdeaProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.android.configure.AndroidGradleModelFacade;
import org.jetbrains.kotlin.idea.gradle.inspections.KotlinGradleModelFacade;
import org.jetbrains.kotlin.idea.gradleJava.inspections.KotlinGradleModelFacadeKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J$\u0010\n\u001a\u0004\u0018\u00010\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00052\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/android/configure/AndroidGradleModelFacade;", "Lorg/jetbrains/kotlin/idea/gradle/inspections/KotlinGradleModelFacade;", "()V", "getDependencyModules", "", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ModuleData;", "ideModule", "gradleIdeaProject", "Lorg/gradle/tooling/model/idea/IdeaProject;", "getResolvedKotlinStdlibVersionByModuleData", "", "moduleData", "libraryIds", "", "intellij.android.kotlin.idea"})
public final class AndroidGradleModelFacade
implements KotlinGradleModelFacade {
    @Nullable
    public String getResolvedKotlinStdlibVersionByModuleData(@NotNull DataNode<?> moduleData, @NotNull List<String> libraryIds) {
        Intrinsics.checkNotNullParameter(moduleData, (String)"moduleData");
        Intrinsics.checkNotNullParameter(libraryIds, (String)"libraryIds");
        Collection collection = ExternalSystemApiUtil.findAllRecursively(moduleData, (Key)AndroidProjectKeys.JAVA_MODULE_MODEL);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil\n  \u2026ctKeys.JAVA_MODULE_MODEL)");
        Sequence $this$forEach$iv = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)getResolvedKotlinStdlibVersionByModuleData.1.INSTANCE);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JarLibraryDependency it = (JarLibraryDependency)element$iv;
            boolean bl = false;
            JarLibraryDependency jarLibraryDependency = it;
            Intrinsics.checkNotNullExpressionValue((Object)jarLibraryDependency, (String)"it");
            Intrinsics.checkNotNullExpressionValue((Object)jarLibraryDependency.getName(), (String)"it.name");
            for (String libraryId : libraryIds) {
                String libraryName;
                String prefix = libraryId + "-";
                if (!StringsKt.startsWith$default((String)libraryName, (String)prefix, (boolean)false, (int)2, null)) continue;
                return StringsKt.substringAfter$default((String)libraryName, (String)prefix, null, (int)2, null);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Collection<DataNode<ModuleData>> getDependencyModules(@NotNull DataNode<ModuleData> ideModule, @NotNull IdeaProject gradleIdeaProject) {
        Intrinsics.checkNotNullParameter(ideModule, (String)"ideModule");
        Intrinsics.checkNotNullParameter((Object)gradleIdeaProject, (String)"gradleIdeaProject");
        DataNode dataNode = ideModule.getParent();
        if (dataNode == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.externalSystem.model.DataNode<com.intellij.openapi.externalSystem.model.project.ProjectData>");
        }
        DataNode ideProject = dataNode;
        DataNode dataNode2 = ExternalSystemApiUtil.find(ideModule, (Key)AndroidProjectKeys.JAVA_MODULE_MODEL);
        if (dataNode2 != null) {
            void $this$mapTo$iv$iv;
            DataNode dataNode3;
            DataNode javaModuleModel = dataNode3 = dataNode2;
            boolean bl = false;
            DataNode dataNode4 = javaModuleModel;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode4, (String)"javaModuleModel");
            Object object = dataNode4.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"javaModuleModel.data");
            Collection collection = ((JavaModuleModel)object).getJavaModuleDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"javaModuleModel.data.javaModuleDependencies");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                JavaModuleDependency javaModuleDependency = (JavaModuleDependency)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                void v5 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"it");
                String string = v5.getModuleName();
                collection2.add(string);
            }
            HashSet moduleNames = CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv));
            return KotlinGradleModelFacadeKt.findModulesByNames((Set)moduleNames, (IdeaProject)gradleIdeaProject, (DataNode)ideProject);
        }
        DataNode dataNode5 = ExternalSystemApiUtil.find(ideModule, (Key)AndroidProjectKeys.ANDROID_MODEL);
        if (dataNode5 != null) {
            void $this$mapNotNullTo$iv;
            void $this$mapNotNullTo$iv$iv;
            DataNode dataNode6;
            DataNode androidModel = dataNode6 = dataNode5;
            boolean bl = false;
            DataNode dataNode7 = androidModel;
            Intrinsics.checkNotNullExpressionValue((Object)dataNode7, (String)"androidModel");
            Object object = dataNode7.getData();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"androidModel.data");
            Collection modules = ((AndroidModuleModel)object).getMainArtifact().getLevel2Dependencies().getModuleDependencies();
            Iterable $this$mapNotNull$iv = modules;
            boolean $i$f$mapNotNull = false;
            Iterable destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl3 = false;
                IdeModuleLibrary it = (IdeModuleLibrary)element$iv$iv;
                boolean bl4 = false;
                String string2 = it.getProjectPath();
                if (string2 == null) continue;
                String it$iv$iv = string = string2;
                boolean bl5 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List projectIds = (List)destination$iv$iv2;
            $this$mapNotNull$iv = projectIds;
            Collection destination$iv = new LinkedHashSet();
            boolean $i$f$mapNotNullTo2 = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator2 = $this$forEach$iv$iv.iterator();
            while (iterator2.hasNext()) {
                DataNode dataNode8;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator2.next();
                boolean bl6 = false;
                String projectId = (String)element$iv;
                boolean bl7 = false;
                DataNode dataNode9 = ExternalSystemApiUtil.findFirstRecursively((DataNode)ideProject, (Predicate)new Predicate(projectId){
                    final /* synthetic */ String $projectId;

                    public final boolean test(DataNode<?> it) {
                        DataNode<?> dataNode = it;
                        Intrinsics.checkNotNullExpressionValue(dataNode, (String)"it");
                        Object object = dataNode.getData();
                        if (!(object instanceof ModuleData)) {
                            object = null;
                        }
                        ModuleData moduleData = (ModuleData)object;
                        return Intrinsics.areEqual((Object)(moduleData != null ? moduleData.getId() : null), (Object)this.$projectId);
                    }
                    {
                        this.$projectId = string;
                    }
                });
                if (dataNode9 == null) continue;
                DataNode it$iv = dataNode8 = dataNode9;
                boolean bl8 = false;
                destination$iv.add(it$iv);
            }
            return destination$iv;
        }
        return CollectionsKt.emptyList();
    }
}

