/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.util.ExceptionUtilRt;
import java.rmi.RemoteException;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenPullServerLogger;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenRemotePullUtil;
import org.jetbrains.idea.maven.server.ServerLogEvent;

public class MavenServerLoggerWrapper
extends MavenRemoteObject
implements MavenPullServerLogger {
    private final ConcurrentLinkedQueue<ServerLogEvent> myPullingQueue = new ConcurrentLinkedQueue();

    public void info(Throwable e) throws RemoteException {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.INFO, this.serialize(e)));
    }

    public void warn(Throwable e) throws RemoteException {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.WARN, this.serialize(e)));
    }

    public void error(Throwable e) throws RemoteException {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.ERROR, this.serialize(e)));
    }

    public void print(String o) throws RemoteException {
        this.myPullingQueue.add(new ServerLogEvent(ServerLogEvent.Type.PRINT, o));
    }

    @Nullable
    public List<ServerLogEvent> pull() {
        return MavenRemotePullUtil.pull(this.myPullingQueue);
    }

    private String serialize(Throwable e) {
        return ExceptionUtilRt.getThrowableText((Throwable)this.wrapException(e), (String)"");
    }
}

