/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.problem;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import de.plushnikov.intellij.plugin.problem.LombokProblem;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import java.util.HashSet;
import java.util.Set;

public class ProblemNewBuilder
implements ProblemBuilder {
    private final Set<LombokProblem> problems;

    public ProblemNewBuilder() {
        this(1);
    }

    public ProblemNewBuilder(int size) {
        this.problems = new HashSet<LombokProblem>(size);
    }

    public Set<LombokProblem> getProblems() {
        return this.problems;
    }

    @Override
    public void addWarning(@InspectionMessage String message) {
        this.addProblem(message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    @Override
    public void addWarning(@InspectionMessage String message, Object ... params) {
        this.addProblem(String.format(message, params), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
    }

    @Override
    public void addError(@InspectionMessage String message) {
        this.addProblem(message, ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
    }

    @Override
    public void addError(@InspectionMessage String message, Object ... params) {
        this.addProblem(String.format(message, params), ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
    }

    @Override
    public void addWarning(@InspectionMessage String message, LocalQuickFix ... quickFixes) {
        this.addProblem(message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickFixes);
    }

    @Override
    public void addError(@InspectionMessage String message, LocalQuickFix ... quickFixes) {
        this.addProblem(message, ProblemHighlightType.GENERIC_ERROR, quickFixes);
    }

    @Override
    public void addProblem(@InspectionMessage String message, ProblemHighlightType highlightType, LocalQuickFix ... quickFixes) {
        this.problems.add(new LombokProblem(message, highlightType, quickFixes));
    }
}

