/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class SetterFieldProcessor
extends AbstractFieldProcessor {
    SetterFieldProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.Setter");
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(0);
        }
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(1);
        }
        if (target == null) {
            SetterFieldProcessor.$$$reportNull$$$0(2);
        }
        String methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation);
        PsiClass psiClass = psiField.getContainingClass();
        if (methodVisibility != null && psiClass != null) {
            target.add((PsiElement)this.createSetterMethod(psiField, psiClass, methodVisibility));
        }
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(3);
        }
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(4);
        }
        if (builder == null) {
            SetterFieldProcessor.$$$reportNull$$$0(5);
        }
        this.validateOnXAnnotations(psiAnnotation, psiField, builder, "onParam");
        boolean result = this.validateFinalModifier(psiAnnotation, psiField, builder);
        if (result && (result = this.validateVisibility(psiAnnotation)) && (result = this.validateExistingMethods(psiField, builder, false))) {
            result = this.validateAccessorPrefix(psiField, builder);
        }
        return result;
    }

    private boolean validateFinalModifier(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(6);
        }
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            SetterFieldProcessor.$$$reportNull$$$0(8);
        }
        boolean result = true;
        if (psiField.hasModifierProperty("final") && null != LombokProcessorUtil.getMethodModifier(psiAnnotation)) {
            builder.addWarning(LombokBundle.message("inspection.message.not.generating.setter.for.this.field.setters", new Object[0]), PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "final", false, false));
            result = false;
        }
        return result;
    }

    private boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(9);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    private boolean validateAccessorPrefix(@NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(10);
        }
        if (builder == null) {
            SetterFieldProcessor.$$$reportNull$$$0(11);
        }
        boolean result = true;
        if (AccessorsInfo.build(psiField).isPrefixUnDefinedOrNotStartsWith(psiField.getName())) {
            builder.addWarning(LombokBundle.message("inspection.message.not.generating.setter.for.this.field.it", new Object[0]));
            result = false;
        }
        return result;
    }

    public Collection<String> getAllSetterNames(@NotNull PsiField psiField, boolean isBoolean) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(12);
        }
        AccessorsInfo accessorsInfo = AccessorsInfo.build(psiField);
        return LombokUtils.toAllSetterNames(accessorsInfo, psiField.getName(), isBoolean);
    }

    @NotNull
    public PsiMethod createSetterMethod(@NotNull PsiField psiField, @NotNull PsiClass psiClass, @NotNull String methodModifier) {
        LombokLightParameter setterParameter;
        boolean isStatic;
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(13);
        }
        if (psiClass == null) {
            SetterFieldProcessor.$$$reportNull$$$0(14);
        }
        if (methodModifier == null) {
            SetterFieldProcessor.$$$reportNull$$$0(15);
        }
        String fieldName = psiField.getName();
        PsiType psiFieldType = psiField.getType();
        PsiAnnotation setterAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.Setter");
        String methodName = LombokUtils.getSetterName(psiField);
        PsiType returnType = this.getReturnType(psiField);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(psiField.getManager(), methodName).withMethodReturnType(returnType).withContainingClass(psiClass).withParameter(fieldName, psiFieldType).withNavigationElement((PsiElement)psiField);
        if (StringUtil.isNotEmpty((String)methodModifier)) {
            methodBuilder.withModifier(methodModifier);
        }
        if (isStatic = psiField.hasModifierProperty("static")) {
            methodBuilder.withModifier("static");
        }
        if (null != (setterParameter = methodBuilder.getParameterList().getParameter(0))) {
            LombokLightModifierList methodParameterModifierList = setterParameter.getModifierList();
            SetterFieldProcessor.copyCopyableAnnotations(psiField, methodParameterModifierList, LombokCopyableAnnotations.BASE_COPYABLE);
            SetterFieldProcessor.copyOnXAnnotations(setterAnnotation, (PsiModifierList)methodParameterModifierList, "onParam");
        }
        LombokLightModifierList modifierList = methodBuilder.getModifierList();
        SetterFieldProcessor.copyCopyableAnnotations(psiField, modifierList, LombokCopyableAnnotations.COPY_TO_SETTER);
        SetterFieldProcessor.copyOnXAnnotations(setterAnnotation, (PsiModifierList)modifierList, "onMethod");
        if (psiField.isDeprecated()) {
            modifierList.addAnnotation("java.lang.Deprecated");
        }
        String codeBlockText = this.createCodeBlockText(psiField, psiClass, returnType, isStatic, (PsiParameter)setterParameter);
        methodBuilder.withBodyText(codeBlockText);
        LombokLightMethodBuilder lombokLightMethodBuilder = methodBuilder;
        if (lombokLightMethodBuilder == null) {
            SetterFieldProcessor.$$$reportNull$$$0(16);
        }
        return lombokLightMethodBuilder;
    }

    @NotNull
    private String createCodeBlockText(@NotNull PsiField psiField, @NotNull PsiClass psiClass, PsiType returnType, boolean isStatic, PsiParameter methodParameter) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(17);
        }
        if (psiClass == null) {
            SetterFieldProcessor.$$$reportNull$$$0(18);
        }
        String thisOrClass = isStatic ? psiClass.getName() : "this";
        String blockText = String.format("%s.%s = %s; ", thisOrClass, psiField.getName(), methodParameter.getName());
        Object codeBlockText = blockText;
        if (!isStatic && !PsiType.VOID.equals((Object)returnType)) {
            codeBlockText = (String)codeBlockText + "return this;";
        }
        String string = codeBlockText;
        if (string == null) {
            SetterFieldProcessor.$$$reportNull$$$0(19);
        }
        return string;
    }

    private PsiType getReturnType(@NotNull PsiField psiField) {
        PsiClass fieldClass;
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(20);
        }
        PsiPrimitiveType result = PsiType.VOID;
        if (!psiField.hasModifierProperty("static") && AccessorsInfo.build(psiField).isChain() && null != (fieldClass = psiField.getContainingClass())) {
            result = PsiClassUtil.getTypeWithGenerics(fieldClass);
        }
        return result;
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            SetterFieldProcessor.$$$reportNull$$$0(21);
        }
        if (psiAnnotation == null) {
            SetterFieldProcessor.$$$reportNull$$$0(22);
        }
        return LombokPsiElementUsage.WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 1: 
            case 3: 
            case 6: 
            case 9: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/field/SetterFieldProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/SetterFieldProcessor";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createSetterMethod";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createCodeBlockText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generatePsiElements";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateFinalModifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "validateVisibility";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "validateAccessorPrefix";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllSetterNames";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createSetterMethod";
                break;
            }
            case 16: 
            case 19: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createCodeBlockText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

