/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.field;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.LombokBundle;
import de.plushnikov.intellij.plugin.problem.ProblemBuilder;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.clazz.constructor.RequiredArgsConstructorProcessor;
import de.plushnikov.intellij.plugin.processor.field.AbstractFieldProcessor;
import de.plushnikov.intellij.plugin.processor.field.AccessorsInfo;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.psi.LombokLightParameter;
import de.plushnikov.intellij.plugin.quickfix.PsiQuickFixFactory;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.thirdparty.LombokUtils;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiClassUtil;
import de.plushnikov.intellij.plugin.util.PsiMethodUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WitherFieldProcessor
extends AbstractFieldProcessor {
    public WitherFieldProcessor() {
        super((Class<? extends PsiElement>)PsiMethod.class, "lombok.experimental.Wither", "lombok.With");
    }

    private RequiredArgsConstructorProcessor getRequiredArgsConstructorProcessor() {
        return (RequiredArgsConstructorProcessor)ApplicationManager.getApplication().getService(RequiredArgsConstructorProcessor.class);
    }

    @Override
    protected boolean validate(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(0);
        }
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(2);
        }
        this.validateOnXAnnotations(psiAnnotation, psiField, builder, "onParam");
        boolean valid = this.validateVisibility(psiAnnotation);
        valid &= this.validName(psiField, builder);
        valid &= this.validNonStatic(psiField, builder);
        valid &= this.validNonFinalInitialized(psiField, builder);
        valid &= this.validIsWitherUnique(psiField, builder);
        PsiClass containingClass = psiField.getContainingClass();
        return valid &= null != containingClass && (containingClass.hasModifierProperty("abstract") || this.validConstructor(containingClass, builder));
    }

    private boolean validateVisibility(@NotNull PsiAnnotation psiAnnotation) {
        String methodVisibility;
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(3);
        }
        return null != (methodVisibility = LombokProcessorUtil.getMethodModifier(psiAnnotation));
    }

    @Override
    protected void generatePsiElements(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation, @NotNull List<? super PsiElement> target) {
        AccessorsInfo accessorsInfo;
        PsiMethod method;
        String methodModifier;
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(4);
        }
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(5);
        }
        if (target == null) {
            WitherFieldProcessor.$$$reportNull$$$0(6);
        }
        if ((methodModifier = LombokProcessorUtil.getMethodModifier(psiAnnotation)) != null && (method = this.createWitherMethod(psiField, methodModifier, accessorsInfo = this.buildAccessorsInfo(psiField))) != null) {
            target.add((PsiElement)method);
        }
    }

    private boolean validName(@NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(7);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(8);
        }
        if (psiField.getName().startsWith("$")) {
            builder.addWarning(LombokBundle.message("inspection.message.not.generating.wither.for.this.field.withers", new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validNonStatic(@NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(9);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(10);
        }
        if (psiField.hasModifierProperty("static")) {
            builder.addWarning(LombokBundle.message("inspection.message.not.generating.wither", new Object[0]), PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "static", false, false));
            return false;
        }
        return true;
    }

    private boolean validNonFinalInitialized(@NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        PsiClass psiClass;
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(11);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(12);
        }
        if (null != (psiClass = psiField.getContainingClass()) && psiField.hasModifierProperty("final") && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.Value") && psiField.hasInitializer() && !PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiField, "lombok.Builder.Default")) {
            builder.addWarning(LombokBundle.message("inspection.message.not.generating.wither.for.this.field.withers.cannot.be.generated", new Object[0]), PsiQuickFixFactory.createModifierListFix((PsiModifierListOwner)psiField, "final", false, false));
            return false;
        }
        return true;
    }

    private boolean validIsWitherUnique(@NotNull PsiField psiField, @NotNull ProblemBuilder builder) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(13);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(14);
        }
        PsiClass fieldContainingClass = psiField.getContainingClass();
        String psiFieldName = psiField.getName();
        if (fieldContainingClass != null) {
            Collection<PsiMethod> classMethods = PsiClassUtil.collectClassMethodsIntern(fieldContainingClass);
            this.filterToleratedElements(classMethods);
            AccessorsInfo accessorsInfo = this.buildAccessorsInfo(psiField);
            Collection<String> possibleWitherNames = LombokUtils.toAllWitherNames(accessorsInfo, psiFieldName, PsiType.BOOLEAN.equals((Object)psiField.getType()));
            for (String witherName : possibleWitherNames) {
                if (!PsiMethodUtil.hasSimilarMethod(classMethods, witherName, 1)) continue;
                builder.addWarning(LombokBundle.message("inspection.message.not.generating.s.method.with.that.name.already.exists", new Object[0]), witherName);
                return false;
            }
        }
        return true;
    }

    public boolean validConstructor(@NotNull PsiClass psiClass, @NotNull ProblemBuilder builder) {
        if (psiClass == null) {
            WitherFieldProcessor.$$$reportNull$$$0(15);
        }
        if (builder == null) {
            WitherFieldProcessor.$$$reportNull$$$0(16);
        }
        if (psiClass.isRecord() || PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.AllArgsConstructor", "lombok.Value", "lombok.Builder")) {
            return true;
        }
        Collection<PsiField> constructorParameters = this.filterFields(psiClass);
        if (PsiAnnotationSearchUtil.isAnnotatedWith((PsiModifierListOwner)psiClass, "lombok.RequiredArgsConstructor", "lombok.Data")) {
            Collection<PsiField> requiredConstructorParameters = this.getRequiredArgsConstructorProcessor().getRequiredFields(psiClass);
            if (constructorParameters.size() == requiredConstructorParameters.size()) {
                return true;
            }
        }
        Collection<PsiMethod> classConstructors = PsiClassUtil.collectClassConstructorIntern(psiClass);
        boolean constructorExists = false;
        for (PsiMethod classConstructor : classConstructors) {
            if (classConstructor.getParameterList().getParametersCount() != constructorParameters.size()) continue;
            constructorExists = true;
            break;
        }
        if (!constructorExists) {
            builder.addWarning(LombokBundle.message("inspection.message.wither.needs.constructor.for.all.fields.d.parameters", new Object[0]), constructorParameters.size());
        }
        return constructorExists;
    }

    private Collection<PsiField> filterFields(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            WitherFieldProcessor.$$$reportNull$$$0(17);
        }
        Collection<PsiField> psiFields = PsiClassUtil.collectClassFieldsIntern(psiClass);
        ArrayList<PsiField> result = new ArrayList<PsiField>(psiFields.size());
        for (PsiField classField : psiFields) {
            String classFieldName = classField.getName();
            if (classFieldName.startsWith("$") || classField.hasModifierProperty("static") || classField.hasModifierProperty("final") && classField.hasInitializer()) continue;
            result.add(classField);
        }
        return result;
    }

    @Nullable
    public PsiMethod createWitherMethod(@NotNull PsiField psiField, @NotNull String methodModifier, @NotNull AccessorsInfo accessorsInfo) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(18);
        }
        if (methodModifier == null) {
            WitherFieldProcessor.$$$reportNull$$$0(19);
        }
        if (accessorsInfo == null) {
            WitherFieldProcessor.$$$reportNull$$$0(20);
        }
        LombokLightMethodBuilder methodBuilder = null;
        PsiClass psiFieldContainingClass = psiField.getContainingClass();
        if (psiFieldContainingClass != null) {
            PsiClassType returnType = PsiClassUtil.getTypeWithGenerics(psiFieldContainingClass);
            String psiFieldName = psiField.getName();
            PsiType psiFieldType = psiField.getType();
            methodBuilder = new LombokLightMethodBuilder(psiField.getManager(), this.getWitherName(accessorsInfo, psiFieldName, psiFieldType)).withMethodReturnType((PsiType)returnType).withContainingClass(psiFieldContainingClass).withNavigationElement((PsiElement)psiField).withModifier(methodModifier);
            PsiAnnotation witherAnnotation = PsiAnnotationSearchUtil.findAnnotation((PsiModifierListOwner)psiField, "lombok.experimental.Wither", "lombok.With");
            WitherFieldProcessor.copyOnXAnnotations(witherAnnotation, (PsiModifierList)methodBuilder.getModifierList(), "onMethod");
            LombokLightParameter methodParameter = new LombokLightParameter(psiFieldName, psiFieldType, (PsiElement)methodBuilder);
            methodBuilder.withParameter(methodParameter);
            LombokLightModifierList methodParameterModifierList = methodParameter.getModifierList();
            WitherFieldProcessor.copyCopyableAnnotations(psiField, methodParameterModifierList, LombokCopyableAnnotations.BASE_COPYABLE);
            WitherFieldProcessor.copyOnXAnnotations(witherAnnotation, (PsiModifierList)methodParameterModifierList, "onParam");
            if (psiFieldContainingClass.hasModifierProperty("abstract")) {
                methodBuilder.withModifier("abstract");
            } else {
                String paramString = this.getConstructorCall(psiField, psiFieldContainingClass);
                String blockText = String.format("return this.%s == %s ? this : new %s(%s);", psiFieldName, psiFieldName, returnType.getCanonicalText(), paramString);
                methodBuilder.withBodyText(blockText);
            }
        }
        return methodBuilder;
    }

    private AccessorsInfo buildAccessorsInfo(@NotNull PsiField psiField) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(21);
        }
        return AccessorsInfo.build(psiField).withFluent(false);
    }

    private String getWitherName(@NotNull AccessorsInfo accessorsInfo, String psiFieldName, PsiType psiFieldType) {
        if (accessorsInfo == null) {
            WitherFieldProcessor.$$$reportNull$$$0(22);
        }
        return LombokUtils.toWitherName(accessorsInfo, psiFieldName, PsiType.BOOLEAN.equals((Object)psiFieldType));
    }

    private String getConstructorCall(@NotNull PsiField psiField, @NotNull PsiClass psiClass) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(23);
        }
        if (psiClass == null) {
            WitherFieldProcessor.$$$reportNull$$$0(24);
        }
        StringBuilder paramString = new StringBuilder();
        Collection<PsiField> psiFields = this.filterFields(psiClass);
        for (PsiField classField : psiFields) {
            String classFieldName = classField.getName();
            if (classField.equals(psiField)) {
                paramString.append(classFieldName);
            } else {
                paramString.append("this.").append(classFieldName);
            }
            paramString.append(',');
        }
        if (paramString.length() > 1) {
            paramString.deleteCharAt(paramString.length() - 1);
        }
        return paramString.toString();
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            WitherFieldProcessor.$$$reportNull$$$0(25);
        }
        if (psiAnnotation == null) {
            WitherFieldProcessor.$$$reportNull$$$0(26);
        }
        return LombokPsiElementUsage.READ_WRITE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 18: 
            case 21: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 2: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: 
            case 17: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodModifier";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessorsInfo";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/field/WitherFieldProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "validateVisibility";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "generatePsiElements";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "validName";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "validNonStatic";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "validNonFinalInitialized";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "validIsWitherUnique";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "validConstructor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "filterFields";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "createWitherMethod";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "buildAccessorsInfo";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "getWitherName";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[2] = "getConstructorCall";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFieldUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

