/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.CompletionMLPolicy;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.UserDataHolderBase;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/ml/sorting/ContextFeaturesContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "calculateContextFactors", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "storage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "fillCompletionVariants", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "MyEnvironment", "intellij.completionMlRanking"})
public final class ContextFeaturesContributor
extends CompletionContributor
implements DumbAware {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        MutableLookupStorage storage;
        LookupImpl lookup;
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (!(lookupEx instanceof LookupImpl)) {
            lookupEx = null;
        }
        if ((lookup = (LookupImpl)lookupEx) != null && (storage = MutableLookupStorage.Companion.get(lookup)) != null) {
            MutableLookupStorage.Companion.saveAsUserData(parameters, storage);
            if (CompletionMLPolicy.Companion.isReRankingDisabled(storage.getLanguage(), parameters)) {
                storage.disableReRanking();
            }
            if (storage.shouldComputeFeatures() && !storage.isContextFactorsInitialized()) {
                this.calculateContextFactors(lookup, parameters, storage);
            }
        }
        super.fillCompletionVariants(parameters, result);
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateContextFactors(LookupImpl lookup, CompletionParameters parameters, MutableLookupStorage storage) {
        MyEnvironment environment = new MyEnvironment(lookup, parameters);
        Map contextFeatures = new LinkedHashMap();
        for (ContextFeatureProvider provider : ContextFeatureProvider.forLanguage((Language)storage.getLanguage())) {
            String providerName;
            Map features2;
            ProgressManager.checkCanceled();
            ContextFeatureProvider contextFeatureProvider = provider;
            Intrinsics.checkNotNullExpressionValue((Object)contextFeatureProvider, (String)"provider");
            Intrinsics.checkNotNullExpressionValue((Object)contextFeatureProvider.getName(), (String)"provider.name");
            long start = System.nanoTime();
            Intrinsics.checkNotNullExpressionValue((Object)provider.calculateFeatures((CompletionEnvironment)environment), (String)"provider.calculateFeatures(environment)");
            Object object = features2;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void featureName;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                object = (String)entry2.getKey();
                entry2 = entry;
                MLFeatureValue value = (MLFeatureValue)entry2.getValue();
                String string = "ml_ctx_" + providerName + "_" + (String)featureName;
                MLFeatureValue mLFeatureValue = value;
                Intrinsics.checkNotNullExpressionValue((Object)mLFeatureValue, (String)"value");
                contextFeatures.put(string, mLFeatureValue);
            }
            long timeSpent = System.nanoTime() - start;
            storage.getPerformanceTracker().contextFeaturesCalculated(providerName, TimeUnit.NANOSECONDS.toMillis(timeSpent));
        }
        storage.initContextFactors(contextFeatures, environment);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/completion/ml/sorting/ContextFeaturesContributor$MyEnvironment;", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lcom/intellij/codeInsight/completion/CompletionParameters;)V", "getLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "getParameters", "intellij.completionMlRanking"})
    private static final class MyEnvironment
    extends UserDataHolderBase
    implements CompletionEnvironment {
        private final LookupImpl lookup;
        private final CompletionParameters parameters;

        @NotNull
        public Lookup getLookup() {
            return (Lookup)this.lookup;
        }

        @NotNull
        public CompletionParameters getParameters() {
            return this.parameters;
        }

        public MyEnvironment(@NotNull LookupImpl lookup, @NotNull CompletionParameters parameters) {
            Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
            Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
            this.lookup = lookup;
            this.parameters = parameters;
        }
    }
}

