/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.completion.ml.sorting;

import com.intellij.codeInsight.completion.CompletionFinalSorter;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.completion.ml.features.RankingFeaturesOverrides;
import com.intellij.completion.ml.performance.CompletionPerformanceTracker;
import com.intellij.completion.ml.personalization.session.SessionFactorsUtils;
import com.intellij.completion.ml.settings.CompletionMLRankingSettings;
import com.intellij.completion.ml.sorting.AdditionalContextFeatureProvider;
import com.intellij.completion.ml.sorting.ElementFeatures;
import com.intellij.completion.ml.sorting.ItemRankInfo;
import com.intellij.completion.ml.sorting.ItemsDecoratorInitializer;
import com.intellij.completion.ml.sorting.LookupFeatureProvider;
import com.intellij.completion.ml.sorting.RankingFeatures;
import com.intellij.completion.ml.sorting.RankingModelWrapper;
import com.intellij.completion.ml.storage.MutableLookupStorage;
import com.intellij.completion.ml.util.LookupExtensionsKt;
import com.intellij.completion.ml.util.RelevanceUtil;
import com.intellij.internal.ml.completion.DecoratingItemsPolicy;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.textMatching.PrefixMatchingUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001d\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 A2\u00020\u0001:\u0003ABCB\u0005\u00a2\u0006\u0002\u0010\u0002JL\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J9\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u001dJh\u0010\u001e\u001a\u00020\n2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\"\u0010*\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J4\u0010+\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0,0!0#2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050-H\u0016J\u0016\u0010.\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0002J\u0016\u00100\u001a\u00020\b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050/H\u0002J\u0018\u00101\u001a\u0002022\u0006\u00103\u001a\u0002022\u0006\u00104\u001a\u000205H\u0002J&\u00106\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050/2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050-2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016JV\u00107\u001a\b\u0012\u0004\u0012\u00020\u00050/2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170#2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010(\u001a\u00020)2\u0006\u0010&\u001a\u00020'H\u0002J4\u00108\u001a\u00020\n2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00050!2\u0006\u0010$\u001a\u00020\u0010H\u0002J<\u00109\u001a\b\u0012\u0004\u0012\u00020\u00050/*\b\u0012\u0004\u0012\u00020\u00050/2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00100#2\u0006\u0010:\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0002J>\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00050/*\b\u0012\u0004\u0012\u00020\u00050/2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170#2\u0006\u0010&\u001a\u00020'2\u0006\u0010<\u001a\u00020=H\u0002J\u0018\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00050/*\b\u0012\u0004\u0012\u00020\u00050/H\u0002J6\u0010?\u001a\b\u0012\u0004\u0012\u00020\u00050/*\b\u0012\u0004\u0012\u00020\u00050/2\u0014\u0010\u001f\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00170#2\u0006\u0010@\u001a\u00020\u0010H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter;", "Lcom/intellij/codeInsight/completion/CompletionFinalSorter;", "()V", "cachedScore", "", "Lcom/intellij/codeInsight/lookup/LookupElement;", "Lcom/intellij/completion/ml/sorting/ItemRankInfo;", "reorderOnlyTopItems", "", "calculateAdditionalFeaturesTo", "", "additionalMap", "", "", "lookupElement", "oldQueryLength", "", "prefixLength", "position", "itemsCount", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "calculateElementScore", "", "ranker", "Lcom/intellij/completion/ml/sorting/RankingModelWrapper;", "element", "features", "Lcom/intellij/completion/ml/sorting/RankingFeatures;", "(Lcom/intellij/completion/ml/sorting/RankingModelWrapper;Lcom/intellij/codeInsight/lookup/LookupElement;ILcom/intellij/completion/ml/sorting/RankingFeatures;I)Ljava/lang/Double;", "calculateScores", "element2score", "items", "", "positionsBefore", "", "queryLength", "prefix", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupStorage", "Lcom/intellij/completion/ml/storage/MutableLookupStorage;", "getCachedRankInfo", "getRelevanceObjects", "Lcom/intellij/openapi/util/Pair;", "", "hasUnknownFeatures", "", "isCacheValid", "overrideElementFeaturesIfNeeded", "Lcom/intellij/completion/ml/sorting/ElementFeatures;", "elementFeatures", "language", "Lcom/intellij/lang/Language;", "sort", "sortByMlScores", "tryFillFromCache", "addDiagnosticsIfNeeded", "reordered", "markRelevantItemsIfNeeded", "decoratingItemsPolicy", "Lcom/intellij/internal/ml/completion/DecoratingItemsPolicy;", "removeDuplicatesIfNeeded", "reorderByMLScores", "toReorder", "Companion", "MeaningfulFeaturesExtractor", "ModelTimeTracker", "intellij.completionMlRanking"})
public final class MLSorter
extends CompletionFinalSorter {
    private final Map<LookupElement, ItemRankInfo> cachedScore = new IdentityHashMap();
    private final boolean reorderOnlyTopItems = Registry.is((String)"completion.ml.reorder.only.top.items", (boolean)true);
    @Deprecated
    private static final Logger LOG;
    @Deprecated
    private static final int REORDER_ONLY_TOP_K = 5;
    @NotNull
    private static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<LookupElement, List<com.intellij.openapi.util.Pair<String, Object>>> getRelevanceObjects(@NotNull Iterable<? extends LookupElement> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        if (this.cachedScore.isEmpty()) {
            void $this$associateTo$iv$iv;
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object t : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = (LookupElement)t;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"NONE")));
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (this.hasUnknownFeatures(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"UNDEFINED")));
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        if (!this.isCacheValid(items)) {
            Iterable<? extends LookupElement> $this$associate$iv = items;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
            Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (LookupElement lookupElement : $this$associateTo$iv$iv) {
                Map map = destination$iv$iv;
                LookupElement it = lookupElement;
                boolean bl = false;
                it = TuplesKt.to((Object)it, (Object)CollectionsKt.listOf((Object)com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)"INVALID_CACHE")));
                map.put(it.getFirst(), it.getSecond());
            }
            return destination$iv$iv;
        }
        Iterable<? extends LookupElement> $this$associate$iv = items;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault($this$associate$iv, (int)10)), (int)16);
        Iterable<? extends LookupElement> $this$associateTo$iv$iv = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (LookupElement lookupElement : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            LookupElement it = lookupElement;
            boolean bl = false;
            List result = new ArrayList();
            ItemRankInfo cached = this.cachedScore.get(it);
            if (cached != null) {
                com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)"ml_rank", (Object)cached.getMlRank());
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"Pair.create(FeatureUtils.ML_RANK, cached.mlRank)");
                result.add(pair);
                com.intellij.openapi.util.Pair pair2 = com.intellij.openapi.util.Pair.create((Object)"before_rerank_order", (Object)cached.getPositionBefore());
                Intrinsics.checkNotNullExpressionValue((Object)pair2, (String)"Pair.create(FeatureUtils\u2026R, cached.positionBefore)");
                result.add(pair2);
            }
            Pair pair = TuplesKt.to((Object)it, (Object)result);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isCacheValid(Iterable<? extends LookupElement> items) {
        void $this$mapTo$iv$iv;
        Iterable<? extends LookupElement> $this$map$iv = items;
        boolean $i$f$map = false;
        Iterable<? extends LookupElement> iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LookupElement lookupElement = (LookupElement)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ItemRankInfo itemRankInfo = this.cachedScore.get(it);
            Integer n = itemRankInfo != null ? Integer.valueOf(itemRankInfo.getPrefixLength()) : null;
            collection.add(n);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv)).size() == 1;
    }

    private final boolean hasUnknownFeatures(Iterable<? extends LookupElement> items) {
        boolean bl;
        block3: {
            Iterable<? extends LookupElement> $this$any$iv = items;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<? extends LookupElement> iterator = $this$any$iv.iterator();
                while (iterator.hasNext()) {
                    ItemRankInfo score2;
                    LookupElement element$iv;
                    LookupElement it = element$iv = iterator.next();
                    boolean bl2 = false;
                    ItemRankInfo itemRankInfo = score2 = this.cachedScore.get(it);
                    if (!((itemRankInfo != null ? itemRankInfo.getMlRank() : null) == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Iterable<LookupElement> sort(@NotNull Iterable<? extends LookupElement> items, @NotNull CompletionParameters parameters) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (!(lookupEx instanceof LookupImpl)) {
            lookupEx = null;
        }
        LookupImpl lookupImpl = (LookupImpl)lookupEx;
        if (lookupImpl == null) {
            return items;
        }
        LookupImpl lookup = lookupImpl;
        MutableLookupStorage mutableLookupStorage = MutableLookupStorage.Companion.get(lookup);
        if (mutableLookupStorage == null) {
            return items;
        }
        MutableLookupStorage lookupStorage = mutableLookupStorage;
        if (!lookupStorage.shouldComputeFeatures()) {
            return items;
        }
        long startedTimestamp = System.currentTimeMillis();
        int queryLength = LookupExtensionsKt.queryLength(lookup);
        String prefix = LookupExtensionsKt.prefix((Lookup)lookup);
        Map element2score = new LinkedHashMap();
        List elements = CollectionsKt.toList(items);
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)elements);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map positionsBefore = destination$iv$iv;
        this.tryFillFromCache(element2score, elements, queryLength);
        List itemsForScoring = element2score.size() == elements.size() ? CollectionsKt.emptyList() : elements;
        this.calculateScores(element2score, itemsForScoring, positionsBefore, queryLength, prefix, lookup, lookupStorage, parameters);
        Iterable<LookupElement> finalRanking = this.sortByMlScores(elements, element2score, positionsBefore, lookupStorage, lookup);
        lookupStorage.getPerformanceTracker().sortingPerformed(itemsForScoring.size(), System.currentTimeMillis() - startedTimestamp);
        return finalRanking;
    }

    /*
     * WARNING - void declaration
     */
    private final void tryFillFromCache(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, int queryLength) {
        boolean bl = false;
        for (LookupElement element : (Iterable)items) {
            void position;
            ItemRankInfo cachedInfo = this.getCachedRankInfo(element, queryLength, (int)position);
            if (cachedInfo == null) {
                return;
            }
            element2score.put(element, cachedInfo.getMlRank());
            ++position;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateScores(Map<LookupElement, Double> element2score, List<? extends LookupElement> items, Map<LookupElement, Integer> positionsBefore, int queryLength, String prefix, LookupImpl lookup, MutableLookupStorage lookupStorage, CompletionParameters parameters) {
        if (items.isEmpty()) {
            return;
        }
        RankingModelWrapper rankingModel = lookupStorage.getModel();
        Project project = lookup.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"lookup.project");
        lookupStorage.initUserFactors(project);
        MeaningfulFeaturesExtractor meaningfulRelevanceExtractor = new MeaningfulFeaturesExtractor();
        Map map = lookup.getRelevanceObjects((Iterable)items, false);
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"lookup.getRelevanceObjects(items, false)");
        Map relevanceObjects = map;
        List calculatedElementFeatures = new ArrayList();
        for (LookupElement lookupElement : items) {
            void relevance;
            int position = ((Number)MapsKt.getValue(positionsBefore, (Object)lookupElement)).intValue();
            List list = relevanceObjects.getOrDefault(lookupElement, CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"relevanceObjects.getOrDe\u2026ult(element, emptyList())");
            Pair<Map<String, Object>, Map<String, Object>> pair = RelevanceUtil.INSTANCE.asRelevanceMaps(list);
            Map map2 = (Map)pair.component1();
            Map additional = (Map)pair.component2();
            SessionFactorsUtils.INSTANCE.saveElementFactorsTo(additional, lookupStorage, lookupElement);
            this.calculateAdditionalFeaturesTo(additional, lookupElement, queryLength, prefix.length(), position, items.size(), parameters);
            lookupStorage.getPerformanceTracker().trackElementFeaturesCalculation("prefix", (Function0)new Function0<Unit>(lookupElement, prefix, additional){
                final /* synthetic */ LookupElement $element;
                final /* synthetic */ String $prefix;
                final /* synthetic */ Map $additional;

                public final void invoke() {
                    String string = this.$element.getLookupString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.lookupString");
                    PrefixMatchingUtil.INSTANCE.calculateFeatures(string, this.$prefix, this.$additional);
                }
                {
                    this.$element = lookupElement;
                    this.$prefix = string;
                    this.$additional = map;
                    super(0);
                }
            });
            meaningfulRelevanceExtractor.processFeatures((Map<String, ? extends Object>)relevance);
            calculatedElementFeatures.add(new ElementFeatures((Map<String, Object>)relevance, additional));
        }
        Map map3 = new LinkedHashMap();
        for (LookupFeatureProvider elementFeatureProvider : LookupFeatureProvider.forLanguage(lookupStorage.getLanguage())) {
            Object features2;
            Intrinsics.checkNotNullExpressionValue(elementFeatureProvider.calculateFeatures(calculatedElementFeatures), (String)"elementFeatureProvider.c\u2026alculatedElementFeatures)");
            map3.putAll(features2);
        }
        Map additionalContextFeatures = new LinkedHashMap();
        for (AdditionalContextFeatureProvider contextFeatureProvider : AdditionalContextFeatureProvider.forLanguage(lookupStorage.getLanguage())) {
            Map<String, String> features3;
            Intrinsics.checkNotNullExpressionValue(contextFeatureProvider.calculateFeatures(lookupStorage.getContextFactors()), (String)"contextFeatureProvider.c\u2026upStorage.contextFactors)");
            additionalContextFeatures.putAll(features3);
        }
        Map contextFactors = MapsKt.plus(lookupStorage.getContextFactors(), (Map)additionalContextFeatures);
        Map<String, Object> commonSessionFactors = SessionFactorsUtils.INSTANCE.updateSessionFactors(lookupStorage, items);
        Set<String> meaningfulRelevance = meaningfulRelevanceExtractor.meaningfulFeatures();
        RankingFeatures features4 = new RankingFeatures(lookupStorage.getUserFactors(), contextFactors, commonSessionFactors, map3, meaningfulRelevance);
        ModelTimeTracker tracker = new ModelTimeTracker();
        boolean bl = false;
        for (LookupElement element : (Iterable)items) {
            void relevance;
            void i;
            ElementFeatures elementFeatures = this.overrideElementFeaturesIfNeeded((ElementFeatures)calculatedElementFeatures.get((int)i), lookupStorage.getLanguage());
            Map<String, Object> map4 = elementFeatures.component1();
            Map<String, Object> additional = elementFeatures.component2();
            Double score2 = tracker.measure((Function0<Double>)((Function0)new Function0<Double>(this, positionsBefore, element, features4, (Map)relevance, additional, rankingModel, queryLength){
                final /* synthetic */ MLSorter this$0;
                final /* synthetic */ Map $positionsBefore;
                final /* synthetic */ LookupElement $element;
                final /* synthetic */ RankingFeatures $features;
                final /* synthetic */ Map $relevance;
                final /* synthetic */ Map $additional;
                final /* synthetic */ RankingModelWrapper $rankingModel;
                final /* synthetic */ int $queryLength;

                @Nullable
                public final Double invoke() {
                    int position = ((Number)MapsKt.getValue((Map)this.$positionsBefore, (Object)this.$element)).intValue();
                    RankingFeatures elementFeatures = this.$features.withElementFeatures(this.$relevance, this.$additional);
                    return MLSorter.access$calculateElementScore(this.this$0, this.$rankingModel, this.$element, position, elementFeatures, this.$queryLength);
                }
                {
                    this.this$0 = mLSorter;
                    this.$positionsBefore = map;
                    this.$element = lookupElement;
                    this.$features = rankingFeatures;
                    this.$relevance = map2;
                    this.$additional = map3;
                    this.$rankingModel = rankingModelWrapper;
                    this.$queryLength = n;
                    super(0);
                }
            }));
            element2score.put(element, score2);
            additional.putAll((Map<String, Object>)relevance);
            lookupStorage.fireElementScored(element, additional, score2);
            ++i;
        }
        tracker.finished(lookupStorage.getPerformanceTracker());
    }

    /*
     * WARNING - void declaration
     */
    private final ElementFeatures overrideElementFeaturesIfNeeded(ElementFeatures elementFeatures, Language language) {
        for (RankingFeaturesOverrides it : RankingFeaturesOverrides.Companion.forLanguage(language)) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string;
            Collection<String> collection;
            Collection destination$iv$iv;
            Logger logger;
            Map<String, Object> overrides = it.getMlElementFeaturesOverrides(elementFeatures.getAdditional());
            elementFeatures.getAdditional().putAll(overrides);
            Map<String, Object> map = overrides;
            if (!map.isEmpty()) {
                void $this$mapTo$iv$iv2;
                void $this$map$iv2;
                map = overrides;
                logger = LOG;
                boolean $i$f$map = false;
                void var8_9 = $this$map$iv2;
                destination$iv$iv = new ArrayList($this$map$iv2.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv2.entrySet().iterator();
                while (iterator.hasNext()) {
                    void it2;
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    collection = destination$iv$iv;
                    boolean bl = false;
                    string = (String)it2.getKey();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                logger.debug("The next ML features was overridden: [" + CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null) + "]");
            }
            Map<String, Object> relevanceOverrides = it.getDefaultWeigherFeaturesOverrides(elementFeatures.getRelevance());
            elementFeatures.getRelevance().putAll(relevanceOverrides);
            Map<String, Object> $i$f$map = relevanceOverrides;
            if (!(!$i$f$map.isEmpty())) continue;
            $i$f$map = relevanceOverrides;
            logger = LOG;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it3;
                Map.Entry item$iv$iv;
                Map.Entry bl = item$iv$iv = iterator.next();
                collection = destination$iv$iv2;
                boolean bl2 = false;
                string = (String)it3.getKey();
                collection.add(string);
            }
            collection = (List)destination$iv$iv2;
            logger.debug("The next default weigher features was overridden: [" + CollectionsKt.joinToString$default((Iterable)collection, null, null, null, (int)0, null, null, (int)63, null) + "]");
        }
        return elementFeatures;
    }

    private final Iterable<LookupElement> sortByMlScores(List<? extends LookupElement> items, Map<LookupElement, Double> element2score, Map<LookupElement, Integer> positionsBefore, MutableLookupStorage lookupStorage, LookupImpl lookup) {
        boolean shouldSort;
        boolean bl;
        block6: {
            Iterable $this$none$iv = element2score.values();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    Double it = (Double)element$iv;
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        boolean bl3 = shouldSort = bl && lookupStorage.shouldReRank();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ML sorting in completion used=" + shouldSort + " for language=" + lookupStorage.getLanguage().getID());
        }
        if (shouldSort) {
            lookupStorage.fireReorderedUsingMLScores();
            RankingModelWrapper rankingModelWrapper = lookupStorage.getModel();
            if (rankingModelWrapper == null || (rankingModelWrapper = rankingModelWrapper.decoratingPolicy()) == null) {
                rankingModelWrapper = DecoratingItemsPolicy.Companion.getDISABLED();
            }
            RankingModelWrapper decoratingItemsPolicy = rankingModelWrapper;
            int topItemsCount = this.reorderOnlyTopItems ? 5 : Integer.MAX_VALUE;
            return this.addDiagnosticsIfNeeded(this.markRelevantItemsIfNeeded(this.reorderByMLScores((Iterable<? extends LookupElement>)items, element2score, topItemsCount), element2score, lookup, (DecoratingItemsPolicy)decoratingItemsPolicy), positionsBefore, topItemsCount, lookup);
        }
        return items;
    }

    private final void calculateAdditionalFeaturesTo(Map<String, Object> additionalMap, LookupElement lookupElement, int oldQueryLength, int prefixLength, int position, int itemsCount, CompletionParameters parameters) {
        additionalMap.put("position", position);
        additionalMap.put("relative_position", (double)position / (double)itemsCount);
        additionalMap.put("query_length", oldQueryLength);
        additionalMap.put("prefix_length", prefixLength);
        additionalMap.put("result_length", lookupElement.getLookupString().length());
        additionalMap.put("auto_popup", parameters.isAutoPopup());
        additionalMap.put("completion_type", parameters.getCompletionType().toString());
        additionalMap.put("invocation_count", parameters.getInvocationCount());
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> reorderByMLScores(Iterable<? extends LookupElement> $this$reorderByMLScores, Map<LookupElement, Double> element2score, int toReorder) {
        void $this$sortedByDescending$iv;
        Iterable<? extends LookupElement> iterable = $this$reorderByMLScores;
        boolean $i$f$sortedByDescending = false;
        LinkedHashSet result = (LinkedHashSet)CollectionsKt.toCollection((Iterable)CollectionsKt.take(this.removeDuplicatesIfNeeded(CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(element2score){
            final /* synthetic */ Map $element2score$inlined;
            {
                this.$element2score$inlined = map;
            }

            public final int compare(T a, T b) {
                LookupElement it = (LookupElement)b;
                boolean bl = false;
                Comparable comparable = (Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it);
                it = (LookupElement)a;
                Comparable comparable2 = comparable;
                bl = false;
                Double d = (Double)MapsKt.getValue((Map)this.$element2score$inlined, (Object)it);
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
            }
        })), (int)toReorder), (Collection)new LinkedHashSet());
        CollectionsKt.addAll((Collection)result, $this$reorderByMLScores);
        return result;
    }

    private final Iterable<LookupElement> removeDuplicatesIfNeeded(Iterable<? extends LookupElement> $this$removeDuplicatesIfNeeded) {
        Iterable iterable;
        if (Registry.is((String)"completion.ml.reorder.without.duplicates", (boolean)false)) {
            Iterable $this$distinctBy$iv = $this$removeDuplicatesIfNeeded;
            boolean $i$f$distinctBy = false;
            HashSet<String> set$iv = new HashSet<String>();
            ArrayList<LookupElement> list$iv = new ArrayList<LookupElement>();
            Iterator<LookupElement> iterator = $this$distinctBy$iv.iterator();
            while (iterator.hasNext()) {
                LookupElement e$iv;
                LookupElement it = e$iv = iterator.next();
                boolean bl = false;
                String key$iv = it.getLookupString();
                if (!set$iv.add(key$iv)) continue;
                list$iv.add(e$iv);
            }
            iterable = list$iv;
        } else {
            iterable = $this$removeDuplicatesIfNeeded;
        }
        return iterable;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> addDiagnosticsIfNeeded(Iterable<? extends LookupElement> $this$addDiagnosticsIfNeeded, Map<LookupElement, Integer> positionsBefore, int reordered, LookupImpl lookup) {
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        if (completionMLRankingSettings.isShowDiffEnabled()) {
            boolean positionChanged = false;
            Iterable<LookupElement> $this$forEachIndexed$iv = $this$addDiagnosticsIfNeeded;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (LookupElement item$iv : $this$forEachIndexed$iv) {
                void element;
                int n = index$iv;
                index$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LookupElement lookupElement = item$iv;
                int position = n;
                boolean bl = false;
                int before = ((Number)MapsKt.getValue(positionsBefore, (Object)element)).intValue();
                if (before >= reordered && position >= reordered) continue;
                int diff = position - before;
                positionChanged = positionChanged || diff != 0;
                ItemsDecoratorInitializer.Companion.itemPositionChanged((LookupElement)element, diff);
            }
            ItemsDecoratorInitializer.Companion.markAsReordered(lookup, positionChanged);
        }
        return $this$addDiagnosticsIfNeeded;
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<LookupElement> markRelevantItemsIfNeeded(Iterable<? extends LookupElement> $this$markRelevantItemsIfNeeded, Map<LookupElement, Double> element2score, LookupImpl lookup, DecoratingItemsPolicy decoratingItemsPolicy) {
        CompletionMLRankingSettings completionMLRankingSettings = CompletionMLRankingSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)completionMLRankingSettings, (String)"CompletionMLRankingSettings.getInstance()");
        if (completionMLRankingSettings.isDecorateRelevantEnabled()) {
            Collection<Double> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable<LookupElement> iterable = $this$markRelevantItemsIfNeeded;
            DecoratingItemsPolicy decoratingItemsPolicy2 = decoratingItemsPolicy;
            boolean $i$f$map = false;
            void var8_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LookupElement lookupElement = (LookupElement)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Double d = element2score.get(it);
                Double d2 = d != null ? d : 0.0;
                collection.add(d2);
            }
            collection = (List)destination$iv$iv;
            Set relevantItems = decoratingItemsPolicy2.itemsToDecorate((Iterable)collection);
            Iterator iterator = relevantItems.iterator();
            while (iterator.hasNext()) {
                int index = ((Number)iterator.next()).intValue();
                ItemsDecoratorInitializer.Companion.markAsRelevant(lookup, (LookupElement)CollectionsKt.elementAt($this$markRelevantItemsIfNeeded, (int)index));
            }
        }
        return $this$markRelevantItemsIfNeeded;
    }

    private final ItemRankInfo getCachedRankInfo(LookupElement element, int prefixLength, int position) {
        ItemRankInfo cached = this.cachedScore.get(element);
        if (cached != null && prefixLength == cached.getPrefixLength() && cached.getPositionBefore() == position) {
            return cached;
        }
        return null;
    }

    private final Double calculateElementScore(RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        Double mlRank = ranker != null && ranker.canScore(features2) ? ranker.score(features2) : null;
        ItemRankInfo info = new ItemRankInfo(position, mlRank, prefixLength);
        this.cachedScore.put(element, info);
        return info.getMlRank();
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MLSorter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    public static final /* synthetic */ Double access$calculateElementScore(MLSorter $this, RankingModelWrapper ranker, LookupElement element, int position, RankingFeatures features2, int prefixLength) {
        return $this.calculateElementScore(ranker, element, position, features2, prefixLength);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u001a\u0010\n\u001a\u00020\u000b2\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\rR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter$MeaningfulFeaturesExtractor;", "", "()V", "meaningful", "", "", "values", "", "meaningfulFeatures", "", "processFeatures", "", "features", "", "intellij.completionMlRanking"})
    private static final class MeaningfulFeaturesExtractor {
        private final Set<String> meaningful = new LinkedHashSet();
        private final Map<String, Object> values = new LinkedHashMap();

        public final void processFeatures(@NotNull Map<String, ? extends Object> features2) {
            Intrinsics.checkNotNullParameter(features2, (String)"features");
            Object object = features2;
            for (Map.Entry<String, ? extends Object> feature : object.entrySet()) {
                object = this.values.get(feature.getKey());
                if (object == null) {
                    this.values.put(feature.getKey(), feature.getValue());
                    continue;
                }
                if (Intrinsics.areEqual((Object)object, (Object)feature.getValue())) continue;
                this.meaningful.add(feature.getKey());
            }
        }

        @NotNull
        public final Set<String> meaningfulFeatures() {
            return this.meaningful;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u0004\u0018\u00010\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000e\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter$ModelTimeTracker;", "", "()V", "itemsScored", "", "timeSpent", "", "finished", "", "performanceTracker", "Lcom/intellij/completion/ml/performance/CompletionPerformanceTracker;", "measure", "", "scoringFun", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Double;", "intellij.completionMlRanking"})
    private static final class ModelTimeTracker {
        private int itemsScored;
        private long timeSpent;

        @Nullable
        public final Double measure(@NotNull Function0<Double> scoringFun) {
            Intrinsics.checkNotNullParameter(scoringFun, (String)"scoringFun");
            long start = System.nanoTime();
            Double result = (Double)scoringFun.invoke();
            if (result != null) {
                ++this.itemsScored;
                this.timeSpent += System.nanoTime() - start;
            }
            return result;
        }

        public final void finished(@NotNull CompletionPerformanceTracker performanceTracker) {
            Intrinsics.checkNotNullParameter((Object)performanceTracker, (String)"performanceTracker");
            if (this.itemsScored != 0) {
                performanceTracker.itemsScored(this.itemsScored, TimeUnit.NANOSECONDS.toMillis(this.timeSpent));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/completion/ml/sorting/MLSorter$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "REORDER_ONLY_TOP_K", "", "intellij.completionMlRanking"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

