/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.config;

import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.cli.Option;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;

@Nullable
public class MavenConfig {
    private final Map<String, Option> optionMap;
    private final String baseDir;

    public MavenConfig(@NotNull Map<String, Option> map, @NotNull String dir2) {
        if (map == null) {
            MavenConfig.$$$reportNull$$$0(0);
        }
        if (dir2 == null) {
            MavenConfig.$$$reportNull$$$0(1);
        }
        this.optionMap = Objects.requireNonNull(map);
        this.baseDir = Objects.requireNonNull(dir2);
    }

    public boolean hasOption(@NotNull MavenConfigSettings configSetting) {
        if (configSetting == null) {
            MavenConfig.$$$reportNull$$$0(2);
        }
        return this.optionMap.containsKey(configSetting.key);
    }

    public String getOptionValue(@NotNull MavenConfigSettings configSetting) {
        Option option;
        if (configSetting == null) {
            MavenConfig.$$$reportNull$$$0(3);
        }
        return (option = this.optionMap.get(configSetting.key)) == null ? null : option.getValue();
    }

    public MavenExecutionOptions.FailureMode getFailureMode() {
        if (this.hasOption(MavenConfigSettings.FAIL_NEVER)) {
            return MavenExecutionOptions.FailureMode.NEVER;
        }
        if (this.hasOption(MavenConfigSettings.FAIL_AT_END)) {
            return MavenExecutionOptions.FailureMode.AT_END;
        }
        if (this.hasOption(MavenConfigSettings.FAIL_FAST)) {
            return MavenExecutionOptions.FailureMode.FAST;
        }
        return null;
    }

    public MavenExecutionOptions.ChecksumPolicy getChecksumPolicy() {
        if (this.hasOption(MavenConfigSettings.CHECKSUM_WARNING_POLICY)) {
            return MavenExecutionOptions.ChecksumPolicy.WARN;
        }
        if (this.hasOption(MavenConfigSettings.CHECKSUM_FAILURE_POLICY)) {
            return MavenExecutionOptions.ChecksumPolicy.FAIL;
        }
        return null;
    }

    public MavenExecutionOptions.LoggingLevel getOutputLevel() {
        if (this.hasOption(MavenConfigSettings.QUIET)) {
            return MavenExecutionOptions.LoggingLevel.DISABLED;
        }
        if (this.hasOption(MavenConfigSettings.DEBUG)) {
            return MavenExecutionOptions.LoggingLevel.DEBUG;
        }
        return null;
    }

    public String getFilePath(@NotNull MavenConfigSettings configSetting) {
        Option option;
        if (configSetting == null) {
            MavenConfig.$$$reportNull$$$0(4);
        }
        if ((option = this.optionMap.get(configSetting.key)) == null) {
            return null;
        }
        File file = new File(option.getValue());
        if (file.isAbsolute() && file.exists()) {
            return option.getValue();
        }
        file = new File(this.baseDir, option.getValue());
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }

    public boolean isEmpty() {
        return this.optionMap.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configSetting";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/config/MavenConfig";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "hasOption";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionValue";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFilePath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

