/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.navigation;

import com.intellij.psi.PsiElement;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementNavigationProvider;
import org.jetbrains.idea.maven.dom.MavenDomElement;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencyManagement;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPluginManagement;

public class MavenGotoSuperHandler
extends DomElementNavigationProvider {
    public String getProviderName() {
        return "MAVEN_GOTO_SUPER";
    }

    public void navigate(DomElement domElement, boolean requestFocus) {
        MavenDomElement target = null;
        if (domElement instanceof MavenDomDependency) {
            target = MavenDomProjectProcessorUtils.searchManagingDependency((MavenDomDependency)domElement);
        } else if (domElement instanceof MavenDomPlugin) {
            target = MavenDomProjectProcessorUtils.searchManagingPlugin((MavenDomPlugin)domElement);
        } else if (domElement instanceof MavenDomParent) {
            target = MavenDomProjectProcessorUtils.findParent((MavenDomParent)domElement, domElement.getManager().getProject());
        }
        if (target != null) {
            PsiNavigateUtil.navigate((PsiElement)target.getXmlTag(), (boolean)requestFocus);
        }
    }

    public boolean canNavigate(DomElement domElement) {
        return domElement instanceof MavenDomDependency && domElement.getParentOfType(MavenDomDependencyManagement.class, false) == null || domElement instanceof MavenDomPlugin && domElement.getParentOfType(MavenDomPluginManagement.class, false) == null || domElement instanceof MavenDomParent;
    }
}

