/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.vfs.LocalFileSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenArtifactUtilKt;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenUtil;

public abstract class MavenProjectImporterBase
implements MavenProjectImporter {
    private static final Logger LOG = Logger.getInstance(MavenProjectImporterBase.class);
    protected final MavenProjectsTree myProjectsTree;
    protected final MavenImportingSettings myImportingSettings;
    protected volatile Map<MavenProject, MavenProjectChanges> myProjectsToImportWithChanges;

    public MavenProjectImporterBase(MavenProjectsTree projectsTree, MavenImportingSettings importingSettings, Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges) {
        this.myProjectsTree = projectsTree;
        this.myImportingSettings = importingSettings;
        this.myProjectsToImportWithChanges = projectsToImportWithChanges;
    }

    protected Set<MavenProject> selectProjectsToImport(Collection<MavenProject> originalProjects) {
        HashSet<MavenProject> result = new HashSet<MavenProject>();
        for (MavenProject each : originalProjects) {
            if (!this.shouldCreateModuleFor(each)) continue;
            result.add(each);
        }
        return result;
    }

    protected boolean shouldCreateModuleFor(MavenProject project2) {
        if (this.myProjectsTree.isIgnored(project2)) {
            return false;
        }
        return !project2.isAggregator() || this.myImportingSettings.isCreateModulesForAggregators();
    }

    protected void scheduleRefreshResolvedArtifacts(List<MavenProjectsProcessorTask> postTasks) {
        ArrayList<MavenArtifact> artifacts = new ArrayList<MavenArtifact>();
        for (MavenProject each : this.myProjectsToImportWithChanges.keySet()) {
            artifacts.addAll(each.getDependencies());
        }
        HashSet<File> files = new HashSet<File>();
        for (MavenArtifact each : artifacts) {
            if (!MavenArtifactUtilKt.resolved(each)) continue;
            files.add(each.getFile());
        }
        if (MavenUtil.isMavenUnitTestModeEnabled()) {
            MavenProjectImporterBase.doRefreshFiles(files);
        } else {
            postTasks.add(new RefreshingFilesTask(files));
        }
    }

    protected boolean projectsToImportHaveChanges() {
        for (MavenProjectChanges each : this.myProjectsToImportWithChanges.values()) {
            if (!each.hasChanges()) continue;
            return true;
        }
        return false;
    }

    protected static void configureMavenProjectsInBackground(@NotNull Collection<MavenProject> projects, @NotNull Map<MavenProject, Module> mavenProjectToModule, @NotNull Project project2) {
        if (projects == null) {
            MavenProjectImporterBase.$$$reportNull$$$0(0);
        }
        if (mavenProjectToModule == null) {
            MavenProjectImporterBase.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            MavenProjectImporterBase.$$$reportNull$$$0(2);
        }
        if (MavenUtil.isLinearImportEnabled()) {
            return;
        }
        MavenUtil.runInBackground(project2, MavenProjectBundle.message("command.name.configuring.projects", new Object[0]), false, indicator -> MavenProjectImporterBase.configureMavenProjects(projects, mavenProjectToModule, project2, indicator));
    }

    @IntellijInternalApi
    @ApiStatus.Internal
    public static void configureMavenProjects(@NotNull Collection<MavenProject> projects, @NotNull Map<MavenProject, Module> mavenProjectToModule, @NotNull Project project2, MavenProgressIndicator indicator) {
        if (projects == null) {
            MavenProjectImporterBase.$$$reportNull$$$0(3);
        }
        if (mavenProjectToModule == null) {
            MavenProjectImporterBase.$$$reportNull$$$0(4);
        }
        if (project2 == null) {
            MavenProjectImporterBase.$$$reportNull$$$0(5);
        }
        List<MavenModuleConfigurer> configurers = MavenModuleConfigurer.getConfigurers();
        float count = 0.0f;
        long startTime = System.currentTimeMillis();
        LOG.info("[maven import] applying " + configurers.size() + " configurers to " + projects.size() + " Maven projects");
        for (MavenProject mavenProject2 : projects) {
            Module module = mavenProjectToModule.get(mavenProject2);
            if (module == null) continue;
            float f = count;
            count = f + 1.0f;
            indicator.setFraction(f / (float)projects.size());
            indicator.setText2(MavenProjectBundle.message("progress.details.configuring.module", module.getName()));
            for (MavenModuleConfigurer configurer : configurers) {
                configurer.configure(mavenProject2, project2, module);
            }
        }
        LOG.info("[maven import] configuring projects took " + (System.currentTimeMillis() - startTime) + "ms");
    }

    protected static void doRefreshFiles(Set<File> files) {
        LocalFileSystem.getInstance().refreshIoFiles(files);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProjectToModule";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/importing/MavenProjectImporterBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureMavenProjectsInBackground";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "configureMavenProjects";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected static class RefreshingFilesTask
    implements MavenProjectsProcessorTask {
        private final Set<File> myFiles;

        protected RefreshingFilesTask(Set<File> files) {
            this.myFiles = files;
        }

        @Override
        public void perform(Project project2, MavenEmbeddersManager embeddersManager, MavenConsole console2, MavenProgressIndicator indicator) {
            indicator.setText(MavenProjectBundle.message("progress.text.refreshing.files", new Object[0]));
            MavenProjectImporterBase.doRefreshFiles(this.myFiles);
        }
    }
}

