/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.tree;

import com.intellij.compiler.impl.javaCompiler.javac.JavacConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.ExternalSystemModulePropertyManager;
import com.intellij.openapi.externalSystem.model.project.ProjectCoordinate;
import com.intellij.openapi.externalSystem.model.project.ProjectId;
import com.intellij.openapi.externalSystem.service.project.ExternalSystemModulePropertyManagerBridge;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProviderImpl;
import com.intellij.openapi.externalSystem.service.project.ProjectDataManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.workspaceModel.ide.WorkspaceModel;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorage;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.MavenProjectImporterBase;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapterLegacyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxy;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyImpl;
import org.jetbrains.idea.maven.importing.ModifiableModelsProviderProxyWrapper;
import org.jetbrains.idea.maven.importing.ModuleModelProxy;
import org.jetbrains.idea.maven.importing.configurers.MavenModuleConfigurer;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportContext;
import org.jetbrains.idea.maven.importing.tree.MavenModuleImportData;
import org.jetbrains.idea.maven.importing.tree.MavenModuleType;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportContextProvider;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;

public class MavenProjectTreeImporter
extends MavenProjectImporterBase {
    private static final Logger LOG = Logger.getInstance(MavenProjectTreeImporter.class);
    private final Project myProject;
    private final ModifiableModelsProviderProxy myModelsProvider;
    private final ModuleModelProxy myModuleModel;
    private final MavenProjectImportContextProvider contextProvider;
    private volatile MavenModuleImportContext myContext;

    public MavenProjectTreeImporter(@NotNull Project p, @NotNull MavenProjectsTree projectsTree, @NotNull Map<MavenProject, MavenProjectChanges> projectsToImportWithChanges, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull MavenImportingSettings importingSettings) {
        if (p == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(0);
        }
        if (projectsTree == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(1);
        }
        if (projectsToImportWithChanges == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(2);
        }
        if (modelsProvider == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(3);
        }
        if (importingSettings == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(4);
        }
        super(projectsTree, importingSettings, projectsToImportWithChanges);
        this.myProject = p;
        this.myModelsProvider = this.getModelProvider(modelsProvider);
        this.myModuleModel = this.myModelsProvider.getModuleModelProxy();
        this.myContext = new MavenModuleImportContext();
        this.contextProvider = new MavenProjectImportContextProvider(p, projectsTree, projectsToImportWithChanges, this.myModuleModel, importingSettings);
    }

    private ModifiableModelsProviderProxy getModelProvider(IdeModifiableModelsProvider modelsProvider) {
        return MavenUtil.newModelEnabled(this.myProject) ? new ModifiableModelsProviderProxyImpl(this.myProject, ((IdeModifiableModelsProviderImpl)modelsProvider).getActualStorageBuilder()) : new ModifiableModelsProviderProxyWrapper(modelsProvider);
    }

    @Override
    @Nullable
    public List<MavenProjectsProcessorTask> importProject() {
        long startTime = System.currentTimeMillis();
        List<MavenProjectsProcessorTask> tasks = this.importProjectTree();
        LOG.info("[maven import] applying models took " + (System.currentTimeMillis() - startTime) + "ms");
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private List<MavenProjectsProcessorTask> importProjectTree() {
        this.myContext = this.contextProvider.getContext();
        boolean hasChanges = false;
        ArrayList<MavenProjectsProcessorTask> postTasks = new ArrayList<MavenProjectsProcessorTask>();
        if (this.myProject.isDisposed()) {
            return null;
        }
        ArrayList<MavenModuleImporter> importers = new ArrayList<MavenModuleImporter>();
        if (this.myContext.hasChanges) {
            hasChanges = true;
            importers.addAll(this.importModules(this.myContext));
            this.scheduleRefreshResolvedArtifacts(postTasks);
        }
        List<Module> obsoleteModules = this.myContext.obsoleteModules;
        boolean isDeleteObsoleteModules = MavenProjectTreeImporter.isDeleteObsoleteModules(obsoleteModules);
        hasChanges |= isDeleteObsoleteModules;
        if (this.myProject.isDisposed()) {
            return null;
        }
        if (hasChanges) {
            MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
                this.setMavenizedModules(obsoleteModules, false);
                if (isDeleteObsoleteModules) {
                    this.deleteModules(obsoleteModules);
                }
                this.removeUnusedProjectLibraries(this.myContext.changedModules);
                this.myModelsProvider.commit();
                if (this.myContext.hasChanges) {
                    this.removeOutdatedCompilerConfigSettings();
                    this.setMavenizedModules(ContainerUtil.map(this.myContext.changedModules, e -> e.getModuleData().getModule()), true);
                }
            }));
            if (!importers.isEmpty()) {
                IdeModifiableModelsProvider provider = ProjectDataManager.getInstance().createModifiableModelsProvider(this.myProject);
                try {
                    ArrayList<MavenModuleImporter> toRun = new ArrayList<MavenModuleImporter>(importers.size());
                    for (MavenModuleImporter importer : importers) {
                        if (importer.isModuleDisposed()) continue;
                        importer.setModifiableModelsProvider(provider);
                        toRun.add(importer);
                    }
                    MavenProjectTreeImporter.configFacets(postTasks, toRun);
                }
                finally {
                    MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> provider.commit()));
                }
            }
            this.configureMavenProjects(this.myContext);
        } else {
            MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.setMavenizedModules(obsoleteModules, false));
            this.disposeModifiableModels();
        }
        return postTasks;
    }

    private static boolean isDeleteObsoleteModules(@NotNull List<Module> obsoleteModules) {
        if (obsoleteModules == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(5);
        }
        return !obsoleteModules.isEmpty();
    }

    private void configureMavenProjects(MavenModuleImportContext moduleImportContext) {
        List<MavenModuleConfigurer> configurers = MavenModuleConfigurer.getConfigurers();
        List<MavenModuleImportData> allModules = moduleImportContext.allModules;
        if (MavenUtil.isLinearImportEnabled()) {
            return;
        }
        MavenUtil.runInBackground(this.myProject, MavenProjectBundle.message("command.name.configuring.projects", new Object[0]), false, indicator -> {
            float count = 0.0f;
            long startTime = System.currentTimeMillis();
            int size = allModules.size();
            LOG.info("[maven import] applying " + configurers.size() + " configurers to " + size + " Maven projects");
            for (MavenModuleImportData importData : allModules) {
                Module module = importData.getModuleData().getModule();
                float f = count;
                count = f + 1.0f;
                indicator.setFraction(f / (float)size);
                indicator.setText2(MavenProjectBundle.message("progress.details.configuring.module", module.getName()));
                for (MavenModuleConfigurer configurer : configurers) {
                    configurer.configure(importData.getMavenProject(), this.myProject, module);
                }
            }
            LOG.info("[maven import] configuring projects took " + (System.currentTimeMillis() - startTime) + "ms");
        });
    }

    private void disposeModifiableModels() {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, () -> this.myModelsProvider.dispose());
    }

    private void deleteModules(@NotNull List<Module> modules2) {
        if (modules2 == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(6);
        }
        for (Module each : modules2) {
            if (each.isDisposed()) continue;
            this.myModuleModel.disposeModule(each);
        }
    }

    private void removeOutdatedCompilerConfigSettings() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        JpsJavaCompilerOptions javacOptions = JavacConfiguration.getOptions((Project)this.myProject, JavacConfiguration.class);
        String options = javacOptions.ADDITIONAL_OPTIONS_STRING;
        javacOptions.ADDITIONAL_OPTIONS_STRING = options = options.replaceFirst("(-target (\\S+))", "");
    }

    private List<MavenModuleImporter> importModules(MavenModuleImportContext moduleImportContext) {
        List<MavenModuleImportData> allModules = moduleImportContext.allModules;
        ArrayList<MavenModuleImporter> importers = new ArrayList<MavenModuleImporter>();
        for (MavenModuleImportData importData : allModules) {
            if (!importData.hasChanges()) {
                importers.add(this.createModuleImporter(importData, moduleImportContext.moduleNameByProject));
                continue;
            }
            MavenProject mavenProject2 = importData.getMavenProject();
            MavenId mavenId = mavenProject2.getMavenId();
            Module module = importData.getModuleData().getModule();
            this.myModelsProvider.registerModulePublication(module, (ProjectCoordinate)new ProjectId(mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion()));
            MavenModuleImporter moduleImporter = this.createModuleImporter(importData, moduleImportContext.moduleNameByProject);
            importers.add(moduleImporter);
            MavenRootModelAdapterLegacyImpl delegate = new MavenRootModelAdapterLegacyImpl(mavenProject2, module, this.myModelsProvider);
            MavenRootModelAdapter rootModelAdapter = new MavenRootModelAdapter(delegate);
            MavenProjectTreeImporter.configModule(importData, moduleImporter, rootModelAdapter);
        }
        return importers;
    }

    private static void configModule(@NotNull MavenModuleImportData importData, @NotNull MavenModuleImporter moduleImporter, @NotNull MavenRootModelAdapter rootModelAdapter) {
        if (importData == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(7);
        }
        if (moduleImporter == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(8);
        }
        if (rootModelAdapter == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(9);
        }
        MavenModuleType type2 = importData.getModuleData().getType();
        rootModelAdapter.init(importData.getModuleData().isNewModule());
        if (type2 == MavenModuleType.AGGREGATOR || type2 == MavenModuleType.MAIN_TEST) {
            moduleImporter.config(rootModelAdapter, importData);
        } else if (type2 == MavenModuleType.AGGREGATOR_MAIN_TEST) {
            moduleImporter.configMainAndTestAggregator(rootModelAdapter, importData);
        } else {
            moduleImporter.configMainAndTest(rootModelAdapter, importData);
        }
    }

    private static void configFacets(List<MavenProjectsProcessorTask> tasks, List<MavenModuleImporter> importers) {
        for (MavenModuleImporter importer : importers) {
            if (importer.isAggregatorMainTestModule()) continue;
            importer.preConfigFacets();
        }
        for (MavenModuleImporter importer : importers) {
            if (importer.isAggregatorMainTestModule()) continue;
            importer.configFacets(tasks);
        }
        for (MavenModuleImporter importer : importers) {
            if (importer.isAggregatorMainTestModule()) continue;
            importer.postConfigFacets();
        }
    }

    private void setMavenizedModules(Collection<Module> modules2, boolean mavenized) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        WorkspaceEntityStorage initialStorage = WorkspaceModel.getInstance((Project)this.myProject).getEntityStorage().getCurrent();
        WorkspaceEntityStorageBuilder storageBuilder = WorkspaceEntityStorageBuilder.from((WorkspaceEntityStorage)initialStorage);
        for (Module module : modules2) {
            if (module.isDisposed()) continue;
            ExternalSystemModulePropertyManager modulePropertyManager = ExternalSystemModulePropertyManager.getInstance((Module)module);
            if (modulePropertyManager instanceof ExternalSystemModulePropertyManagerBridge && module instanceof ModuleBridge && ((ModuleBridge)module).getDiff() == null) {
                ((ExternalSystemModulePropertyManagerBridge)modulePropertyManager).setMavenized(mavenized, storageBuilder);
                continue;
            }
            modulePropertyManager.setMavenized(mavenized);
        }
        WorkspaceModel.getInstance((Project)this.myProject).updateProjectModel(builder -> {
            builder.addDiff((WorkspaceEntityStorageDiffBuilder)storageBuilder);
            return null;
        });
    }

    private MavenModuleImporter createModuleImporter(MavenModuleImportData importData, Map<MavenProject, String> moduleNameByProject) {
        return new MavenModuleImporter(importData.getModuleData().getModule(), this.myProjectsTree, importData.getMavenProject(), importData.getChanges(), moduleNameByProject, this.myImportingSettings, this.myModelsProvider, importData.getModuleData().getType());
    }

    private void removeUnusedProjectLibraries(List<MavenModuleImportData> changedModuleImportData) {
        HashSet unusedLibraries = new HashSet();
        Collections.addAll(unusedLibraries, this.myModelsProvider.getAllLibraries());
        for (ModuleRootModel eachModel : this.collectModuleModels(changedModuleImportData)) {
            for (OrderEntry eachEntry : eachModel.getOrderEntries()) {
                if (!(eachEntry instanceof LibraryOrderEntry)) continue;
                unusedLibraries.remove(((LibraryOrderEntry)eachEntry).getLibrary());
            }
        }
        for (Library each : unusedLibraries) {
            if (MavenProjectTreeImporter.isDisposed(each) || !MavenRootModelAdapter.isMavenLibrary(each) || MavenRootModelAdapter.isChangedByUser(each)) continue;
            this.myModelsProvider.removeLibrary(each);
        }
    }

    private static boolean isDisposed(Library library) {
        return library instanceof LibraryEx && ((LibraryEx)library).isDisposed();
    }

    private Collection<ModuleRootModel> collectModuleModels(List<MavenModuleImportData> changedModuleImportData) {
        HashMap<Module, ModifiableRootModel> rootModels = new HashMap<Module, ModifiableRootModel>();
        for (MavenModuleImportData importData : changedModuleImportData) {
            Module module = importData.getModuleData().getModule();
            ModifiableRootModel rootModel = this.myModelsProvider.getModifiableRootModel(module);
            rootModels.put(module, rootModel);
        }
        for (Module each : this.myModuleModel.getModules()) {
            if (rootModels.containsKey(each)) continue;
            rootModels.put(each, this.myModelsProvider.getModifiableRootModel(each));
        }
        return rootModels.values();
    }

    @Override
    @NotNull
    public List<Module> getCreatedModules() {
        List<Module> list = this.myContext.createdModules;
        if (list == null) {
            MavenProjectTreeImporter.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsTree";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsToImportWithChanges";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelsProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importingSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obsoleteModules";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importData";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleImporter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModelAdapter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/tree/MavenProjectTreeImporter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/tree/MavenProjectTreeImporter";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getCreatedModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isDeleteObsoleteModules";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "deleteModules";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configModule";
                break;
            }
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

