/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.config.MavenConfig;
import org.jetbrains.idea.maven.config.MavenConfigParser;
import org.jetbrains.idea.maven.config.MavenConfigSettings;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.MavenWslUtil;

public class MavenGeneralSettings
implements Cloneable {
    private transient Project myProject;
    private boolean workOffline = false;
    private String mavenHome = "Bundled (Maven 3)";
    private String mavenSettingsFile = "";
    private String overriddenLocalRepository = "";
    private boolean printErrorStackTraces = false;
    private boolean usePluginRegistry = false;
    private boolean nonRecursive = false;
    private boolean alwaysUpdateSnapshots = false;
    private boolean showDialogWithAdvancedSettings = false;
    private boolean useMavenConfig = false;
    private String threads;
    private MavenExecutionOptions.LoggingLevel outputLevel = MavenExecutionOptions.LoggingLevel.INFO;
    MavenExecutionOptions.ChecksumPolicy checksumPolicy = MavenExecutionOptions.ChecksumPolicy.NOT_SET;
    private MavenExecutionOptions.FailureMode failureBehavior = MavenExecutionOptions.FailureMode.NOT_SET;
    private MavenExecutionOptions.PluginUpdatePolicy pluginUpdatePolicy = MavenExecutionOptions.PluginUpdatePolicy.DEFAULT;
    private transient File myEffectiveLocalRepositoryCache;
    private transient File myEffectiveLocalHomeCache;
    private transient VirtualFile myEffectiveSuperPomCache;
    private transient Set<String> myDefaultPluginsCache;
    private transient MavenConfig mavenConfigCache;
    private int myBulkUpdateLevel = 0;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public MavenGeneralSettings() {
    }

    public MavenGeneralSettings(Project project2) {
        this.myProject = project2;
    }

    public void setProject(Project project2) {
        this.myProject = project2;
    }

    public void beginUpdate() {
        ++this.myBulkUpdateLevel;
    }

    public void endUpdate() {
        if (--this.myBulkUpdateLevel == 0) {
            this.changed();
        }
    }

    public void changed() {
        if (this.myBulkUpdateLevel > 0) {
            return;
        }
        this.myEffectiveLocalRepositoryCache = null;
        this.myDefaultPluginsCache = null;
        this.myEffectiveLocalHomeCache = null;
        this.myEffectiveSuperPomCache = null;
        this.mavenConfigCache = null;
        this.fireChanged();
    }

    @Property
    @NotNull
    public MavenExecutionOptions.PluginUpdatePolicy getPluginUpdatePolicy() {
        MavenExecutionOptions.PluginUpdatePolicy pluginUpdatePolicy = this.pluginUpdatePolicy;
        if (pluginUpdatePolicy == null) {
            MavenGeneralSettings.$$$reportNull$$$0(0);
        }
        return pluginUpdatePolicy;
    }

    public void setPluginUpdatePolicy(MavenExecutionOptions.PluginUpdatePolicy value) {
        if (value == null) {
            return;
        }
        this.pluginUpdatePolicy = value;
        this.changed();
    }

    @Property
    @NotNull
    public MavenExecutionOptions.ChecksumPolicy getChecksumPolicy() {
        MavenExecutionOptions.ChecksumPolicy checksumPolicy = this.checksumPolicy;
        if (checksumPolicy == null) {
            MavenGeneralSettings.$$$reportNull$$$0(1);
        }
        return checksumPolicy;
    }

    public void setChecksumPolicy(MavenExecutionOptions.ChecksumPolicy value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.checksumPolicy), (Object)((Object)value))) {
            this.checksumPolicy = value;
            this.changed();
        }
    }

    @Property
    @NotNull
    public MavenExecutionOptions.FailureMode getFailureBehavior() {
        MavenExecutionOptions.FailureMode failureMode = this.failureBehavior;
        if (failureMode == null) {
            MavenGeneralSettings.$$$reportNull$$$0(2);
        }
        return failureMode;
    }

    public void setFailureBehavior(MavenExecutionOptions.FailureMode value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.failureBehavior), (Object)((Object)value))) {
            this.failureBehavior = value;
            this.changed();
        }
    }

    @Transient
    @Deprecated(forRemoval=true)
    @NotNull
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.getOutputLevel();
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(3);
        }
        return loggingLevel;
    }

    @Property
    @NotNull
    public MavenExecutionOptions.LoggingLevel getOutputLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.outputLevel;
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(4);
        }
        return loggingLevel;
    }

    public void setOutputLevel(MavenExecutionOptions.LoggingLevel value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.outputLevel), (Object)((Object)value))) {
            this.outputLevel = value;
            this.changed();
        }
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public void setWorkOffline(boolean value) {
        if (!Comparing.equal((Object)this.workOffline, (Object)value)) {
            this.workOffline = value;
            this.changed();
        }
    }

    @NotNull
    public String getMavenHome() {
        String string = this.mavenHome;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setMavenHome(@NotNull String mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(6);
        }
        File mavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory(mavenHome);
        File bundledMavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory("Bundled (Maven 3)");
        String mavenHomeToSet = mavenHome;
        if (FileUtil.filesEqual((File)mavenHomeDirectory, (File)bundledMavenHomeDirectory)) {
            mavenHomeToSet = "Bundled (Maven 3)";
        }
        if (!Objects.equals(this.mavenHome, mavenHomeToSet)) {
            this.mavenHome = mavenHomeToSet;
            this.myDefaultPluginsCache = null;
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public File getEffectiveMavenHome() {
        if (this.myEffectiveLocalHomeCache == null) {
            this.myEffectiveLocalHomeCache = MavenWslUtil.resolveMavenHome(this.myProject, this.getMavenHome());
        }
        return this.myEffectiveLocalHomeCache;
    }

    @NotNull
    public String getUserSettingsFile() {
        String string = this.mavenSettingsFile;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setUserSettingsFile(@Nullable String mavenSettingsFile) {
        if (mavenSettingsFile == null) {
            return;
        }
        if (!Objects.equals(this.mavenSettingsFile, mavenSettingsFile)) {
            this.mavenSettingsFile = mavenSettingsFile;
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public File getEffectiveUserSettingsIoFile() {
        return MavenWslUtil.getUserSettings(this.myProject, this.getUserSettingsFile(), this.getMavenConfig());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public File getEffectiveGlobalSettingsIoFile() {
        return MavenWslUtil.getGlobalSettings(this.myProject, this.getMavenHome(), this.getMavenConfig());
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public VirtualFile getEffectiveUserSettingsFile() {
        File file = this.getEffectiveUserSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @Deprecated(forRemoval=true)
    public List<VirtualFile> getEffectiveSettingsFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(2);
        VirtualFile file = this.getEffectiveUserSettingsFile();
        if (file != null) {
            result.add(file);
        }
        if ((file = this.getEffectiveGlobalSettingsFile()) != null) {
            result.add(file);
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public VirtualFile getEffectiveGlobalSettingsFile() {
        File file = this.getEffectiveGlobalSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @NotNull
    public String getLocalRepository() {
        String string = this.overriddenLocalRepository;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setLocalRepository(@Nullable String overridenLocalRepository) {
        if (overridenLocalRepository == null) {
            return;
        }
        if (!Objects.equals(this.overriddenLocalRepository, overridenLocalRepository)) {
            this.overriddenLocalRepository = overridenLocalRepository;
            MavenServerManager.getInstance().shutdown(true);
            this.changed();
        }
    }

    @Deprecated(forRemoval=true)
    public File getEffectiveLocalRepository() {
        File result = this.myEffectiveLocalRepositoryCache;
        if (result != null) {
            return result;
        }
        this.myEffectiveLocalRepositoryCache = result = MavenWslUtil.getLocalRepo(this.myProject, this.overriddenLocalRepository, this.mavenHome, this.mavenSettingsFile, this.getMavenConfig());
        return result;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public VirtualFile getEffectiveSuperPom() {
        VirtualFile result = this.myEffectiveSuperPomCache;
        if (result != null && result.isValid()) {
            return result;
        }
        this.myEffectiveSuperPomCache = result = MavenUtil.resolveSuperPomFile(this.getEffectiveMavenHome());
        return result;
    }

    public boolean isDefaultPlugin(String groupId, String artifactId) {
        return this.getDefaultPlugins().contains(groupId + ":" + artifactId);
    }

    private Set<String> getDefaultPlugins() {
        Set<String> result = this.myDefaultPluginsCache;
        if (result != null) {
            return result;
        }
        result = new HashSet<String>();
        VirtualFile effectiveSuperPom = this.getEffectiveSuperPom();
        if (effectiveSuperPom != null) {
            Element superProject = MavenJDOMUtil.read(effectiveSuperPom, null);
            for (Element each : MavenJDOMUtil.findChildrenByPath(superProject, "build.pluginManagement.plugins", "plugin")) {
                String groupId = MavenJDOMUtil.findChildValueByPath(each, "groupId", "org.apache.maven.plugins");
                String artifactId = MavenJDOMUtil.findChildValueByPath(each, "artifactId", null);
                result.add(groupId + ":" + artifactId);
            }
        }
        this.myDefaultPluginsCache = result;
        return result;
    }

    public boolean isPrintErrorStackTraces() {
        return this.printErrorStackTraces;
    }

    public void setPrintErrorStackTraces(boolean value) {
        if (!Comparing.equal((Object)this.printErrorStackTraces, (Object)value)) {
            this.printErrorStackTraces = value;
            this.changed();
        }
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void setUsePluginRegistry(boolean value) {
        if (!Comparing.equal((Object)this.usePluginRegistry, (Object)value)) {
            this.usePluginRegistry = value;
            this.changed();
        }
    }

    public boolean isUseMavenConfig() {
        return this.useMavenConfig;
    }

    public void setUseMavenConfig(boolean value) {
        if (!Comparing.equal((Object)this.useMavenConfig, (Object)value)) {
            this.useMavenConfig = value;
            this.changed();
        }
    }

    public boolean isAlwaysUpdateSnapshots() {
        return this.alwaysUpdateSnapshots;
    }

    public void setAlwaysUpdateSnapshots(boolean value) {
        if (!Comparing.equal((Object)this.alwaysUpdateSnapshots, (Object)value)) {
            this.alwaysUpdateSnapshots = value;
            this.changed();
        }
    }

    public boolean isShowDialogWithAdvancedSettings() {
        return this.showDialogWithAdvancedSettings;
    }

    public void setShowDialogWithAdvancedSettings(boolean value) {
        if (!Comparing.equal((Object)this.showDialogWithAdvancedSettings, (Object)value)) {
            this.showDialogWithAdvancedSettings = value;
            this.changed();
        }
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean value) {
        if (!Comparing.equal((Object)this.nonRecursive, (Object)value)) {
            this.nonRecursive = value;
            this.changed();
        }
    }

    @Nullable
    public String getThreads() {
        return this.threads;
    }

    public void setThreads(@Nullable String value) {
        String nullizeValue = StringUtil.nullize((String)value);
        if (!Objects.equals(this.threads, nullizeValue)) {
            this.threads = nullizeValue;
            this.changed();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenGeneralSettings that = (MavenGeneralSettings)o;
        if (this.nonRecursive != that.nonRecursive) {
            return false;
        }
        if (this.outputLevel != that.outputLevel) {
            return false;
        }
        if (this.pluginUpdatePolicy != that.pluginUpdatePolicy) {
            return false;
        }
        if (this.alwaysUpdateSnapshots != that.alwaysUpdateSnapshots) {
            return false;
        }
        if (this.showDialogWithAdvancedSettings != that.showDialogWithAdvancedSettings) {
            return false;
        }
        if (this.printErrorStackTraces != that.printErrorStackTraces) {
            return false;
        }
        if (this.usePluginRegistry != that.usePluginRegistry) {
            return false;
        }
        if (this.useMavenConfig != that.useMavenConfig) {
            return false;
        }
        if (this.workOffline != that.workOffline) {
            return false;
        }
        if (!this.checksumPolicy.equals((Object)that.checksumPolicy)) {
            return false;
        }
        if (!this.failureBehavior.equals((Object)that.failureBehavior)) {
            return false;
        }
        if (!this.overriddenLocalRepository.equals(that.overriddenLocalRepository)) {
            return false;
        }
        if (!this.mavenHome.equals(that.mavenHome)) {
            return false;
        }
        if (!this.mavenSettingsFile.equals(that.mavenSettingsFile)) {
            return false;
        }
        return Objects.equals(this.threads, that.threads);
    }

    public int hashCode() {
        int result = this.workOffline ? 1 : 0;
        result = 31 * result + this.mavenHome.hashCode();
        result = 31 * result + this.mavenSettingsFile.hashCode();
        result = 31 * result + this.overriddenLocalRepository.hashCode();
        result = 31 * result + (this.printErrorStackTraces ? 1 : 0);
        result = 31 * result + (this.usePluginRegistry ? 1 : 0);
        result = 31 * result + (this.useMavenConfig ? 1 : 0);
        result = 31 * result + (this.nonRecursive ? 1 : 0);
        result = 31 * result + this.outputLevel.hashCode();
        result = 31 * result + this.checksumPolicy.hashCode();
        result = 31 * result + this.failureBehavior.hashCode();
        result = 31 * result + this.pluginUpdatePolicy.hashCode();
        return result;
    }

    public MavenGeneralSettings clone() {
        try {
            MavenGeneralSettings result = (MavenGeneralSettings)super.clone();
            result.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            result.myBulkUpdateLevel = 0;
            result.setProject(this.myProject);
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l, Disposable parentDisposable) {
        this.addListener(l);
        Disposer.register((Disposable)parentDisposable, () -> this.removeListener(l));
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    @Transient
    public void updateFromMavenConfig(@NotNull List<VirtualFile> mavenRootProjects) {
        MavenConfig config;
        if (mavenRootProjects == null) {
            MavenGeneralSettings.$$$reportNull$$$0(9);
        }
        if (mavenRootProjects.isEmpty() || !this.useMavenConfig) {
            return;
        }
        this.mavenConfigCache = null;
        VirtualFile file = mavenRootProjects.get(0);
        this.mavenConfigCache = config = MavenConfigParser.parse(file.isDirectory() ? file.getPath() : file.getParent().getPath());
        if (config == null) {
            return;
        }
        MavenExecutionOptions.ChecksumPolicy checksumConfig = Objects.requireNonNullElse(config.getChecksumPolicy(), MavenExecutionOptions.ChecksumPolicy.NOT_SET);
        boolean needUpdate = !Objects.equals((Object)checksumConfig, (Object)this.checksumPolicy);
        this.checksumPolicy = checksumConfig;
        MavenExecutionOptions.FailureMode failureBehaviorConfig = Objects.requireNonNullElse(config.getFailureMode(), MavenExecutionOptions.FailureMode.NOT_SET);
        needUpdate = needUpdate || !Objects.equals((Object)this.failureBehavior, (Object)failureBehaviorConfig);
        this.failureBehavior = failureBehaviorConfig;
        MavenExecutionOptions.LoggingLevel outputLevelCongig = Objects.requireNonNullElse(config.getOutputLevel(), MavenExecutionOptions.LoggingLevel.INFO);
        needUpdate = needUpdate || !Objects.equals((Object)this.outputLevel, (Object)outputLevelCongig);
        this.outputLevel = outputLevelCongig;
        Boolean offlineConfig = Objects.requireNonNullElse(config.hasOption(MavenConfigSettings.OFFLINE), false);
        needUpdate = needUpdate || !Objects.equals(this.workOffline, offlineConfig);
        this.workOffline = offlineConfig;
        Boolean stackTracesConfig = Objects.requireNonNullElse(config.hasOption(MavenConfigSettings.ERRORS), false);
        needUpdate = needUpdate || !Objects.equals(this.printErrorStackTraces, stackTracesConfig);
        this.printErrorStackTraces = stackTracesConfig;
        Boolean updateSnapshotsConfig = Objects.requireNonNullElse(config.hasOption(MavenConfigSettings.UPDATE_SNAPSHOTS), false);
        needUpdate = needUpdate || !Objects.equals(this.alwaysUpdateSnapshots, updateSnapshotsConfig);
        this.alwaysUpdateSnapshots = updateSnapshotsConfig;
        Boolean nonRecursiveConfig = Objects.requireNonNullElse(config.hasOption(MavenConfigSettings.NON_RECURSIVE), false);
        needUpdate = needUpdate || !Objects.equals(this.nonRecursive, nonRecursiveConfig);
        this.nonRecursive = nonRecursiveConfig;
        String threadsConfig = StringUtil.nullize((String)config.getOptionValue(MavenConfigSettings.THREADS));
        needUpdate = needUpdate || !Objects.equals(StringUtil.nullize((String)this.threads), threadsConfig);
        this.threads = threadsConfig;
        if (needUpdate) {
            this.changed();
        }
        this.mavenConfigCache = config;
    }

    @Transient
    public MavenConfig getMavenConfig() {
        MavenProjectsManager instance;
        if (!this.useMavenConfig) {
            return null;
        }
        if (this.mavenConfigCache != null) {
            return this.mavenConfigCache;
        }
        MavenProjectsManager mavenProjectsManager = instance = this.myProject != null ? MavenProjectsManager.getInstance(this.myProject) : null;
        if (instance == null) {
            return null;
        }
        this.updateFromMavenConfig(MavenUtil.collectFiles(instance.getRootProjects()));
        return this.mavenConfigCache;
    }

    private void fireChanged() {
        for (Listener each : this.myListeners) {
            each.changed();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenRootProjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginUpdatePolicy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChecksumPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureBehavior";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenHome";
                break;
            }
            case 6: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSettingsFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepository";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHome";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "updateFromMavenConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public void changed();
    }
}

