/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.UiUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;
import org.jetbrains.idea.maven.wizards.MavenOpenProjectProvider;

public class AddManagedFilesAction
extends MavenAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project2;
        if (e == null) {
            AddManagedFilesAction.$$$reportNull$$$0(0);
        }
        if ((project2 = MavenActionUtil.getProject(e.getDataContext())) == null) {
            return;
        }
        final MavenProjectsManager manager = MavenProjectsManager.getInstanceIfCreated(project2);
        if (manager == null) {
            return;
        }
        FileChooserDescriptor singlePomSelection = new FileChooserDescriptor(true, true, false, false, false, false){

            public boolean isFileSelectable(@Nullable VirtualFile file) {
                return super.isFileSelectable(file) && !manager.isManagedFile(file);
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && !MavenActionUtil.isMavenProjectFile(file)) {
                    return false;
                }
                return super.isFileVisible(file, showHiddenFiles);
            }
        };
        VirtualFile fileToSelect = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile[] files = FileChooser.chooseFiles((FileChooserDescriptor)singlePomSelection, (Project)project2, (VirtualFile)fileToSelect);
        if (files.length == 1) {
            VirtualFile projectFile = files[0];
            ReadAction.nonBlocking(() -> projectFile.isDirectory() ? projectFile.getChildren() : files).finishOnUiThread(ModalityState.defaultModalityState(), it -> {
                if (ContainerUtil.exists((Object[])it, MavenActionUtil::isMavenProjectFile)) {
                    MavenOpenProjectProvider openProjectProvider = new MavenOpenProjectProvider();
                    openProjectProvider.linkToExistingProject(projectFile, project2);
                } else {
                    String projectPath = UiUtils.getPresentablePath((String)projectFile.getPath());
                    String message = projectFile.isDirectory() ? MavenProjectBundle.message("maven.AddManagedFiles.warning.message.directory", projectPath) : MavenProjectBundle.message("maven.AddManagedFiles.warning.message.file", projectPath);
                    String title = MavenProjectBundle.message("maven.AddManagedFiles.warning.title", new Object[0]);
                    Messages.showWarningDialog((Project)project2, (String)message, (String)title);
                }
            }).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/actions/AddManagedFilesAction", "actionPerformed"));
    }
}

