/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.externalSystem.dependency.analyzer.AbstractDependencyAnalyzerAction;
import com.intellij.openapi.externalSystem.dependency.analyzer.DAArtifact;
import com.intellij.openapi.externalSystem.dependency.analyzer.DependencyAnalyzerDependency;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import java.awt.Component;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.navigator.MavenProjectsStructure;
import org.jetbrains.idea.maven.project.MavenDependencyAnalyzerContributor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/idea/maven/project/actions/MavenDependencyAnalyzerAction;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction;", "()V", "getContributors", "", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction$Contributor;", "getSystemId", "Lcom/intellij/openapi/externalSystem/model/ProjectSystemId;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "MavenToolwindowContributor", "ProjectViewContributor", "intellij.maven"})
public final class MavenDependencyAnalyzerAction
extends AbstractDependencyAnalyzerAction {
    @NotNull
    public ProjectSystemId getSystemId(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ProjectSystemId projectSystemId = MavenUtil.SYSTEM_ID;
        Intrinsics.checkNotNullExpressionValue((Object)projectSystemId, (String)"MavenUtil.SYSTEM_ID");
        return projectSystemId;
    }

    @NotNull
    public List<AbstractDependencyAnalyzerAction.Contributor<?>> getContributors() {
        return CollectionsKt.listOf((Object[])new AbstractDependencyAnalyzerAction.Contributor[]{new MavenToolwindowContributor(), new ProjectViewContributor()});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/project/actions/MavenDependencyAnalyzerAction$MavenToolwindowContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction$Contributor;", "Lcom/intellij/ui/treeStructure/SimpleNode;", "()V", "getDependencyData", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Data;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectedData", "getDependencyScope", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/DependencyAnalyzerDependency$Scope;", "getExternalProjectPath", "", "getSelectedData", "intellij.maven"})
    private static final class MavenToolwindowContributor
    implements AbstractDependencyAnalyzerAction.Contributor<SimpleNode> {
        @Nullable
        public SimpleNode getSelectedData(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Component data = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            Component component = data;
            if (!(component instanceof SimpleTree)) {
                component = null;
            }
            SimpleTree simpleTree = (SimpleTree)component;
            return simpleTree != null ? simpleTree.getSelectedNode() : null;
        }

        @Nullable
        public String getExternalProjectPath(@NotNull AnActionEvent e, @NotNull SimpleNode selectedData) {
            MavenProjectsStructure.ProjectNode projectNode;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
            if (selectedData instanceof MavenProjectsStructure.ProjectNode) {
                MavenProject mavenProject2 = ((MavenProjectsStructure.ProjectNode)selectedData).getMavenProject();
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject2, (String)"selectedData.mavenProject");
                return mavenProject2.getPath();
            }
            if (selectedData instanceof MavenProjectsStructure.MavenSimpleNode && (projectNode = ((MavenProjectsStructure.MavenSimpleNode)selectedData).findParent(MavenProjectsStructure.ProjectNode.class)) != null) {
                MavenProject mavenProject3 = projectNode.getMavenProject();
                Intrinsics.checkNotNullExpressionValue((Object)mavenProject3, (String)"projectNode.mavenProject");
                return mavenProject3.getPath();
            }
            Project project2 = e.getProject();
            if (project2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return null");
            Project project3 = project2;
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstance(project3);
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.getInstance(project)");
            List<MavenProject> list = mavenProjectsManager.getRootProjects();
            Intrinsics.checkNotNullExpressionValue(list, (String)"MavenProjectsManager.get\u2026nce(project).rootProjects");
            MavenProject mavenProject4 = (MavenProject)CollectionsKt.firstOrNull(list);
            return mavenProject4 != null ? mavenProject4.getPath() : null;
        }

        @Nullable
        public DependencyAnalyzerDependency.Data getDependencyData(@NotNull AnActionEvent e, @NotNull SimpleNode selectedData) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
            if (selectedData instanceof MavenProjectsStructure.DependencyNode) {
                MavenArtifact mavenArtifact = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"selectedData.artifact");
                String string = mavenArtifact.getGroupId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedData.artifact.groupId");
                MavenArtifact mavenArtifact2 = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact2, (String)"selectedData.artifact");
                String string2 = mavenArtifact2.getArtifactId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"selectedData.artifact.artifactId");
                MavenArtifact mavenArtifact3 = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact3, (String)"selectedData.artifact");
                String string3 = mavenArtifact3.getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"selectedData.artifact.version");
                return (DependencyAnalyzerDependency.Data)new DAArtifact(string, string2, string3);
            }
            return null;
        }

        @Nullable
        public DependencyAnalyzerDependency.Scope getDependencyScope(@NotNull AnActionEvent e, @NotNull SimpleNode selectedData) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
            if (selectedData instanceof MavenProjectsStructure.DependencyNode) {
                MavenArtifact mavenArtifact = ((MavenProjectsStructure.DependencyNode)selectedData).getArtifact();
                Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"selectedData.artifact");
                String string = mavenArtifact.getScope();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedData.artifact.scope");
                return (DependencyAnalyzerDependency.Scope)MavenDependencyAnalyzerContributor.Companion.scope(string);
            }
            return null;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/idea/maven/project/actions/MavenDependencyAnalyzerAction$ProjectViewContributor;", "Lcom/intellij/openapi/externalSystem/dependency/analyzer/AbstractDependencyAnalyzerAction$Contributor;", "Lorg/jetbrains/idea/maven/project/MavenProject;", "()V", "getDependencyData", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "selectedData", "getDependencyScope", "getExternalProjectPath", "", "getSelectedData", "intellij.maven"})
    private static final class ProjectViewContributor
    implements AbstractDependencyAnalyzerAction.Contributor<MavenProject> {
        @Nullable
        public MavenProject getSelectedData(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Project project2 = e.getProject();
            if (project2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"e.project ?: return null");
            Project project3 = project2;
            Object[] objectArray = (Module[])e.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (objectArray == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"e.getData(LangDataKeys.M\u2026EXT_ARRAY) ?: return null");
            Object[] modules2 = objectArray;
            MavenProjectsManager mavenProjectsManager = MavenProjectsManager.getInstanceIfCreated(project3);
            if (mavenProjectsManager == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)mavenProjectsManager, (String)"MavenProjectsManager.get\u2026d(project) ?: return null");
            MavenProjectsManager projectsManager = mavenProjectsManager;
            return (MavenProject)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])modules2), (Function1)((Function1)new Function1<Module, MavenProject>(projectsManager){
                final /* synthetic */ MavenProjectsManager $projectsManager;

                @Nullable
                public final MavenProject invoke(Module it) {
                    return this.$projectsManager.findProject(it);
                }
                {
                    this.$projectsManager = mavenProjectsManager;
                    super(1);
                }
            })));
        }

        @NotNull
        public String getExternalProjectPath(@NotNull AnActionEvent e, @NotNull MavenProject selectedData) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
            String string = selectedData.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"selectedData.path");
            return string;
        }

        @Nullable
        public Void getDependencyData(@NotNull AnActionEvent e, @NotNull MavenProject selectedData) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
            return null;
        }

        @Nullable
        public Void getDependencyScope(@NotNull AnActionEvent e, @NotNull MavenProject selectedData) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Intrinsics.checkNotNullParameter((Object)selectedData, (String)"selectedData");
            return null;
        }
    }
}

