/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.indices.IndicesBundle;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

public final class MavenArtifactUtil {
    public static final String[] DEFAULT_GROUPS = new String[]{"org.apache.maven.plugins", "org.codehaus.mojo"};
    public static final String MAVEN_PLUGIN_DESCRIPTOR = "META-INF/maven/plugin.xml";
    private static final Map<Path, MavenPluginInfo> ourPluginInfoCache = Collections.synchronizedMap(new HashMap());

    @Nullable
    public static MavenPluginInfo readPluginInfo(File localRepository, MavenId mavenId) {
        Path file = MavenArtifactUtil.getArtifactNioPath(localRepository, mavenId.getGroupId(), mavenId.getArtifactId(), mavenId.getVersion(), "jar");
        MavenPluginInfo result = ourPluginInfoCache.get(file);
        if (result == null) {
            result = MavenArtifactUtil.createPluginDocument(file);
            ourPluginInfoCache.put(file, result);
        }
        return result;
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id) {
        return MavenArtifactUtil.hasArtifactFile(localRepository, id, "jar");
    }

    public static boolean hasArtifactFile(File localRepository, MavenId id, String type2) {
        return Files.exists(MavenArtifactUtil.getArtifactFile(localRepository, id, type2), new LinkOption[0]);
    }

    @NotNull
    public static Path getArtifactFile(File localRepository, MavenId id, String type2) {
        return MavenArtifactUtil.getArtifactNioPath(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), type2);
    }

    @NotNull
    public static Path getArtifactFile(File localRepository, MavenId id) {
        return MavenArtifactUtil.getArtifactNioPath(localRepository, id.getGroupId(), id.getArtifactId(), id.getVersion(), "pom");
    }

    public static boolean isPluginIdEquals(@Nullable String groupId1, @Nullable String artifactId1, @Nullable String groupId2, @Nullable String artifactId2) {
        if (artifactId1 == null) {
            return false;
        }
        if (!artifactId1.equals(artifactId2)) {
            return false;
        }
        if (groupId1 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!groupId1.equals(group)) continue;
                groupId1 = null;
                break;
            }
        }
        if (groupId2 != null) {
            for (String group : DEFAULT_GROUPS) {
                if (!groupId2.equals(group)) continue;
                groupId2 = null;
                break;
            }
        }
        return Objects.equals(groupId1, groupId2);
    }

    @Deprecated
    @NotNull
    public static File getArtifactFile(File localRepository, String groupId, String artifactId, String version2, String type2) {
        File file = MavenArtifactUtil.getArtifactNioPath(localRepository, groupId, artifactId, version2, type2).toFile();
        if (file == null) {
            MavenArtifactUtil.$$$reportNull$$$0(0);
        }
        return file;
    }

    @NotNull
    public static Path getArtifactNioPath(File localRepository, String groupId, String artifactId, String version2, String type2) {
        Path dir2 = null;
        if (StringUtil.isEmpty((String)groupId)) {
            String each;
            String[] stringArray = DEFAULT_GROUPS;
            int n = stringArray.length;
            for (int i = 0; i < n && !Files.exists(dir2 = MavenArtifactUtil.getArtifactDirectory(localRepository, each = stringArray[i], artifactId), new LinkOption[0]); ++i) {
            }
        } else {
            dir2 = MavenArtifactUtil.getArtifactDirectory(localRepository, groupId, artifactId);
        }
        if (StringUtil.isEmpty((String)version2)) {
            version2 = MavenArtifactUtil.resolveVersion(dir2);
        }
        Path path = dir2.resolve(version2).resolve(artifactId + "-" + version2 + "." + type2);
        if (path == null) {
            MavenArtifactUtil.$$$reportNull$$$0(1);
        }
        return path;
    }

    private static Path getArtifactDirectory(File localRepository, String groupId, String artifactId) {
        String relativePath = StringUtil.replace((String)groupId, (String)".", (String)File.separator) + File.separator + artifactId;
        return localRepository.toPath().resolve(relativePath);
    }

    private static String resolveVersion(Path pluginDir) {
        ArrayList versions = new ArrayList();
        try (Stream<Path> children = Files.list(pluginDir);){
            children.forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    versions.add(path.getFileName().toString());
                }
            });
        }
        catch (NoSuchFileException e) {
            return "";
        }
        catch (Exception e) {
            MavenLog.LOG.warn(e.getMessage());
            return "";
        }
        if (versions.isEmpty()) {
            return "";
        }
        Collections.sort(versions);
        return (String)versions.get(versions.size() - 1);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static MavenPluginInfo createPluginDocument(Path file) {
        try {
            if (!Files.exists(file, new LinkOption[0])) {
                return null;
            }
            try (ZipFile jar = new ZipFile(file.toFile());){
                MavenPluginInfo mavenPluginInfo;
                block16: {
                    ZipEntry entry = jar.getEntry(MAVEN_PLUGIN_DESCRIPTOR);
                    if (entry == null) {
                        MavenLog.LOG.info(IndicesBundle.message("repository.plugin.corrupt", file));
                        MavenPluginInfo mavenPluginInfo2 = null;
                        return mavenPluginInfo2;
                    }
                    InputStream is = jar.getInputStream(entry);
                    try {
                        byte[] bytes = FileUtil.loadBytes((InputStream)is);
                        mavenPluginInfo = new MavenPluginInfo(bytes);
                        if (is == null) break block16;
                    }
                    catch (Throwable throwable) {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    is.close();
                }
                return mavenPluginInfo;
            }
        }
        catch (IOException e) {
            MavenLog.LOG.info((Throwable)e);
            return null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/idea/maven/utils/MavenArtifactUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactNioPath";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

