/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManagerImpl;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.OpenapiIcons;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenProjectImporter;
import org.jetbrains.idea.maven.importing.tree.MavenProjectImportContextProvider;
import org.jetbrains.idea.maven.model.MavenArchetype;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenEnvironmentForm;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenArchetypesStep;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;
import org.jetbrains.idea.maven.wizards.MavenWizardBundle;

public abstract class AbstractMavenModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private MavenProject myAggregatorProject;
    private MavenProject myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private MavenId myProjectId;
    private MavenArchetype myArchetype;
    private MavenEnvironmentForm myEnvironmentForm;
    private Map<String, String> myPropertiesToCreateByArtifact;

    public void setupRootModel(@NotNull ModifiableRootModel rootModel) {
        if (rootModel == null) {
            AbstractMavenModuleBuilder.$$$reportNull$$$0(0);
        }
        Project project2 = rootModel.getProject();
        VirtualFile root = this.createAndGetContentEntry();
        rootModel.addContentEntry(root);
        if (this.myJdk != null) {
            rootModel.setSdk(this.myJdk);
        } else {
            rootModel.inheritSdk();
        }
        MavenUtil.runWhenInitialized(project2, (Runnable)((DumbAwareRunnable)() -> {
            if (this.myEnvironmentForm != null) {
                this.myEnvironmentForm.setData(MavenProjectsManager.getInstance(project2).getGeneralSettings());
            }
            new MavenModuleBuilderHelper(this.myProjectId, this.myAggregatorProject, this.myParentProject, this.myInheritGroupId, this.myInheritVersion, this.myArchetype, this.myPropertiesToCreateByArtifact, MavenProjectBundle.message("command.name.create.new.maven.module", new Object[0])).configure(project2, root, false);
        }));
    }

    @Nullable
    public Module commitModule(@NotNull Project project2, @Nullable ModifiableModuleModel model2) {
        if (project2 == null) {
            AbstractMavenModuleBuilder.$$$reportNull$$$0(1);
        }
        this.setMavenModuleFilePath(project2, this.getName());
        return super.commitModule(project2, model2);
    }

    private void setMavenModuleFilePath(@NotNull Project project2, @NotNull String moduleName) {
        if (project2 == null) {
            AbstractMavenModuleBuilder.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            AbstractMavenModuleBuilder.$$$reportNull$$$0(3);
        }
        if (this.myParentProject == null) {
            return;
        }
        if (!MavenProjectImporter.isImportToTreeStructureEnabled(project2)) {
            return;
        }
        String parentModuleName = MavenProjectImportContextProvider.getModuleName(this.myParentProject, project2);
        if (StringUtil.isNotEmpty((String)parentModuleName)) {
            String moduleFilePath = project2.getBasePath() + File.separator + parentModuleName + "." + moduleName + ".iml";
            this.setModuleFilePath(moduleFilePath);
        }
    }

    @NonNls
    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return MavenProjectBundle.message("configurable.MavenSettings.display.name", new Object[0]);
    }

    public String getParentGroup() {
        return "Java";
    }

    public int getWeight() {
        return 2000;
    }

    public String getDescription() {
        return MavenWizardBundle.message("maven.builder.module.builder.description", new Object[0]);
    }

    public Icon getNodeIcon() {
        return OpenapiIcons.RepositoryLibraryLogo;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public boolean isSuitableSdkType(SdkTypeId sdk) {
        return sdk == JavaSdk.getInstance();
    }

    public abstract ModuleWizardStep[] createWizardSteps(@NotNull WizardContext var1, @NotNull ModulesProvider var2);

    private VirtualFile createAndGetContentEntry() {
        String path = FileUtil.toSystemIndependentName((String)this.getContentEntryPath());
        new File(path).mkdirs();
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
    }

    public List<Pair<String, String>> getSourcePaths() {
        return Collections.emptyList();
    }

    public void setSourcePaths(List<Pair<String, String>> sourcePaths) {
    }

    public void addSourcePath(Pair<String, String> sourcePathInfo) {
    }

    public void setAggregatorProject(MavenProject project2) {
        this.myAggregatorProject = project2;
    }

    public MavenProject getAggregatorProject() {
        return this.myAggregatorProject;
    }

    public void setParentProject(MavenProject project2) {
        this.myParentProject = project2;
    }

    public MavenProject getParentProject() {
        return this.myParentProject;
    }

    public void setInheritedOptions(boolean groupId, boolean version2) {
        this.myInheritGroupId = groupId;
        this.myInheritVersion = version2;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public void setInheritGroupId(boolean inheritGroupId) {
        this.myInheritGroupId = inheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setInheritVersion(boolean inheritVersion) {
        this.myInheritVersion = inheritVersion;
    }

    public void setProjectId(MavenId id) {
        this.myProjectId = id;
    }

    public MavenId getProjectId() {
        return this.myProjectId;
    }

    public void setArchetype(MavenArchetype archetype) {
        this.myArchetype = archetype;
    }

    public MavenArchetype getArchetype() {
        return this.myArchetype;
    }

    public MavenEnvironmentForm getEnvironmentForm() {
        return this.myEnvironmentForm;
    }

    public void setEnvironmentForm(MavenEnvironmentForm environmentForm) {
        this.myEnvironmentForm = environmentForm;
    }

    public Map<String, String> getPropertiesToCreateByArtifact() {
        return this.myPropertiesToCreateByArtifact;
    }

    public void setPropertiesToCreateByArtifact(Map<String, String> propertiesToCreateByArtifact) {
        this.myPropertiesToCreateByArtifact = propertiesToCreateByArtifact;
    }

    public String getGroupName() {
        return "Maven";
    }

    @Nullable
    public ModuleWizardStep getCustomOptionsStep(WizardContext context, Disposable parentDisposable) {
        MavenArchetypesStep step = new MavenArchetypesStep(this, null);
        Disposer.register((Disposable)parentDisposable, (Disposable)step);
        return step;
    }

    @Nullable
    public ModuleWizardStep modifySettingsStep(@NotNull SettingsStep settingsStep) {
        ModuleNameLocationSettings nameLocationSettings;
        if (settingsStep == null) {
            AbstractMavenModuleBuilder.$$$reportNull$$$0(4);
        }
        if ((nameLocationSettings = settingsStep.getModuleNameLocationSettings()) != null && this.myProjectId != null && this.myProjectId.getArtifactId() != null) {
            nameLocationSettings.setModuleName(StringUtil.sanitizeJavaIdentifier((String)this.myProjectId.getArtifactId()));
            if (this.myAggregatorProject != null) {
                nameLocationSettings.setModuleContentRoot(this.myAggregatorProject.getDirectory() + "/" + this.myProjectId.getArtifactId());
            }
        }
        return super.modifySettingsStep(settingsStep);
    }

    @Nullable
    public Project createProject(String name, String path) {
        return ExternalProjectsManagerImpl.setupCreatedProject((Project)super.createProject(name, path));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsStep";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/wizards/AbstractMavenModuleBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupRootModel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "commitModule";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setMavenModuleFilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "modifySettingsStep";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

