/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitBranchesCollection {
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;

    public GitBranchesCollection(@NotNull Map<GitLocalBranch, Hash> localBranches2, @NotNull Map<GitRemoteBranch, Hash> remoteBranches2) {
        if (localBranches2 == null) {
            GitBranchesCollection.$$$reportNull$$$0(0);
        }
        if (remoteBranches2 == null) {
            GitBranchesCollection.$$$reportNull$$$0(1);
        }
        this.myRemoteBranches = remoteBranches2;
        this.myLocalBranches = localBranches2;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        Collection<GitLocalBranch> collection = Collections.unmodifiableCollection(this.myLocalBranches.keySet());
        if (collection == null) {
            GitBranchesCollection.$$$reportNull$$$0(2);
        }
        return collection;
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Collection<GitRemoteBranch> collection = Collections.unmodifiableCollection(this.myRemoteBranches.keySet());
        if (collection == null) {
            GitBranchesCollection.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @Nullable
    public Hash getHash(@NotNull GitBranch branch) {
        if (branch == null) {
            GitBranchesCollection.$$$reportNull$$$0(4);
        }
        if (branch instanceof GitLocalBranch) {
            return this.myLocalBranches.get(branch);
        }
        if (branch instanceof GitRemoteBranch) {
            return this.myRemoteBranches.get(branch);
        }
        return null;
    }

    @NotNull
    public Collection<GitLocalBranch> findLocalBranchesByHash(@NotNull Hash hash) {
        if (hash == null) {
            GitBranchesCollection.$$$reportNull$$$0(5);
        }
        List list2 = ContainerUtil.filter(this.myLocalBranches.keySet(), key -> this.myLocalBranches.get(key).equals(hash));
        if (list2 == null) {
            GitBranchesCollection.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public Collection<GitRemoteBranch> findRemoteBranchesByHash(@NotNull Hash hash) {
        if (hash == null) {
            GitBranchesCollection.$$$reportNull$$$0(7);
        }
        List list2 = ContainerUtil.filter(this.myRemoteBranches.keySet(), key -> this.myRemoteBranches.get(key).equals(hash));
        if (list2 == null) {
            GitBranchesCollection.$$$reportNull$$$0(8);
        }
        return list2;
    }

    @Nullable
    public GitLocalBranch findLocalBranch(@NotNull String name) {
        GitLocalBranch branch;
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(9);
        }
        return this.myLocalBranches.containsKey(branch = new GitLocalBranch(name)) ? branch : null;
    }

    @Nullable
    public GitRemoteBranch findRemoteBranch(@NotNull String name) {
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(10);
        }
        return GitBranchesCollection.findByName(this.myRemoteBranches.keySet(), name);
    }

    @Nullable
    public GitBranch findBranchByName(@NotNull String name) {
        GitLocalBranch result2;
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(11);
        }
        return (result2 = this.findLocalBranch(name)) == null ? this.findRemoteBranch(name) : result2;
    }

    @Nullable
    private static <T extends GitBranch> T findByName(@NotNull Collection<T> branches2, @NotNull String name) {
        if (branches2 == null) {
            GitBranchesCollection.$$$reportNull$$$0(12);
        }
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(13);
        }
        return (T)((GitBranch)ContainerUtil.find(branches2, branch -> GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)name, (Object)branch.getName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchesCollection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchesCollection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalBranches";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranches";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocalBranchesByHash";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findRemoteBranchesByHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getHash";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBranchesByHash";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranchesByHash";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBranch";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findBranchByName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

