/*
 * Decompiled with CFR 0.152.
 */
package git4idea.pull;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.ide.ui.laf.darcula.DarculaUIUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.MutableCollectionComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.DropDownLink;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBranchesCollection;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitPullSettings;
import git4idea.config.GitVersionSpecialty;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeDialogKt;
import git4idea.merge.dialog.CmdLabel;
import git4idea.merge.dialog.FlatComboBoxUI;
import git4idea.merge.dialog.GitOptionsPanel;
import git4idea.merge.dialog.GitOptionsPopupBuilder;
import git4idea.merge.dialog.OptionInfo;
import git4idea.pull.GitPullDialog;
import git4idea.pull.GitPullOption;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.ui.ComboBoxWithAutoCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KFunction;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00c5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b *\u0001J\u0018\u0000 h2\u00020\u0001:\u0001hB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ;\u0010-\u001a5\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f\u0012#\u0012!\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\u0012\u0012\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u00130\u00050\u00100\u0010H\u0002J\u0016\u0010.\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nH\u0002J\u0010\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u000201H\u0002J\b\u00102\u001a\u00020\u0015H\u0014J\b\u00103\u001a\u000204H\u0002J\b\u00105\u001a\u00020\u0015H\u0002J\u0018\u00106\u001a\u0012\u0012\u000e\u0012\f0\u000b\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b807H\u0002J\b\u00109\u001a\u00020\u0015H\u0002J\u000e\u0010:\u001a\b\u0012\u0004\u0012\u00020\u001b0!H\u0002J\u000e\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00110%H\u0002J\u0016\u0010<\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0%H\u0002J\b\u0010=\u001a\u000201H\u0014J\b\u0010>\u001a\u00020?H\u0014J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u00020A0\u0005H\u0014J/\u0010B\u001a!\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\u0012\u0012\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u00130\u00050\u00102\u0006\u0010C\u001a\u00020\u000fH\u0002J\u0014\u0010D\u001a\u0004\u0018\u00010\u00112\b\u0010C\u001a\u0004\u0018\u00010\u000fH\u0002J\b\u0010E\u001a\u00020FH\u0002J\u0012\u0010G\u001a\f0\u000b\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\bHH\u0002J\u001d\u0010I\u001a\u00020J2\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010LJ\b\u0010M\u001a\u00020\u000bH\u0014J\u0016\u0010N\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001c2\u0006\u0010O\u001a\u00020\u001bH\u0002J\u000e\u0010P\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005H\u0002J\u0016\u0010Q\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nH\u0016J\n\u0010R\u001a\u0004\u0018\u00010\u0011H\u0002J\u001e\u0010S\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00052\u0006\u0010C\u001a\u00020\u000f2\u0006\u0010K\u001a\u00020\u0011H\u0002J\u0006\u0010T\u001a\u00020\u0013J\u0006\u0010U\u001a\u00020\u0011J\n\u0010V\u001a\u0004\u0018\u00010\u000fH\u0002J\u000b\u0010W\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0012J\u0006\u0010X\u001a\u00020\u0019J\u0010\u0010Y\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u001bH\u0002J\u0010\u0010Z\u001a\u00020\u00192\u0006\u0010O\u001a\u00020\u001bH\u0002J\b\u0010[\u001a\u00020?H\u0002J\u0010\u0010\\\u001a\u00020?2\u0006\u0010O\u001a\u00020\u001bH\u0002J\b\u0010]\u001a\u00020?H\u0002J\b\u0010^\u001a\u00020?H\u0002J\b\u0010_\u001a\u00020?H\u0002J\b\u0010`\u001a\u00020\u0019H\u0002J\b\u0010a\u001a\u00020?H\u0002J\b\u0010b\u001a\u00020?H\u0002J\b\u0010c\u001a\u00020?H\u0002J\b\u0010d\u001a\u00020?H\u0002J\n\u0010e\u001a\u0004\u0018\u00010AH\u0002J\n\u0010f\u001a\u0004\u0018\u00010AH\u0002J\n\u0010g\u001a\u0004\u0018\u00010AH\u0002R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RA\u0010\r\u001a5\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f\u0012#\u0012!\u0012\t\u0012\u00070\u0011\u00a2\u0006\u0002\b\u0012\u0012\u0012\u0012\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00130\u00130\u00050\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\u001c0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001b0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R2\u0010&\u001a&\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f \f*\u0012\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00050'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010(\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001b0*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u0006i"}, d2={"Lgit4idea/pull/GitPullDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "defaultRoot", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/vfs/VirtualFile;)V", "branchField", "Lgit4idea/ui/ComboBoxWithAutoCompletion;", "", "kotlin.jvm.PlatformType", "branches", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "Lorg/jetbrains/annotations/NotNull;", "Lgit4idea/GitRemoteBranch;", "commandPanel", "Ljavax/swing/JPanel;", "fetchSupport", "Lgit4idea/fetch/GitFetchSupport;", "isNoVerifySupported", "", "optionInfos", "Lgit4idea/pull/GitPullOption;", "Lgit4idea/merge/dialog/OptionInfo;", "optionsPanel", "Lgit4idea/merge/dialog/GitOptionsPanel;", "panel", "popupBuilder", "Lgit4idea/merge/dialog/GitOptionsPopupBuilder;", "pullSettings", "Lgit4idea/config/GitPullSettings;", "remoteField", "Lcom/intellij/openapi/ui/ComboBox;", "repositories", "", "repositoryField", "selectedOptions", "", "getSelectedOptions", "()Ljava/util/Set;", "collectBranches", "createBranchField", "createBranchFieldPopupComponent", "content", "Ljavax/swing/JComponent;", "createCenterPanel", "createCmdLabel", "Lgit4idea/merge/dialog/CmdLabel;", "createCommandPanel", "createOptionsDropDown", "Lcom/intellij/ui/components/DropDownLink;", "Lorg/jetbrains/annotations/Nls;", "createPanel", "createPopupBuilder", "createRemoteField", "createRepoField", "createSouthPanel", "doOKAction", "", "doValidateAll", "Lcom/intellij/openapi/ui/ValidationInfo;", "getBranchesInRepo", "repository", "getCurrentOrDefaultRemote", "getFetchActionShortcut", "Lcom/intellij/openapi/actionSystem/ShortcutSet;", "getFetchActionShortcutText", "Lcom/intellij/openapi/util/NlsSafe;", "getFetchTask", "git4idea/pull/GitPullDialog$getFetchTask$1", "remote", "(Lgit4idea/repo/GitRepository;Lgit4idea/repo/GitRemote;)Lgit4idea/pull/GitPullDialog$getFetchTask$1;", "getHelpId", "getOptionInfo", "option", "getOptions", "getPreferredFocusedComponent", "getRemote", "getRemoteBranches", "getSelectedBranch", "getSelectedRemote", "getSelectedRepository", "gitRoot", "isCommitAfterMerge", "isOptionEnabled", "isOptionSelected", "loadSettings", "optionChosen", "performFetch", "rerender", "saveSettings", "showRootField", "updateBranchesField", "updateRemotesField", "updateTitle", "updateUi", "validateBranchField", "validateRemoteField", "validateRepositoryField", "Companion", "intellij.vcs.git"})
public final class GitPullDialog
extends DialogWrapper {
    @NotNull
    private final Set<GitPullOption> selectedOptions;
    private final GitFetchSupport fetchSupport;
    private final GitPullSettings pullSettings;
    private final List<GitRepository> repositories;
    private final Map<GitRepository, Map<GitRemote, List<GitRemoteBranch>>> branches;
    private final Map<GitPullOption, OptionInfo<GitPullOption>> optionInfos;
    private final GitOptionsPopupBuilder<GitPullOption> popupBuilder;
    private final ComboBox<GitRepository> repositoryField;
    private final ComboBox<GitRemote> remoteField;
    private final ComboBoxWithAutoCompletion<String> branchField;
    private final JPanel commandPanel;
    private final GitOptionsPanel<GitPullOption> optionsPanel;
    private final JPanel panel;
    private final boolean isNoVerifySupported;
    private final Project project;
    private final List<VirtualFile> roots;
    private final VirtualFile defaultRoot;
    private static final CustomShortcutSet FETCH_ACTION_SHORTCUT;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final Set<GitPullOption> getSelectedOptions() {
        return this.selectedOptions;
    }

    @NotNull
    protected JPanel createCenterPanel() {
        return this.panel;
    }

    @NotNull
    public ComboBoxWithAutoCompletion<String> getPreferredFocusedComponent() {
        return this.branchField;
    }

    @NotNull
    protected JComponent createSouthPanel() {
        JComponent jComponent = super.createSouthPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"super.createSouthPanel()");
        return GitMergeDialogKt.createSouthPanelWithOptionsDropDown(jComponent, this.createOptionsDropDown());
    }

    @NotNull
    protected String getHelpId() {
        return "reference.VersionControl.Git.Pull";
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])new KFunction[]{new Function0<ValidationInfo>(this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateRepositoryField((GitPullDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>(this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateRemoteField((GitPullDialog)((Object)this.receiver));
            }
        }, new Function0<ValidationInfo>(this){

            @Nullable
            public final ValidationInfo invoke() {
                return GitPullDialog.access$validateBranchField((GitPullDialog)((Object)this.receiver));
            }
        }});
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ValidationInfo validationInfo;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            KFunction it = (KFunction)element$iv$iv;
            boolean bl2 = false;
            ValidationInfo validationInfo2 = (ValidationInfo)((Function0)it).invoke();
            if (validationInfo2 == null) continue;
            ValidationInfo it$iv$iv = validationInfo = validationInfo2;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doOKAction() {
        try {
            this.saveSettings();
        }
        finally {
            super.doOKAction();
        }
    }

    @NotNull
    public final VirtualFile gitRoot() {
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
            String string = "No selected repository found";
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)gitRepository, (String)"getSelectedRepository()?\u2026lected repository found\")");
        return gitRepository;
    }

    @NotNull
    public final GitRemote getSelectedRemote() {
        GitRemote gitRemote = (GitRemote)this.remoteField.getItem();
        if (gitRemote == null) {
            String string = "No selected remote found";
            throw new IllegalStateException(string.toString());
        }
        return gitRemote;
    }

    @NotNull
    public final GitRemoteBranch getSelectedBranch() {
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null) {
            String string = "No selected repository found";
            throw new IllegalStateException(string.toString());
        }
        GitRepository repository = gitRepository;
        GitRemote remote = this.getSelectedRemote();
        String branchName = remote.getName() + "/" + (String)this.branchField.getItem();
        GitRemoteBranch gitRemoteBranch = repository.getBranches().findRemoteBranch(branchName);
        if (gitRemoteBranch == null) {
            String string = "Unable to find remote branch: " + branchName;
            throw new IllegalStateException(string.toString());
        }
        return gitRemoteBranch;
    }

    public final boolean isCommitAfterMerge() {
        return !this.selectedOptions.contains((Object)GitPullOption.NO_COMMIT);
    }

    private final GitRemote getRemote() {
        return (GitRemote)this.remoteField.getItem();
    }

    private final void loadSettings() {
        Collection collection = this.selectedOptions;
        Set<GitPullOption> set = this.pullSettings.getOptions();
        Intrinsics.checkNotNullExpressionValue(set, (String)"pullSettings.options");
        Iterable iterable = set;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
    }

    private final void saveSettings() {
        this.pullSettings.setOptions(this.selectedOptions);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRepository, Map<GitRemote, List<GitRemoteBranch>>> collectBranches() {
        List<GitRepository> list2 = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
        Iterable $this$associateWith$iv = list2;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void repository;
            GitRepository gitRepository = (GitRepository)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            void v1 = repository;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"repository");
            Map<GitRemote, List<GitRemoteBranch>> map3 = this.getBranchesInRepo((GitRepository)v1);
            map2.put(t, map3);
        }
        return result$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<GitRemote, List<GitRemoteBranch>> getBranchesInRepo(GitRepository repository) {
        void $this$groupByTo$iv$iv;
        GitBranchesCollection gitBranchesCollection = repository.getBranches();
        Intrinsics.checkNotNullExpressionValue((Object)gitBranchesCollection, (String)"repository.branches");
        Collection<GitRemoteBranch> collection = gitBranchesCollection.getRemoteBranches();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"repository.branches.remoteBranches");
        Iterable $this$sortedBy$iv = collection;
        boolean $i$f$sortedBy = false;
        Iterable $this$groupBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                GitRemoteBranch branch = (GitRemoteBranch)a;
                boolean bl = false;
                GitRemoteBranch gitRemoteBranch = branch;
                Intrinsics.checkNotNullExpressionValue((Object)gitRemoteBranch, (String)"branch");
                branch = (GitRemoteBranch)b;
                Comparable comparable = (Comparable)((Object)gitRemoteBranch.getNameForRemoteOperations());
                bl = false;
                GitRemoteBranch gitRemoteBranch2 = branch;
                Intrinsics.checkNotNullExpressionValue((Object)gitRemoteBranch2, (String)"branch");
                String string = gitRemoteBranch2.getNameForRemoteOperations();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
            }
        });
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            GitRemoteBranch branch = (GitRemoteBranch)element$iv$iv;
            boolean bl = false;
            GitRemoteBranch gitRemoteBranch = branch;
            Intrinsics.checkNotNullExpressionValue((Object)gitRemoteBranch, (String)"branch");
            GitRemote key$iv$iv = gitRemoteBranch.getRemote();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final ValidationInfo validateRepositoryField() {
        return this.getSelectedRepository() != null ? null : new ValidationInfo(GitBundle.message("pull.repository.not.selected.error", new Object[0]), (JComponent)this.repositoryField);
    }

    private final ValidationInfo validateRemoteField() {
        return this.getRemote() != null ? null : new ValidationInfo(GitBundle.message("pull.remote.not.selected", new Object[0]), (JComponent)this.remoteField);
    }

    private final ValidationInfo validateBranchField() {
        return GitMergeDialogKt.validateBranchField(this.branchField, "pull.branch.not.selected.error");
    }

    private final GitRepository getSelectedRepository() {
        return (GitRepository)this.repositoryField.getItem();
    }

    private final void updateRemotesField() {
        GitRepository repository = this.getSelectedRepository();
        ComboBoxModel comboBoxModel = this.remoteField.getModel();
        if (comboBoxModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<git4idea.repo.GitRemote!>");
        }
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        Object object = repository;
        if (object == null || (object = object.getRemotes()) == null || (object = CollectionsKt.toList((Iterable)((Iterable)object))) == null) {
            object = CollectionsKt.emptyList();
        }
        model.update((List)object);
        model.setSelectedItem((Object)this.getCurrentOrDefaultRemote(repository));
    }

    private final void updateBranchesField() {
        Object object;
        Object branchToSelect = (String)this.branchField.getItem();
        GitRepository gitRepository = this.getSelectedRepository();
        if (gitRepository == null) {
            return;
        }
        GitRepository repository = gitRepository;
        GitRemote gitRemote = this.getRemote();
        if (gitRemote == null) {
            return;
        }
        GitRemote remote = gitRemote;
        List<String> list2 = GitBranchUtil.sortBranchNames((Collection<String>)this.getRemoteBranches(repository, remote));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"GitBranchUtil.sortBranch\u2026ches(repository, remote))");
        List<String> branches2 = list2;
        ComboBoxModel comboBoxModel = this.branchField.getModel();
        if (comboBoxModel == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.ui.MutableCollectionComboBoxModel<kotlin.String!>");
        }
        MutableCollectionComboBoxModel model = (MutableCollectionComboBoxModel)comboBoxModel;
        model.update(branches2);
        if (branchToSelect == null || !branches2.contains(branchToSelect)) {
            Object object2;
            Object object3 = repository.getCurrentBranch();
            if (object3 == null || (object3 = ((GitLocalBranch)object3).findTrackedBranch(repository)) == null || (object3 = ((GitRemoteBranch)object3).getNameForRemoteOperations()) == null) {
                Object v5;
                block8: {
                    Object object4 = object = (Iterable)branches2;
                    Iterator iterator = object4.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String branch = (String)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)branch, (Object)repository.getCurrentBranchName())) continue;
                        v5 = t;
                        break block8;
                    }
                    v5 = null;
                }
                object3 = object2 = (String)v5;
            }
            if (object3 == null) {
                object2 = branchToSelect = "";
            }
        }
        if ((object = (CharSequence)branchToSelect).length() == 0) {
            this.startTrackingValidation();
        }
        this.branchField.setSelectedItem(branchToSelect);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getRemoteBranches(GitRepository repository, GitRemote remote) {
        List list2;
        Map<GitRemote, List<GitRemoteBranch>> map2 = this.branches.get(repository);
        if (map2 != null && (map2 = map2.get(remote)) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)((Object)map2);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                void it;
                GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v1 = it;
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
                Intrinsics.checkNotNullExpressionValue((Object)v1.getNameForRemoteOperations(), (String)"it.nameForRemoteOperations");
                collection.add(string);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    private final GitRemote getCurrentOrDefaultRemote(GitRepository repository) {
        Object object = repository;
        if (object == null || (object = object.getRemotes()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"repository?.remotes ?: return null");
        Object remotes = object;
        if (remotes.isEmpty()) {
            return null;
        }
        Object object2 = GitUtil.getTrackInfoForCurrentBranch(repository);
        if (object2 == null || (object2 = ((GitBranchTrackInfo)object2).getRemote()) == null) {
            object2 = GitUtil.getDefaultOrFirstRemote((Collection<GitRemote>)remotes);
        }
        return object2;
    }

    private final void optionChosen(GitPullOption option) {
        if (!this.selectedOptions.contains((Object)option)) {
            Collection collection = this.selectedOptions;
            collection.add(option);
        } else {
            Collection collection = this.selectedOptions;
            collection.remove((Object)option);
        }
        this.updateUi();
    }

    private final void performFetch() {
        if (this.fetchSupport.isFetchRunning()) {
            return;
        }
        GitRepository repository = this.getSelectedRepository();
        GitRemote remote = this.getRemote();
        if (repository == null || remote == null) {
            VcsNotifier.getInstance((Project)this.project).notifyError("git.fetch.error", GitBundle.message("pull.fetch.failed.notification.title", new Object[0]), GitBundle.message("pull.fetch.failed.notification.text", new Object[0]));
            return;
        }
        GitVcs.runInBackground(this.getFetchTask(repository, remote));
    }

    private final getFetchTask.1 getFetchTask(GitRepository repository, GitRemote remote) {
        return new Task.Backgroundable(this, repository, remote, this.project, GitBundle.message("fetching", new Object[0]), true){
            final /* synthetic */ GitPullDialog this$0;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRemote $remote;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitPullDialog.access$getFetchSupport$p(this.this$0).fetch(this.$repository, this.$remote);
            }

            public void onSuccess() {
                GitPullDialog.access$getBranches$p(this.this$0).put(this.$repository, GitPullDialog.access$getBranchesInRepo(this.this$0, this.$repository));
                if (Intrinsics.areEqual((Object)GitPullDialog.access$getSelectedRepository(this.this$0), (Object)this.$repository) && Intrinsics.areEqual((Object)GitPullDialog.access$getRemote(this.this$0), (Object)this.$remote)) {
                    GitPullDialog.access$updateBranchesField(this.this$0);
                }
            }
            {
                this.this$0 = this$0;
                this.$repository = $captured_local_variable$1;
                this.$remote = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        };
    }

    private final GitOptionsPopupBuilder<GitPullOption> createPopupBuilder() {
        String string = GitBundle.message("pull.options.modify.popup.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"pull.\u2026ions.modify.popup.title\")");
        return new GitOptionsPopupBuilder<GitPullOption>(this.project, string, (Function0)new Function0<List<? extends GitPullOption>>(this){

            @NotNull
            public final List<GitPullOption> invoke() {
                return GitPullDialog.access$getOptions((GitPullDialog)((Object)this.receiver));
            }
        }, (Function1)new Function1<GitPullOption, OptionInfo<GitPullOption>>(this){

            @NotNull
            public final OptionInfo<GitPullOption> invoke(@NotNull GitPullOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitPullDialog.access$getOptionInfo((GitPullDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitPullOption, Boolean>(this){

            public final boolean invoke(@NotNull GitPullOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitPullDialog.access$isOptionSelected((GitPullDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitPullOption, Boolean>(this){

            public final boolean invoke(@NotNull GitPullOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitPullDialog.access$isOptionEnabled((GitPullDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitPullOption, Unit>(this){

            public final void invoke(@NotNull GitPullOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                GitPullDialog.access$optionChosen((GitPullDialog)((Object)this.receiver), p1);
            }
        }, null, 128, null);
    }

    private final boolean isOptionSelected(GitPullOption option) {
        return this.selectedOptions.contains((Object)option);
    }

    private final DropDownLink<String> createOptionsDropDown() {
        DropDownLink dropDownLink;
        DropDownLink $this$apply = dropDownLink = new DropDownLink((Object)GitBundle.message("merge.options.modify", new Object[0]), (Function1)new Function1<DropDownLink<String>, JBPopup>(this){
            final /* synthetic */ GitPullDialog this$0;

            @NotNull
            public final JBPopup invoke(@NotNull DropDownLink<String> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                return (JBPopup)GitPullDialog.access$getPopupBuilder$p(this.this$0).createPopup();
            }
            {
                this.this$0 = gitPullDialog;
                super(1);
            }
        });
        boolean bl = false;
        $this$apply.setMnemonic(77);
        return dropDownLink;
    }

    private final OptionInfo<GitPullOption> getOptionInfo(GitPullOption option) {
        OptionInfo<GitPullOption> optionInfo = this.optionInfos.computeIfAbsent(option, new Function(option){
            final /* synthetic */ GitPullOption $option;

            @NotNull
            public final OptionInfo<GitPullOption> apply(@NotNull GitPullOption it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                return new OptionInfo<GitPullOption>(this.$option, this.$option.getOption(), this.$option.getDescription());
            }
            {
                this.$option = gitPullOption;
            }
        });
        Intrinsics.checkNotNullExpressionValue(optionInfo, (String)"optionInfos.computeIfAbs\u2026, option.description)\n  }");
        return optionInfo;
    }

    private final List<GitPullOption> getOptions() {
        List list2;
        List $this$apply = list2 = ArraysKt.toMutableList((Object[])GitPullOption.values());
        boolean bl = false;
        if (!this.isNoVerifySupported) {
            $this$apply.remove((Object)GitPullOption.NO_VERIFY);
        }
        return list2;
    }

    private final void updateUi() {
        this.optionsPanel.rerender(this.selectedOptions);
        this.rerender();
    }

    private final void rerender() {
        this.getWindow().pack();
        this.getWindow().revalidate();
        this.pack();
        this.repaint();
    }

    private final boolean isOptionEnabled(GitPullOption option) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = this.selectedOptions;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    GitPullOption it = (GitPullOption)((Object)element$iv);
                    boolean bl2 = false;
                    if (it.isOptionSuitable(option)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final void updateTitle() {
        GitRepository gitRepository = this.getSelectedRepository();
        String currentBranchName = gitRepository != null ? gitRepository.getCurrentBranchName() : null;
        CharSequence charSequence = currentBranchName;
        this.setTitle(charSequence == null || charSequence.length() == 0 ? GitBundle.message("pull.dialog.title", new Object[0]) : GitBundle.message("pull.dialog.with.branch.title", currentBranchName));
    }

    private final JPanel createPanel() {
        JPanel jPanel;
        JPanel $this$apply = jPanel = new JPanel();
        boolean bl = false;
        $this$apply.setLayout((LayoutManager)new MigLayout(new LC().insets("0").hideMode(3), new AC().grow()));
        $this$apply.add((Component)this.commandPanel, new CC().growX());
        $this$apply.add((Component)this.optionsPanel, new CC().newline().width("100%").alignY("top"));
        return jPanel;
    }

    private final boolean showRootField() {
        return this.roots.size() > 1;
    }

    private final JPanel createCommandPanel() {
        JPanel jPanel;
        JPanel $this$apply = jPanel = new JPanel();
        boolean bl = false;
        AC colConstraints = this.showRootField() ? new AC().grow(100.0f, new int[]{0, 3}) : new AC().grow(100.0f, new int[]{2});
        $this$apply.setLayout((LayoutManager)new MigLayout(new LC().fillX().insets("0").gridGap("0", "0").noVisualPadding(), colConstraints));
        if (this.showRootField()) {
            $this$apply.add((Component)this.repositoryField, new CC().gapAfter("0").minWidth(JBUI.scale((int)115) + "px").growX());
        }
        $this$apply.add((Component)this.createCmdLabel(), new CC().gapAfter("0").alignY("top").minWidth(JBUI.scale((int)85) + "px"));
        $this$apply.add((Component)this.remoteField, new CC().alignY("top").minWidth(JBUI.scale((int)90) + "px"));
        $this$apply.add((Component)((Object)this.branchField), new CC().alignY("top").minWidth(JBUI.scale((int)250) + "px").growX());
        return jPanel;
    }

    private final CmdLabel createCmdLabel() {
        return new CmdLabel("git pull", new Insets(1, this.showRootField() ? 0 : 1, 1, 0), (Dimension)new JBDimension(JBUI.scale((int)85), this.branchField.getPreferredSize().height, true));
    }

    private final ComboBox<GitRepository> createRepoField() {
        ComboBox<GitRepository> comboBox;
        List<GitRepository> list2 = this.repositories;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"repositories");
        ComboBox<GitRepository> $this$apply = comboBox = GitMergeDialogKt.createRepositoryField(list2, this.defaultRoot);
        boolean bl = false;
        $this$apply.addActionListener(new ActionListener(this){
            final /* synthetic */ GitPullDialog this$0;
            {
                this.this$0 = gitPullDialog;
            }

            public final void actionPerformed(ActionEvent it) {
                GitPullDialog.access$updateTitle(this.this$0);
                GitPullDialog.access$updateRemotesField(this.this$0);
            }
        });
        return comboBox;
    }

    private final ComboBox<GitRemote> createRemoteField() {
        ComboBox comboBox;
        ComboBox $this$apply = comboBox = new ComboBox((ComboBoxModel)new MutableCollectionComboBoxModel());
        boolean bl = false;
        $this$apply.setSwingPopup(false);
        $this$apply.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)HtmlChunk.text((String)GitBundle.message("util.remote.renderer.none", new Object[0])).italic().wrapWith(HtmlChunk.Element.html()).toString(), (com.intellij.util.Function)createRemoteField.1.1.INSTANCE));
        Insets insets = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), 0);
        String string = GitBundle.message("pull.branch.no.matching.remotes", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"pull.\u2026nch.no.matching.remotes\")");
        $this$apply.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(null, insets, string, null, 9, null)));
        $this$apply.setItem((Object)this.getCurrentOrDefaultRemote(this.getSelectedRepository()));
        $this$apply.addItemListener(new ItemListener(this){
            final /* synthetic */ GitPullDialog this$0;
            {
                this.this$0 = gitPullDialog;
            }

            public final void itemStateChanged(ItemEvent e) {
                ItemEvent itemEvent = e;
                Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"e");
                if (itemEvent.getStateChange() == 1) {
                    GitPullDialog.access$updateBranchesField(this.this$0);
                }
            }
        });
        return comboBox;
    }

    private final ComboBoxWithAutoCompletion<String> createBranchField() {
        ComboBoxWithAutoCompletion<String> comboBoxWithAutoCompletion;
        ComboBoxWithAutoCompletion<String> $this$apply = comboBoxWithAutoCompletion = new ComboBoxWithAutoCompletion<String>((ComboBoxModel)new MutableCollectionComboBoxModel((List)new ArrayList()), this.project);
        boolean bl = false;
        $this$apply.setPrototypeDisplayValue("origin/long-enough-branch-name");
        String string = GitBundle.message("pull.branch.field.placeholder", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"pull.branch.field.placeholder\")");
        $this$apply.setPlaceholder(string);
        new RefreshAction($this$apply, this){
            final /* synthetic */ ComboBoxWithAutoCompletion $this_apply;
            final /* synthetic */ GitPullDialog this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = gitPullDialog;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                ComboPopup comboPopup = this.$this_apply.getPopup();
                if (comboPopup != null) {
                    comboPopup.hide();
                }
                GitPullDialog.access$performFetch(this.this$0);
            }

            public void update(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Presentation presentation = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
                presentation.setEnabled(true);
            }
        }.registerCustomShortcutSet(this.getFetchActionShortcut(), (JComponent)((Object)$this$apply));
        Insets insets = new Insets(1, 0, 1, 1);
        Insets insets2 = new Insets(DarculaUIUtil.BW.get(), 0, DarculaUIUtil.BW.get(), DarculaUIUtil.BW.get());
        String string2 = GitBundle.message("pull.branch.nothing.to.pull", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"pull.branch.nothing.to.pull\")");
        $this$apply.setUI((ComboBoxUI)((Object)new FlatComboBoxUI(insets, insets2, string2, (Function1<? super JComponent, ? extends JComponent>)((Function1)new Function1<JComponent, JPanel>(this){

            @NotNull
            public final JPanel invoke(@NotNull JComponent p1) {
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return GitPullDialog.access$createBranchFieldPopupComponent((GitPullDialog)((Object)this.receiver), p1);
            }
        }))));
        return comboBoxWithAutoCompletion;
    }

    private final JPanel createBranchFieldPopupComponent(JComponent content2) {
        JPanel jPanel;
        JPanel $this$apply = jPanel = new JPanel();
        boolean bl = false;
        $this$apply.setLayout((LayoutManager)new MigLayout(new LC().insets("0")));
        $this$apply.add((Component)content2, new CC().width("100%"));
        JLabel jLabel = HintUtil.createAdComponent((String)GitBundle.message("pull.dialog.fetch.shortcuts.hint", this.getFetchActionShortcutText()), (Border)JBUI.CurrentTheme.BigPopup.advertiserBorder(), (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"HintUtil.createAdCompone\u2026     SwingConstants.LEFT)");
        JLabel hintLabel = jLabel;
        hintLabel.setPreferredSize((Dimension)JBDimension.create((Dimension)hintLabel.getPreferredSize(), (boolean)true).withHeight(17));
        $this$apply.add((Component)hintLabel, new CC().newline().width("100%"));
        return jPanel;
    }

    private final ShortcutSet getFetchActionShortcut() {
        AnAction anAction = ActionManager.getInstance().getAction("Refresh");
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"ActionManager.getInstanc\u2026deActions.ACTION_REFRESH)");
        ShortcutSet shortcutSet = anAction.getShortcutSet();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutSet, (String)"ActionManager.getInstanc\u2026TION_REFRESH).shortcutSet");
        ShortcutSet refreshActionShortcut = shortcutSet;
        Shortcut[] shortcutArray = refreshActionShortcut.getShortcuts();
        Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"refreshActionShortcut.shortcuts");
        Shortcut[] shortcutArray2 = shortcutArray;
        if (!(shortcutArray2.length == 0)) {
            return refreshActionShortcut;
        }
        return (ShortcutSet)FETCH_ACTION_SHORTCUT;
    }

    private final String getFetchActionShortcutText() {
        String string = KeymapUtil.getPreferredShortcutText((Shortcut[])this.getFetchActionShortcut().getShortcuts());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"KeymapUtil.getPreferredS\u2026tionShortcut().shortcuts)");
        return string;
    }

    public GitPullDialog(@NotNull Project project, @NotNull List<? extends VirtualFile> roots, @NotNull VirtualFile defaultRoot) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)defaultRoot, (String)"defaultRoot");
        super(project);
        this.project = project;
        this.roots = roots;
        this.defaultRoot = defaultRoot;
        this.selectedOptions = new LinkedHashSet();
        Project $this$service$iv = this.project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(GitFetchSupport.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        this.fetchSupport = (GitFetchSupport)object;
        $this$service$iv = this.project;
        $i$f$service = false;
        Object object2 = $this$service$iv.getService(GitPullSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getService(T::class.java)");
        this.pullSettings = (GitPullSettings)object2;
        GitRepositoryManager gitRepositoryManager = GitRepositoryManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"GitRepositoryManager.getInstance(project)");
        this.repositories = DvcsUtil.sortRepositories((Collection)gitRepositoryManager.getRepositories());
        this.branches = MapsKt.toMutableMap(this.collectBranches());
        this.optionInfos = new LinkedHashMap();
        this.popupBuilder = this.createPopupBuilder();
        this.repositoryField = this.createRepoField();
        this.remoteField = this.createRemoteField();
        this.branchField = this.createBranchField();
        this.commandPanel = this.createCommandPanel();
        this.optionsPanel = new GitOptionsPanel((Function1)new Function1<GitPullOption, Unit>(this){

            public final void invoke(@NotNull GitPullOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                GitPullDialog.access$optionChosen((GitPullDialog)((Object)this.receiver), p1);
            }
        }, (Function1)new Function1<GitPullOption, OptionInfo<GitPullOption>>(this){

            @NotNull
            public final OptionInfo<GitPullOption> invoke(@NotNull GitPullOption p1) {
                Intrinsics.checkNotNullParameter((Object)((Object)p1), (String)"p1");
                return GitPullDialog.access$getOptionInfo((GitPullDialog)((Object)this.receiver), p1);
            }
        });
        this.panel = this.createPanel();
        this.isNoVerifySupported = GitVersionSpecialty.NO_VERIFY_SUPPORTED.existsIn(GitExecutableManager.getInstance().getVersion(this.project));
        this.updateTitle();
        this.setOKButtonText(GitBundle.message("pull.button", new Object[0]));
        this.loadSettings();
        this.updateRemotesField();
        this.init();
        this.updateUi();
    }

    static {
        Companion = new Companion(null);
        FETCH_ACTION_SHORTCUT = SystemInfo.isMac ? new CustomShortcutSet(KeyStroke.getKeyStroke(82, 256)) : new CustomShortcutSet(KeyStroke.getKeyStroke(116, 128));
    }

    public static final /* synthetic */ ValidationInfo access$validateRepositoryField(GitPullDialog $this) {
        return $this.validateRepositoryField();
    }

    public static final /* synthetic */ ValidationInfo access$validateRemoteField(GitPullDialog $this) {
        return $this.validateRemoteField();
    }

    public static final /* synthetic */ ValidationInfo access$validateBranchField(GitPullDialog $this) {
        return $this.validateBranchField();
    }

    public static final /* synthetic */ GitFetchSupport access$getFetchSupport$p(GitPullDialog $this) {
        return $this.fetchSupport;
    }

    public static final /* synthetic */ Map access$getBranchesInRepo(GitPullDialog $this, GitRepository repository) {
        return $this.getBranchesInRepo(repository);
    }

    public static final /* synthetic */ Map access$getBranches$p(GitPullDialog $this) {
        return $this.branches;
    }

    public static final /* synthetic */ GitRepository access$getSelectedRepository(GitPullDialog $this) {
        return $this.getSelectedRepository();
    }

    public static final /* synthetic */ GitRemote access$getRemote(GitPullDialog $this) {
        return $this.getRemote();
    }

    public static final /* synthetic */ void access$updateBranchesField(GitPullDialog $this) {
        $this.updateBranchesField();
    }

    public static final /* synthetic */ List access$getOptions(GitPullDialog $this) {
        return $this.getOptions();
    }

    public static final /* synthetic */ OptionInfo access$getOptionInfo(GitPullDialog $this, GitPullOption option) {
        return $this.getOptionInfo(option);
    }

    public static final /* synthetic */ boolean access$isOptionSelected(GitPullDialog $this, GitPullOption option) {
        return $this.isOptionSelected(option);
    }

    public static final /* synthetic */ boolean access$isOptionEnabled(GitPullDialog $this, GitPullOption option) {
        return $this.isOptionEnabled(option);
    }

    public static final /* synthetic */ void access$optionChosen(GitPullDialog $this, GitPullOption option) {
        $this.optionChosen(option);
    }

    public static final /* synthetic */ GitOptionsPopupBuilder access$getPopupBuilder$p(GitPullDialog $this) {
        return $this.popupBuilder;
    }

    public static final /* synthetic */ void access$updateTitle(GitPullDialog $this) {
        $this.updateTitle();
    }

    public static final /* synthetic */ void access$updateRemotesField(GitPullDialog $this) {
        $this.updateRemotesField();
    }

    public static final /* synthetic */ void access$performFetch(GitPullDialog $this) {
        $this.performFetch();
    }

    public static final /* synthetic */ JPanel access$createBranchFieldPopupComponent(GitPullDialog $this, JComponent content2) {
        return $this.createBranchFieldPopupComponent(content2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/pull/GitPullDialog$Companion;", "", "()V", "FETCH_ACTION_SHORTCUT", "Lcom/intellij/openapi/actionSystem/CustomShortcutSet;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

