/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive.dialog.view;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorSettingsProvider;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEntryWithDetails;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableModel;
import git4idea.rebase.interactive.dialog.GitRebaseCommitsTableView;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditor;
import git4idea.rebase.interactive.dialog.view.CommitMessageCellEditorKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0081\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u000b\b\u0000\u0018\u0000 12\u00020\u00012\u00020\u0002:\u00011B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u001b\u001a\u00020\u0010H\u0002J\b\u0010\u001c\u001a\u00020\u0012H\u0002J\r\u0010\u001d\u001a\u00070\u001e\u00a2\u0006\u0002\b\u001fH\u0016J2\u0010 \u001a\u00020!2\u0006\u0010\u0005\u001a\u00020\"2\b\u0010\u0014\u001a\u0004\u0018\u00010#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0015H\u0016J\u0012\u0010(\u001a\u00020%2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\u0018\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00158B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor;", "Ljavax/swing/AbstractCellEditor;", "Ljavax/swing/table/TableCellEditor;", "project", "Lcom/intellij/openapi/project/Project;", "table", "Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;", "disposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/rebase/interactive/dialog/GitRebaseCommitsTableView;Lcom/intellij/openapi/Disposable;)V", "closeEditorAction", "git4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$closeEditorAction$1", "Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$closeEditorAction$1;", "commitMessageForEntry", "", "Lgit4idea/rebase/GitRebaseEntryWithDetails;", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "hint", "Ljavax/swing/JLabel;", "lastUsedCommitMessageField", "value", "", "savedHeight", "getSavedHeight", "()I", "setSavedHeight", "(I)V", "createCommitMessage", "createHint", "getCellEditorValue", "", "Lorg/jetbrains/annotations/NotNull;", "getTableCellEditorComponent", "Ljava/awt/Component;", "Ljavax/swing/JTable;", "", "isSelected", "", "row", "column", "isCellEditable", "e", "Ljava/util/EventObject;", "registerCloseEditorShortcut", "", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "shortcut", "Ljavax/swing/KeyStroke;", "Companion", "intellij.vcs.git"})
public final class CommitMessageCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final closeEditorAction.1 closeEditorAction;
    private final Map<GitRebaseEntryWithDetails, CommitMessage> commitMessageForEntry;
    private CommitMessage lastUsedCommitMessageField;
    private final JLabel hint;
    private final Project project;
    private final GitRebaseCommitsTableView table;
    private final Disposable disposable;
    @NonNls
    private static final String COMMIT_MESSAGE_HEIGHT_KEY = "Git.Interactive.Rebase.Dialog.Commit.Message.Height";
    private static final int HINT_HEIGHT;
    private static final int DEFAULT_COMMIT_MESSAGE_HEIGHT;
    @NotNull
    public static final Companion Companion;

    private final int getSavedHeight() {
        return PropertiesComponent.getInstance((Project)this.project).getInt(COMMIT_MESSAGE_HEIGHT_KEY, DEFAULT_COMMIT_MESSAGE_HEIGHT);
    }

    private final void setSavedHeight(int value) {
        PropertiesComponent.getInstance((Project)this.project).setValue(COMMIT_MESSAGE_HEIGHT_KEY, value, DEFAULT_COMMIT_MESSAGE_HEIGHT);
    }

    private final CommitMessage createCommitMessage() {
        CommitMessage commitMessage;
        CommitMessage $this$apply = commitMessage = new CommitMessage(this.project, false, false, true);
        boolean bl = false;
        $this$apply.getEditorField().addSettingsProvider(new EditorSettingsProvider(this){
            final /* synthetic */ CommitMessageCellEditor this$0;
            {
                this.this$0 = commitMessageCellEditor;
            }

            public final void customizeSettings(EditorEx editor) {
                EditorEx editorEx = editor;
                Intrinsics.checkNotNullExpressionValue((Object)editorEx, (String)"editor");
                JScrollPane jScrollPane = editorEx.getScrollPane();
                Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"editor.scrollPane");
                jScrollPane.setBorder((Border)JBUI.Borders.empty());
                KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 128);
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke, (String)"KeyStroke.getKeyStroke(K\u2026nputEvent.CTRL_DOWN_MASK)");
                CommitMessageCellEditor.access$registerCloseEditorShortcut(this.this$0, editor, keyStroke);
                KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 256);
                Intrinsics.checkNotNullExpressionValue((Object)keyStroke2, (String)"KeyStroke.getKeyStroke(K\u2026nputEvent.META_DOWN_MASK)");
                CommitMessageCellEditor.access$registerCloseEditorShortcut(this.this$0, editor, keyStroke2);
            }
        });
        $this$apply.getEditorField().setCaretPosition(0);
        Disposer.register((Disposable)this.disposable, (Disposable)((Disposable)$this$apply));
        return commitMessage;
    }

    private final void registerCloseEditorShortcut(EditorEx editor, KeyStroke shortcut) {
        String key = "applyEdit" + shortcut;
        JComponent jComponent = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        jComponent.getInputMap().put(shortcut, key);
        JComponent jComponent2 = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent2, (String)"editor.contentComponent");
        jComponent2.getActionMap().put(key, this.closeEditorAction);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Component getTableCellEditorComponent(@NotNull JTable table, @Nullable Object value, boolean isSelected, int row, int column) {
        BorderLayoutPanel borderLayoutPanel;
        CommitMessage commitMessageField;
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        GitRebaseCommitsTableModel<?> model = this.table.getModel();
        Map<GitRebaseEntryWithDetails, CommitMessage> map2 = this.commitMessageForEntry;
        Object key$iv = model.getEntry(row);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            CommitMessage answer$iv = this.createCommitMessage();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        this.lastUsedCommitMessageField = commitMessageField = (CommitMessage)object;
        commitMessageField.setText(model.getCommitMessage(row));
        table.setRowHeight(row, this.getSavedHeight());
        BorderLayoutPanel componentPanel2 = new BorderLayoutPanel(commitMessageField){
            final /* synthetic */ CommitMessage $commitMessageField;

            public void requestFocus() {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(this){
                    final /* synthetic */ getTableCellEditorComponent.componentPanel.1 this$0;

                    public final void run() {
                        IdeFocusManager.getGlobalInstance().requestFocus((Component)this.this$0.$commitMessageField.getEditorField(), true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$commitMessageField = $captured_local_variable$0;
            }
        };
        BorderLayoutPanel $this$apply = borderLayoutPanel = componentPanel2.addToCenter((Component)commitMessageField).addToBottom((Component)this.hint);
        boolean bl = false;
        $this$apply.setBackground(table.getBackground());
        $this$apply.setBorder(JBUI.Borders.merge((Border)IdeBorderFactory.createBorder(), (Border)((Border)JBUI.Borders.empty((int)6, (int)0, (int)0, (int)6)), (boolean)true));
        BorderLayoutPanel borderLayoutPanel2 = $this$apply;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"this");
        CommitMessageCellEditorKt.access$makeResizable((JPanel)borderLayoutPanel2, (Function1)new Function1<Integer, Unit>(this, table, row){
            final /* synthetic */ CommitMessageCellEditor this$0;
            final /* synthetic */ JTable $table$inlined;
            final /* synthetic */ int $row$inlined;
            {
                this.this$0 = commitMessageCellEditor;
                this.$table$inlined = jTable;
                this.$row$inlined = n;
                super(1);
            }

            public final void invoke(int newHeight) {
                int n = CommitMessageCellEditor.access$getDEFAULT_COMMIT_MESSAGE_HEIGHT$cp();
                int height = Math.max(n, newHeight);
                this.$table$inlined.setRowHeight(this.$row$inlined, height);
                CommitMessageCellEditor.access$setSavedHeight$p(this.this$0, height);
            }
        });
        BorderLayoutPanel borderLayoutPanel3 = borderLayoutPanel;
        Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel3, (String)"componentPanel.addToCent\u2026ht = height\n      }\n    }");
        return (Component)borderLayoutPanel3;
    }

    private final JLabel createHint() {
        JLabel jLabel;
        String string = GitBundle.message("rebase.interactive.dialog.reword.hint.text", KeymapUtil.getFirstKeyboardShortcutText((ShortcutSet)CommonShortcuts.CTRL_ENTER));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"rebas\u2026monShortcuts.CTRL_ENTER))");
        String hint = string;
        JLabel $this$apply = jLabel = HintUtil.createAdComponent((String)hint, (Border)JBUI.CurrentTheme.BigPopup.advertiserBorder(), (int)2);
        boolean bl = false;
        $this$apply.setForeground(JBUI.CurrentTheme.BigPopup.advertiserForeground());
        $this$apply.setBackground(JBUI.CurrentTheme.BigPopup.advertiserBackground());
        $this$apply.setOpaque(true);
        JLabel jLabel2 = jLabel;
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"HintUtil.createAdCompone\u2026    isOpaque = true\n    }");
        JLabel hintLabel = jLabel2;
        Dimension size = hintLabel.getPreferredSize();
        size.height = HINT_HEIGHT;
        hintLabel.setPreferredSize(size);
        return hintLabel;
    }

    @Override
    @NotNull
    public String getCellEditorValue() {
        Object object = this.lastUsedCommitMessageField;
        if (object == null || (object = object.getText()) == null) {
            object = "";
        }
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"lastUsedCommitMessageField?.text ?: \"\"");
        return object;
    }

    @Override
    public boolean isCellEditable(@Nullable EventObject e) {
        return this.table.getSelectedRowCount() > 1 ? false : (e instanceof MouseEvent ? ((MouseEvent)e).getClickCount() >= 2 : true);
    }

    public CommitMessageCellEditor(@NotNull Project project, @NotNull GitRebaseCommitsTableView table, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)table), (String)"table");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project = project;
        this.table = table;
        this.disposable = disposable;
        this.closeEditorAction = new AbstractAction(this){
            final /* synthetic */ CommitMessageCellEditor this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                this.this$0.stopCellEditing();
            }
            {
                this.this$0 = this$0;
            }
        };
        this.commitMessageForEntry = new LinkedHashMap();
        this.hint = this.createHint();
    }

    static {
        Companion = new Companion(null);
        HINT_HEIGHT = JBUIScale.scale((int)17);
        DEFAULT_COMMIT_MESSAGE_HEIGHT = GitRebaseCommitsTableView.Companion.getDEFAULT_CELL_HEIGHT() * 5;
    }

    public static final /* synthetic */ void access$registerCloseEditorShortcut(CommitMessageCellEditor $this, EditorEx editor, KeyStroke shortcut) {
        $this.registerCloseEditorShortcut(editor, shortcut);
    }

    public static final /* synthetic */ int access$getDEFAULT_COMMIT_MESSAGE_HEIGHT$cp() {
        return DEFAULT_COMMIT_MESSAGE_HEIGHT;
    }

    public static final /* synthetic */ int access$getSavedHeight$p(CommitMessageCellEditor $this) {
        return $this.getSavedHeight();
    }

    public static final /* synthetic */ void access$setSavedHeight$p(CommitMessageCellEditor $this, int n) {
        $this.setSavedHeight(n);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lgit4idea/rebase/interactive/dialog/view/CommitMessageCellEditor$Companion;", "", "()V", "COMMIT_MESSAGE_HEIGHT_KEY", "", "DEFAULT_COMMIT_MESSAGE_HEIGHT", "", "HINT_HEIGHT", "canResize", "", "height", "point", "Ljava/awt/Point;", "canResize$intellij_vcs_git", "intellij.vcs.git"})
    public static final class Companion {
        public final boolean canResize$intellij_vcs_git(int height, @NotNull Point point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            int n = point.y;
            return height - HINT_HEIGHT <= n && height >= n;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

