/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.ChangeListViewerDialog;
import com.intellij.openapi.vcs.changes.ui.LoadingCommittedChangeListPanel;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.CollectConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.vcs.log.Hash;
import git4idea.GitCommit;
import git4idea.GitStashUsageCollector;
import git4idea.GitUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitSimpleEventDetector;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.history.GitCommitRequirements;
import git4idea.history.GitLogUtil;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryFiles;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitStashOperations;
import git4idea.stash.GitStashUtils;
import git4idea.stash.UnstashConflictResolver;
import git4idea.ui.StashInfo;
import git4idea.util.GitUIUtil;
import git4idea.util.GitUntrackedFilesHelper;
import git4idea.util.LocalChangesWouldBeOverwrittenHelper;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\"\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0007JF\u0010\u000e\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0007J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J2\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u0004H\u0007JB\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0007J \u0010%\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010&\u001a\u00020\u0004H\u0007\u00a8\u0006'"}, d2={"Lgit4idea/stash/GitStashOperations;", "", "()V", "clearStashesWithConfirmation", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentComponent", "Ljava/awt/Component;", "dropStashWithConfirmation", "stash", "Lgit4idea/ui/StashInfo;", "loadStashChanges", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/vcs/changes/Change;", "", "Lgit4idea/GitCommit;", "hash", "Lcom/intellij/vcs/log/Hash;", "parentHashes", "refreshUnstashedChanges", "", "unstash", "branch", "", "popStash", "reinstateIndex", "rootAndRevisions", "", "handlerProvider", "Lkotlin/Function1;", "Lgit4idea/commands/GitLineHandler;", "conflictResolver", "Lgit4idea/merge/GitConflictResolver;", "viewStash", "compareWithLocal", "intellij.vcs.git"})
public final class GitStashOperations {
    @NotNull
    public static final GitStashOperations INSTANCE;

    @JvmStatic
    public static final boolean dropStashWithConfirmation(@NotNull Project project, @Nullable Component parentComponent, @NotNull StashInfo stash) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        String string = GitBundle.message("git.unstash.drop.confirmation.title", stash.getStash());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.u\u2026tion.title\", stash.stash)");
        String string2 = GitBundle.message("git.unstash.drop.confirmation.message", stash.getStash(), stash.getMessage());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"git.u\u2026           stash.message)");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getQuestionIcon());
        boolean bl = confirmed = parentComponent != null ? dialogBuilder.ask(parentComponent) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h2 = new GitLineHandler(project, stash.getRoot(), GitCommand.STASH);
        h2.addParameters("drop", stash.getStash());
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(h2){
                final /* synthetic */ GitLineHandler $h;

                public final void compute() {
                    Git.getInstance().runCommand(this.$h).throwOnError(new int[0]);
                }
                {
                    this.$h = gitLineHandler;
                }
            }, GitBundle.message("unstash.dialog.remove.stash.progress.indicator.title", stash.getStash()), true, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h2.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final boolean clearStashesWithConfirmation(@NotNull Project project, @NotNull VirtualFile root, @Nullable Component parentComponent) {
        boolean confirmed;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        String string = GitBundle.message("git.unstash.clear.confirmation.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GitBundle.message(\"git.u\u2026lear.confirmation.title\")");
        String string2 = GitBundle.message("git.unstash.clear.confirmation.message", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"GitBundle.message(\"git.u\u2026ar.confirmation.message\")");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).icon(Messages.getWarningIcon());
        boolean bl = confirmed = parentComponent != null ? dialogBuilder.ask(parentComponent) : dialogBuilder.ask(project);
        if (!confirmed) {
            return false;
        }
        GitLineHandler h2 = new GitLineHandler(project, root, GitCommand.STASH);
        h2.addParameters("clear");
        try {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(h2){
                final /* synthetic */ GitLineHandler $h;

                public final void compute() {
                    Git.getInstance().runCommand(this.$h).throwOnError(new int[0]);
                }
                {
                    this.$h = gitLineHandler;
                }
            }, GitBundle.message("unstash.clearing.stashes", new Object[0]), false, project);
            return true;
        }
        catch (VcsException ex) {
            GitUIUtil.showOperationError(project, ex, h2.printableCommandLine());
            return false;
        }
    }

    @JvmStatic
    public static final void viewStash(@NotNull Project project, @NotNull StashInfo stash, boolean compareWithLocal) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        LoadingCommittedChangeListPanel panel2 = new LoadingCommittedChangeListPanel(project);
        panel2.loadChangesInBackground(new ThrowableComputable(project, stash, compareWithLocal){
            final /* synthetic */ Project $project;
            final /* synthetic */ StashInfo $stash;
            final /* synthetic */ boolean $compareWithLocal;

            public final LoadingCommittedChangeListPanel.ChangelistData compute() {
                GitCommittedChangeList changes = GitChangeUtils.getRevisionChanges(this.$project, GitUtil.getRootForFile(this.$project, this.$stash.getRoot()), this.$stash.getHash().asString(), true, this.$compareWithLocal, false);
                return new LoadingCommittedChangeListPanel.ChangelistData((CommittedChangeList)changes, null);
            }
            {
                this.$project = project;
                this.$stash = stashInfo;
                this.$compareWithLocal = bl;
            }
        });
        ChangeListViewerDialog.show((Project)project, (String)GitBundle.message("unstash.view.dialog.title", stash.getStash()), (LoadingCommittedChangeListPanel)panel2, null, (boolean)false);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresBackgroundThread
    @NotNull
    public final Pair<Collection<Change>, List<GitCommit>> loadStashChanges(@NotNull Project project, @NotNull VirtualFile root, @NotNull Hash hash, @NotNull List<? extends Hash> parentHashes) throws VcsException {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)hash, (String)"hash");
        Intrinsics.checkNotNullParameter(parentHashes, (String)"parentHashes");
        List stashCommits = new ArrayList();
        Iterable iterable = parentHashes;
        Collection collection2 = CollectionsKt.listOf((Object)hash.asString());
        VirtualFile virtualFile = root;
        Project project2 = project;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Hash hash2 = (Hash)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            String string = it.asString();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        GitLogUtil.readFullDetailsForHashes(project2, virtualFile, CollectionsKt.plus((Collection)collection2, (Iterable)collection), new GitCommitRequirements(true, null, GitCommitRequirements.DiffInMergeCommits.FIRST_PARENT, 2, null), (Consumer<? super GitCommit>)new Consumer(stashCommits){
            final /* synthetic */ List $stashCommits;

            public final void consume(GitCommit it) {
                GitCommit gitCommit = it;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)gitCommit), (String)"it");
                this.$stashCommits.add(gitCommit);
            }
            {
                this.$stashCommits = list2;
            }
        });
        if (stashCommits.isEmpty()) {
            throw (Throwable)new VcsException(GitBundle.message("stash.load.changes.error", root.getName(), hash.asString()));
        }
        return new Pair((Object)((GitCommit)((Object)CollectionsKt.first((List)stashCommits))).getChanges(0), (Object)CollectionsKt.drop((Iterable)stashCommits, (int)1));
    }

    @JvmStatic
    public static final boolean unstash(@NotNull Project project, @NotNull StashInfo stash, @Nullable String branch, boolean popStash, boolean reinstateIndex) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stash, (String)"stash");
        Boolean completed2 = (Boolean)ProgressManager.getInstance().runProcessWithProgressSynchronously(new ThrowableComputable(project, stash, branch, popStash, reinstateIndex){
            final /* synthetic */ Project $project;
            final /* synthetic */ StashInfo $stash;
            final /* synthetic */ String $branch;
            final /* synthetic */ boolean $popStash;
            final /* synthetic */ boolean $reinstateIndex;

            public final Boolean compute() {
                return GitStashOperations.unstash(this.$project, MapsKt.mapOf((Pair)new Pair((Object)this.$stash.getRoot(), (Object)this.$stash.getHash())), (Function1<? super VirtualFile, ? extends GitLineHandler>)((Function1)new Function1<VirtualFile, GitLineHandler>(this){
                    final /* synthetic */ unstash.completed.1 this$0;

                    @NotNull
                    public final GitLineHandler invoke(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GitStashUtils.access$createUnstashHandler(this.this$0.$project, this.this$0.$stash, this.this$0.$branch, this.this$0.$popStash, this.this$0.$reinstateIndex);
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                }), new UnstashConflictResolver(this.$project, this.$stash));
            }
            {
                this.$project = project;
                this.$stash = stashInfo;
                this.$branch = string;
                this.$popStash = bl;
                this.$reinstateIndex = bl2;
            }
        }, GitBundle.message("unstash.unstashing", new Object[0]), true, project);
        if (!completed2.booleanValue()) {
            return false;
        }
        VcsNotifier.getInstance((Project)project).notifySuccess("git.unstash.patch.applied", "", VcsBundle.message((String)"patch.apply.success.applied.text", (Object[])new Object[0]));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean unstash(@NotNull Project project, @NotNull Map<VirtualFile, ? extends Hash> rootAndRevisions, @NotNull Function1<? super VirtualFile, ? extends GitLineHandler> handlerProvider, @NotNull GitConflictResolver conflictResolver) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(rootAndRevisions, (String)"rootAndRevisions");
        Intrinsics.checkNotNullParameter(handlerProvider, (String)"handlerProvider");
        Intrinsics.checkNotNullParameter((Object)conflictResolver, (String)"conflictResolver");
        AutoCloseable autoCloseable = (AutoCloseable)DvcsUtil.workingTreeChangeStarted((Project)project, (String)GitBundle.message("activity.name.unstash", new Object[0]));
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            VirtualFile virtualFile = rootAndRevisions;
            Iterator<Map.Entry<VirtualFile, ? extends Hash>> iterator = virtualFile.entrySet().iterator();
            while (iterator.hasNext()) {
                GitCommandResult result2;
                Object object;
                void root;
                Map.Entry<VirtualFile, ? extends Hash> entry;
                Map.Entry<VirtualFile, ? extends Hash> entry2 = entry = iterator.next();
                virtualFile = entry2.getKey();
                entry2 = entry;
                Hash hash = entry2.getValue();
                GitLineHandler handler = (GitLineHandler)handlerProvider.invoke((Object)root);
                GitSimpleEventDetector indexConflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.INDEX_CONFLICT_ON_UNSTASH);
                GitSimpleEventDetector conflictDetector = new GitSimpleEventDetector(GitSimpleEventDetector.Event.MERGE_CONFLICT_ON_UNSTASH);
                GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector((VirtualFile)root);
                GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector((VirtualFile)root, GitLocalChangesWouldBeOverwrittenDetector.Operation.MERGE);
                handler.addLineListener(indexConflictDetector);
                handler.addLineListener(conflictDetector);
                handler.addLineListener(untrackedFilesDetector);
                handler.addLineListener(localChangesDetector);
                StructuredIdeActivity activity = GitStashUsageCollector.Companion.logStashPop(project);
                Intrinsics.checkNotNullExpressionValue((Object)Git.getInstance().runCommand((Computable<? extends GitLineHandler>)new Computable(handler){
                    final /* synthetic */ GitLineHandler $handler;

                    public final GitLineHandler compute() {
                        return this.$handler;
                    }
                    {
                        this.$handler = gitLineHandler;
                    }
                }), (String)"Git.getInstance().runCommand { handler }");
                StructuredIdeActivity.finished$default((StructuredIdeActivity)activity, null, (int)1, null);
                if (hash != null) {
                    INSTANCE.refreshUnstashedChanges(project, hash, (VirtualFile)root);
                }
                if ((object = (GitRepository)GitRepositoryManager.getInstance(project).getRepositoryForFileQuick((VirtualFile)root)) != null && (object = object.getRepositoryFiles()) != null) {
                    ((GitRepositoryFiles)object).refreshIndexFile();
                }
                if (indexConflictDetector.hasHappened()) {
                    VcsNotifier.getInstance((Project)project).notifyError("git.unstash.failed", GitBundle.message("notification.title.unstash.failed.index.conflict", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                    boolean bl2 = false;
                    return bl2;
                }
                if (conflictDetector.hasHappened()) {
                    boolean bl3 = conflictResolver.merge();
                    return bl3;
                }
                if (untrackedFilesDetector.wasMessageDetected()) {
                    GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(project, (VirtualFile)root, (Collection<String>)untrackedFilesDetector.getRelativeFilePaths(), GitBundle.message("unstash.operation.name", new Object[0]), null);
                    boolean bl4 = false;
                    return bl4;
                }
                if (localChangesDetector.wasMessageDetected()) {
                    LocalChangesWouldBeOverwrittenHelper.showErrorNotification(project, "git.stash.local.changes.detected", (VirtualFile)root, GitBundle.message("unstash.operation.name", new Object[0]), (Collection<String>)localChangesDetector.getRelativeFilePaths());
                    boolean bl5 = false;
                    return bl5;
                }
                if (result2.success()) continue;
                VcsNotifier.getInstance((Project)project).notifyError("git.unstash.failed", GitBundle.message("notification.title.unstash.failed", new Object[0]), result2.getErrorOutputAsHtmlString(), true);
                boolean bl6 = false;
                return bl6;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void refreshUnstashedChanges(Project project, Hash hash, VirtualFile root) {
        try {
            void $this$flatMapTo$iv$iv;
            GitCommit stashCommit;
            CollectConsumer consumer2 = new CollectConsumer();
            GitLogUtil.readFullDetailsForHashes(project, root, CollectionsKt.listOf((Object)hash.asString()), new GitCommitRequirements(false, GitCommitRequirements.DiffRenameLimit.NoRenames.INSTANCE, GitCommitRequirements.DiffInMergeCommits.DIFF_TO_PARENTS), (Consumer<? super GitCommit>)((Consumer)consumer2));
            Collection collection = consumer2.getResult();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"consumer.result");
            GitCommit gitCommit = stashCommit = (GitCommit)((Object)CollectionsKt.first((Iterable)collection));
            Intrinsics.checkNotNullExpressionValue((Object)((Object)gitCommit), (String)"stashCommit");
            Iterable $this$flatMap$iv = (Iterable)RangesKt.until((int)0, (int)gitCommit.getParents().size());
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            Iterator iterator = $this$flatMapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                int element$iv$iv;
                int it = element$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                Iterable list$iv$iv = stashCommit.getChanges(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List changesInStash = (List)destination$iv$iv;
            GitUtil.refreshVfs(root, changesInStash);
        }
        catch (Exception e) {
            GitStashUtils.access$getLOG$p().warn("Couldn't load changes in root [" + root + "] in stash resolved to [" + hash + "]", (Throwable)e);
        }
    }

    private GitStashOperations() {
    }

    static {
        GitStashOperations gitStashOperations;
        INSTANCE = gitStashOperations = new GitStashOperations();
    }
}

