/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.panel.PanelBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.concurrency.FutureResult;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.textCompletion.DefaultTextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextCompletionValueDescriptor;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.UI;
import com.intellij.vcs.log.VcsLogRefs;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.impl.VcsGoToRefComparator;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.actions.TwoStepCompletionProvider;
import com.intellij.vcs.log.ui.actions.VcsRefCompletionProvider;
import git4idea.GitBranch;
import git4idea.GitReference;
import git4idea.GitTag;
import git4idea.branch.GitBranchUtil;
import git4idea.log.GitRefManager;
import git4idea.repo.GitRepository;
import it.unimi.dsi.fastutil.Hash;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.stream.Stream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitRefDialog
extends DialogWrapper {
    private final TextFieldWithCompletion myTextField;
    private final JComponent myCenterPanel;

    public GitRefDialog(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull @NlsContexts.DialogTitle String title, @NotNull @NlsContexts.Label String message) {
        if (project == null) {
            GitRefDialog.$$$reportNull$$$0(0);
        }
        if (repositories == null) {
            GitRefDialog.$$$reportNull$$$0(1);
        }
        if (title == null) {
            GitRefDialog.$$$reportNull$$$0(2);
        }
        if (message == null) {
            GitRefDialog.$$$reportNull$$$0(3);
        }
        super(project);
        this.setTitle(title);
        TextCompletionProvider completionProvider2 = GitRefDialog.getCompletionProvider(project, repositories, this.getDisposable());
        this.myTextField = new TextFieldWithCompletion(project, completionProvider2, "", true, true, false);
        this.myCenterPanel = UI.PanelFactory.grid().add((PanelBuilder)UI.PanelFactory.panel((JComponent)new JBLabel(message))).add((PanelBuilder)UI.PanelFactory.panel((JComponent)this.myTextField)).createPanel();
        this.init();
    }

    @NotNull
    private static TextCompletionProvider getCompletionProvider(@NotNull Project project, @NotNull List<GitRepository> repositories, @NotNull Disposable disposable) {
        VcsLogManager logManager;
        if (project == null) {
            GitRefDialog.$$$reportNull$$$0(4);
        }
        if (repositories == null) {
            GitRefDialog.$$$reportNull$$$0(5);
        }
        if (disposable == null) {
            GitRefDialog.$$$reportNull$$$0(6);
        }
        if ((logManager = VcsProjectLog.getInstance((Project)project).getLogManager()) != null) {
            List roots = ContainerUtil.map(repositories, Repository::getRoot);
            DataPack dataPack = logManager.getDataManager().getDataPack();
            if (dataPack != DataPack.EMPTY) {
                VcsGoToRefComparator comparator = new VcsGoToRefComparator(dataPack.getLogProviders());
                return new MyVcsRefCompletionProvider((VcsLogRefs)dataPack.getRefsModel(), roots, (Comparator<? super VcsRef>)comparator);
            }
        }
        List branches2 = ContainerUtil.concat(GitBranchUtil.getCommonLocalBranches(repositories), GitBranchUtil.getCommonRemoteBranches(repositories));
        FutureResult<Collection<GitTag>> tagsFuture = GitRefDialog.scheduleCollectCommonTags(repositories, disposable);
        return new MySimpleCompletionListProvider(branches2, tagsFuture);
    }

    private static FutureResult<Collection<GitTag>> scheduleCollectCommonTags(@NotNull List<GitRepository> repositories, @NotNull Disposable disposable) {
        if (repositories == null) {
            GitRefDialog.$$$reportNull$$$0(7);
        }
        if (disposable == null) {
            GitRefDialog.$$$reportNull$$$0(8);
        }
        FutureResult futureResult = new FutureResult();
        ApplicationManager.getApplication().executeOnPooledThread(() -> futureResult.set((Object)((Collection)BackgroundTaskUtil.runUnderDisposeAwareIndicator((Disposable)disposable, () -> GitBranchUtil.collectCommon(repositories.stream().map(repository -> {
            try {
                List<String> tags = GitBranchUtil.getAllTags(repository.getProject(), repository.getRoot());
                return ContainerUtil.map(tags, GitTag::new);
            }
            catch (VcsException e) {
                return Collections.emptyList();
            }
        }))))));
        return futureResult;
    }

    @NotNull
    public String getReference() {
        String string = this.myTextField.getText();
        if (string == null) {
            GitRefDialog.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myCenterPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myTextField;
    }

    @NotNull
    private static Collection<VcsRef> collectCommonVcsRefs(@NotNull Stream<? extends VcsRef> stream) {
        if (stream == null) {
            GitRefDialog.$$$reportNull$$$0(10);
        }
        MultiMap map2 = MultiMap.create();
        stream.forEach(ref -> map2.putValue((Object)ref.getRoot(), ref));
        Stream<Collection> groups = map2.entrySet().stream().map(Map.Entry::getValue);
        List<VcsRef> list2 = GitBranchUtil.collectCommon(groups, new NameAndTypeHashingStrategy());
        if (list2 == null) {
            GitRefDialog.$$$reportNull$$$0(11);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/ui/branch/GitRefDialog";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/ui/branch/GitRefDialog";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReference";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommonVcsRefs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionProvider";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scheduleCollectCommonTags";
                break;
            }
            case 9: 
            case 11: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "collectCommonVcsRefs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class GitReferenceDescriptor
    extends DefaultTextCompletionValueDescriptor<GitReference> {
        private GitReferenceDescriptor() {
        }

        @NotNull
        public String getLookupString(@NotNull GitReference item) {
            if (item == null) {
                GitReferenceDescriptor.$$$reportNull$$$0(0);
            }
            String string = item.getName();
            if (string == null) {
                GitReferenceDescriptor.$$$reportNull$$$0(1);
            }
            return string;
        }

        public int compare(GitReference item1, GitReference item2) {
            return item1.compareTo(item2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitRefDialog$GitReferenceDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitRefDialog$GitReferenceDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class NameAndTypeHashingStrategy
    implements Hash.Strategy<VcsRef> {
        private NameAndTypeHashingStrategy() {
        }

        public int hashCode(VcsRef object) {
            return object == null ? 0 : Comparing.hashcode((Object)object.getName(), (Object)object.getType());
        }

        public boolean equals(VcsRef o1, VcsRef o2) {
            return o1 == o2 || o1 != null && o2 != null && Objects.equals(o1.getName(), o2.getName()) && Objects.equals(o1.getType(), o2.getType());
        }
    }

    private static final class VcsRefDescriptor
    extends DefaultTextCompletionValueDescriptor<VcsRef> {
        @NotNull
        private final Comparator<? super VcsRef> myReferenceComparator;

        private VcsRefDescriptor(@NotNull Comparator<? super VcsRef> comparator) {
            if (comparator == null) {
                VcsRefDescriptor.$$$reportNull$$$0(0);
            }
            this.myReferenceComparator = comparator;
        }

        @NotNull
        public String getLookupString(@NotNull VcsRef item) {
            if (item == null) {
                VcsRefDescriptor.$$$reportNull$$$0(1);
            }
            String string = item.getName();
            if (string == null) {
                VcsRefDescriptor.$$$reportNull$$$0(2);
            }
            return string;
        }

        public int compare(VcsRef item1, VcsRef item2) {
            return this.myReferenceComparator.compare((VcsRef)item1, (VcsRef)item2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitRefDialog$VcsRefDescriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitRefDialog$VcsRefDescriptor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLookupString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getLookupString";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MySimpleCompletionListProvider
    extends TwoStepCompletionProvider<GitReference> {
        @NotNull
        private final List<? extends GitBranch> myBranches;
        @NotNull
        private final FutureResult<? extends Collection<GitTag>> myTagsFuture;

        MySimpleCompletionListProvider(@NotNull List<? extends GitBranch> branches2, @NotNull FutureResult<? extends Collection<GitTag>> tagsFuture) {
            if (branches2 == null) {
                MySimpleCompletionListProvider.$$$reportNull$$$0(0);
            }
            if (tagsFuture == null) {
                MySimpleCompletionListProvider.$$$reportNull$$$0(1);
            }
            super((TextCompletionValueDescriptor)new GitReferenceDescriptor());
            this.myBranches = branches2;
            this.myTagsFuture = tagsFuture;
        }

        @NotNull
        protected Stream<? extends GitReference> collectSync(@NotNull CompletionResultSet result2) {
            if (result2 == null) {
                MySimpleCompletionListProvider.$$$reportNull$$$0(2);
            }
            Stream<GitBranch> stream = this.myBranches.stream().filter(branch -> result2.getPrefixMatcher().prefixMatches(branch.getName()));
            if (stream == null) {
                MySimpleCompletionListProvider.$$$reportNull$$$0(3);
            }
            return stream;
        }

        @NotNull
        protected Stream<? extends GitReference> collectAsync(@NotNull CompletionResultSet result2) {
            Stream<GitTag> stream;
            if (result2 == null) {
                MySimpleCompletionListProvider.$$$reportNull$$$0(4);
            }
            try {
                stream = ((Collection)this.myTagsFuture.get()).stream().filter(tag -> result2.getPrefixMatcher().prefixMatches(tag.getName()));
            }
            catch (InterruptedException | ExecutionException e) {
                Stream stream2 = Stream.empty();
                if (stream2 == null) {
                    MySimpleCompletionListProvider.$$$reportNull$$$0(6);
                }
                return stream2;
            }
            if (stream == null) {
                MySimpleCompletionListProvider.$$$reportNull$$$0(5);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branches";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tagsFuture";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitRefDialog$MySimpleCompletionListProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitRefDialog$MySimpleCompletionListProvider";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectSync";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectAsync";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "collectSync";
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "collectAsync";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyVcsRefCompletionProvider
    extends VcsRefCompletionProvider {
        MyVcsRefCompletionProvider(@NotNull VcsLogRefs refs, @NotNull Collection<? extends VirtualFile> roots, @NotNull Comparator<? super VcsRef> comparator) {
            if (refs == null) {
                MyVcsRefCompletionProvider.$$$reportNull$$$0(0);
            }
            if (roots == null) {
                MyVcsRefCompletionProvider.$$$reportNull$$$0(1);
            }
            if (comparator == null) {
                MyVcsRefCompletionProvider.$$$reportNull$$$0(2);
            }
            super(refs, roots, (TextCompletionValueDescriptor)new VcsRefDescriptor(comparator));
        }

        @NotNull
        protected Stream<VcsRef> filterRefs(@NotNull Stream<VcsRef> vcsRefs) {
            if (vcsRefs == null) {
                MyVcsRefCompletionProvider.$$$reportNull$$$0(3);
            }
            Stream<VcsRef> branches2 = vcsRefs.filter(ref -> {
                VcsRefType type = ref.getType();
                return type == GitRefManager.LOCAL_BRANCH || type == GitRefManager.REMOTE_BRANCH || type == GitRefManager.TAG;
            });
            Stream<VcsRef> stream = GitRefDialog.collectCommonVcsRefs(branches2).stream();
            if (stream == null) {
                MyVcsRefCompletionProvider.$$$reportNull$$$0(4);
            }
            return stream;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "refs";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsRefs";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/ui/branch/GitRefDialog$MyVcsRefCompletionProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/ui/branch/GitRefDialog$MyVcsRefCompletionProvider";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterRefs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "filterRefs";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

